#include <stdlib.h>
#include <db.h>
#include <fcntl.h>
#include <limits.h>
#include <stdio.h>
#include <sys/types.h>

#include "avltree.h"
#include "bplus.h"


static IX_DESC	ix;

void
avl_create_index(AVL_IX_DESC *pix, int dup, int flag)
{
	char	buf[100];

	sprintf(buf, "/tmp/avl_%d", getpid());
	if (make_index(buf, &ix, 1) != IX_OK) {
		perror(buf);
		exit(1);
	}
	unlink(buf);
}


int
avl_add_key(AVL_IX_REC *pe, AVL_IX_DESC *pix)
{
	ENTRY	e;

	e.recptr = (OFF_T) pe->recptr;
	strcpy(e.key, pe->key);
	if (add_key(&e, &ix) != IX_OK) {
		perror(e.key);
		exit(1);
	}
	return AVL_IX_OK;
}

int
avl_find_key(AVL_IX_REC *pe, AVL_IX_DESC *pix)
{
	ENTRY	e;

	e.recptr = (OFF_T) pe->recptr;
	strcpy(e.key, pe->key);

	if (find_key(&e, &ix) != IX_OK) {
		perror(e.key);
		exit(1);
	}
	return AVL_IX_OK;
}
