#ifndef _incl_defns
#define _incl_defns

#include "list.h"

typedef struct
{
    int ndim;
    int *block_size;
    int *npoints;
}   Size_info;

typedef struct
{
    float *store;
    float *col_store;
    float *row_store;
    float *work;
    int *directory;
}   Store_info;

typedef struct
{
    int nlevels;
    float *levels;
    List *vertices;
}   Level_info;

typedef struct
{
    int dim0;
    int dim1;
    int nsub_blocks0;
    int nsub_blocks1;
}   Plane_info;

typedef struct
{
    int dir_size;
    int *directory;
    int out_size;
    float *output;
    float *lower;
    float *upper;
}   Output_info;

typedef struct
{
    String input_file;
    String output_file;
    FILE *file_in;
    FILE *file_out;
    Bool swapped;
    Bool integer;
    Bool blocked;
    int header;
    Bool deflated;
    int dir_size;
}   File_info;

typedef struct
{
    int *first;
    int *last;
}   Limit_info;

#define  MAX_EXCLUDE  25

typedef struct
{
    int n;
    float first[MAX_EXCLUDE];
    float last[MAX_EXCLUDE];
}   Exclude_info;

#define  MAX_DIAGONAL  (MAX_NDIM*(MAX_NDIM-1)/2)

typedef struct
{
    int n;
    int dim0[MAX_DIAGONAL];
    int dim1[MAX_DIAGONAL];
    float delta[MAX_DIAGONAL];
}   Diagonal_info;

#endif /* _incl_defns */
