#ifndef _incl_ref
#define _incl_ref

#include "macros.h"
#include "types.h"

#define  SMALL_SW	1.0
#define  SMALL_SF	1.0

typedef char Ref_name[10];

static Ref_name ref_names[] =
{
#define  REF_POINTS	0
	"points",

#define  REF_PPM	1
	"ppm",

#define  REF_HZ		2
	"Hz",

#define  NREF_TYPES	3
};

typedef struct
{
    float sw;		/* Hz */
    float sf;		/* MHz */
    float refppm;	/* ppm */
    float refpt;	/* point */
    char nuc[10];
}   Ref_info;

extern void free_ref_memory
	(Ref_info **ref);

extern Status initialize_ref
	(int ndim, Ref_info **ref, String error_msg);

extern void write_ref
	(FILE *fp, Ref_info *ref);

extern void convert_from_point
	(int ref_type, int npoints, Ref_info *ref, float *point);

extern void convert_from_points
	(int ref_type, int ndim, int *npoints, Ref_info *ref, float *points);

extern void convert_to_point
	(int ref_type, int npoints, Ref_info *ref, float *point);

extern void convert_to_points
	(int ref_type, int ndim, int *npoints, Ref_info *ref, float *points);

extern void check_orientation
	(int ref_type, int ndim, float *lower, float *upper);

extern void convert_range_to_points
	(int ref_type, int ndim, int *npoints, Ref_info *ref,
						float *lower, float *upper);

extern void convert_range_from_points
	(int ref_type, int ndim, int *npoints, Ref_info *ref,
						float *lower, float *upper);

extern void find_sub_ref
	(Ref_info *ref1, Ref_info *ref2,
                                int first, int last, int step, int npoints);

extern float fractional_ref_offset
	(int ref_type, Ref_info *ref, float value);

extern void offset_to_point
	(int ref_type, int npoints, Ref_info *ref, float *offset);

extern void offset_to_points
	(int ref_type, int ndim, int *npoints, Ref_info *ref, float *offsets);

#endif /* _incl_ref */
