#include "block.h"

#include "block_io.h"

static float *work;
static float *data;

static int *block_size;
static int *npoints;
static int *point;

/*
static String name;
*/

static int ndim;
static int dim;

static int size_of_block;
static int data_point;
static int first_block;
static int step_block;
static int last_block;
static int first_work;
static int step_work;
static int nrow;
static int row_block;
static int nwork_alloc;

static int nblocks[MAX_NDIM];
static int cum_nblocks[MAX_NDIM];
static int cum_block_size[MAX_NDIM];
static int array[MAX_NDIM];

static int ndirectory = 0;
static int *directory;

static Block_IO block_io;

static void init_arrays()
{
    int i, n;

    BLOCKS(nblocks, npoints, block_size, ndim);

    CUMULATIVE(cum_nblocks, nblocks, n, ndim);
    CUMULATIVE(cum_block_size, block_size, size_of_block, ndim);

    point[dim] = 0;
    for (i = 0; i < ndim; i++)
    {
	array[i] = point[i] / block_size[i];
	point[i] %= block_size[i];
    }

    INDEX_OF_ARRAY(first_block, array, cum_nblocks, ndim);
    INDEX_OF_ARRAY(first_work, point, cum_block_size, ndim);

    step_block = cum_nblocks[dim];
    step_work = cum_block_size[dim];

    nrow = npoints[dim];
    row_block = block_size[dim];
    last_block = first_block + step_block*nblocks[dim];
}

static void free_block_memory()
{
    if (nwork_alloc > 0)
	FREE(work, float);
}

static Status alloc_block_memory()
{
    if (size_of_block > nwork_alloc)
    {
	free_block_memory();
	MALLOC(work, float, size_of_block);
	nwork_alloc = size_of_block;
    }

    return  OK;
}

void free_directory_memory()
{
    FREE(directory, int);

    ndirectory = 0;
}

static Status alloc_directory_memory(int dir_size)
{
    if (dir_size > ndirectory)
    {
	free_directory_memory();
	MALLOC(directory, int, dir_size);

	ndirectory = dir_size;
    }

    return  OK;
}

static Status do_block(int block, String error_msg)
{
    int d, w, last_point;

    last_point = data_point + row_block;
    last_point = MIN(nrow, last_point);

    for (d = data_point, w = first_work; d < last_point; d++, w += step_work)
	data[d] = work[w];

    data_point = last_point;

    return  OK;
}

static Status block_process(String error_msg)
{
    int b;

    data_point = 0;
    for (b = first_block; b < last_block; b += step_block)
    {
	CHECK_STATUS(read_file_block(&block_io, b, work, error_msg));

	CHECK_STATUS(do_block(b, error_msg));
    }

    return  OK;
}

Status process_blocks(Size_info *size_info, File_info *file_info,
				Point_info *point_info, String error_msg)
{
    int i;

    ndim = size_info->ndim;
    block_size = size_info->block_size;
    npoints = size_info->npoints;

    dim = point_info->dim;
    point = point_info->point;
    data = point_info->data;

    if (!(file_info->blocked))  /* fudge for non-blocked data */
    {
	block_size[0] = npoints[0];

	for (i = 1; i < ndim; i++)
	    block_size[i] = 1;
    }

    init_arrays();

    if (alloc_block_memory() == ERROR)
	RETURN_ERROR_MSG("allocating memory for block");

    if (file_info->deflated &&
		(alloc_directory_memory(file_info->dir_size) == ERROR))
	RETURN_ERROR_MSG("allocating memory for directory");

    block_io.name = file_info->name;
    block_io.file = file_info->file;
    block_io.swapped = file_info->swapped;
    block_io.integer = file_info->integer;
    block_io.deflated = file_info->deflated;
    block_io.header = file_info->header;
    block_io.dir_size = file_info->dir_size;
    block_io.directory = directory;
    block_io.block_size = size_of_block;
    block_io.byte_size = file_info->byte_size;

    CHECK_STATUS(init_block_read(&block_io, error_msg));

/*
    sprintf(error_msg, "\"%s\": ", name);
    error_msg += strlen(error_msg);
*/

    CHECK_STATUS(block_process(error_msg));

    return  OK;
}
