#include "conv.h"

#define  DO_CONVOLVE \
	 {   c = 0; \
	     for( k = first; k <= last; k += s) \
		 c += data[k] * (*f++); \
	     convolve[i+j] = c / d;   }

void calculate_convolve(int npts, float *data, float *convolve,
			int width, float *filter, float *sum, int step)
{
    int i, j, k, w2, first, last;
    int n = npts, w = width, s = step;
    float c, d, *f;

    w2 = w / 2;  w2 *= s;

/*  first w2 points  */

    for (i = 0; i < w2; i += s)
    {
	d = sum[(w2+i)/s];

	for( j = 0; j < s; j++)
	{
	    first = j;
	    last = i + j + w2;

	    f = filter + (w2-i)/s;
	    DO_CONVOLVE;
	}
    }

/*  bulk of points  */

    for (i = w2; i < n-w2; i += s)
    {
	d = sum[w-1];

	for( j = 0; j < s; j++)
	{
	    first = i + j - w2;
	    last = i + j + w2;

	    f = filter;
	    DO_CONVOLVE;
	}
    }

/*  last w2 points  */

    for (i = n-w2; i < n; i += s)
    {
	d = sum[w-2-(i+w2-n)/s];

	for( j = 0; j < s; j++)
	{
	    first = i + j - w2;
	    last = n - s + j;

	    f = filter;
	    DO_CONVOLVE;
	}
    }
}

void calculate_sine_filter(int width, float *filter, float *sum)
{
    int i;
    float s = 0;

    for (i = 0; i < width; i++)
    {
	filter[i] = sin(PI * ((double) (i+1)) / ((double) (width+1)));
	s += filter[i];
	sum[i] = s;
    }
}

void calculate_box_filter(int width, float *filter, float *sum)
{
    int i;

    for (i = 0; i < width; i++)
    {
	filter[i] = 1;
	sum[i] = i + 1;
    }
}

/*  assumes that width is odd, and width > 0  */
void calculate_triangle_filter(int width, float *filter, float *sum)
{
    int i, w2 = width/2;
    float s = 0;

    filter[w2] = 1;

    for (i = 1; i <= w2; i++)
    {
	filter[w2+i] = ((float) (w2+1-i)) / ((float) (w2+1));
	filter[w2-i] = filter[w2+i];
    }

    for (i = 0; i < width; i++)
    {
	s += filter[i];
	sum[i] = s;
    }
}

/*  assumes that width is odd, width > 0, and 0 < end < 1  */
void calculate_gaussian_filter(int width, float end, float *filter, float *sum)
{
    int i, w2 = width/2;
    float s = 0;
    double a;

    a = - log((double) end) / (w2*w2);

    filter[w2] = 1;

    for (i = 1; i <= w2; i++)
    {
	filter[w2+i] = exp(- a * i * i);
	filter[w2-i] = filter[w2+i];
    }

    for (i = 0; i < width; i++)
    {
	s += filter[i];
	sum[i] = s;
    }
}

Status read_and_sum_filter(String file, int width, float *filter, float *sum,
							String error_msg)
{
    int i, w2 = width/2;
    float f, s = 0;
    FILE *fp;

    if (OPEN_FOR_READING(fp, file))
    {
	sprintf(error_msg, "opening '%s' for reading", file);
	return  ERROR;
    }

    sprintf(error_msg, "reading '%s': ", file);
    error_msg += strlen(error_msg);

    filter[w2] = 1;

    for (i = 0; (i < w2) && (fscanf(fp, "%f", &f) == 1); i++)
    {
	if (f <= 0)
	{
	    fclose(fp);

	    sprintf(error_msg, "filter value #%d is %f, must be > 0", i+1, f);
	    return  ERROR;
	}

	filter[w2-i-1] = filter[w2+i+1] = f;
    }

    fclose(fp);

    if (i < width)
    {
	sprintf(error_msg, "only found %d filter values, expecting %d",
								i, width);
	return  ERROR;
    }

    for (i = 0; i < width; i++)
    {
	s += filter[i];
	sum[i] = s;
    }

    return  OK;
}
