#include "input.h"

#include "block.h"
#include "par.h"
#include "parser.h"
#include "ref.h"
#include "script.h"

#define  READ_POINT	1
#define  READ_DIM	2
#define  READ_NAME	3
#define  READ_REF	4

#include "input_ref.h"  /* code explicitly dependent on reference structure */

static Ref_info *input_ref = (Ref_info *) NULL;

Ref_info *get_input_ref()
{
    return  input_ref;
}

static Status do_read_par(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    int i, n, dim, ndim, *p;
    static int point[MAX_NDIM];
    float *data;
    String name;
    Par_info par_info;
    Ref_info *ref;
    FILE *fp;
    Status status;
    Size_info size_info;
    File_info file_info;
    Point_info point_info;

    store_float_to_int(store[READ_POINT]);
    store_float_to_int(store[READ_DIM]);

    name = (String) (store[READ_NAME]->data);

    CHECK_STATUS(read_par_file(name, &par_info, error_msg));

    if (par_info.deflated)
	RETURN_ERROR_MSG("data file cannot be deflated");

    dim = *((int *) (store[READ_DIM]->data));
    ndim = par_info.ndim;

    if ((dim < 1) || (dim > ndim))
    {
	sprintf(error_msg,
		"dimension (argument %d) is %d, must be in range 1 to %d",
						READ_DIM, dim, ndim);
	return  ERROR;
    }

    dim--;
    n = par_info.npoints[dim];

    ref = (Ref_info *) (store[READ_REF]->data);
    find_sub_ref(ref, par_info.ref + dim, 0, 1, 1, 1);
		/* above just copies reference */

    store_type_float(store[OUTPUT_X]);
    CHECK_STATUS(check_parser_alloc(store[OUTPUT_X], n, error_msg));
    data = (float *) (store[OUTPUT_X]->data);

    p = (int *) (store[READ_POINT]->data);
    COPY_VECTOR(point, p, ndim);

    for (i = 0; i < ndim; i++)
    {
	if (i == dim)
	    continue;

	if ((point[i] < 1) || (point[i] > par_info.npoints[i]))
	{
	    sprintf(error_msg, "point %d is %d, must be in range 1 to %d",
					i+1, point[i], par_info.npoints[i]);
	    return  ERROR;
	}

	point[i]--;
    }

    name = par_info.file;
    if (OPEN_FOR_READING(fp, name))
    {
	sprintf(error_msg, "could not open file \"%s\"", name);
	return  ERROR;
    }

    size_info.ndim = ndim;
    size_info.block_size = par_info.block_size;
    size_info.npoints = par_info.npoints;

    file_info.name = name;
    file_info.file = fp;
    file_info.swapped = par_info.swapped;
    file_info.integer = par_info.integer;
    file_info.blocked = par_info.blocked;
    file_info.header = par_info.header;
    file_info.deflated = par_info.deflated;
    file_info.dir_size = par_info.dir_size;
    file_info.byte_size = par_info.byte_size;

    point_info.dim = dim;
    point_info.point = point;
    point_info.data = data;

    status = process_blocks(&size_info, &file_info, &point_info, error_msg);

    fclose(fp);

    return  status;
}

static Status do_set_reference(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
#include "input_ref.c"  /* code explicitly dependent on reference structure */

    return  OK;
}

static Status setup_ref_store(Parser_store **store, String error_msg)
{
    Parser_store *s;

    sprintf(error_msg, "allocating memory for reference");
    MALLOC(input_ref, Ref_info, 1);
    MALLOC(s, Parser_store, 1);

    s->ndata = s->nalloc = 0;  /* not used */
    s->data_type = PARSER_NONE;
    s->data = (Generic_ptr) input_ref;

    *store = s;

    return  OK;
}

Status init_read_par(int nstore, Parser_store **store, String error_msg)
{
    Parser_store *s;

    CHECK_STATUS(setup_ref_store(&s, error_msg));

    store[READ_REF] = s;

/*  +1 below because of READ_REF above  */
    if (setup_command(nstore+1, store, "read_par", do_read_par,
                                                        error_msg) == ERROR)
        return  ERROR;

    store[OUTPUT_X]->data_type = PARSER_FRA;

    return  OK;
}

Status init_set_reference(int nstore, Parser_store **store, String error_msg)
{
    Parser_store *s;

    CHECK_STATUS(setup_ref_store(&s, error_msg));

    store[REF_REF] = s;

/*  +1 below because of REF_REF above  */
    if (setup_command(nstore+1, store, "set_reference", do_set_reference,
                                                        error_msg) == ERROR)
        return  ERROR;

    store[OUTPUT_X]->data_type = PARSER_FRA;

    return  OK;
}
