#include "lp_first.h"

#include "lp.h"
#include "parser.h"
#include "script.h"

#define  LP_NUMBER_PREDICTED	2
#define  LP_SEQUENCE_LENGTH	3
#define  LP_NUMBER_SEQUENCES	4
#define  LP_VALUE_CUTOFF	5

static int nalloc = 0;
static int lalloc = 0;
static float **u;
static float **v;
static float *w;
static float *x;
static float *d;
static float *t;
Bool use_lp_first;

static int ndata;
static int npts;
static int p;
static int l;
static int n;
static float c;
static int s;
static float *data_in;
static float *data_out;

static void free_lp_memory()
{
    int i;

    if ((nalloc > 0) && (lalloc > 0))
    {
	for (i = 0; i < nalloc; i++)
	    FREE(u[i], float);

	for (i = 0; i < lalloc; i++)
	    FREE(v[i], float);

	FREE(u, float *);
	FREE(v, float *);
	FREE(w, float);
	FREE(x, float);
	FREE(d, float);
	FREE(t, float);

	nalloc = 0;
	lalloc = 0;
    }
}

static Status alloc_lp_memory(String error_msg)
{
    int i;

    if ((n <= nalloc) && (l <= lalloc))
	return  OK;

    free_lp_memory();

    sprintf(error_msg, "allocating lp memory");

    MALLOC(u, float *, n);
    MALLOC(v, float *, l);
    MALLOC(w, float, l);
    MALLOC(x, float, l);
    MALLOC(d, float, n);
    MALLOC(t, float, l);

    for (i = 0; i < n; i++)
	MALLOC(u[i], float, l);

    for (i = 0; i < l; i++)
	MALLOC(v[i], float, l);

    nalloc = n;
    lalloc = l;

    return  OK;
}


static Status check_lp_first(Bool complex, Parser_store **store,
							String error_msg)
{
    int m;

    ndata = store[INPUT_X]->ndata;
    store_int_to_float(store[INPUT_X]);
    data_in = (float *) (store[INPUT_X]->data);

    store_float_to_int(store[LP_NUMBER_PREDICTED]);
    p = *((int *) (store[LP_NUMBER_PREDICTED]->data));

    store_float_to_int(store[LP_SEQUENCE_LENGTH]);
    l = *((int *) (store[LP_SEQUENCE_LENGTH]->data));

    store_float_to_int(store[LP_NUMBER_SEQUENCES]);
    n = *((int *) (store[LP_NUMBER_SEQUENCES]->data));

    store_int_to_float(store[LP_VALUE_CUTOFF]);
    c = *((float *) (store[LP_VALUE_CUTOFF]->data));

    if (p < 1)
        RETURN_ERROR_MSG("number of predicted points must be >= 1");

    if (l < 1)
        RETURN_ERROR_MSG("length of sequence must be >= 1");

    if (c <= 0)
        RETURN_ERROR_MSG("cutoff must be > 0");

    if (c >= 1)
        RETURN_ERROR_MSG("cutoff must be < 1");

    m = ndata - p;

    if (n < l)
        RETURN_ERROR_MSG("number of sequences must be >= length");

    if (l > (m/2))
        RETURN_ERROR_MSG("length of sequence too large");

    if (n > (m - l))
        RETURN_ERROR_MSG("number of sequences too large");

    if (store[INPUT_X]->data_type & PARSER_COMPLEX)
	s = 2;
    else if (store[INPUT_X]->data_type & PARSER_REAL)
	s = 1;

    if (complex)
    {
	l *= s;
	n *= s;
    }

    if (complex && (s == 2))
	use_lp_first = FALSE;
    else
	use_lp_first = TRUE;

    npts = s * ndata;

    store_type_float(store[OUTPUT_X]);
    CHECK_STATUS(check_parser_alloc(store[OUTPUT_X], ndata, error_msg));
    data_out = (float *) (store[OUTPUT_X]->data);

    CHECK_STATUS(alloc_lp_memory(error_msg));

    return  OK;
}

static void calc_lp_first()
{
    COPY_VECTOR(data_out, data_in, npts);

    if (use_lp_first)
        lp_first(data_out, l, n, p, s, c, u, v, w, x, d, t);
    else
        lp_first2(data_out, l/2, n/2, p, c, u, v, w, x, d, t);
}

static Status do_lp_first(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    CHECK_STATUS(check_lp_first(FALSE, store, error_msg));

    calc_lp_first();

    return  OK;
}

static Status do_lp_first2(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    CHECK_STATUS(check_lp_first(TRUE, store, error_msg));

    calc_lp_first();

    return  OK;
}

Status init_lp_first(int nstore, Parser_store **store, String error_msg)
{
    CHECK_STATUS(setup_command(nstore, store, "lp_first", do_lp_first, error_msg));

    store[OUTPUT_X]->data_type = store[INPUT_X]->data_type;
    store[OUTPUT_X]->data_type |= PARSER_INT | PARSER_FLOAT;

    return  OK;
}

Status init_lp_first2(int nstore, Parser_store **store, String error_msg)
{
    CHECK_STATUS(setup_command(nstore, store, "lp_first2", do_lp_first2, error_msg));

    store[OUTPUT_X]->data_type = store[INPUT_X]->data_type;
    store[OUTPUT_X]->data_type |= PARSER_INT | PARSER_FLOAT;

    return  OK;
}
