#include "output_popup.h"

#include "output.hlp"

#include "callback.h"
#include "draw.h"
#include "hpgl.h"
#include "object.h"
#include "object_popup.h"
#include "output.h"
#include "param.h"
#include "ps.h"
#include "region_popup.h"
#include "utility.h"
#include "window.h"

#define  TIME_DATE	0
#define  NO_TIME_DATE	1
#define  NTIME_DATES	2

#define  FILE_NAME	0
#define  NO_FILE_NAME	1
#define  NFILE_NAMES	2

#define  OUTPUT_FONT	"Times-Roman"

static Widget output_popup = (Widget) NULL;
static Widget output_form;

static Cursor output_cursor;

static Widget time_date_boxes[NTIME_DATES];
static Radiobox_item time_date_items[] =
{
    { "time & date", NO_CALLBACK, NO_DATA, time_date_boxes + TIME_DATE },
    { "no time & date", NO_CALLBACK, NO_DATA, time_date_boxes + NO_TIME_DATE }
};

static int time_date_type = TIME_DATE;
static int ntime_date_types = ARRAY_SIZE(time_date_boxes);

static Widget file_name_boxes[NFILE_NAMES];
static Radiobox_item file_name_items[] =
{
    { "file name", NO_CALLBACK, NO_DATA, file_name_boxes + FILE_NAME },
    { "no file name", NO_CALLBACK, NO_DATA, file_name_boxes + NO_FILE_NAME }
};

static int file_name_type = FILE_NAME;
static int nfile_name_types = ARRAY_SIZE(file_name_boxes);

static Widget file_field;
static Widget title_field;
static Widget size_field;

static Textfield_item textfield_items[] =
{
    { "file name: ", output_file, NO_CALLBACK, NO_DATA, &file_field },
    { "title: ", output_title, NO_CALLBACK, NO_DATA, &title_field },
    { "size: ",  output_size, NO_CALLBACK, NO_DATA, &size_field }
};

static int ntexts = ARRAY_SIZE(textfield_items);

static Widget other_field;

static Textfield_item other_items[] =
{
    { "", other_size, NO_CALLBACK, NO_DATA, &other_field }
};

static int nothers = ARRAY_SIZE(other_items);

static Widget size_mode_boxes[NSIZE_MODES];
static Radiobox_item size_mode_items[NSIZE_MODES];

static int size_mode_type = SIZE_PICTURE;
static int nsize_mode_types = ARRAY_SIZE(size_mode_boxes);

static Widget size_units_boxes[NSIZE_UNITS];
static Radiobox_item size_units_items[NSIZE_UNITS];

static int size_units_type = SIZE_PICTURE;
static int nsize_units_types = ARRAY_SIZE(size_units_boxes);

static Widget paper_size_boxes[NPAPER_SIZES];
static Radiobox_item paper_size_items[NPAPER_SIZES];

static int paper_size_type = A4_PAPER;
static int npaper_size_types = ARRAY_SIZE(paper_size_boxes);

static Widget paper_dirn_boxes[NPAPER_DIRNS];
static Radiobox_item paper_dirn_items[NPAPER_DIRNS];

static int paper_dirn_type = PORTRAIT;
static int npaper_dirn_types = ARRAY_SIZE(paper_dirn_boxes);

static Widget output_color_boxes[NCOLOR_TYPES];
static Radiobox_item output_color_items[NCOLOR_TYPES];

static int output_color_type = BLACK_WHITE;
static int noutput_color_types = ARRAY_SIZE(output_color_boxes);

static Widget output_gl_boxes[NGL_TYPES];
static Radiobox_item output_gl_items[NGL_TYPES];

static int output_gl_type = PS_OUTPUT;
static int noutput_gl_types = ARRAY_SIZE(output_gl_boxes);

void update_output_params()
{
    if (output_popup)
    {
	get_textfields(textfield_items, ntexts);
	get_textfields(other_items, nothers);

	time_date_type = get_radio_state(time_date_boxes, ntime_date_types);
	file_name_type = get_radio_state(file_name_boxes, nfile_name_types);
	size_mode_type = get_radio_state(size_mode_boxes, nsize_mode_types);
	size_units_type = get_radio_state(size_units_boxes, nsize_units_types);
	paper_size_type = get_radio_state(paper_size_boxes, npaper_size_types);
	paper_dirn_type = get_radio_state(paper_dirn_boxes, npaper_dirn_types);
	output_color_type = get_radio_state(output_color_boxes,
							noutput_color_types);
	output_gl_type = get_radio_state(output_gl_boxes, noutput_gl_types);

	sprintf(time_date, "%d", time_date_type);
	sprintf(show_name, "%d", file_name_type);
	sprintf(size_mode, "%d", size_mode_type);
	sprintf(size_units, "%d", size_units_type);
	sprintf(paper_size, "%d", paper_size_type);
	sprintf(paper_dirn, "%d", paper_dirn_type);
	sprintf(output_color, "%d", output_color_type);
	sprintf(output_gl, "%d", output_gl_type);
    }
    else
    {
	if (*time_date)
	    time_date_type = atoi(time_date);

	if (*show_name)
	    file_name_type = atoi(show_name);

	if (*size_mode)
	    size_mode_type = atoi(size_mode);

	if (*size_units)
	    size_units_type = atoi(size_units);

	if (*paper_size)
	    paper_size_type = atoi(paper_size);

	if (*paper_dirn)
	    paper_dirn_type = atoi(paper_dirn);

	if (*output_color)
	    output_color_type = atoi(output_color);

	if (*output_gl)
	    output_gl_type = atoi(output_gl);
    }
}

static void save_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    Line error_msg;
    Draw_info draw_info;
    Draw_funcs *ptr_draw_funcs;
    static Line time_and_date, fonts;
    static FILE *fp;
    static float size[PLOT_DIM];
    static Output_param output_param = { output_size, size };
    static Output_border title = { output_title, OUTPUT_FONT, 18,
				JUSTIFICATION_LEFT, EDGE_TOP, TRUE };
    static Output_border date = { time_and_date, OUTPUT_FONT, 12,
				JUSTIFICATION_RIGHT, EDGE_BOTTOM, TRUE };
    static Output_border file = { output_file, OUTPUT_FONT, 12,
				JUSTIFICATION_LEFT, EDGE_BOTTOM, TRUE };
    static Output_choices choices = { &title, &date, &file, size, other_size,
				A4_PAPER, PORTRAIT, BLACK_WHITE, TRUE };
    static Output_setup output_setup = { SIZE_PICTURE, INCH_UNITS,
                                                        PS_OUTPUT, &choices };
    static Ps_data ps_data = { (FILE *) NULL, PS_OUTPUT, &choices, fonts };
    static Draw_funcs ps_draw_funcs = { PAPER_DISPLAY, (Generic_ptr) &ps_data,
	start_ps, end_ps, new_ps_range, ps_line, ps_text,
	set_ps_color, set_ps_font, set_ps_line_style };
    static Hpgl_data hpgl_data = { (FILE *) NULL, &choices };
    static Draw_funcs hpgl_draw_funcs = { PAPER_DISPLAY,
	(Generic_ptr) &hpgl_data,
	start_hpgl, end_hpgl, new_hpgl_range, hpgl_line,
	hpgl_text, set_hpgl_color, set_hpgl_font, set_hpgl_line_style };

    update_output_params();

    strcpy(fonts, OUTPUT_FONT);

    STRIP_LEADING_SPACE(output_file);
    STRIP_TRAILING_SPACE(output_file);

    if (get_output_param(&output_param, error_msg) == ERROR)
	ERROR_AND_RETURN(error_msg);

    initialize_properties();
    if (run_script(0, error_msg) == ERROR)
	ERROR_AND_RETURN(error_msg);

    if (region_apply(&(draw_info.ref_type), draw_info.x, draw_info.y,
							error_msg) == ERROR)
	ERROR_AND_RETURN(error_msg);

    if (objects_apply(error_msg) == ERROR)
	ERROR_AND_RETURN(error_msg);

    if ((fp = fopen(output_file, WRITE)) == NULL)
    {
	sprintf(error_msg, "opening file '%s'", output_file);
	ERROR_AND_RETURN(error_msg);
    }

    choices.paper_size = paper_size_type;
    choices.paper_dirn = paper_dirn_type;
    choices.output_color = output_color_type;

    if (time_date_type == TIME_DATE)
	choices.time_date->use = TRUE;
    else
	choices.time_date->use = FALSE;

    if (file_name_type == FILE_NAME)
	choices.file_name->use = TRUE;
    else
	choices.file_name->use = FALSE;

    output_setup.size_mode = size_mode_type;
    output_setup.size_units = size_units_type;
    output_setup.output_gl = output_gl_type;

    if (setup_output(&output_setup, error_msg) == ERROR)
    {
	fclose(fp);
	ERROR_AND_RETURN(error_msg);
    }

    if ((output_gl_type == PS_OUTPUT) || (output_gl_type == EPS_OUTPUT))
    {
        ptr_draw_funcs = &ps_draw_funcs;

        ps_data.file = fp;
        ps_data.type = output_gl_type;
    }
    else /* output_gl_type == HPGL_OUTPUT */
    {
        ptr_draw_funcs = &hpgl_draw_funcs;

        hpgl_data.file = fp;
    }

    change_cursor(output_cursor);

    if (do_drawing(0, &draw_info, ptr_draw_funcs, error_msg) == ERROR)
    {
	fclose(fp);
	change_cursor(None);
        ERROR_AND_RETURN(error_msg);
    }

    fclose(fp);
    change_cursor(None);
}

static void other_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    set_radio_state(paper_size_boxes, NPAPER_SIZES, OTHER_SIZE);
}

static void create_output_popup(Widget parent)
{
    Widget buttons, radio, radio2, separator, texts;
    Apply_dismiss_help_info adh_info;
    char save_label[] = "save";

    update_output_params();

    initialize_boxes(size_mode_items, size_mode_names,
				size_mode_boxes, nsize_mode_types);

    initialize_boxes(size_units_items, size_units_names,
				size_units_boxes, nsize_units_types);

    initialize_boxes(paper_size_items, paper_size_names,
				paper_size_boxes, npaper_size_types);

    initialize_boxes(paper_dirn_items, paper_dirn_names,
				paper_dirn_boxes, npaper_dirn_types);

    initialize_boxes(output_color_items, output_color_names,
				output_color_boxes, noutput_color_types);

    initialize_boxes(output_gl_items, output_gl_names,
				output_gl_boxes, noutput_gl_types);

    output_popup = create_popup(parent, "Graphical Output");
    CHECK_WIDGET_WARNING(output_popup);

    output_form = create_form(output_popup);
    CHECK_WIDGET_DESTROY_WARNING(output_form, output_popup);

    texts = create_textfields(output_form, textfield_items, ntexts);
    CHECK_WIDGET_DESTROY_WARNING(texts, output_popup);
    attachments(texts, FORM_ATTACH, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    radio = create_radiobox(output_form, size_mode_items, nsize_mode_types,
						size_mode_type, HORIZONTAL);
    CHECK_WIDGET_DESTROY_WARNING(radio, output_popup);
    attachments(radio, texts, NO_ATTACH, NO_ATTACH, FORM_ATTACH);

    radio2 = create_radiobox(output_form, size_units_items,
			nsize_units_types, size_units_type, HORIZONTAL);
    CHECK_WIDGET_DESTROY_WARNING(radio2, output_popup);
    attachments(radio2, radio, NO_ATTACH, NO_ATTACH, FORM_ATTACH);

    radio = create_radiobox(output_form, time_date_items, ntime_date_types,
						time_date_type, HORIZONTAL);
    CHECK_WIDGET_DESTROY_WARNING(radio, output_popup);
    attachments(radio, radio2, NO_ATTACH, FORM_ATTACH, NO_ATTACH);

    radio2 = create_radiobox(output_form, file_name_items, nfile_name_types,
						file_name_type, HORIZONTAL);
    CHECK_WIDGET_DESTROY_WARNING(radio2, output_popup);
    attachments(radio2, radio, NO_ATTACH, FORM_ATTACH, NO_ATTACH);

    separator = create_separator(output_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, output_popup);
    attachments(separator, radio2, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    radio = create_radiobox(output_form, paper_size_items, npaper_size_types,
						paper_size_type, VERTICAL);
    CHECK_WIDGET_DESTROY_WARNING(radio, output_popup);
    attachments(radio, separator, NO_ATTACH, FORM_ATTACH, NO_ATTACH);

    separator = create_separator(output_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, output_popup);
    attachments(separator, radio, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    other_items->callback = other_callback;
    texts = create_textfields(output_form, other_items, nothers);
    CHECK_WIDGET_DESTROY_WARNING(texts, output_popup);
    attachments(texts, NO_ATTACH, separator, FORM_ATTACH, FORM_ATTACH);

    radio = create_radiobox(output_form, paper_dirn_items, npaper_dirn_types,
						paper_dirn_type, VERTICAL);
    CHECK_WIDGET_DESTROY_WARNING(radio, output_popup);
    attachments(radio, separator, NO_ATTACH, FORM_ATTACH, NO_ATTACH);

    separator = create_separator(output_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, output_popup);
    attachments(separator, radio, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    radio = create_radiobox(output_form, output_color_items,
			noutput_color_types, output_color_type, VERTICAL);
    CHECK_WIDGET_DESTROY_WARNING(radio, output_popup);
    attachments(radio, separator, NO_ATTACH, FORM_ATTACH, NO_ATTACH);

    separator = create_separator(output_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, output_popup);
    attachments(separator, radio, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    radio = create_radiobox(output_form, output_gl_items,
			noutput_gl_types, output_gl_type, VERTICAL);
    CHECK_WIDGET_DESTROY_WARNING(radio, output_popup);
    attachments(radio, separator, NO_ATTACH, FORM_ATTACH, NO_ATTACH);

    separator = create_separator(output_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, output_popup);
    attachments(separator, radio, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    adh_info.apply_label = save_label;
    adh_info.apply_callback = save_callback;
    adh_info.dismiss_form = output_form;
    adh_info.help_message = output_help;

    buttons = create_apply_dismiss_help(output_form, &adh_info);
    CHECK_WIDGET_DESTROY_WARNING(buttons, output_popup);
    attachments(buttons, separator, FORM_ATTACH, FORM_ATTACH, FORM_ATTACH);
    offsets(buttons, UNIT_OFFSET, NO_OFFSET, UNIT_OFFSET, UNIT_OFFSET);

    manage_widget(output_form);

    output_cursor = create_busy_cursor(WIDGET_DISPLAY(output_form));
}

void output_popup_callback(Widget parent, Callback_ptr data, Callback_ptr cbs)
{
    if (!output_popup)
	create_output_popup(parent);

    if (output_popup)
	popup(output_form);
}
