#ifndef _incl_contour
#define _incl_contour

#include "macros.h"
#include "types.h"

#include "list.h"

typedef float Data;

typedef struct
{
    Data x, y;
}   Coord;

typedef struct V_struct
{
    Coord p;
    struct V_struct *v1;
    struct V_struct *v2;
    int marker;
}   Vertex;

typedef struct
{
    int nlevels;		/* number of levels */
    float *levels;		/* the levels for the contours */
    int *npoints;
    Coord *offset;
    Coord *scale;
    List *vertices;		/* list of vertices */
    Status (*get_row)(Data **data, String error_msg);	/* get data row */
    Timer_funcs *timer_funcs;
}   Contour_info;

extern void free_contour_memory
	();

extern Status construct_contours
	(Contour_info *contour_info, String error_msg);

extern int next_chain
	(List *vertices, Vertex **vertex);

#endif /* _incl_contour */
