#include "data_func.h"

#include "data.h"
#include "object.h"

static int ndata_sets = 0;

void remove_data_set_func(int data_set)
{
    if (data_set < ndata_sets)
	ndata_sets--;

    free_data_set(data_set);
}

void register_data_set_func(int data_set, String name)
{
    if (data_set >= ndata_sets)
	ndata_sets++;
}

void data_delete_func()
{
    int i;

    for (i = ndata_sets-1; i >= 0; i--)
    {
	if (get_data_on_off(i) == VISIBILITY_ON)
	    remove_data_set_func(i);
    }
}

void data_next_func()
{
    int i, on_off;

    if (ndata_sets < 2)
	return;

    on_off = get_data_on_off(ndata_sets-1);

    for (i = ndata_sets-1; i > 0; i--)
	set_data_on_off(i, get_data_on_off(i-1));

    set_data_on_off(0, on_off);
}

void data_previous_func()
{
    int i, on_off;

    if (ndata_sets < 2)
	return;

    on_off = get_data_on_off(0);

    for (i = 0; i < (ndata_sets-1); i++)
	set_data_on_off(i, get_data_on_off(i+1));

    set_data_on_off(ndata_sets-1, on_off);
}

void data_select_func(int data_set)
{
    int on_off;

    on_off = get_data_on_off(data_set);

    if (on_off == VISIBILITY_ON)
	set_data_on_off(data_set, VISIBILITY_OFF);
    else /* on_off == VISIBILITY_OFF */
	set_data_on_off(data_set, VISIBILITY_ON);
}

void data_all_on_func()
{
    int i;

    for (i = 0; i < ndata_sets; i++)
	set_data_on_off(i, VISIBILITY_ON);
}

void data_all_off_func()
{
    int i;

    for (i = 0; i < ndata_sets; i++)
	set_data_on_off(i, VISIBILITY_OFF);
}
