#include "levels.h"

#include "utility.h"

static int nlevels;
static int nlevels_alloc = 0;
static float *levels = NULL;

void free_levels()
{
    FREE(levels, float);
    nlevels_alloc = 0;
}

static Status allocate_levels()
{
    if (nlevels > nlevels_alloc)
    {
	free_levels();
	MALLOC(levels, float, nlevels);
	nlevels_alloc = nlevels;
    }

    return  OK;
}

#define  SMALLEST_LEVEL  (1.0e-6)

Status find_levels(Levels_info *info, String error_msg)
{
    int i;
    float level, change;

    if (get_floats(1, &level, info->base_level) == ERROR)
    {
	sprintf(error_msg, "no value for base level");
	return  ERROR;
    }

/*
    if (level < SMALLEST_LEVEL)
    {
	sprintf(error_msg, "base level is %7.2e, must be > %7.2e",
						level, SMALLEST_LEVEL);
	return  ERROR;
    }
*/
    if (level <= 0)
    {
	sprintf(error_msg, "base level is %7.2e, must be > 0", level);
	return  ERROR;
    }

    if (get_integers(1, &nlevels, info->number_levels) == ERROR)
    {
	sprintf(error_msg, "no value for number of levels");
	return  ERROR;
    }

    if (nlevels < 1)
    {
	sprintf(error_msg, "number of levels is %d, must be < 1", nlevels);
	return  ERROR;
    }

    if (get_floats(1, &change, info->change_levels) == ERROR)
    {
	sprintf(error_msg, "no value for change between levels");
	return  ERROR;
    }

    if (allocate_levels() == ERROR)
    {
	sprintf(error_msg, "allocating memory for levels");
	return  ERROR;
    }

    levels[0] = level;

    for (i = 1; i < nlevels; i++)
    {
	if (info->change_type == CHANGE_MULTIPLY)
	    levels[i] = change * levels[i-1];
	else
	    levels[i] = change + levels[i-1];

/*
	if (levels[i] < SMALLEST_LEVEL)
    	{
	    sprintf(error_msg, "level #%d is %7.2e, must be > %7.2e",
					i+1, levels[i], SMALLEST_LEVEL);
	    return  ERROR;
    	}
*/
	if (levels[i] <= 0)
	{
	    sprintf(error_msg, "level #%d is %7.2e, must be > 0",
					i+1, levels[i]);
	    return  ERROR;
 	}

    }

    info->nlevels = nlevels;
    info->levels = levels;

    return  OK;
}

Status modify_levels(String base_level, String level_modifier,
					int modify_type, String error_msg)
{
    float level, modifier;

    if (get_floats(1, &level, base_level) == ERROR)
	RETURN_ERROR_MSG("no value for base level");

    if (get_floats(1, &modifier, level_modifier) == ERROR)
	RETURN_ERROR_MSG("no value for base level modifier");

    switch(modify_type)
    {
	case MODIFY_MULTIPLY:
	    level *= modifier;
	    break;

	case MODIFY_DIVIDE:
	    level /= modifier;
	    break;

	case MODIFY_ADD:
	    level += modifier;
	    break;

	case MODIFY_SUBTRACT:
	    level -= modifier;
	    break;
    }

    sprintf(base_level, "%3.2f", level);

    return  OK;
}
