#define  EXTERN
#include "param_value.h"
#undef  EXTERN

#include "param.h"

#define  NO_PATTERN	""

typedef struct
{
    char *value;
    char pattern[30];
}   Parameter;

#include "param_param.h"

#define  SEPARATOR	':'

static Line param_name;

Bool pattern_is_parameter(char *pattern, char **value)
{
    Parameter *params;

    for (params = parameters; params->value; params++)
    {
	if (!strcmp(params->pattern, pattern))
	{
	    *value = params->value;

	    return  TRUE;
	}
    }

    return  FALSE;
}

void save_parameters()
{
    Parameter *params;
    FILE *fp;

    if (*param_name)
    {
	if (!OPEN_FOR_WRITING(fp, param_name))
	{
    	    for (params = parameters; params->value; params++)
	    {
		fprintf(fp, "%s %c ", params->pattern, SEPARATOR);

	    	STRIP_LEADING_SPACE(params->value);
		fputs(params->value, fp);

		fprintf(fp, "\n");
	    }

	    fclose (fp);
	}
    }
}

static void find_match(char *pattern, char *value)
{
    Parameter *params;

    for (params = parameters; params->value; params++)
    {
	if (!strcmp(params->pattern, pattern))
	{
	    STRIP_LEADING_SPACE(value);
	    strcpy(params->value, value);

	    return;
	}
    }
}

static void read_parameters()
{
    char *pattern, *value;
    char line[2*LINE_SIZE];
    FILE *fp;

    if (!OPEN_FOR_READING(fp, param_name))
    {
	while (fgets(line, 2*LINE_SIZE, fp))
	{
	    STRIP_CARRIAGE_RETURN(line);
    	    if (value = strchr(line, SEPARATOR))
	    {
		*value = 0;  pattern = line;
	    	STRIP_LEADING_SPACE(pattern);
	    	STRIP_TRAILING_SPACE(pattern);

	    	find_match(pattern, value+1);
	    }
	}

	fclose (fp);
    }
}

#define  EXTRA_SYMBOL  "."

static void create_param_name(char *program)
{
    char *ptr;

    *param_name = 0;
    if (*program)
    {
	ptr = strrchr(program, DIRECTORY_SYMBOL);

/*
	if (ptr)
	{
	    ptr++;
	    strncpy(param_name, program, ptr-program);
	}
	else
	{
	    ptr = program;
	}

	strcat(param_name, EXTRA_SYMBOL);
	strcat(param_name, ptr);
*/
	if (ptr)
	    ptr++;
	else
	    ptr = program;

	sprintf(param_name, "%s%s", EXTRA_SYMBOL, ptr);
    }
}

static void set_defaults()
{
    Parameter *params;

    for (params = parameters; params->value; params++)
	*(params->value) = 0;
}

void initialize_parameters(char *program)
{
    set_defaults();

    create_param_name(program);

    if (*param_name)  read_parameters();
}

#ifdef TEST

void main(int argc, char **argv)
{
    initialize_parameters(argv[0]);
    save_parameters();
}

#endif /* TEST */
