#include "save_func.h"

#include "data.h"
#include "param.h"
#include "region_func.h"
#include "save.h"
#include "utility.h"

static int region_type = WHOLE_REGION;

static int nsave_sets = 0;
static int current_set = -1;

static void update_save_data()
{
    if (*save_region)
	region_type = atoi(save_region);
}

void remove_save_set_func(int save_set)
{
    if (save_set < nsave_sets)
    {
	if (save_set == current_set)
	    current_set = -1;

	nsave_sets--;
    }
}

void register_save_set_func(int save_set)
{
    if (save_set >= nsave_sets)
	nsave_sets++;
}

void save_select_func(int save_set)
{
    if (current_set == save_set)
	current_set = -1;
    else
	current_set = save_set;
}

Status save_save_func(YesNo_func func, String error_msg)
{
    int i, ref_type, first[DISPLAY_DIM], last[DISPLAY_DIM];
    float x, lower[DISPLAY_DIM], upper[DISPLAY_DIM];
    Data_info *data_info;
    Line msg;

    if (current_set == -1)
	RETURN_ERROR_MSG("no data set selected");

    update_save_data();

    if (file_exists(save_data))
    {
	sprintf(msg, "Data file '%s' exists, overwrite?", save_data);

        if ((*func)(msg, "Yes", "No", (String) NULL) == NO)
            return  OK;
    }

    if (file_exists(save_param))
    {
	sprintf(msg, "Parameter file '%s' exists, overwrite?", save_param);

        if ((*func)(msg, "Yes", "No", (String) NULL) == NO)
            return  OK;
    }

    data_info = get_data_set(current_set);

    if (region_type == WHOLE_REGION)
    {
	for (i = 0; i < DISPLAY_DIM; i++)
	{
	    first[i] = 0;
	    last[i] = data_info->npoints[i];
	}
    }
    else /* (region_type == DISPLAY_REGION) */
    {
	CHECK_STATUS(find_region_func(&ref_type, lower, upper, error_msg));

	convert_range_to_points(ref_type, DISPLAY_DIM, data_info->npoints,
					data_info->ref, lower, upper);

	for (i = 0; i < DISPLAY_DIM; i++)
	{
	    x = MAX(1, lower[i]);
	    first[i] = x - 0.5;
	    x = MIN(data_info->npoints[i], upper[i]);
	    last[i] = x + 0.5;
	}
    }

    return  save_data_set(save_data, save_param, data_info, first, last,
								error_msg);
}
