#include "block3.h"

#include "block_io.h"
#include "script.h"
#include "utility.h"

static int nstore;
static float *store;

static Bool have_output;

static int ndim;

static Script *script;

static int nchunks;
static int max_nblocks_chunk;
static int nblocks_chunk;
/*
static int size_of_chunk;
*/
static int process_size;

static int total_nblocks;
static int size_of_block;
static int disk_block;

static int *block_size;
static int *npoints;

static int nblocks[MAX_NDIM];

static int cum_blocks[MAX_NDIM];
static int cum_block_size[MAX_NDIM];

static Block_IO block_io_in;
static Block_IO block_io_out;

static void init_arrays()
{
    int dim;

    BLOCKS(nblocks, npoints, block_size, ndim);

    CUMULATIVE(cum_blocks, nblocks, total_nblocks, ndim);
    CUMULATIVE(cum_block_size, block_size, size_of_block, ndim);

    max_nblocks_chunk = nstore / size_of_block;
    max_nblocks_chunk = MIN(max_nblocks_chunk, total_nblocks);

    nchunks = 1 + (total_nblocks - 1) / max_nblocks_chunk;

    dim = script->dims[1];
    VECTOR_PRODUCT(process_size, block_size, dim);
}

static void init_chunk(int chunk)
{
    disk_block = chunk * max_nblocks_chunk;

    if (chunk == (nchunks-1))
	nblocks_chunk = total_nblocks - disk_block;
    else
	nblocks_chunk = max_nblocks_chunk;

/*
    size_of_chunk = nblocks_chunk * size_of_block;

    printf("disk block = %d, size_of_chunk = %d\n", disk_block, size_of_chunk);
*/
}

static Status disk_to_store(int chunk, String error_msg)
{
    sprintf(error_msg, "chunk %d: ", chunk);
    error_msg += strlen(error_msg);

    CHECK_STATUS(read_file_blocks(&block_io_in, disk_block, nblocks_chunk, store, error_msg));

    return  OK;
}

static Status store_to_disk(int chunk, String error_msg)
{
    sprintf(error_msg, "chunk %d: ", chunk);
    error_msg += strlen(error_msg);

    CHECK_STATUS(write_file_blocks(&block_io_out, disk_block, nblocks_chunk, store, error_msg));

    return  OK;
}

static void process_chunk()
{
    int i, j, nsteps, u1, v1, u2, v2, a1, b1, a2, b2;

    nsteps = nblocks_chunk * size_of_block / (2 * process_size);

    for (i = 0; i < nsteps; i++)
    {
	for (j = 0; j < process_size; j += 2)
	{
	    u1 = 2 * process_size * i + j;
	    v1 = u1 + 1;
	    u2 = u1 + process_size;
	    v2 = u2 + 1;

	    a1 = store[u1];
	    b1 = store[v1];
	    a2 = store[u2];
	    b2 = store[v2];

	    store[u1] = HALF * (a1 + a2);
	    store[v1] = HALF * (b1 + b2);
	    store[u2] = HALF * (b1 - b2);
	    store[v2] = HALF * (- a1 + a2);
	}
    }
}

static Status block_process3(String error_msg)
{
    int i;

    for (i = 0; i < nchunks; i++)
    {
	printf("\t... working on chunk %d of %d\n", i+1, nchunks);
	FLUSH;

	init_chunk(i);

	CHECK_STATUS(disk_to_store(i, error_msg));

	process_chunk();

	if (have_output)
	{
	    if (block_io_in.file == block_io_out.file)
		block_io_out.last_done = block_io_in.last_done;

	    CHECK_STATUS(store_to_disk(i, error_msg));

	    if (block_io_in.file == block_io_out.file)
		block_io_in.last_done = block_io_out.last_done;
	}
    }

    return  OK;
}

Status process_blocks3(Size_info *size_info, Store_info *store_info,
			File_info *file_info,
			Script *s, String error_msg)
{
    script = s;

    ndim = size_info->ndim;
    block_size = size_info->block_size;
    npoints = size_info->npoints;

    store = store_info->store;
    nstore = store_info->nstore;

    have_output = file_info->have_output;

    if (!(file_info->blocked))
	RETURN_ERROR_MSG("must have blocked data in process_blocks3()");

    init_arrays();

    block_io_in.name = file_info->input_file;
    block_io_in.file = file_info->file_in;
    block_io_in.swapped = file_info->swapped;
    block_io_in.integer = file_info->integer;
    block_io_in.deflated = FALSE;
    block_io_in.header = file_info->header;
    block_io_in.dir_size = 0;
    block_io_in.directory = (int *) NULL;
    block_io_in.block_size = size_of_block;
    block_io_in.byte_size = file_info->byte_size;

    block_io_out.name = file_info->output_file;
    block_io_out.file = file_info->file_out;
    block_io_out.block_size = size_of_block;
    block_io_out.deflated = FALSE;

    CHECK_STATUS(block_process3(error_msg));

    if (have_output)
    {
	file_info->input_file = file_info->output_file;
	file_info->swapped = determine_swapped();
	file_info->integer = FALSE;
	file_info->blocked = TRUE;
	file_info->header = 0;
    }

    return  OK;
}
