#include "utility.h"

Bool determine_swapped()
{
    Bool swapped = FALSE;

#ifdef BIG_ENDIAN_DATA
    if (is_little_endian())
	swapped = TRUE;
#endif /* BIG_ENDIAN_DATA */

#ifdef LITTLE_ENDIAN_DATA
    if (is_big_endian())
	swapped = TRUE;
#endif /* LITTLE_ENDIAN_DATA */

    return  swapped;
}

Status endian_fwrite(char *x, int n, FILE *fp)
{
    Status status = OK;
    Bool swapped = determine_swapped();

    if (swapped)
	swap_bytes(x, BYTES_PER_WORD*n);

    if (FWRITE(x, BYTES_PER_WORD, n, fp))
	status = ERROR;

    if (swapped)
	swap_bytes(x, BYTES_PER_WORD*n);

    return  status;
}

/* below only handles four byte case, not sure about rest */
Bool is_big_endian()
{
    static char c[4] = { 0, 0, 0, 1 };
    int x;

    x = *((int *) &c);

    if (x == 1)
	return  TRUE;
    else
	return  FALSE;
}

Bool is_little_endian()
{
    return !is_big_endian();
}

int endianess()
{
    if (is_big_endian())
	return  IS_BIG_ENDIAN;
    else
	return  IS_LITTLE_ENDIAN;
}

Bool file_exists(String file)
{
    FILE *fp;

    if (OPEN_FOR_READING(fp, file))
    {
	return  FALSE;
    }
    else
    {
	fclose(fp);

	return  TRUE;
    }
}

Bool equal_strings(String string1, String string2)
{
    if (strcmp(string1, string2))
	return  FALSE;
    else
	return  TRUE;
}

Status copy_string(String *string1, String string2, String error_msg)
{
    int n = strlen(string2) + 1;
    char *s;

    sprintf(error_msg, "allocating memory for string copy");
    MALLOC(s, char, n);

    strcpy(s, string2);
    *string1 = s;

    return  OK;
}

Bool empty_string(String string)
{
    int i, n = strlen(string);

    for (i = 0; i < n; i++)
    {
	if (!isspace(string[i]))
	    return  FALSE;
    }

    return  TRUE;
}

/* print_integer_array assumes array components should have +1 added */

void print_integer_array(int n, int *array)
{
    int i;

    printf("(");

    for (i = 0; i < n; i++)
    {
        if (i > 0)
            printf(", ");

        printf("%d", array[i]+1);
    }

    printf(")");
}

/* swap_bytes assumes that there are 4 bytes per word */

void swap_bytes(char *ptr, int nbytes)
{
    char *ptr2;

    for (ptr2 = ptr+nbytes; ptr < ptr2; ptr += 4)
    {
	SWAP(ptr[0], ptr[3], char);
	SWAP(ptr[1], ptr[2], char);
    }
}

/* float_words takes integer data and converts it to floating point */

void float_words(float *ptr, int nwords)
{
    float *ptr2;

    for (ptr2 = ptr+nwords; ptr < ptr2; ptr++)
	*ptr = *((int *) ptr);
}

/* int_words takes floating point data and converts it to integer by rounding */

void int_words(int *ptr, int nwords)
{
    int *ptr2;
    float x;

    for (ptr2 = ptr+nwords; ptr < ptr2; ptr++)
    {
	x = *((float *) ptr);
	*ptr = NEAREST_INTEGER(x);
    }
}

int log_2(int n)  /* assumes that n is a power of 2 */
{
    int m = -1;

    while (n > 0)
    {
	n >>= 1;  m++;
    }

    return  m;
}

int floor_power_of_2(int n)
{
    int m = -1;

    if (n < 1)  return  0;  /* arbitrary */

    while (n > 0)
    {
	n >>= 1;  m++;
    }

    return  (1 << m);
}

int ceil_power_of_2(int n)
{
    int m = -1, p, q = n;

    if (q < 1)  return  0;  /* arbitrary */

    while (q > 0)
    {
	q >>= 1;  m++;
    }

    p = 1 << m;

    if (p < n)
	return  2*p;
    else
	return  p;
}

int greatest_common_factor(int m, int n)
{
    int p;

    if (m == 0)
	return  n;

    if (n == 0)
	return  m;

    m = ABS(m);
    n = ABS(n);

    if (m > n)
	SWAP(m, n, int);

    p = n % m;
    while (p != 0)
    {
	n = m;
	m = p;
	p = n % m;
    }

    return  m;
}

YesNo yes_func(String msg, String yes, String no, String cancel)
{
    return  YES;
}

YesNo no_func(String msg, String yes, String no, String cancel)
{
    return  NO;
}

YesNo cancel_func(String msg, String yes, String no, String cancel)
{
    return  CANCEL;
}

Status start_screen_print(String error_msg)
{
    return  OK;
}

void print_screen_message(String message)
{
    printf(message);
}

void end_screen_print()
{
}

void start_no_timer(String message)
{
}

int update_no_timer(float fraction)
{
    return  CONTINUE;
}

void stop_no_timer(Status status)
{
}

void start_screen_timer(String message)
{
    printf("%s ...\n", message);
}

int update_screen_timer(float fraction)
{
    int percent = 100.0 * fraction;
    printf("\t%3d%% done\n", percent);

    return  CONTINUE;
}

void stop_screen_timer(Status status)
{
    if (status == OK)
	printf("... Finished\n");
}

#define  SEPARATOR  " \t"

Status get_integers(int n, int *array, char *string)
{
    int i;
    char *ptr1, *ptr2;
    Line copy;

    strncpy(copy, string, LINE_SIZE);
    ptr1 = copy;
    for (i = 0; i < n; i++)
    {
	if (!(ptr2 = strtok(ptr1, SEPARATOR)) ||
		(sscanf(ptr2, "%d", array+i) != 1))
	    return  ERROR;

	ptr1 = NULL;
    }

    return  OK;
}

Status get_floats(int n, float *array, char *string)
{
    int i;
    char *ptr1, *ptr2;
    Line copy;

    strncpy(copy, string, LINE_SIZE);
    ptr1 = copy;
    for (i = 0; i < n; i++)
    {
	if (!(ptr2 = strtok(ptr1, SEPARATOR)) ||
		(sscanf(ptr2, "%f", array+i) != 1))
	    return  ERROR;

	ptr1 = NULL;
    }

    return  OK;
}

int get_max_integers(int nmax, int *array, char *string)
{
    int n;
    char *ptr1, *ptr2;
    Line copy;

    strncpy(copy, string, LINE_SIZE);
    ptr1 = copy;
    for (n = 0; n < nmax; n++)
    {
	if (!(ptr2 = strtok(ptr1, SEPARATOR)) ||
		(sscanf(ptr2, "%d", array+n) != 1))
	    return  n;

	ptr1 = NULL;
    }

    return  n;
}

int get_max_floats(int nmax, float *array, char *string)
{
    int n;
    char *ptr1, *ptr2;
    Line copy;

    strncpy(copy, string, LINE_SIZE);
    ptr1 = copy;
    for (n = 0; n < nmax; n++)
    {
	if (!(ptr2 = strtok(ptr1, SEPARATOR)) ||
		(sscanf(ptr2, "%f", array+n) != 1))
	    return  n;

	ptr1 = NULL;
    }

    return  n;
}

static Bool skip_this(int ind, int n, int *skip)
{
    int i;

    for (i = 0; i < n; i++)
	if (skip[i] == ind)
	    return  TRUE;

    return  FALSE;
}

Status get_some_integers(int n, int m, int *skip, int *array, char *string)
{
    int i;
    char *ptr1, *ptr2;
    Line copy;

    strncpy(copy, string, LINE_SIZE);
    ptr1 = copy;
    for (i = 0; i < n; i++)
    {
	if (!(ptr2 = strtok(ptr1, SEPARATOR)))
	    return  ERROR;

	if (skip_this(i, m, skip))
	    array[i] = 0;
	else if (sscanf(ptr2, "%d", array+i) != 1)
	    return  ERROR;

	ptr1 = NULL;
    }

    return  OK;
}

Status get_some_floats(int n, int m, int *skip, float *array, char *string)
{
    int i;
    char *ptr1, *ptr2;
    Line copy;

    strncpy(copy, string, LINE_SIZE);
    ptr1 = copy;
    for (i = 0; i < n; i++)
    {
	if (!(ptr2 = strtok(ptr1, SEPARATOR)))
	    return  ERROR;

	if (skip_this(i, m, skip))
	    array[i] = 0;
	else if (sscanf(ptr2, "%f", array+i) != 1)
	    return  ERROR;

	ptr1 = NULL;
    }

    return  OK;
}
