#include "contour.h"

#include "list.h"

#define  NTIMER_UPDATES  50
	/* number of timer updates when constructing contours */

#define  ARRAYS_ALLOC  100
	/* number of arrays of vertices, nodes to allocate at a time */

#define  VERTICES_ALLOC  1000
	/* number of vertices, nodes to allocate at a time */

static int i0;
static int i1;
static int npoints0;
static int npoints1;
static int nlevels;
static int nvertices;
static int narrays;
static int nvertices_max = 0;
static int narrays_max = 0;
static int nvertices_alloc = VERTICES_ALLOC;
static int narrays_alloc = ARRAYS_ALLOC;
static int nrows_max = 0;
/*
static int ndata_max = 0;
*/

static Vertex *v_new;
static Vertex *v_col;
static Vertex **v_row;
static Vertex **v_rows = (Vertex **) NULL;
static Vertex **vertex_arrays = (Vertex **) NULL;

static List v_list;
static List *v_lists;
static Node **node_arrays = (Node **) NULL;

static Data level;
static Data *levels;
static Coord *offset;
static Coord *scale;
static Data *data_old;
static Data *data_new;
static Data *d_old;
static Data *d_new;

static Line err_msg;

static Status (*get_data_row)(Data **data, String error_msg);
static Timer_funcs *timer_funcs;

static Status new_vertex()
{
    int m;
    Vertex *v;
    Node *n;

    if (nvertices >= nvertices_alloc)
    {
	narrays++;

	if (narrays >= narrays_max)
	{
	    m = narrays_alloc + narrays_max;

	    sprintf(err_msg, "reallocating memory for arrays");

	    REALLOC(node_arrays, Node *, m);
	    REALLOC(vertex_arrays, Vertex *, m);

	    narrays_max = m;
	}

	if (narrays >= nvertices_max)
	{
	    n = (Node *) NULL;  v = (Vertex *) NULL;
	    sprintf(err_msg, "allocating memory for vertices");

	    MALLOC(n, Node, nvertices_alloc);
	    MALLOC(v, Vertex, nvertices_alloc);

	    node_arrays[narrays] = n;
	    vertex_arrays[narrays] = v;

	    nvertices_max++;
	}

	nvertices = 0;
    }

    v = &(vertex_arrays[narrays][nvertices]);
    n = &(node_arrays[narrays][nvertices]);

    DATA(n) = (Generic_ptr) v;
    NEXT(n) = v_list;
    v_list = n;

    v_new = v;
    v_new->v1 = (Vertex *) NULL;
    v_new->v2 = (Vertex *) NULL;
    v_new->marker = 0;

    nvertices++;

    return  OK;
}

#define  INTERPOLATE(a, b)  ((level - (a)) / ((b) - (a)))

static Status new_vertex0(Data d1, Data d2, int x, int y)
{
    CHECK_STATUS(new_vertex());

    v_new->p.x = offset->x + scale->x*(x + INTERPOLATE(d1, d2));
    v_new->p.y = offset->y + scale->y*y;

    return  OK;
}

static Status new_vertex1(Data d1, Data d2, int x, int y)
{
    CHECK_STATUS(new_vertex());

    v_new->p.x = offset->x + scale->x*x;
    v_new->p.y = offset->y + scale->y*(y + INTERPOLATE(d1, d2));

    return  OK;
}

static Status new_edge00()
{
    return  OK;
}

static Status new_edge33()
{
    return  OK;
}

static Status new_edge01()
{
    CHECK_STATUS(new_vertex1(*d_old, *d_new, i0+1, i1));
    v_col = v_new;

    v_row[i0]->v1 = v_col;
    v_col->v2 = v_row[i0];

    return  OK;
}

static Status new_edge32()
{
    CHECK_STATUS(new_vertex1(*d_old, *d_new, i0+1, i1));
    v_col = v_new;

    v_row[i0]->v2 = v_col;
    v_col->v1 = v_row[i0];

    return  OK;
}

static Status new_edge02()
{
    CHECK_STATUS(new_vertex0(*(d_new-1), *d_new, i0, i1+1));
    v_row[i0] = v_new;

    CHECK_STATUS(new_vertex1(*d_old, *d_new, i0+1, i1));
    v_col = v_new;

    v_row[i0]->v2 = v_col;
    v_col->v1 = v_row[i0];

    return  OK;
}

static Status new_edge31()
{
    CHECK_STATUS(new_vertex0(*(d_new-1), *d_new, i0, i1+1));
    v_row[i0] = v_new;

    CHECK_STATUS(new_vertex1(*d_old, *d_new, i0+1, i1));
    v_col = v_new;

    v_row[i0]->v1 = v_col;
    v_col->v2 = v_row[i0];

    return  OK;
}

static Status new_edge03()
{
    CHECK_STATUS(new_vertex0(*(d_new-1), *d_new, i0, i1+1));

    v_row[i0]->v1 = v_new;
    v_new->v2 = v_row[i0];

    v_row[i0] = v_new;

    return  OK;
}

static Status new_edge30()
{
    CHECK_STATUS(new_vertex0(*(d_new-1), *d_new, i0, i1+1));

    v_row[i0]->v2 = v_new;
    v_new->v1 = v_row[i0];

    v_row[i0] = v_new;

    return  OK;
}

static Status new_edge10()
{
    v_row[i0]->v2 = v_col;
    v_col->v1 = v_row[i0];

    return  OK;
}

static Status new_edge23()
{
    v_row[i0]->v1 = v_col;
    v_col->v2 = v_row[i0];

    return  OK;
}

static Status new_edge11()
{
    CHECK_STATUS(new_vertex1(*d_old, *d_new, i0+1, i1));

    v_col->v1 = v_new;
    v_new->v2 = v_col;

    v_col = v_new;

    return  OK;
}

static Status new_edge22()
{
    CHECK_STATUS(new_vertex1(*d_old, *d_new, i0+1, i1));

    v_col->v2 = v_new;
    v_new->v1 = v_col;

    v_col = v_new;

    return  OK;
}

static Status new_edge12()
{
    Data d, d1, d2, d3, d4;
    Vertex *v;

    d1 = *(d_old-1);
    d2 = *d_old;
    d3 = *(d_new-1);
    d4 = *d_new;

    CHECK_STATUS(new_vertex0(d3, d4, i0, i1+1));
    v = v_new;

    CHECK_STATUS(new_vertex1(d2, d4, i0+1, i1));

    d = (d1 + d2 + d3 + d4) / 4;

    if (d > level)
    {
    	v_col->v1 = v;
    	v->v2 = v_col;
	v_new->v1 = v_row[i0];
	v_row[i0]->v2 = v_new;
    }
    else
    {
    	v_col->v1 = v_row[i0];
	v_row[i0]->v2 = v_col;
	v_new->v1 = v;
    	v->v2 = v_new;
    }

    v_row[i0] = v;
    v_col = v_new;

    return  OK;
}

static Status new_edge21()
{
    Data d, d1, d2, d3, d4;
    Vertex *v;

    d1 = *(d_old-1);
    d2 = *d_old;
    d3 = *(d_new-1);
    d4 = *d_new;

    CHECK_STATUS(new_vertex0(d3, d4, i0, i1+1));
    v = v_new;

    CHECK_STATUS(new_vertex1(d2, d4, i0+1, i1));

    d = (d1 + d2 + d3 + d4) / 4;

    if (d > level)
    {
    	v_col->v2 = v_row[i0];
	v_row[i0]->v1 = v_col;
	v_new->v2 = v;
    	v->v1 = v_new;
    }
    else
    {
    	v_col->v2 = v;
    	v->v1 = v_col;
	v_new->v2 = v_row[i0];
	v_row[i0]->v1 = v_new;
    }

    v_row[i0] = v;
    v_col = v_new;

    return  OK;
}

static Status new_edge13()
{
    CHECK_STATUS(new_vertex0(*(d_new-1), *d_new, i0, i1+1));

    v_col->v1 = v_new;
    v_new->v2 = v_col;

    v_row[i0] = v_new;

    return  OK;
}

static Status new_edge20()
{
    CHECK_STATUS(new_vertex0(*(d_new-1), *d_new, i0, i1+1));

    v_col->v2 = v_new;
    v_new->v1 = v_col;

    v_row[i0] = v_new;

    return  OK;
}

#define  N  4

#define  GET_DATA_ROW(data) \
	 CHECK_STATUS((*get_data_row)(&data, err_msg));

#define  DATA_ABOVE_LEVEL(d)   ( ((d) > level) ? 1 : 0 )
#define  DATA_ABOVE_LEVEL2(d)  ( ((d) > level) ? 2 : 0 )

static Status do_contours()
{
    int l, b_old, b_new, n;
    float fraction;
    Data *d_end;
    Bool *have_edge;
/*
    static Bool have_edge[N][N] =
	{ { FALSE, TRUE, TRUE, TRUE },
	  { TRUE, TRUE, TRUE, TRUE },
	  { TRUE, TRUE, TRUE, TRUE },
	  { TRUE, TRUE, TRUE, FALSE } };
*/
    static Bool have_edge_0[N] = { FALSE, TRUE, TRUE, TRUE };
    static Bool have_edge_1[N] = { TRUE, TRUE, TRUE, TRUE };
    static Bool have_edge_2[N] = { TRUE, TRUE, TRUE, TRUE };
    static Bool have_edge_3[N] = { TRUE, TRUE, TRUE, FALSE };
    static Bool *have_edge_n[N] =
	{ have_edge_0, have_edge_1, have_edge_2, have_edge_3 };
    static Status (*new_edge_proc[N][N])() =
	{ { new_edge00, new_edge01, new_edge02, new_edge03 },
	  { new_edge10, new_edge11, new_edge12, new_edge13 },
	  { new_edge20, new_edge21, new_edge22, new_edge23 },
	  { new_edge30, new_edge31, new_edge32, new_edge33 } };

    GET_DATA_ROW(data_old);

    fraction = 0;
    if ((*(timer_funcs->update_timer))(fraction) == ABORT)
	    return  OTHER;

    i1 = 0;
    for (l = 0; l < nlevels; l++)
    {
	level = levels[l];
	v_list = v_lists[l];
	v_row = v_rows + l*(npoints0-1);

	d_old = data_old;

	b_old = DATA_ABOVE_LEVEL(*d_old);

	for (i0 = 0; i0 < npoints0-1; i0++)
	{
	    b_new = DATA_ABOVE_LEVEL(*(++d_old));

	    if (b_old != b_new)
	    {
		CHECK_STATUS(new_vertex0(*(d_old-1), *d_old, i0, i1));
		v_row[i0] = v_new;
		b_old = b_new;
	    }

    	}

	v_lists[l] = v_list;
    }

    n = npoints1 / NTIMER_UPDATES;
    n = MAX(n, 1);

    for (i1 = 0; i1 < npoints1-1; i1++)
    {
	if (!((i1+1) % n))
	{
	    fraction = ((float) (i1+1)) / ((float) npoints1);

	    if ((*(timer_funcs->update_timer))(fraction) == ABORT)
		return  OTHER;
	}

	GET_DATA_ROW(data_new);

	for (l = 0; l < nlevels; l++)
	{
	    level = levels[l];
	    v_list = v_lists[l];
	    v_row = v_rows + l*(npoints0-1);

	    d_old = data_old;
	    d_new = data_new;

	    d_end = d_old + (npoints0 - 1);

	    b_old = DATA_ABOVE_LEVEL(*d_old)
	    		+ DATA_ABOVE_LEVEL2(*d_new);

	    i0 = 0;
	    if ((b_old == 1) || (b_old == 2))
	    {
		CHECK_STATUS(new_vertex1(*d_old, *d_new, i0, i1));
		v_col = v_new;
	    }

/*
	    for (i0 = 0; i0 < npoints0-1; i0++)
*/
	    have_edge = have_edge_n[b_old];
	    while (d_old < d_end)
	    {
	    	b_new = DATA_ABOVE_LEVEL(*(++d_old))
	    			| DATA_ABOVE_LEVEL2(*(++d_new));

/*
		if (have_edge[b_old][b_new])
*/
		if (have_edge[b_new])
		{
		    i0 = d_old - data_old - 1;
		    CHECK_STATUS((*new_edge_proc[b_old][b_new])());

		    b_old = b_new;
		    have_edge = have_edge_n[b_old];
		}
	    }

	    v_lists[l] = v_list;
	}

	SWAP(data_old, data_new, Data *);
    }

    return  OK;
}

static Status init_contours()
{
    int m;
    Vertex *v;
    Node *n;

    nvertices = 0;
    narrays = 0;

    m = nlevels * (npoints0-1);

    if (m > nrows_max)
    {
	FREE(v_rows, Vertex *);

	sprintf(err_msg, "allocating memory for row vertices");

    	MALLOC(v_rows, Vertex *, m);

	nrows_max = m;
    }

/*
    m = npoints0;

    if (m > ndata_max)
    {
	FREE(data_old, Data);
	FREE(data_new, Data);

	sprintf(err_msg, "allocating memory for data row");

	MALLOC(data_old, Data, m);
	MALLOC(data_new, Data, m);

	ndata_max = m;
    }
*/

    if (narrays_max == 0)
    {
	sprintf(err_msg, "allocating memory for arrays");

	MALLOC(node_arrays, Node *, narrays_alloc);
	MALLOC(vertex_arrays, Vertex *, narrays_alloc);

	narrays_max = narrays_alloc;

	sprintf(err_msg, "allocating memory for vertices");

	MALLOC(n, Node, nvertices_alloc);
	MALLOC(v, Vertex, nvertices_alloc);

	node_arrays[0] = n;
	vertex_arrays[0] = v;

	nvertices_max = 1;
    }

    return  OK;
}

void free_contour_memory()
{
    int i;

    for (i = 0; i < nvertices_max; i++)
    {
	FREE(vertex_arrays[i], Vertex);
	FREE(node_arrays[i], Node);
    }

    FREE(vertex_arrays, Vertex *);
    FREE(node_arrays, Node *);

    FREE(v_rows, Vertex *);
/*
    FREE(data_old, Data);
    FREE(data_new, Data);
*/

    nvertices_max = 0;
    narrays_max = 0;
    nrows_max = 0;
/*
    ndata_max = 0;
*/
}

Status construct_contours(Contour_info *contour_info, String error_msg)
{
    int l;
    Status status;

    nlevels = contour_info->nlevels;
    levels = contour_info->levels;
    npoints0 = contour_info->npoints[0];
    npoints1 = contour_info->npoints[1];
    offset = contour_info->offset;
    scale = contour_info->scale;
    v_lists = contour_info->vertices;
    get_data_row = contour_info->get_row;
    timer_funcs = contour_info->timer_funcs;

    for (l = 0; l < nlevels; l++)
	v_lists[l] = (List) NULL;

/*  if npoints < 2 then no contours, but get_data_row may need to be called  */
    if ((npoints0 < 1) || (npoints1 < 1))
	return  OK;

    if (init_contours() == ERROR) \
    {
	free_contour_memory();
	sprintf(error_msg, "construct_contours: %s", err_msg);

	return  ERROR;
    }

    if ((status = do_contours()) == ERROR) \
    {
	free_contour_memory();
	sprintf(error_msg, "construct_contours: %s", err_msg);
    }

    return  status;
}

int next_chain(List *vertices, Vertex **vertex)
{
    int nvert;
    List vert;
    Vertex *v, *vv;

    for (vert = *vertices; vert; vert = NEXT(vert))
    {
	v = (Vertex *) DATA(vert);
	if (v->marker == 0)
	    break;
    }

    *vertices = vert;

    if (!vert)
	return  0;

    nvert = 1;

    for (vv = v; (vv->v1) && (vv->v1 != v); vv = vv->v1)
    {
	nvert++;
	vv->marker = 1;
    }

    vv->marker = 1;

    for (v = v->v2; v && (v != vv); v = v->v2)
    {
	nvert++;
	v->marker = 1;
    }

    *vertex = vv;

    return  nvert;
}

#ifdef TEST

#define  MAX_NLEVELS  20

#define  MAX_NPOINTS  100

static int npts;
static float *data0;
static float *data1;
static FILE *fp;

static Status get_row(Data **p_data, String error_msg)
{
    static int row = 0;
    Data *data;

    if (row % 2)
	data = data0;
    else
	data = data1;

    if (fread((void *) data, BYTES_PER_WORD, npts, fp) != npts)
    {
	sprintf(error_msg, "reading data row %d", row);
	return  ERROR;
    }

    *p_data = data;
    row++;

    return  OK;
}

static Status alloc_mem()
{
    MALLOC(data0, Data, npts);
    MALLOC(data1, Data, npts);

    return  OK;
}

void main()
{
    int i, n, l, nlevels, npoints[2], open, closed;
    Coord offset, scale;
    float levels[MAX_NLEVELS];
    List vert, vertices[MAX_NLEVELS];
    int count[MAX_NPOINTS];
    Line file_name, error_msg;
    Vertex *v, *vv;
    Contour_info contour_info;

    printf("Data file name: ");
    scanf("%s", file_name);

    if ((fp = fopen(file_name, READ)) == NULL)
        ERROR_AND_EXIT("could not open file");

    printf("Number of points: ");
    scanf("%d %d", npoints, npoints+1);

    npts = npoints[0];

    if (alloc_mem() == ERROR)
	ERROR_AND_EXIT("allocating memory for data");

    printf("Number of levels: ");
    scanf("%d", &nlevels);

    if (nlevels > MAX_NLEVELS)
    {
	sprintf(error_msg, "maximum number of levels: %d", MAX_NLEVELS);
	ERROR_AND_EXIT(error_msg);
    }

    printf("Contour levels: ");

    for (l = 0; l < nlevels; l++)
	scanf("%f", levels+l);

    offset.x = offset.y = 0;
    scale.x = scale.y = 1;

    contour_info.nlevels = nlevels;
    contour_info.levels = levels;
    contour_info.npoints = npoints;
    contour_info.offset = &offset;
    contour_info.scale = &scale;
    contour_info.vertices = vertices;
    contour_info.get_row = get_row;

    if (construct_contours(&contour_info, error_msg) == ERROR)
	ERROR_AND_EXIT(error_msg);

    printf("nvertices = %d\n", nvertices+nvertices_alloc*narrays);

    open = closed = 0;
    ZERO_VECTOR(count, MAX_NPOINTS);

    for (l = 0; l < nlevels; l++)
    {
	vert = vertices[l];

	while ((n = next_chain(&vert, &v)) > 0)
	{
	    if (v->v1)
		closed++;
	    else
		open++;

	    n = MIN(n, MAX_NPOINTS-1);
	    count[n]++;
	}
    }

    printf("nopen chains = %d, nclosed chains = %d\n", open, closed);

/*
    for (n = MAX_NPOINTS-1; (n >= 0) && (count[n] == 0); n--)
	;
*/
    n = MAX_NPOINTS - 1;

    printf("chain vertex count histogram:");
    for (i = 0; i <= n; i++)
    {
	if (!(i % 10))
	    printf("\n");

	printf("%5d ", count[i]);
    }

    printf("\n");
}

#endif /* TEST */
