#include "event_handle.h"

void no_button_handler(Button button, int x, int y, Time time)
{
}

void no_key_handler(Key_symbol key, int x, int y, Time time)
{
}

static Button get_button(int state)
{
    Button button;

    if (state & Button1Mask)
	button = Button1;
    else if (state & Button2Mask)
	button = Button2;
    else if (state & Button3Mask)
	button = Button3;
    else
	button = AnyButton;

    return  button;
}

static Key_symbol get_key(XEvent *event)
{
    Line buffer;
    Key_symbol key;
    XComposeStatus compose;

    (void) XLookupString((XKeyEvent *) event, buffer, LINE_SIZE,
							&key, &compose);

    return  key;
}

static void event_handler(Widget widget, XtPointer data, XEvent *event,
								Boolean *cont)
{
    Button button;
    int x, y;
    Time time;
    Key_symbol key;
    Event_handlers *handlers = (Event_handlers *) data;

    switch (event->type)
    {
	case ButtonPress:
	    button = ((XButtonPressedEvent *) event)->button;
	    x = ((XButtonPressedEvent *) event)->x;
	    y = ((XButtonPressedEvent *) event)->y;
	    time = ((XButtonPressedEvent *) event)->time;

	    (*(handlers->button_press))(button, x, y, time);

	    break;

	case ButtonRelease:
	    button = ((XButtonReleasedEvent *) event)->button;
	    x = ((XButtonReleasedEvent *) event)->x;
	    y = ((XButtonReleasedEvent *) event)->y;
	    time = ((XButtonReleasedEvent *) event)->time;

	    (*(handlers->button_release))(button, x, y, time);

	    break;

	case MotionNotify:
	    button = get_button(((XMotionEvent *) event)->state);
	    x = ((XMotionEvent *) event)->x;
	    y = ((XMotionEvent *) event)->y;
	    time = ((XMotionEvent *) event)->time;

	    (*(handlers->pointer_motion))(button, x, y, time);

	    break;

	case EnterNotify:
	    button = get_button(((XEnterWindowEvent *) event)->state);
	    x = ((XEnterWindowEvent *) event)->x;
	    y = ((XEnterWindowEvent *) event)->y;
	    time = ((XEnterWindowEvent *) event)->time;

	    (*(handlers->enter_window))(button, x, y, time);

	    break;

	case LeaveNotify:
	    button = get_button(((XLeaveWindowEvent *) event)->state);
	    x = ((XLeaveWindowEvent *) event)->x;
	    y = ((XLeaveWindowEvent *) event)->y;
	    time = ((XLeaveWindowEvent *) event)->time;

	    (*(handlers->leave_window))(button, x, y, time);

	    break;

        case KeyPress:
	    key = get_key(event);
	    x = ((XKeyPressedEvent *) event)->x;
	    y = ((XKeyPressedEvent *) event)->y;
	    time = ((XKeyPressedEvent *) event)->time;

	    (*(handlers->key_press))(key, x, y, time);

	    break;

        case KeyRelease:
	    key = get_key(event);
	    x = ((XKeyReleasedEvent *) event)->x;
	    y = ((XKeyReleasedEvent *) event)->y;
	    time = ((XKeyReleasedEvent *) event)->time;

	    (*(handlers->key_release))(key, x, y, time);

	    break;

	default:
	    printf("received unknown event type %d\n", event->type);
    }
}

void add_event_handler(Widget widget, Event_handle *handle)
{
    XtAddEventHandler(widget, handle->mask, False, event_handler,
					(XtPointer) (handle->handlers));
}
