#include "plots.h"

#include "data.h"
#include "input.h"
#include "object.h"

#define  PLOT_NAME		2
#define  PLOT_DATA_INFO		3

static Status do_plot_y(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    Data_info *data_info = (Data_info *) (store[PLOT_DATA_INFO]->data);
    Object_property *property = &(data_info->property);

    get_current_property(first_run, property);

    return  OK;
}

Status init_plot_y(int nstore, Parser_store **store, String error_msg)
{
    Ref_info *ref = get_input_ref();

    if (register_data_set(PLOT_NAME, PLOT_DATA_INFO, -1, INPUT_X, store,
						ref, error_msg) == ERROR)
	return  ERROR;

/*  +1 below because of Data_info  */
    if (setup_command(nstore+1, store, "plot_y", do_plot_y,
							error_msg) == ERROR)
	return  ERROR;

    return  OK;
}
