#include "fold_func.h"

#include "param.h"
#include "fold.h"

static int x_fold_type = REGION_NO_FOLD;
static int y_fold_type = REGION_NO_FOLD;
static int x_flip_type = PEAK_FLIP_OFF;
static int y_flip_type = PEAK_FLIP_OFF;

#define  SET_VALUE(string, value) \
	 {   sprintf(string, "%7.2f", value);   }

#define  SET_VALUE_OR_DEFAULT(string, value) \
	 {   if (!(*(string)))  SET_VALUE(string, value);   }

#define  WIDTH_MIN	500.0
#define  WIDTH_MAX	1500.0
#define  WIDTH_VALUE	1000.0
#define  CENTER_MIN	500.0
#define  CENTER_MAX	1500.0
#define  CENTER_VALUE	1000.0

void set_fold_params()
{
/*  below needed so that scale initialized correctly  */
    SET_VALUE_OR_DEFAULT(x_width_min, WIDTH_MIN);
    SET_VALUE_OR_DEFAULT(x_width_max, WIDTH_MAX);
    SET_VALUE_OR_DEFAULT(x_width_value, WIDTH_VALUE);
    SET_VALUE_OR_DEFAULT(x_center_min, CENTER_MIN);
    SET_VALUE_OR_DEFAULT(x_center_max, CENTER_MAX);
    SET_VALUE_OR_DEFAULT(x_center_value, CENTER_VALUE);
    SET_VALUE_OR_DEFAULT(y_width_min, WIDTH_MIN);
    SET_VALUE_OR_DEFAULT(y_width_max, WIDTH_MAX);
    SET_VALUE_OR_DEFAULT(y_width_value, WIDTH_VALUE);
    SET_VALUE_OR_DEFAULT(y_center_min, CENTER_MIN);
    SET_VALUE_OR_DEFAULT(y_center_max, CENTER_MAX);
    SET_VALUE_OR_DEFAULT(y_center_value, CENTER_VALUE);
}

static void update_fold_data()
{
    if (*x_fold)
	x_fold_type = atoi(x_fold);

    if (*y_fold)
	y_fold_type = atoi(y_fold);

    if (*x_flip)
	x_flip_type = atoi(x_flip);

    if (*y_flip)
	y_flip_type = atoi(y_flip);
}

void default_fold_numbers()
{
    SET_VALUE(x_width_min, WIDTH_MIN);
    SET_VALUE(x_width_max, WIDTH_MAX);
    SET_VALUE(x_width_value, WIDTH_VALUE);
    SET_VALUE(x_center_min, CENTER_MIN);
    SET_VALUE(x_center_max, CENTER_MAX);
    SET_VALUE(x_center_value, CENTER_VALUE);
    SET_VALUE(y_width_min, WIDTH_MIN);
    SET_VALUE(y_width_max, WIDTH_MAX);
    SET_VALUE(y_width_value, WIDTH_VALUE);
    SET_VALUE(y_center_min, CENTER_MIN);
    SET_VALUE(y_center_max, CENTER_MAX);
    SET_VALUE(y_center_value, CENTER_VALUE);
}

Status find_fold_type(int *fold_type, int *flip_type, String error_msg)
{
    update_fold_data();

    fill_fold_type(fold_type, x_fold_type, y_fold_type);
    fill_flip_type(flip_type, x_flip_type, y_flip_type);

    return  OK;
}

static void get_range(float *s0, float *s1, String width, String center)
{
    float w, c;

    w = atof(width);
    c = atof(center);

    w /= 2;

    *s0 = c - w;
    *s1 = c + w;
}

void get_fold_range(float *lower, float *upper)
{
    get_range(lower, upper, x_width_value, x_center_value);
    get_range(lower+1, upper+1, y_width_value, y_center_value);
}

static void set_range(float s0, float s1,
		String width_value, String width_min, String width_max,
		String center_value, String center_min, String center_max)
{
    float w, c;

    w = s1 - s0;
    c = 0.5 * (s0 + s1);

    SET_VALUE(width_value, w);

    if ((w < atoi(width_min)) || (w > atoi(width_max)))
    {
	SET_VALUE(width_min, 0.5*w);
	SET_VALUE(width_max, 1.5*w);
    }

    SET_VALUE(center_value, c);

    if ((c < atoi(center_min)) || (c > atoi(center_max)))
    {
	SET_VALUE(center_min, c - 0.5*w);
	SET_VALUE(center_max, c + 0.5*w);
    }
}

void set_fold_range(float *lower, float *upper)
{
    set_range(lower[0], upper[0], x_width_value, x_width_min, x_width_max,
                                x_center_value, x_center_min, x_center_max);

    set_range(lower[1], upper[1], y_width_value, y_width_min, y_width_max,
                                y_center_value, y_center_min, y_center_max);
}
