#include "plot2_nog.h"

#include "color.h"
#include "param.h"
#include "position.h"

#include "script.h"
#include "command.h"

void main(int argc, char **argv)
{
    char *ptr;
    Line error_msg, param_file;

    printf(product);

    if (help_request(argc, argv, help_table))
	exit (0);

    if (argc != 2)
    {
	sprintf(error_msg, "correct usage: %s <plot2 file>", argv[0]);
	ERROR_AND_EXIT(error_msg);
    }

    strcpy(param_file, argv[0]);
    if (ptr = strrchr(param_file, '_'))
	*ptr = 0;

    initialize_parameters(param_file);
    initialize_colors();
    read_positions();

    if (run_script_file(argv[1], script_action_table, error_msg) == ERROR)
	ERROR_AND_EXIT(error_msg);
}
