#ifndef _incl_script
#define _incl_script

#include "macros.h"
#include "types.h"

typedef Status (*Command_func)(String value, Generic_ptr data,String error_msg);

typedef struct
{
    String key;
    Command_func func;
}   Script_action;

extern Status print_command_func
	(String value, Generic_ptr data, String error_msg);

extern Status sleep_command_func
	(String value, Generic_ptr data, String error_msg);

extern Status no_command_func
	(String value, Generic_ptr data, String error_msg);

extern Status read_script_file
	(String file, Script_action *table, String error_msg);

extern Status run_script_file
	(String file, Script_action *table, String error_msg);

#endif /* _incl_script */
