#include "unblock.h"

#include "block.h"
#include "par.h"
#include "parse.h"
#include "ref.h"

static int ndim;
static int *block_size;
static int *npoints;

static int nstore;
static float *store;

/*
static Ref_info *ref;
*/

static char *input_file;
static Line output_file;
static FILE *file_in;
static FILE *file_out;
static Bool swapped_in;
static Bool integer_in;
static Bool swapped_out;
static Bool integer_out;
static Bool blocked;
static int header;
static Bool deflated;
static int dir_size;
static int *directory;

static Bool input_found;
static Bool output_found;
static char *unblock_file;

static int parse_string[] = { PARSE_STRING };

#define  FOUND_TWICE(string) \
	 {   sprintf(error_msg, "in \"%s\" '%s' found twice", \
				unblock_file, string);  return  ERROR;   }

#define  FOUND_BEFORE(string1, string2) \
	 {   sprintf(error_msg, "in \"%s\" '%s' found before '%s'", \
			unblock_file, string1, string2);  return  ERROR;   }

#define  NOT_FOUND(string) \
	 {   sprintf(error_msg, "in \"%s\" no '%s' found", \
				unblock_file, string);  return  ERROR;   }

static Status allocate_memory(String error_msg)
{
    sprintf(error_msg, "allocating memory for store");
    MALLOC(store, float, nstore);

    if (deflated)
    {
	sprintf(error_msg, "allocating memory for directory");
	MALLOC(directory, int, dir_size);
    }

    return  OK;
}

static void determine_params()
{
    VECTOR_PRODUCT(nstore, block_size, ndim);
    nstore *= BLOCK(npoints[0], block_size[0]);
}

static Status input_parse(Generic_ptr *var, String error_msg)
{
    String par_file = (String) (*var);
    Par_info par_info;

    if (input_found)
	FOUND_TWICE("input");

    CHECK_STATUS(read_par_file(par_file, &par_info, error_msg));

    input_file = par_info.file;
    ndim = par_info.ndim;
    npoints = par_info.npoints;
    block_size = par_info.block_size;
/*
    ref = par_info.ref;
*/
    swapped_in = par_info.swapped;
    integer_in = par_info.integer;
    blocked = par_info.blocked;
    header = par_info.header;
    deflated = par_info.deflated;
    dir_size = par_info.dir_size;

    if (!blocked)
    {
	sprintf(error_msg, "input file \"%s\" must be blocked", input_file);
	return  ERROR;
    }

    if (deflated)
	printf("Warning: input file \"%s\" deflated\n", input_file);
/*
	RETURN_ERROR_MSG("input file cannot be deflated");
*/

    input_found = TRUE;

    return  OK;
}

static Status output_parse(Generic_ptr *var, String error_msg)
{
    String name = (String) (*var);

    if (!input_found)
	FOUND_BEFORE("output", "input");

    if (output_found)
	FOUND_TWICE("output");

    strcpy(output_file, name);

    output_found = TRUE;

    return  OK;
}

static Status int_parse(Generic_ptr *var, String error_msg)
{
    if (!output_found)
	FOUND_BEFORE("int", "output");

    if (integer_out)
	FOUND_TWICE("int");

    integer_out = TRUE;

    return  OK;
}

static Status swap_parse(Generic_ptr *var, String error_msg)
{
    if (!output_found)
	FOUND_BEFORE("swap", "output");

    if (swapped_out)
	FOUND_TWICE("swap");

    swapped_out = TRUE;

    return  OK;
}

static Parse_line unblock_table[] =
{
    { "input",		1,	parse_string,		input_parse },
    { "output",		1,	parse_string,		output_parse },
    { "int",		0,	(int *) NULL,		int_parse },
    { "swap",		0,	(int *) NULL,		swap_parse },
    { (String) NULL,	0,	(int *) NULL,		no_parse_func }
};

static Status read_unblock_file(String error_msg)
{
    input_found = FALSE;
    output_found = FALSE;

    integer_out = FALSE;
    swapped_out = FALSE;

    CHECK_STATUS(parse_file(unblock_file, unblock_table, TRUE, error_msg));

    if (!input_found)
	NOT_FOUND("input");

    if (!output_found)
	NOT_FOUND("output");

    return  OK;
}

void main(int argc, char **argv)
{
    Line error_msg;
    Size_info size_info;
    Store_info store_info;
    File_info file_info;

    printf(product);

    if (help_request(argc, argv, help_table))
	exit (0);

    if (argc != 2)
    {
        sprintf(error_msg, "correct usage: %s <unblock file>", argv[0]);
        ERROR_AND_EXIT(error_msg);
    }

    unblock_file = argv[1];

    if (read_unblock_file(error_msg) == ERROR)
        ERROR_AND_EXIT(error_msg);

    determine_params();

    if (allocate_memory(error_msg) == ERROR)
        ERROR_AND_EXIT(error_msg);

    if (OPEN_FOR_BINARY_READING(file_in, input_file))
    {
	sprintf(error_msg, "opening \"%s\" for reading", input_file);
	ERROR_AND_EXIT(error_msg);
    }

    if (OPEN_FOR_BINARY_WRITING(file_out, output_file))
    {
	sprintf(error_msg, "opening \"%s\" for writing", output_file);
	ERROR_AND_EXIT(error_msg);
    }

    size_info.ndim = ndim;
    size_info.block_size = block_size;
    size_info.npoints = npoints;

    store_info.store = store;
    store_info.directory = directory;

    file_info.input_file = input_file;
    file_info.output_file = output_file;
    file_info.file_in = file_in;
    file_info.file_out = file_out;
    file_info.swapped_in = swapped_in;
    file_info.integer_in = integer_in;
    file_info.blocked = blocked;
    file_info.header = header;
    file_info.deflated = deflated;
    file_info.dir_size = dir_size;
    file_info.swapped_out = swapped_out;
    file_info.integer_out = integer_out;

    if (block_process(&size_info, &store_info, &file_info, error_msg) == ERROR)
	ERROR_AND_EXIT(error_msg);
}
