#include "macros.h"
#include "types.h"

#define  MAX_NDIM	10

#define  SIZE_OF_BLOCK  4096

#define  DEFAULT_SF	500.0
#define  DEFAULT_SW	2000.0
#define  DEFAULT_PPM	1.0
#define  DEFAULT_PT	0.0
#define  DEFAULT_NUC	"1H"
#define  DEFAULT_AXT	1

#define  TEXT_SIZE      8

void main(int argc, char **argv)
{
    int i, j, ndim, n = SIZE_OF_BLOCK, x[SIZE_OF_BLOCK];
    int tot_nblocks, max_nblocks, dim, ind;
    int npoints[MAX_NDIM], nblocks[MAX_NDIM], block_size[MAX_NDIM];
    float *y = (float *) x;
    float sw[MAX_NDIM], sf[MAX_NDIM], refppm[MAX_NDIM], refpt[MAX_NDIM];
    char nuc[MAX_NDIM][TEXT_SIZE], *ptr, *ptr2, *file_in, *file_out;
    Line file_name, line, error_msg;
    FILE *fp, *fp2;

    if (argc < 3)
    {
	sprintf(error_msg, "correct syntax: %s <par file> <matrix file>",
								argv[0]);
	ERROR_AND_EXIT(error_msg);
    }

    file_in = argv[1];
    file_out = argv[2];

    if ((fp = fopen(file_in, READ)) == NULL)
	ERROR_AND_EXIT("opening parameter file");

    while (fgets(line, LINE_SIZE, fp))
    {
	STRIP_LEADING_SPACE(line);

	ptr = line;

	while (*ptr && !isspace(*ptr))
	    ptr++;

	ptr2 = ptr;

	while (*ptr && isspace(*ptr))
	    ptr++;

	*ptr2 = 0;

	if (!strcmp(line, "ndim"))
	{
	    ndim = atoi(ptr);

	    for (i = 0; i < ndim; i++)
	    {
		sw[i] = DEFAULT_SW;
		sf[i] = DEFAULT_SF;
		refppm[i] = DEFAULT_PPM;
		refpt[i] = DEFAULT_PT;

		for (j = 0; j < TEXT_SIZE; j++)
		    nuc[i][j] = 0;

		strcpy(nuc[i], DEFAULT_NUC);
	    }
	}
	else if (!strcmp(line, "file"))
	{
	    strcpy(file_name, ptr);
	    STRIP_CARRIAGE_RETURN(file_name);
	}
	else if (!strcmp(line, "dim"))
	    dim = atoi(ptr) - 1;
	else if (!strcmp(line, "npts"))
	    npoints[dim] = atoi(ptr);
	else if (!strcmp(line, "block"))
	    block_size[dim] = atoi(ptr);
	else if (!strcmp(line, "sw"))
	    sw[dim] = atof(ptr);
	else if (!strcmp(line, "sf"))
	    sf[dim] = atof(ptr);
	else if (!strcmp(line, "refppm"))
	    refppm[dim] = atof(ptr);
	else if (!strcmp(line, "refpt"))
	    refpt[dim] = atof(ptr);
	else if (!strcmp(line, "nuc"))
	    strcpy(nuc[dim], ptr);
    }

    fclose(fp);

    for (i = 0; i < ndim; i++)
    {
	if (block_size[i] < 1)
	{
	    sprintf(error_msg, "'block' is < 1 for dimension %d", i+1);
	    ERROR_AND_EXIT(error_msg);
	}

	if (npoints[i] < 1)
	{
	    sprintf(error_msg, "'npts' is < 1 for dimension %d", i+1);
	    ERROR_AND_EXIT(error_msg);
	}
    }

    if ((fp = fopen(file_out, WRITE)) == NULL)
	ERROR_AND_EXIT("opening matrix file");

    tot_nblocks = 1;
    max_nblocks = 0;
    for (i = 0; i < ndim; i++)
    {
	nblocks[i] = 1 + (npoints[i] - 1) / block_size[i];
	tot_nblocks *= nblocks[i];
	max_nblocks = MAX(max_nblocks, nblocks[i]);
    }

    for (i = 0; i < SIZE_OF_BLOCK; i++)
	x[i] = 0;

				/* number of dimensions */
    x[0] = ndim;

				/* matrix type */
    x[1] = 1;

				/* total number of blocks */
    x[2] = tot_nblocks;
    x[2]++;			/* + 1 for header */

				/* largest number of blocks */
    x[3] = max_nblocks;

    ind = 20;
				/* totorg in Felix (what is it?) */
    for (i = 0; i < ndim; i++)
        x[ind++] = 1;

				/* (real) dimensions */
    for (i = 0; i < ndim; i++)
        x[ind++] = npoints[i];

				/* number of blocks */
    for (i = 0; i < ndim; i++)
        x[ind++] = nblocks[i];

				/* cumulative block tally */
    x[ind++] = 1;
    for (i = 1; i < ndim; i++)
    {
        x[ind] = nblocks[i-1] * x[ind-1];
	ind++;
    }

				/* number of points per block */
    for (i = 0; i < ndim; i++)
        x[ind++] = block_size[i];

				/* cumulative point tally */
    x[ind++] = 1;
    for (i = 1; i < ndim; i++)
    {
        x[ind] = block_size[i-1] * x[ind-1];
	ind++;
    }

				/* reference sf */
    for (i = 0; i < ndim; i++)
        y[ind++] = sf[i];

				/* reference sw */
    for (i = 0; i < ndim; i++)
        y[ind++] = sw[i];

				/* reference ppm */
    for (i = 0; i < ndim; i++)
        y[ind++] = refppm[i];

				/* reference point */
    for (i = 0; i < ndim; i++)
        y[ind++] = refpt[i];

				/* reference axis */
    for (i = 0; i < ndim; i++)
        x[ind++] = DEFAULT_AXT;

    ind = 220;
				/* reference axis text */
    for (i = 0; i < ndim; i++)
        for (j = 0; j < TEXT_SIZE; j++)
            x[ind++] = (int) nuc[i][j];

    ind = 100;
				/* number of files for this matrix */
    x[ind++] = 1;

				/* number of blocks per output file */
    x[ind++] = 1+tot_nblocks;	/* +1 for header */

    ind = 111;

				/* number of characters for output file name */
    x[ind++] = strlen(file_out);

    ind = 121;
				/* output file name(s) */
    for (j = 0; j < strlen(file_out); j++)
	x[ind++] = (int) file_out[j];

				/* flag as N-dimensional */
    x[SIZE_OF_BLOCK-1] = 1;

    if ((fp2 = fopen(file_name, READ)) == NULL)
	ERROR_AND_EXIT("opening data file");

    if (fwrite((void *) x, BYTES_PER_WORD, n, fp) != n)
	ERROR_AND_EXIT("writing matrix file header");

    while (fread((void *) x, BYTES_PER_WORD, n, fp2) == n)
	if (fwrite((void *) x, BYTES_PER_WORD, n, fp) != n)
	    ERROR_AND_EXIT("writing matrix data");

    fclose(fp);
}
