#ifndef _incl_contours
#define _incl_contours

#include "macros.h"
#include "types.h"

typedef struct
{
    int positive_contours;
    int negative_contours;
    int ndim;
    int header_size;
    int dir_size;
    int *directory;
    float lower[2], upper[2]; /* plane region, in ppm */
    int word; /* just to keep track of where you are in file */
    int polylines; /* just to keep track of how many polylines there are */
}   Contours;

extern Contours *load_contours
	(String name, String error_msg);

extern void draw_contours
	(Contours *c); 

#endif /* _incl_contours */
