   /* BenAri external declarations for routines to read the tables */

#include "bacicnty.h"


   /* global array sizes */
extern int code_size;    /* actual size of code array */
extern int tab_size;     /* actual size of tab array  */
extern int btab_size;    /* actual size of btab array */ 
extern int atab_size;    /* actual size of atab array */
extern int stab_size;    /* actual size of stab array */
extern int last_infile;  /* index of last file in infile array */
extern int last_dbg_ix;  /* index of last entry in dbg array */

extern int read_code_table(FILE *f, ORDER code[]);

extern int read_identifier_table(FILE *f, TAB_STRUCT tab[]);

extern int read_block_table(FILE *f, BTAB_STRUCT btab[]);

extern int read_array_table(FILE *f, ATAB_STRUCT atab[]);

extern int read_string_table(FILE *f, char stab[]);

extern int read_file_info(FILE *f,InputFile** inputfile);

extern int read_debug_info(FILE* f, PCDEBUG dbg[]);

   /* check header line of a .pob or .pco file for validity */
extern void check_header(FILE *f);

   /* read pcode file up to, but not including, file & debug info */
extern void read_pcode_file(FILE *f);

   /* read the entire pcode file */
extern void read_entire_pcode_file(FILE *f);

  
/*
 *
 *  $Log: readtab.h,v $
 * Revision 1.3  1997/09/04  11:01:21  bynum
 * change prototypes to add name of array being read, add check_header
 *
 * Revision 1.2  1997/06/17  05:52:08  bynum
 * switch read functions from void to int, add read_entire_pcode_file()
 *
 * Revision 1.1  1995/09/07  13:59:31  bynum
 * Initial revision
 *
 * Revision 1.1  1995/09/07  13:59:31  bynum
 * Initial revision
 *
 *
 */

