/*  This is the minimal standard random number generator based on  */
/*  Schrage's method described on page 1195 of:                    */
/*     Random Number Generators: Good ones are hard to find        */
/*     Stephen K. Park & Keith W. Miller, CACM, v.31,10(Oct.88),   */
/*     pp. 1192 - 1201                                             */
/*  Implemented by Bill Bynum, September, 1993                     */

extern void randomize();
   /* randomize();                                                 */
   /* sets the seed for the random number generator from the clock */

extern void setseed();
   /* setseed(long newseed);                       */
   /* sets the seed to 'newseed', if it's positive */
   /* otherwise the default seed (1) is used       */

extern float strand();
   /* strand();                                                        */
   /* returns a randomly distributed 'random' real between 0 & 2^31 -1 */

extern unsigned random();
   /* random(range);                                                */
   /* returns a 'randomly' chosen integer between 0 and 'range' - 1 */


   /* the next two are for the user-callable random number generator */
   /* in the interpreter                                             */
extern float ustrand();
   /* strand();                                                        */
   /* returns a randomly distributed 'random' real between 0 & 2^31 -1 */

extern unsigned urandom();
   /* random(range);                                                */
   /* returns a 'randomly' chosen integer between 0 and 'range' - 1 */

/*
 *
 *  $Log: random.h,v $
 * Revision 1.2  1995/06/30  13:46:28  bynum
 * add 'ustrand' and 'urandom' functions with 'useed' to provide user
 * of interpreter with callable random number generator
 *
 * Revision 1.1  1995/06/22  06:49:42  bynum
 * Initial revision
 *
 *
 */
