import sys
from os import listdir, getcwd
from os.path import abspath, isdir, join, dirname, basename
from argparse import ArgumentParser

sys.path.append(abspath("scripts"))
from generate_imports_helper import comment, get_importable_lines


import_line_format = "\t_ \"{beat_path}/{module}/{name}\""
import_template = """// Licensed to Elasticsearch B.V. under one or more contributor
// license agreements. See the NOTICE file distributed with
// this work for additional information regarding copyright
// ownership. Elasticsearch B.V. licenses this file to you under
// the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Code generated by 'make imports' - DO NOT EDIT.

/*
{comment}
*/
package {package}

import (
{imports}
)
"""


def generate_and_write_to_file(outfile, go_beat_path):
    imported_beat_lines = get_importable_lines(go_beat_path, import_line_format)
    imported_lines = "\n".join(imported_beat_lines)
    package = basename(dirname(outfile))
    list_go = import_template.format(package=package,
                                     comment=comment,
                                     imports=imported_lines)
    with open(outfile, "w") as output:
        output.write(list_go)


if __name__ == "__main__":
    parser = ArgumentParser(description="Generate imports for Beats packages")
    parser.add_argument("--out", default="include/list.go")
    parser.add_argument("beats_path")
    args = parser.parse_args()

    generate_and_write_to_file(args.out, args.beats_path)
