// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudformation

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

const opCancelUpdateStack = "CancelUpdateStack"

// CancelUpdateStackRequest is a API request type for the CancelUpdateStack API operation.
type CancelUpdateStackRequest struct {
	*aws.Request
	Input *CancelUpdateStackInput
	Copy  func(*CancelUpdateStackInput) CancelUpdateStackRequest
}

// Send marshals and sends the CancelUpdateStack API request.
func (r CancelUpdateStackRequest) Send() (*CancelUpdateStackOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*CancelUpdateStackOutput), nil
}

// CancelUpdateStackRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Cancels an update on the specified stack. If the call completes successfully,
// the stack rolls back the update and reverts to the previous stack configuration.
//
// You can cancel only stacks that are in the UPDATE_IN_PROGRESS state.
//
//    // Example sending a request using the CancelUpdateStackRequest method.
//    req := client.CancelUpdateStackRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CancelUpdateStack
func (c *CloudFormation) CancelUpdateStackRequest(input *CancelUpdateStackInput) CancelUpdateStackRequest {
	op := &aws.Operation{
		Name:       opCancelUpdateStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelUpdateStackInput{}
	}

	output := &CancelUpdateStackOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return CancelUpdateStackRequest{Request: req, Input: input, Copy: c.CancelUpdateStackRequest}
}

const opContinueUpdateRollback = "ContinueUpdateRollback"

// ContinueUpdateRollbackRequest is a API request type for the ContinueUpdateRollback API operation.
type ContinueUpdateRollbackRequest struct {
	*aws.Request
	Input *ContinueUpdateRollbackInput
	Copy  func(*ContinueUpdateRollbackInput) ContinueUpdateRollbackRequest
}

// Send marshals and sends the ContinueUpdateRollback API request.
func (r ContinueUpdateRollbackRequest) Send() (*ContinueUpdateRollbackOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*ContinueUpdateRollbackOutput), nil
}

// ContinueUpdateRollbackRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// For a specified stack that is in the UPDATE_ROLLBACK_FAILED state, continues
// rolling it back to the UPDATE_ROLLBACK_COMPLETE state. Depending on the cause
// of the failure, you can manually  fix the error (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed)
// and continue the rollback. By continuing the rollback, you can return your
// stack to a working state (the UPDATE_ROLLBACK_COMPLETE state), and then try
// to update the stack again.
//
// A stack goes into the UPDATE_ROLLBACK_FAILED state when AWS CloudFormation
// cannot roll back all changes after a failed stack update. For example, you
// might have a stack that is rolling back to an old database instance that
// was deleted outside of AWS CloudFormation. Because AWS CloudFormation doesn't
// know the database was deleted, it assumes that the database instance still
// exists and attempts to roll back to it, causing the update rollback to fail.
//
//    // Example sending a request using the ContinueUpdateRollbackRequest method.
//    req := client.ContinueUpdateRollbackRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ContinueUpdateRollback
func (c *CloudFormation) ContinueUpdateRollbackRequest(input *ContinueUpdateRollbackInput) ContinueUpdateRollbackRequest {
	op := &aws.Operation{
		Name:       opContinueUpdateRollback,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ContinueUpdateRollbackInput{}
	}

	output := &ContinueUpdateRollbackOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return ContinueUpdateRollbackRequest{Request: req, Input: input, Copy: c.ContinueUpdateRollbackRequest}
}

const opCreateChangeSet = "CreateChangeSet"

// CreateChangeSetRequest is a API request type for the CreateChangeSet API operation.
type CreateChangeSetRequest struct {
	*aws.Request
	Input *CreateChangeSetInput
	Copy  func(*CreateChangeSetInput) CreateChangeSetRequest
}

// Send marshals and sends the CreateChangeSet API request.
func (r CreateChangeSetRequest) Send() (*CreateChangeSetOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*CreateChangeSetOutput), nil
}

// CreateChangeSetRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Creates a list of changes that will be applied to a stack so that you can
// review the changes before executing them. You can create a change set for
// a stack that doesn't exist or an existing stack. If you create a change set
// for a stack that doesn't exist, the change set shows all of the resources
// that AWS CloudFormation will create. If you create a change set for an existing
// stack, AWS CloudFormation compares the stack's information with the information
// that you submit in the change set and lists the differences. Use change sets
// to understand which resources AWS CloudFormation will create or change, and
// how it will change resources in an existing stack, before you create or update
// a stack.
//
// To create a change set for a stack that doesn't exist, for the ChangeSetType
// parameter, specify CREATE. To create a change set for an existing stack,
// specify UPDATE for the ChangeSetType parameter. After the CreateChangeSet
// call successfully completes, AWS CloudFormation starts creating the change
// set. To check the status of the change set or to review it, use the DescribeChangeSet
// action.
//
// When you are satisfied with the changes the change set will make, execute
// the change set by using the ExecuteChangeSet action. AWS CloudFormation doesn't
// make changes until you execute the change set.
//
//    // Example sending a request using the CreateChangeSetRequest method.
//    req := client.CreateChangeSetRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet
func (c *CloudFormation) CreateChangeSetRequest(input *CreateChangeSetInput) CreateChangeSetRequest {
	op := &aws.Operation{
		Name:       opCreateChangeSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateChangeSetInput{}
	}

	output := &CreateChangeSetOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return CreateChangeSetRequest{Request: req, Input: input, Copy: c.CreateChangeSetRequest}
}

const opCreateStack = "CreateStack"

// CreateStackRequest is a API request type for the CreateStack API operation.
type CreateStackRequest struct {
	*aws.Request
	Input *CreateStackInput
	Copy  func(*CreateStackInput) CreateStackRequest
}

// Send marshals and sends the CreateStack API request.
func (r CreateStackRequest) Send() (*CreateStackOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*CreateStackOutput), nil
}

// CreateStackRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Creates a stack as specified in the template. After the call completes successfully,
// the stack creation starts. You can check the status of the stack via the
// DescribeStacks API.
//
//    // Example sending a request using the CreateStackRequest method.
//    req := client.CreateStackRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStack
func (c *CloudFormation) CreateStackRequest(input *CreateStackInput) CreateStackRequest {
	op := &aws.Operation{
		Name:       opCreateStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStackInput{}
	}

	output := &CreateStackOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return CreateStackRequest{Request: req, Input: input, Copy: c.CreateStackRequest}
}

const opCreateStackInstances = "CreateStackInstances"

// CreateStackInstancesRequest is a API request type for the CreateStackInstances API operation.
type CreateStackInstancesRequest struct {
	*aws.Request
	Input *CreateStackInstancesInput
	Copy  func(*CreateStackInstancesInput) CreateStackInstancesRequest
}

// Send marshals and sends the CreateStackInstances API request.
func (r CreateStackInstancesRequest) Send() (*CreateStackInstancesOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*CreateStackInstancesOutput), nil
}

// CreateStackInstancesRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Creates stack instances for the specified accounts, within the specified
// regions. A stack instance refers to a stack in a specific account and region.
// Accounts and Regions are required parameters—you must specify at least one
// account and one region.
//
//    // Example sending a request using the CreateStackInstancesRequest method.
//    req := client.CreateStackInstancesRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackInstances
func (c *CloudFormation) CreateStackInstancesRequest(input *CreateStackInstancesInput) CreateStackInstancesRequest {
	op := &aws.Operation{
		Name:       opCreateStackInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStackInstancesInput{}
	}

	output := &CreateStackInstancesOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return CreateStackInstancesRequest{Request: req, Input: input, Copy: c.CreateStackInstancesRequest}
}

const opCreateStackSet = "CreateStackSet"

// CreateStackSetRequest is a API request type for the CreateStackSet API operation.
type CreateStackSetRequest struct {
	*aws.Request
	Input *CreateStackSetInput
	Copy  func(*CreateStackSetInput) CreateStackSetRequest
}

// Send marshals and sends the CreateStackSet API request.
func (r CreateStackSetRequest) Send() (*CreateStackSetOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*CreateStackSetOutput), nil
}

// CreateStackSetRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Creates a stack set.
//
//    // Example sending a request using the CreateStackSetRequest method.
//    req := client.CreateStackSetRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackSet
func (c *CloudFormation) CreateStackSetRequest(input *CreateStackSetInput) CreateStackSetRequest {
	op := &aws.Operation{
		Name:       opCreateStackSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStackSetInput{}
	}

	output := &CreateStackSetOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return CreateStackSetRequest{Request: req, Input: input, Copy: c.CreateStackSetRequest}
}

const opDeleteChangeSet = "DeleteChangeSet"

// DeleteChangeSetRequest is a API request type for the DeleteChangeSet API operation.
type DeleteChangeSetRequest struct {
	*aws.Request
	Input *DeleteChangeSetInput
	Copy  func(*DeleteChangeSetInput) DeleteChangeSetRequest
}

// Send marshals and sends the DeleteChangeSet API request.
func (r DeleteChangeSetRequest) Send() (*DeleteChangeSetOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DeleteChangeSetOutput), nil
}

// DeleteChangeSetRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Deletes the specified change set. Deleting change sets ensures that no one
// executes the wrong change set.
//
// If the call successfully completes, AWS CloudFormation successfully deleted
// the change set.
//
//    // Example sending a request using the DeleteChangeSetRequest method.
//    req := client.DeleteChangeSetRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteChangeSet
func (c *CloudFormation) DeleteChangeSetRequest(input *DeleteChangeSetInput) DeleteChangeSetRequest {
	op := &aws.Operation{
		Name:       opDeleteChangeSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteChangeSetInput{}
	}

	output := &DeleteChangeSetOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return DeleteChangeSetRequest{Request: req, Input: input, Copy: c.DeleteChangeSetRequest}
}

const opDeleteStack = "DeleteStack"

// DeleteStackRequest is a API request type for the DeleteStack API operation.
type DeleteStackRequest struct {
	*aws.Request
	Input *DeleteStackInput
	Copy  func(*DeleteStackInput) DeleteStackRequest
}

// Send marshals and sends the DeleteStack API request.
func (r DeleteStackRequest) Send() (*DeleteStackOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DeleteStackOutput), nil
}

// DeleteStackRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Deletes a specified stack. Once the call completes successfully, stack deletion
// starts. Deleted stacks do not show up in the DescribeStacks API if the deletion
// has been completed successfully.
//
//    // Example sending a request using the DeleteStackRequest method.
//    req := client.DeleteStackRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStack
func (c *CloudFormation) DeleteStackRequest(input *DeleteStackInput) DeleteStackRequest {
	op := &aws.Operation{
		Name:       opDeleteStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteStackInput{}
	}

	output := &DeleteStackOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return DeleteStackRequest{Request: req, Input: input, Copy: c.DeleteStackRequest}
}

const opDeleteStackInstances = "DeleteStackInstances"

// DeleteStackInstancesRequest is a API request type for the DeleteStackInstances API operation.
type DeleteStackInstancesRequest struct {
	*aws.Request
	Input *DeleteStackInstancesInput
	Copy  func(*DeleteStackInstancesInput) DeleteStackInstancesRequest
}

// Send marshals and sends the DeleteStackInstances API request.
func (r DeleteStackInstancesRequest) Send() (*DeleteStackInstancesOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DeleteStackInstancesOutput), nil
}

// DeleteStackInstancesRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Deletes stack instances for the specified accounts, in the specified regions.
//
//    // Example sending a request using the DeleteStackInstancesRequest method.
//    req := client.DeleteStackInstancesRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackInstances
func (c *CloudFormation) DeleteStackInstancesRequest(input *DeleteStackInstancesInput) DeleteStackInstancesRequest {
	op := &aws.Operation{
		Name:       opDeleteStackInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteStackInstancesInput{}
	}

	output := &DeleteStackInstancesOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return DeleteStackInstancesRequest{Request: req, Input: input, Copy: c.DeleteStackInstancesRequest}
}

const opDeleteStackSet = "DeleteStackSet"

// DeleteStackSetRequest is a API request type for the DeleteStackSet API operation.
type DeleteStackSetRequest struct {
	*aws.Request
	Input *DeleteStackSetInput
	Copy  func(*DeleteStackSetInput) DeleteStackSetRequest
}

// Send marshals and sends the DeleteStackSet API request.
func (r DeleteStackSetRequest) Send() (*DeleteStackSetOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DeleteStackSetOutput), nil
}

// DeleteStackSetRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Deletes a stack set. Before you can delete a stack set, all of its member
// stack instances must be deleted. For more information about how to do this,
// see DeleteStackInstances.
//
//    // Example sending a request using the DeleteStackSetRequest method.
//    req := client.DeleteStackSetRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackSet
func (c *CloudFormation) DeleteStackSetRequest(input *DeleteStackSetInput) DeleteStackSetRequest {
	op := &aws.Operation{
		Name:       opDeleteStackSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteStackSetInput{}
	}

	output := &DeleteStackSetOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return DeleteStackSetRequest{Request: req, Input: input, Copy: c.DeleteStackSetRequest}
}

const opDescribeAccountLimits = "DescribeAccountLimits"

// DescribeAccountLimitsRequest is a API request type for the DescribeAccountLimits API operation.
type DescribeAccountLimitsRequest struct {
	*aws.Request
	Input *DescribeAccountLimitsInput
	Copy  func(*DescribeAccountLimitsInput) DescribeAccountLimitsRequest
}

// Send marshals and sends the DescribeAccountLimits API request.
func (r DescribeAccountLimitsRequest) Send() (*DescribeAccountLimitsOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DescribeAccountLimitsOutput), nil
}

// DescribeAccountLimitsRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Retrieves your account's AWS CloudFormation limits, such as the maximum number
// of stacks that you can create in your account.
//
//    // Example sending a request using the DescribeAccountLimitsRequest method.
//    req := client.DescribeAccountLimitsRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimits
func (c *CloudFormation) DescribeAccountLimitsRequest(input *DescribeAccountLimitsInput) DescribeAccountLimitsRequest {
	op := &aws.Operation{
		Name:       opDescribeAccountLimits,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccountLimitsInput{}
	}

	output := &DescribeAccountLimitsOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return DescribeAccountLimitsRequest{Request: req, Input: input, Copy: c.DescribeAccountLimitsRequest}
}

const opDescribeChangeSet = "DescribeChangeSet"

// DescribeChangeSetRequest is a API request type for the DescribeChangeSet API operation.
type DescribeChangeSetRequest struct {
	*aws.Request
	Input *DescribeChangeSetInput
	Copy  func(*DescribeChangeSetInput) DescribeChangeSetRequest
}

// Send marshals and sends the DescribeChangeSet API request.
func (r DescribeChangeSetRequest) Send() (*DescribeChangeSetOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DescribeChangeSetOutput), nil
}

// DescribeChangeSetRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Returns the inputs for the change set and a list of changes that AWS CloudFormation
// will make if you execute the change set. For more information, see Updating
// Stacks Using Change Sets (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-changesets.html)
// in the AWS CloudFormation User Guide.
//
//    // Example sending a request using the DescribeChangeSetRequest method.
//    req := client.DescribeChangeSetRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeChangeSet
func (c *CloudFormation) DescribeChangeSetRequest(input *DescribeChangeSetInput) DescribeChangeSetRequest {
	op := &aws.Operation{
		Name:       opDescribeChangeSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeChangeSetInput{}
	}

	output := &DescribeChangeSetOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return DescribeChangeSetRequest{Request: req, Input: input, Copy: c.DescribeChangeSetRequest}
}

const opDescribeStackEvents = "DescribeStackEvents"

// DescribeStackEventsRequest is a API request type for the DescribeStackEvents API operation.
type DescribeStackEventsRequest struct {
	*aws.Request
	Input *DescribeStackEventsInput
	Copy  func(*DescribeStackEventsInput) DescribeStackEventsRequest
}

// Send marshals and sends the DescribeStackEvents API request.
func (r DescribeStackEventsRequest) Send() (*DescribeStackEventsOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DescribeStackEventsOutput), nil
}

// DescribeStackEventsRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Returns all stack related events for a specified stack in reverse chronological
// order. For more information about a stack's event history, go to Stacks (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/concept-stack.html)
// in the AWS CloudFormation User Guide.
//
// You can list events for stacks that have failed to create or have been deleted
// by specifying the unique stack identifier (stack ID).
//
//    // Example sending a request using the DescribeStackEventsRequest method.
//    req := client.DescribeStackEventsRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackEvents
func (c *CloudFormation) DescribeStackEventsRequest(input *DescribeStackEventsInput) DescribeStackEventsRequest {
	op := &aws.Operation{
		Name:       opDescribeStackEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeStackEventsInput{}
	}

	output := &DescribeStackEventsOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return DescribeStackEventsRequest{Request: req, Input: input, Copy: c.DescribeStackEventsRequest}
}

// Paginate pages iterates over the pages of a DescribeStackEventsRequest operation,
// calling the Next method for each page. Using the paginators Next
// method will depict whether or not there are more pages.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeStackEvents operation.
//		req := client.DescribeStackEventsRequest(input)
//		p := req.Paginate()
//		for p.Next() {
//			page := p.CurrentPage()
//		}
//
//		if err := p.Err(); err != nil {
//			return err
//		}
//
func (p *DescribeStackEventsRequest) Paginate(opts ...aws.Option) DescribeStackEventsPager {
	return DescribeStackEventsPager{
		Pager: aws.Pager{
			NewRequest: func() (*aws.Request, error) {
				var inCpy *DescribeStackEventsInput
				if p.Input != nil {
					tmp := *p.Input
					inCpy = &tmp
				}

				req := p.Copy(inCpy)
				req.ApplyOptions(opts...)

				return req.Request, nil
			},
		},
	}
}

// DescribeStackEventsPager is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeStackEventsPager struct {
	aws.Pager
}

func (p *DescribeStackEventsPager) CurrentPage() *DescribeStackEventsOutput {
	return p.Pager.CurrentPage().(*DescribeStackEventsOutput)
}

const opDescribeStackInstance = "DescribeStackInstance"

// DescribeStackInstanceRequest is a API request type for the DescribeStackInstance API operation.
type DescribeStackInstanceRequest struct {
	*aws.Request
	Input *DescribeStackInstanceInput
	Copy  func(*DescribeStackInstanceInput) DescribeStackInstanceRequest
}

// Send marshals and sends the DescribeStackInstance API request.
func (r DescribeStackInstanceRequest) Send() (*DescribeStackInstanceOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DescribeStackInstanceOutput), nil
}

// DescribeStackInstanceRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Returns the stack instance that's associated with the specified stack set,
// AWS account, and region.
//
// For a list of stack instances that are associated with a specific stack set,
// use ListStackInstances.
//
//    // Example sending a request using the DescribeStackInstanceRequest method.
//    req := client.DescribeStackInstanceRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackInstance
func (c *CloudFormation) DescribeStackInstanceRequest(input *DescribeStackInstanceInput) DescribeStackInstanceRequest {
	op := &aws.Operation{
		Name:       opDescribeStackInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStackInstanceInput{}
	}

	output := &DescribeStackInstanceOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return DescribeStackInstanceRequest{Request: req, Input: input, Copy: c.DescribeStackInstanceRequest}
}

const opDescribeStackResource = "DescribeStackResource"

// DescribeStackResourceRequest is a API request type for the DescribeStackResource API operation.
type DescribeStackResourceRequest struct {
	*aws.Request
	Input *DescribeStackResourceInput
	Copy  func(*DescribeStackResourceInput) DescribeStackResourceRequest
}

// Send marshals and sends the DescribeStackResource API request.
func (r DescribeStackResourceRequest) Send() (*DescribeStackResourceOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DescribeStackResourceOutput), nil
}

// DescribeStackResourceRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Returns a description of the specified resource in the specified stack.
//
// For deleted stacks, DescribeStackResource returns resource information for
// up to 90 days after the stack has been deleted.
//
//    // Example sending a request using the DescribeStackResourceRequest method.
//    req := client.DescribeStackResourceRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResource
func (c *CloudFormation) DescribeStackResourceRequest(input *DescribeStackResourceInput) DescribeStackResourceRequest {
	op := &aws.Operation{
		Name:       opDescribeStackResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStackResourceInput{}
	}

	output := &DescribeStackResourceOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return DescribeStackResourceRequest{Request: req, Input: input, Copy: c.DescribeStackResourceRequest}
}

const opDescribeStackResources = "DescribeStackResources"

// DescribeStackResourcesRequest is a API request type for the DescribeStackResources API operation.
type DescribeStackResourcesRequest struct {
	*aws.Request
	Input *DescribeStackResourcesInput
	Copy  func(*DescribeStackResourcesInput) DescribeStackResourcesRequest
}

// Send marshals and sends the DescribeStackResources API request.
func (r DescribeStackResourcesRequest) Send() (*DescribeStackResourcesOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DescribeStackResourcesOutput), nil
}

// DescribeStackResourcesRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Returns AWS resource descriptions for running and deleted stacks. If StackName
// is specified, all the associated resources that are part of the stack are
// returned. If PhysicalResourceId is specified, the associated resources of
// the stack that the resource belongs to are returned.
//
// Only the first 100 resources will be returned. If your stack has more resources
// than this, you should use ListStackResources instead.
//
// For deleted stacks, DescribeStackResources returns resource information for
// up to 90 days after the stack has been deleted.
//
// You must specify either StackName or PhysicalResourceId, but not both. In
// addition, you can specify LogicalResourceId to filter the returned result.
// For more information about resources, the LogicalResourceId and PhysicalResourceId,
// go to the AWS CloudFormation User Guide (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/).
//
// A ValidationError is returned if you specify both StackName and PhysicalResourceId
// in the same request.
//
//    // Example sending a request using the DescribeStackResourcesRequest method.
//    req := client.DescribeStackResourcesRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResources
func (c *CloudFormation) DescribeStackResourcesRequest(input *DescribeStackResourcesInput) DescribeStackResourcesRequest {
	op := &aws.Operation{
		Name:       opDescribeStackResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStackResourcesInput{}
	}

	output := &DescribeStackResourcesOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return DescribeStackResourcesRequest{Request: req, Input: input, Copy: c.DescribeStackResourcesRequest}
}

const opDescribeStackSet = "DescribeStackSet"

// DescribeStackSetRequest is a API request type for the DescribeStackSet API operation.
type DescribeStackSetRequest struct {
	*aws.Request
	Input *DescribeStackSetInput
	Copy  func(*DescribeStackSetInput) DescribeStackSetRequest
}

// Send marshals and sends the DescribeStackSet API request.
func (r DescribeStackSetRequest) Send() (*DescribeStackSetOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DescribeStackSetOutput), nil
}

// DescribeStackSetRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Returns the description of the specified stack set.
//
//    // Example sending a request using the DescribeStackSetRequest method.
//    req := client.DescribeStackSetRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSet
func (c *CloudFormation) DescribeStackSetRequest(input *DescribeStackSetInput) DescribeStackSetRequest {
	op := &aws.Operation{
		Name:       opDescribeStackSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStackSetInput{}
	}

	output := &DescribeStackSetOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return DescribeStackSetRequest{Request: req, Input: input, Copy: c.DescribeStackSetRequest}
}

const opDescribeStackSetOperation = "DescribeStackSetOperation"

// DescribeStackSetOperationRequest is a API request type for the DescribeStackSetOperation API operation.
type DescribeStackSetOperationRequest struct {
	*aws.Request
	Input *DescribeStackSetOperationInput
	Copy  func(*DescribeStackSetOperationInput) DescribeStackSetOperationRequest
}

// Send marshals and sends the DescribeStackSetOperation API request.
func (r DescribeStackSetOperationRequest) Send() (*DescribeStackSetOperationOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DescribeStackSetOperationOutput), nil
}

// DescribeStackSetOperationRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Returns the description of the specified stack set operation.
//
//    // Example sending a request using the DescribeStackSetOperationRequest method.
//    req := client.DescribeStackSetOperationRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSetOperation
func (c *CloudFormation) DescribeStackSetOperationRequest(input *DescribeStackSetOperationInput) DescribeStackSetOperationRequest {
	op := &aws.Operation{
		Name:       opDescribeStackSetOperation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStackSetOperationInput{}
	}

	output := &DescribeStackSetOperationOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return DescribeStackSetOperationRequest{Request: req, Input: input, Copy: c.DescribeStackSetOperationRequest}
}

const opDescribeStacks = "DescribeStacks"

// DescribeStacksRequest is a API request type for the DescribeStacks API operation.
type DescribeStacksRequest struct {
	*aws.Request
	Input *DescribeStacksInput
	Copy  func(*DescribeStacksInput) DescribeStacksRequest
}

// Send marshals and sends the DescribeStacks API request.
func (r DescribeStacksRequest) Send() (*DescribeStacksOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DescribeStacksOutput), nil
}

// DescribeStacksRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Returns the description for the specified stack; if no stack name was specified,
// then it returns the description for all the stacks created.
//
// If the stack does not exist, an AmazonCloudFormationException is returned.
//
//    // Example sending a request using the DescribeStacksRequest method.
//    req := client.DescribeStacksRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacks
func (c *CloudFormation) DescribeStacksRequest(input *DescribeStacksInput) DescribeStacksRequest {
	op := &aws.Operation{
		Name:       opDescribeStacks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeStacksInput{}
	}

	output := &DescribeStacksOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return DescribeStacksRequest{Request: req, Input: input, Copy: c.DescribeStacksRequest}
}

// Paginate pages iterates over the pages of a DescribeStacksRequest operation,
// calling the Next method for each page. Using the paginators Next
// method will depict whether or not there are more pages.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeStacks operation.
//		req := client.DescribeStacksRequest(input)
//		p := req.Paginate()
//		for p.Next() {
//			page := p.CurrentPage()
//		}
//
//		if err := p.Err(); err != nil {
//			return err
//		}
//
func (p *DescribeStacksRequest) Paginate(opts ...aws.Option) DescribeStacksPager {
	return DescribeStacksPager{
		Pager: aws.Pager{
			NewRequest: func() (*aws.Request, error) {
				var inCpy *DescribeStacksInput
				if p.Input != nil {
					tmp := *p.Input
					inCpy = &tmp
				}

				req := p.Copy(inCpy)
				req.ApplyOptions(opts...)

				return req.Request, nil
			},
		},
	}
}

// DescribeStacksPager is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeStacksPager struct {
	aws.Pager
}

func (p *DescribeStacksPager) CurrentPage() *DescribeStacksOutput {
	return p.Pager.CurrentPage().(*DescribeStacksOutput)
}

const opEstimateTemplateCost = "EstimateTemplateCost"

// EstimateTemplateCostRequest is a API request type for the EstimateTemplateCost API operation.
type EstimateTemplateCostRequest struct {
	*aws.Request
	Input *EstimateTemplateCostInput
	Copy  func(*EstimateTemplateCostInput) EstimateTemplateCostRequest
}

// Send marshals and sends the EstimateTemplateCost API request.
func (r EstimateTemplateCostRequest) Send() (*EstimateTemplateCostOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*EstimateTemplateCostOutput), nil
}

// EstimateTemplateCostRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Returns the estimated monthly cost of a template. The return value is an
// AWS Simple Monthly Calculator URL with a query string that describes the
// resources required to run the template.
//
//    // Example sending a request using the EstimateTemplateCostRequest method.
//    req := client.EstimateTemplateCostRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/EstimateTemplateCost
func (c *CloudFormation) EstimateTemplateCostRequest(input *EstimateTemplateCostInput) EstimateTemplateCostRequest {
	op := &aws.Operation{
		Name:       opEstimateTemplateCost,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EstimateTemplateCostInput{}
	}

	output := &EstimateTemplateCostOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return EstimateTemplateCostRequest{Request: req, Input: input, Copy: c.EstimateTemplateCostRequest}
}

const opExecuteChangeSet = "ExecuteChangeSet"

// ExecuteChangeSetRequest is a API request type for the ExecuteChangeSet API operation.
type ExecuteChangeSetRequest struct {
	*aws.Request
	Input *ExecuteChangeSetInput
	Copy  func(*ExecuteChangeSetInput) ExecuteChangeSetRequest
}

// Send marshals and sends the ExecuteChangeSet API request.
func (r ExecuteChangeSetRequest) Send() (*ExecuteChangeSetOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*ExecuteChangeSetOutput), nil
}

// ExecuteChangeSetRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Updates a stack using the input information that was provided when the specified
// change set was created. After the call successfully completes, AWS CloudFormation
// starts updating the stack. Use the DescribeStacks action to view the status
// of the update.
//
// When you execute a change set, AWS CloudFormation deletes all other change
// sets associated with the stack because they aren't valid for the updated
// stack.
//
// If a stack policy is associated with the stack, AWS CloudFormation enforces
// the policy during the update. You can't specify a temporary stack policy
// that overrides the current policy.
//
//    // Example sending a request using the ExecuteChangeSetRequest method.
//    req := client.ExecuteChangeSetRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ExecuteChangeSet
func (c *CloudFormation) ExecuteChangeSetRequest(input *ExecuteChangeSetInput) ExecuteChangeSetRequest {
	op := &aws.Operation{
		Name:       opExecuteChangeSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ExecuteChangeSetInput{}
	}

	output := &ExecuteChangeSetOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return ExecuteChangeSetRequest{Request: req, Input: input, Copy: c.ExecuteChangeSetRequest}
}

const opGetStackPolicy = "GetStackPolicy"

// GetStackPolicyRequest is a API request type for the GetStackPolicy API operation.
type GetStackPolicyRequest struct {
	*aws.Request
	Input *GetStackPolicyInput
	Copy  func(*GetStackPolicyInput) GetStackPolicyRequest
}

// Send marshals and sends the GetStackPolicy API request.
func (r GetStackPolicyRequest) Send() (*GetStackPolicyOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*GetStackPolicyOutput), nil
}

// GetStackPolicyRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Returns the stack policy for a specified stack. If a stack doesn't have a
// policy, a null value is returned.
//
//    // Example sending a request using the GetStackPolicyRequest method.
//    req := client.GetStackPolicyRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetStackPolicy
func (c *CloudFormation) GetStackPolicyRequest(input *GetStackPolicyInput) GetStackPolicyRequest {
	op := &aws.Operation{
		Name:       opGetStackPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetStackPolicyInput{}
	}

	output := &GetStackPolicyOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return GetStackPolicyRequest{Request: req, Input: input, Copy: c.GetStackPolicyRequest}
}

const opGetTemplate = "GetTemplate"

// GetTemplateRequest is a API request type for the GetTemplate API operation.
type GetTemplateRequest struct {
	*aws.Request
	Input *GetTemplateInput
	Copy  func(*GetTemplateInput) GetTemplateRequest
}

// Send marshals and sends the GetTemplate API request.
func (r GetTemplateRequest) Send() (*GetTemplateOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*GetTemplateOutput), nil
}

// GetTemplateRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Returns the template body for a specified stack. You can get the template
// for running or deleted stacks.
//
// For deleted stacks, GetTemplate returns the template for up to 90 days after
// the stack has been deleted.
//
// If the template does not exist, a ValidationError is returned.
//
//    // Example sending a request using the GetTemplateRequest method.
//    req := client.GetTemplateRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplate
func (c *CloudFormation) GetTemplateRequest(input *GetTemplateInput) GetTemplateRequest {
	op := &aws.Operation{
		Name:       opGetTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTemplateInput{}
	}

	output := &GetTemplateOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return GetTemplateRequest{Request: req, Input: input, Copy: c.GetTemplateRequest}
}

const opGetTemplateSummary = "GetTemplateSummary"

// GetTemplateSummaryRequest is a API request type for the GetTemplateSummary API operation.
type GetTemplateSummaryRequest struct {
	*aws.Request
	Input *GetTemplateSummaryInput
	Copy  func(*GetTemplateSummaryInput) GetTemplateSummaryRequest
}

// Send marshals and sends the GetTemplateSummary API request.
func (r GetTemplateSummaryRequest) Send() (*GetTemplateSummaryOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*GetTemplateSummaryOutput), nil
}

// GetTemplateSummaryRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Returns information about a new or existing template. The GetTemplateSummary
// action is useful for viewing parameter information, such as default parameter
// values and parameter types, before you create or update a stack or stack
// set.
//
// You can use the GetTemplateSummary action when you submit a template, or
// you can get template information for a stack set, or a running or deleted
// stack.
//
// For deleted stacks, GetTemplateSummary returns the template information for
// up to 90 days after the stack has been deleted. If the template does not
// exist, a ValidationError is returned.
//
//    // Example sending a request using the GetTemplateSummaryRequest method.
//    req := client.GetTemplateSummaryRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplateSummary
func (c *CloudFormation) GetTemplateSummaryRequest(input *GetTemplateSummaryInput) GetTemplateSummaryRequest {
	op := &aws.Operation{
		Name:       opGetTemplateSummary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTemplateSummaryInput{}
	}

	output := &GetTemplateSummaryOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return GetTemplateSummaryRequest{Request: req, Input: input, Copy: c.GetTemplateSummaryRequest}
}

const opListChangeSets = "ListChangeSets"

// ListChangeSetsRequest is a API request type for the ListChangeSets API operation.
type ListChangeSetsRequest struct {
	*aws.Request
	Input *ListChangeSetsInput
	Copy  func(*ListChangeSetsInput) ListChangeSetsRequest
}

// Send marshals and sends the ListChangeSets API request.
func (r ListChangeSetsRequest) Send() (*ListChangeSetsOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*ListChangeSetsOutput), nil
}

// ListChangeSetsRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Returns the ID and status of each active change set for a stack. For example,
// AWS CloudFormation lists change sets that are in the CREATE_IN_PROGRESS or
// CREATE_PENDING state.
//
//    // Example sending a request using the ListChangeSetsRequest method.
//    req := client.ListChangeSetsRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListChangeSets
func (c *CloudFormation) ListChangeSetsRequest(input *ListChangeSetsInput) ListChangeSetsRequest {
	op := &aws.Operation{
		Name:       opListChangeSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListChangeSetsInput{}
	}

	output := &ListChangeSetsOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return ListChangeSetsRequest{Request: req, Input: input, Copy: c.ListChangeSetsRequest}
}

const opListExports = "ListExports"

// ListExportsRequest is a API request type for the ListExports API operation.
type ListExportsRequest struct {
	*aws.Request
	Input *ListExportsInput
	Copy  func(*ListExportsInput) ListExportsRequest
}

// Send marshals and sends the ListExports API request.
func (r ListExportsRequest) Send() (*ListExportsOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*ListExportsOutput), nil
}

// ListExportsRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Lists all exported output values in the account and region in which you call
// this action. Use this action to see the exported output values that you can
// import into other stacks. To import values, use the Fn::ImportValue (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html)
// function.
//
// For more information, see  AWS CloudFormation Export Stack Output Values
// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html).
//
//    // Example sending a request using the ListExportsRequest method.
//    req := client.ListExportsRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExports
func (c *CloudFormation) ListExportsRequest(input *ListExportsInput) ListExportsRequest {
	op := &aws.Operation{
		Name:       opListExports,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListExportsInput{}
	}

	output := &ListExportsOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return ListExportsRequest{Request: req, Input: input, Copy: c.ListExportsRequest}
}

// Paginate pages iterates over the pages of a ListExportsRequest operation,
// calling the Next method for each page. Using the paginators Next
// method will depict whether or not there are more pages.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListExports operation.
//		req := client.ListExportsRequest(input)
//		p := req.Paginate()
//		for p.Next() {
//			page := p.CurrentPage()
//		}
//
//		if err := p.Err(); err != nil {
//			return err
//		}
//
func (p *ListExportsRequest) Paginate(opts ...aws.Option) ListExportsPager {
	return ListExportsPager{
		Pager: aws.Pager{
			NewRequest: func() (*aws.Request, error) {
				var inCpy *ListExportsInput
				if p.Input != nil {
					tmp := *p.Input
					inCpy = &tmp
				}

				req := p.Copy(inCpy)
				req.ApplyOptions(opts...)

				return req.Request, nil
			},
		},
	}
}

// ListExportsPager is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListExportsPager struct {
	aws.Pager
}

func (p *ListExportsPager) CurrentPage() *ListExportsOutput {
	return p.Pager.CurrentPage().(*ListExportsOutput)
}

const opListImports = "ListImports"

// ListImportsRequest is a API request type for the ListImports API operation.
type ListImportsRequest struct {
	*aws.Request
	Input *ListImportsInput
	Copy  func(*ListImportsInput) ListImportsRequest
}

// Send marshals and sends the ListImports API request.
func (r ListImportsRequest) Send() (*ListImportsOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*ListImportsOutput), nil
}

// ListImportsRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Lists all stacks that are importing an exported output value. To modify or
// remove an exported output value, first use this action to see which stacks
// are using it. To see the exported output values in your account, see ListExports.
//
// For more information about importing an exported output value, see the Fn::ImportValue
// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html)
// function.
//
//    // Example sending a request using the ListImportsRequest method.
//    req := client.ListImportsRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListImports
func (c *CloudFormation) ListImportsRequest(input *ListImportsInput) ListImportsRequest {
	op := &aws.Operation{
		Name:       opListImports,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListImportsInput{}
	}

	output := &ListImportsOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return ListImportsRequest{Request: req, Input: input, Copy: c.ListImportsRequest}
}

// Paginate pages iterates over the pages of a ListImportsRequest operation,
// calling the Next method for each page. Using the paginators Next
// method will depict whether or not there are more pages.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListImports operation.
//		req := client.ListImportsRequest(input)
//		p := req.Paginate()
//		for p.Next() {
//			page := p.CurrentPage()
//		}
//
//		if err := p.Err(); err != nil {
//			return err
//		}
//
func (p *ListImportsRequest) Paginate(opts ...aws.Option) ListImportsPager {
	return ListImportsPager{
		Pager: aws.Pager{
			NewRequest: func() (*aws.Request, error) {
				var inCpy *ListImportsInput
				if p.Input != nil {
					tmp := *p.Input
					inCpy = &tmp
				}

				req := p.Copy(inCpy)
				req.ApplyOptions(opts...)

				return req.Request, nil
			},
		},
	}
}

// ListImportsPager is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListImportsPager struct {
	aws.Pager
}

func (p *ListImportsPager) CurrentPage() *ListImportsOutput {
	return p.Pager.CurrentPage().(*ListImportsOutput)
}

const opListStackInstances = "ListStackInstances"

// ListStackInstancesRequest is a API request type for the ListStackInstances API operation.
type ListStackInstancesRequest struct {
	*aws.Request
	Input *ListStackInstancesInput
	Copy  func(*ListStackInstancesInput) ListStackInstancesRequest
}

// Send marshals and sends the ListStackInstances API request.
func (r ListStackInstancesRequest) Send() (*ListStackInstancesOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*ListStackInstancesOutput), nil
}

// ListStackInstancesRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Returns summary information about stack instances that are associated with
// the specified stack set. You can filter for stack instances that are associated
// with a specific AWS account name or region.
//
//    // Example sending a request using the ListStackInstancesRequest method.
//    req := client.ListStackInstancesRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackInstances
func (c *CloudFormation) ListStackInstancesRequest(input *ListStackInstancesInput) ListStackInstancesRequest {
	op := &aws.Operation{
		Name:       opListStackInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListStackInstancesInput{}
	}

	output := &ListStackInstancesOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return ListStackInstancesRequest{Request: req, Input: input, Copy: c.ListStackInstancesRequest}
}

const opListStackResources = "ListStackResources"

// ListStackResourcesRequest is a API request type for the ListStackResources API operation.
type ListStackResourcesRequest struct {
	*aws.Request
	Input *ListStackResourcesInput
	Copy  func(*ListStackResourcesInput) ListStackResourcesRequest
}

// Send marshals and sends the ListStackResources API request.
func (r ListStackResourcesRequest) Send() (*ListStackResourcesOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*ListStackResourcesOutput), nil
}

// ListStackResourcesRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Returns descriptions of all resources of the specified stack.
//
// For deleted stacks, ListStackResources returns resource information for up
// to 90 days after the stack has been deleted.
//
//    // Example sending a request using the ListStackResourcesRequest method.
//    req := client.ListStackResourcesRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackResources
func (c *CloudFormation) ListStackResourcesRequest(input *ListStackResourcesInput) ListStackResourcesRequest {
	op := &aws.Operation{
		Name:       opListStackResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStackResourcesInput{}
	}

	output := &ListStackResourcesOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return ListStackResourcesRequest{Request: req, Input: input, Copy: c.ListStackResourcesRequest}
}

// Paginate pages iterates over the pages of a ListStackResourcesRequest operation,
// calling the Next method for each page. Using the paginators Next
// method will depict whether or not there are more pages.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListStackResources operation.
//		req := client.ListStackResourcesRequest(input)
//		p := req.Paginate()
//		for p.Next() {
//			page := p.CurrentPage()
//		}
//
//		if err := p.Err(); err != nil {
//			return err
//		}
//
func (p *ListStackResourcesRequest) Paginate(opts ...aws.Option) ListStackResourcesPager {
	return ListStackResourcesPager{
		Pager: aws.Pager{
			NewRequest: func() (*aws.Request, error) {
				var inCpy *ListStackResourcesInput
				if p.Input != nil {
					tmp := *p.Input
					inCpy = &tmp
				}

				req := p.Copy(inCpy)
				req.ApplyOptions(opts...)

				return req.Request, nil
			},
		},
	}
}

// ListStackResourcesPager is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListStackResourcesPager struct {
	aws.Pager
}

func (p *ListStackResourcesPager) CurrentPage() *ListStackResourcesOutput {
	return p.Pager.CurrentPage().(*ListStackResourcesOutput)
}

const opListStackSetOperationResults = "ListStackSetOperationResults"

// ListStackSetOperationResultsRequest is a API request type for the ListStackSetOperationResults API operation.
type ListStackSetOperationResultsRequest struct {
	*aws.Request
	Input *ListStackSetOperationResultsInput
	Copy  func(*ListStackSetOperationResultsInput) ListStackSetOperationResultsRequest
}

// Send marshals and sends the ListStackSetOperationResults API request.
func (r ListStackSetOperationResultsRequest) Send() (*ListStackSetOperationResultsOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*ListStackSetOperationResultsOutput), nil
}

// ListStackSetOperationResultsRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Returns summary information about the results of a stack set operation.
//
//    // Example sending a request using the ListStackSetOperationResultsRequest method.
//    req := client.ListStackSetOperationResultsRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperationResults
func (c *CloudFormation) ListStackSetOperationResultsRequest(input *ListStackSetOperationResultsInput) ListStackSetOperationResultsRequest {
	op := &aws.Operation{
		Name:       opListStackSetOperationResults,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListStackSetOperationResultsInput{}
	}

	output := &ListStackSetOperationResultsOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return ListStackSetOperationResultsRequest{Request: req, Input: input, Copy: c.ListStackSetOperationResultsRequest}
}

const opListStackSetOperations = "ListStackSetOperations"

// ListStackSetOperationsRequest is a API request type for the ListStackSetOperations API operation.
type ListStackSetOperationsRequest struct {
	*aws.Request
	Input *ListStackSetOperationsInput
	Copy  func(*ListStackSetOperationsInput) ListStackSetOperationsRequest
}

// Send marshals and sends the ListStackSetOperations API request.
func (r ListStackSetOperationsRequest) Send() (*ListStackSetOperationsOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*ListStackSetOperationsOutput), nil
}

// ListStackSetOperationsRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Returns summary information about operations performed on a stack set.
//
//    // Example sending a request using the ListStackSetOperationsRequest method.
//    req := client.ListStackSetOperationsRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperations
func (c *CloudFormation) ListStackSetOperationsRequest(input *ListStackSetOperationsInput) ListStackSetOperationsRequest {
	op := &aws.Operation{
		Name:       opListStackSetOperations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListStackSetOperationsInput{}
	}

	output := &ListStackSetOperationsOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return ListStackSetOperationsRequest{Request: req, Input: input, Copy: c.ListStackSetOperationsRequest}
}

const opListStackSets = "ListStackSets"

// ListStackSetsRequest is a API request type for the ListStackSets API operation.
type ListStackSetsRequest struct {
	*aws.Request
	Input *ListStackSetsInput
	Copy  func(*ListStackSetsInput) ListStackSetsRequest
}

// Send marshals and sends the ListStackSets API request.
func (r ListStackSetsRequest) Send() (*ListStackSetsOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*ListStackSetsOutput), nil
}

// ListStackSetsRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Returns summary information about stack sets that are associated with the
// user.
//
//    // Example sending a request using the ListStackSetsRequest method.
//    req := client.ListStackSetsRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSets
func (c *CloudFormation) ListStackSetsRequest(input *ListStackSetsInput) ListStackSetsRequest {
	op := &aws.Operation{
		Name:       opListStackSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListStackSetsInput{}
	}

	output := &ListStackSetsOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return ListStackSetsRequest{Request: req, Input: input, Copy: c.ListStackSetsRequest}
}

const opListStacks = "ListStacks"

// ListStacksRequest is a API request type for the ListStacks API operation.
type ListStacksRequest struct {
	*aws.Request
	Input *ListStacksInput
	Copy  func(*ListStacksInput) ListStacksRequest
}

// Send marshals and sends the ListStacks API request.
func (r ListStacksRequest) Send() (*ListStacksOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*ListStacksOutput), nil
}

// ListStacksRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Returns the summary information for stacks whose status matches the specified
// StackStatusFilter. Summary information for stacks that have been deleted
// is kept for 90 days after the stack is deleted. If no StackStatusFilter is
// specified, summary information for all stacks is returned (including existing
// stacks and stacks that have been deleted).
//
//    // Example sending a request using the ListStacksRequest method.
//    req := client.ListStacksRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacks
func (c *CloudFormation) ListStacksRequest(input *ListStacksInput) ListStacksRequest {
	op := &aws.Operation{
		Name:       opListStacks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStacksInput{}
	}

	output := &ListStacksOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return ListStacksRequest{Request: req, Input: input, Copy: c.ListStacksRequest}
}

// Paginate pages iterates over the pages of a ListStacksRequest operation,
// calling the Next method for each page. Using the paginators Next
// method will depict whether or not there are more pages.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListStacks operation.
//		req := client.ListStacksRequest(input)
//		p := req.Paginate()
//		for p.Next() {
//			page := p.CurrentPage()
//		}
//
//		if err := p.Err(); err != nil {
//			return err
//		}
//
func (p *ListStacksRequest) Paginate(opts ...aws.Option) ListStacksPager {
	return ListStacksPager{
		Pager: aws.Pager{
			NewRequest: func() (*aws.Request, error) {
				var inCpy *ListStacksInput
				if p.Input != nil {
					tmp := *p.Input
					inCpy = &tmp
				}

				req := p.Copy(inCpy)
				req.ApplyOptions(opts...)

				return req.Request, nil
			},
		},
	}
}

// ListStacksPager is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListStacksPager struct {
	aws.Pager
}

func (p *ListStacksPager) CurrentPage() *ListStacksOutput {
	return p.Pager.CurrentPage().(*ListStacksOutput)
}

const opSetStackPolicy = "SetStackPolicy"

// SetStackPolicyRequest is a API request type for the SetStackPolicy API operation.
type SetStackPolicyRequest struct {
	*aws.Request
	Input *SetStackPolicyInput
	Copy  func(*SetStackPolicyInput) SetStackPolicyRequest
}

// Send marshals and sends the SetStackPolicy API request.
func (r SetStackPolicyRequest) Send() (*SetStackPolicyOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*SetStackPolicyOutput), nil
}

// SetStackPolicyRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Sets a stack policy for a specified stack.
//
//    // Example sending a request using the SetStackPolicyRequest method.
//    req := client.SetStackPolicyRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetStackPolicy
func (c *CloudFormation) SetStackPolicyRequest(input *SetStackPolicyInput) SetStackPolicyRequest {
	op := &aws.Operation{
		Name:       opSetStackPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetStackPolicyInput{}
	}

	output := &SetStackPolicyOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return SetStackPolicyRequest{Request: req, Input: input, Copy: c.SetStackPolicyRequest}
}

const opSignalResource = "SignalResource"

// SignalResourceRequest is a API request type for the SignalResource API operation.
type SignalResourceRequest struct {
	*aws.Request
	Input *SignalResourceInput
	Copy  func(*SignalResourceInput) SignalResourceRequest
}

// Send marshals and sends the SignalResource API request.
func (r SignalResourceRequest) Send() (*SignalResourceOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*SignalResourceOutput), nil
}

// SignalResourceRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Sends a signal to the specified resource with a success or failure status.
// You can use the SignalResource API in conjunction with a creation policy
// or update policy. AWS CloudFormation doesn't proceed with a stack creation
// or update until resources receive the required number of signals or the timeout
// period is exceeded. The SignalResource API is useful in cases where you want
// to send signals from anywhere other than an Amazon EC2 instance.
//
//    // Example sending a request using the SignalResourceRequest method.
//    req := client.SignalResourceRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SignalResource
func (c *CloudFormation) SignalResourceRequest(input *SignalResourceInput) SignalResourceRequest {
	op := &aws.Operation{
		Name:       opSignalResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SignalResourceInput{}
	}

	output := &SignalResourceOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return SignalResourceRequest{Request: req, Input: input, Copy: c.SignalResourceRequest}
}

const opStopStackSetOperation = "StopStackSetOperation"

// StopStackSetOperationRequest is a API request type for the StopStackSetOperation API operation.
type StopStackSetOperationRequest struct {
	*aws.Request
	Input *StopStackSetOperationInput
	Copy  func(*StopStackSetOperationInput) StopStackSetOperationRequest
}

// Send marshals and sends the StopStackSetOperation API request.
func (r StopStackSetOperationRequest) Send() (*StopStackSetOperationOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*StopStackSetOperationOutput), nil
}

// StopStackSetOperationRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Stops an in-progress operation on a stack set and its associated stack instances.
//
//    // Example sending a request using the StopStackSetOperationRequest method.
//    req := client.StopStackSetOperationRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StopStackSetOperation
func (c *CloudFormation) StopStackSetOperationRequest(input *StopStackSetOperationInput) StopStackSetOperationRequest {
	op := &aws.Operation{
		Name:       opStopStackSetOperation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopStackSetOperationInput{}
	}

	output := &StopStackSetOperationOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return StopStackSetOperationRequest{Request: req, Input: input, Copy: c.StopStackSetOperationRequest}
}

const opUpdateStack = "UpdateStack"

// UpdateStackRequest is a API request type for the UpdateStack API operation.
type UpdateStackRequest struct {
	*aws.Request
	Input *UpdateStackInput
	Copy  func(*UpdateStackInput) UpdateStackRequest
}

// Send marshals and sends the UpdateStack API request.
func (r UpdateStackRequest) Send() (*UpdateStackOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*UpdateStackOutput), nil
}

// UpdateStackRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Updates a stack as specified in the template. After the call completes successfully,
// the stack update starts. You can check the status of the stack via the DescribeStacks
// action.
//
// To get a copy of the template for an existing stack, you can use the GetTemplate
// action.
//
// For more information about creating an update template, updating a stack,
// and monitoring the progress of the update, see Updating a Stack (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html).
//
//    // Example sending a request using the UpdateStackRequest method.
//    req := client.UpdateStackRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStack
func (c *CloudFormation) UpdateStackRequest(input *UpdateStackInput) UpdateStackRequest {
	op := &aws.Operation{
		Name:       opUpdateStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateStackInput{}
	}

	output := &UpdateStackOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return UpdateStackRequest{Request: req, Input: input, Copy: c.UpdateStackRequest}
}

const opUpdateStackInstances = "UpdateStackInstances"

// UpdateStackInstancesRequest is a API request type for the UpdateStackInstances API operation.
type UpdateStackInstancesRequest struct {
	*aws.Request
	Input *UpdateStackInstancesInput
	Copy  func(*UpdateStackInstancesInput) UpdateStackInstancesRequest
}

// Send marshals and sends the UpdateStackInstances API request.
func (r UpdateStackInstancesRequest) Send() (*UpdateStackInstancesOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*UpdateStackInstancesOutput), nil
}

// UpdateStackInstancesRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Updates the parameter values for stack instances for the specified accounts,
// within the specified regions. A stack instance refers to a stack in a specific
// account and region.
//
// You can only update stack instances in regions and accounts where they already
// exist; to create additional stack instances, use CreateStackInstances (http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStackInstances.html).
//
// During stack set updates, any parameters overridden for a stack instance
// are not updated, but retain their overridden value.
//
// You can only update the parameter values that are specified in the stack
// set; to add or delete a parameter itself, use UpdateStackSet (http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html)
// to update the stack set template. If you add a parameter to a template, before
// you can override the parameter value specified in the stack set you must
// first use UpdateStackSet (http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html)
// to update all stack instances with the updated template and parameter value
// specified in the stack set. Once a stack instance has been updated with the
// new parameter, you can then override the parameter value using UpdateStackInstances.
//
//    // Example sending a request using the UpdateStackInstancesRequest method.
//    req := client.UpdateStackInstancesRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackInstances
func (c *CloudFormation) UpdateStackInstancesRequest(input *UpdateStackInstancesInput) UpdateStackInstancesRequest {
	op := &aws.Operation{
		Name:       opUpdateStackInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateStackInstancesInput{}
	}

	output := &UpdateStackInstancesOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return UpdateStackInstancesRequest{Request: req, Input: input, Copy: c.UpdateStackInstancesRequest}
}

const opUpdateStackSet = "UpdateStackSet"

// UpdateStackSetRequest is a API request type for the UpdateStackSet API operation.
type UpdateStackSetRequest struct {
	*aws.Request
	Input *UpdateStackSetInput
	Copy  func(*UpdateStackSetInput) UpdateStackSetRequest
}

// Send marshals and sends the UpdateStackSet API request.
func (r UpdateStackSetRequest) Send() (*UpdateStackSetOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*UpdateStackSetOutput), nil
}

// UpdateStackSetRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Updates the stack set, and associated stack instances in the specified accounts
// and regions.
//
// Even if the stack set operation created by updating the stack set fails (completely
// or partially, below or above a specified failure tolerance), the stack set
// is updated with your changes. Subsequent CreateStackInstances calls on the
// specified stack set use the updated stack set.
//
//    // Example sending a request using the UpdateStackSetRequest method.
//    req := client.UpdateStackSetRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackSet
func (c *CloudFormation) UpdateStackSetRequest(input *UpdateStackSetInput) UpdateStackSetRequest {
	op := &aws.Operation{
		Name:       opUpdateStackSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateStackSetInput{}
	}

	output := &UpdateStackSetOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return UpdateStackSetRequest{Request: req, Input: input, Copy: c.UpdateStackSetRequest}
}

const opUpdateTerminationProtection = "UpdateTerminationProtection"

// UpdateTerminationProtectionRequest is a API request type for the UpdateTerminationProtection API operation.
type UpdateTerminationProtectionRequest struct {
	*aws.Request
	Input *UpdateTerminationProtectionInput
	Copy  func(*UpdateTerminationProtectionInput) UpdateTerminationProtectionRequest
}

// Send marshals and sends the UpdateTerminationProtection API request.
func (r UpdateTerminationProtectionRequest) Send() (*UpdateTerminationProtectionOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*UpdateTerminationProtectionOutput), nil
}

// UpdateTerminationProtectionRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Updates termination protection for the specified stack. If a user attempts
// to delete a stack with termination protection enabled, the operation fails
// and the stack remains unchanged. For more information, see Protecting a Stack
// From Being Deleted (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html)
// in the AWS CloudFormation User Guide.
//
// For nested stacks (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html),
// termination protection is set on the root stack and cannot be changed directly
// on the nested stack.
//
//    // Example sending a request using the UpdateTerminationProtectionRequest method.
//    req := client.UpdateTerminationProtectionRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateTerminationProtection
func (c *CloudFormation) UpdateTerminationProtectionRequest(input *UpdateTerminationProtectionInput) UpdateTerminationProtectionRequest {
	op := &aws.Operation{
		Name:       opUpdateTerminationProtection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTerminationProtectionInput{}
	}

	output := &UpdateTerminationProtectionOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return UpdateTerminationProtectionRequest{Request: req, Input: input, Copy: c.UpdateTerminationProtectionRequest}
}

const opValidateTemplate = "ValidateTemplate"

// ValidateTemplateRequest is a API request type for the ValidateTemplate API operation.
type ValidateTemplateRequest struct {
	*aws.Request
	Input *ValidateTemplateInput
	Copy  func(*ValidateTemplateInput) ValidateTemplateRequest
}

// Send marshals and sends the ValidateTemplate API request.
func (r ValidateTemplateRequest) Send() (*ValidateTemplateOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*ValidateTemplateOutput), nil
}

// ValidateTemplateRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Validates a specified template. AWS CloudFormation first checks if the template
// is valid JSON. If it isn't, AWS CloudFormation checks if the template is
// valid YAML. If both these checks fail, AWS CloudFormation returns a template
// validation error.
//
//    // Example sending a request using the ValidateTemplateRequest method.
//    req := client.ValidateTemplateRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ValidateTemplate
func (c *CloudFormation) ValidateTemplateRequest(input *ValidateTemplateInput) ValidateTemplateRequest {
	op := &aws.Operation{
		Name:       opValidateTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ValidateTemplateInput{}
	}

	output := &ValidateTemplateOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return ValidateTemplateRequest{Request: req, Input: input, Copy: c.ValidateTemplateRequest}
}

// Structure that contains the results of the account gate function which AWS
// CloudFormation invokes, if present, before proceeding with a stack set operation
// in an account and region.
//
// For each account and region, AWS CloudFormation lets you specify a Lamdba
// function that encapsulates any requirements that must be met before CloudFormation
// can proceed with a stack set operation in that account and region. CloudFormation
// invokes the function each time a stack set operation is requested for that
// account and region; if the function returns FAILED, CloudFormation cancels
// the operation in that account and region, and sets the stack set operation
// result status for that account and region to FAILED.
//
// For more information, see Configuring a target account gate (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-account-gating.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/AccountGateResult
type AccountGateResult struct {
	_ struct{} `type:"structure"`

	// The status of the account gate function.
	//
	//    * SUCCEEDED: The account gate function has determined that the account
	//    and region passes any requirements for a stack set operation to occur.
	//    AWS CloudFormation proceeds with the stack operation in that account and
	//    region.
	//
	//    * FAILED: The account gate function has determined that the account and
	//    region does not meet the requirements for a stack set operation to occur.
	//    AWS CloudFormation cancels the stack set operation in that account and
	//    region, and sets the stack set operation result status for that account
	//    and region to FAILED.
	//
	//    * SKIPPED: AWS CloudFormation has skipped calling the account gate function
	//    for this account and region, for one of the following reasons:
	//
	// An account gate function has not been specified for the account and region.
	//    AWS CloudFormation proceeds with the stack set operation in this account
	//    and region.
	//
	// The AWSCloudFormationStackSetExecutionRole of the stack set adminstration
	//    account lacks permissions to invoke the function. AWS CloudFormation proceeds
	//    with the stack set operation in this account and region.
	//
	// Either no action is necessary, or no action is possible, on the stack. AWS
	//    CloudFormation skips the stack set operation in this account and region.
	Status AccountGateStatus `type:"string" enum:"true"`

	// The reason for the account gate status assigned to this account and region
	// for the stack set operation.
	StatusReason *string `type:"string"`
}

// String returns the string representation
func (s AccountGateResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountGateResult) GoString() string {
	return s.String()
}

// The AccountLimit data type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/AccountLimit
type AccountLimit struct {
	_ struct{} `type:"structure"`

	// The name of the account limit. Currently, the only account limit is StackLimit.
	Name *string `type:"string"`

	// The value that is associated with the account limit name.
	Value *int64 `type:"integer"`
}

// String returns the string representation
func (s AccountLimit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountLimit) GoString() string {
	return s.String()
}

// The input for the CancelUpdateStack action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CancelUpdateStackInput
type CancelUpdateStackInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for this CancelUpdateStack request. Specify this token
	// if you plan to retry requests so that AWS CloudFormation knows that you're
	// not attempting to cancel an update on a stack with the same name. You might
	// retry CancelUpdateStack requests to ensure that AWS CloudFormation successfully
	// received them.
	ClientRequestToken *string `min:"1" type:"string"`

	// The name or the unique stack ID that is associated with the stack.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CancelUpdateStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelUpdateStackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelUpdateStackInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CancelUpdateStackInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientRequestToken", 1))
	}

	if s.StackName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CancelUpdateStackOutput
type CancelUpdateStackOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s CancelUpdateStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelUpdateStackOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s CancelUpdateStackOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// The Change structure describes the changes AWS CloudFormation will perform
// if you execute the change set.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/Change
type Change struct {
	_ struct{} `type:"structure"`

	// A ResourceChange structure that describes the resource and action that AWS
	// CloudFormation will perform.
	ResourceChange *ResourceChange `type:"structure"`

	// The type of entity that AWS CloudFormation changes. Currently, the only entity
	// type is Resource.
	Type ChangeType `type:"string" enum:"true"`
}

// String returns the string representation
func (s Change) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Change) GoString() string {
	return s.String()
}

// The ChangeSetSummary structure describes a change set, its status, and the
// stack with which it's associated.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ChangeSetSummary
type ChangeSetSummary struct {
	_ struct{} `type:"structure"`

	// The ID of the change set.
	ChangeSetId *string `min:"1" type:"string"`

	// The name of the change set.
	ChangeSetName *string `min:"1" type:"string"`

	// The start time when the change set was created, in UTC.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Descriptive information about the change set.
	Description *string `min:"1" type:"string"`

	// If the change set execution status is AVAILABLE, you can execute the change
	// set. If you can’t execute the change set, the status indicates why. For example,
	// a change set might be in an UNAVAILABLE state because AWS CloudFormation
	// is still creating it or in an OBSOLETE state because the stack was already
	// updated.
	ExecutionStatus ExecutionStatus `type:"string" enum:"true"`

	// The ID of the stack with which the change set is associated.
	StackId *string `type:"string"`

	// The name of the stack with which the change set is associated.
	StackName *string `type:"string"`

	// The state of the change set, such as CREATE_IN_PROGRESS, CREATE_COMPLETE,
	// or FAILED.
	Status ChangeSetStatus `type:"string" enum:"true"`

	// A description of the change set's status. For example, if your change set
	// is in the FAILED state, AWS CloudFormation shows the error message.
	StatusReason *string `type:"string"`
}

// String returns the string representation
func (s ChangeSetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeSetSummary) GoString() string {
	return s.String()
}

// The input for the ContinueUpdateRollback action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ContinueUpdateRollbackInput
type ContinueUpdateRollbackInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for this ContinueUpdateRollback request. Specify this
	// token if you plan to retry requests so that AWS CloudFormation knows that
	// you're not attempting to continue the rollback to a stack with the same name.
	// You might retry ContinueUpdateRollback requests to ensure that AWS CloudFormation
	// successfully received them.
	ClientRequestToken *string `min:"1" type:"string"`

	// A list of the logical IDs of the resources that AWS CloudFormation skips
	// during the continue update rollback operation. You can specify only resources
	// that are in the UPDATE_FAILED state because a rollback failed. You can't
	// specify resources that are in the UPDATE_FAILED state for other reasons,
	// for example, because an update was cancelled. To check why a resource update
	// failed, use the DescribeStackResources action, and view the resource status
	// reason.
	//
	// Specify this property to skip rolling back resources that AWS CloudFormation
	// can't successfully roll back. We recommend that you  troubleshoot (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed)
	// resources before skipping them. AWS CloudFormation sets the status of the
	// specified resources to UPDATE_COMPLETE and continues to roll back the stack.
	// After the rollback is complete, the state of the skipped resources will be
	// inconsistent with the state of the resources in the stack template. Before
	// performing another stack update, you must update the stack or resources to
	// be consistent with each other. If you don't, subsequent stack updates might
	// fail, and the stack will become unrecoverable.
	//
	// Specify the minimum number of resources required to successfully roll back
	// your stack. For example, a failed resource update might cause dependent resources
	// to fail. In this case, it might not be necessary to skip the dependent resources.
	//
	// To skip resources that are part of nested stacks, use the following format:
	// NestedStackName.ResourceLogicalID. If you want to specify the logical ID
	// of a stack resource (Type: AWS::CloudFormation::Stack) in the ResourcesToSkip
	// list, then its corresponding embedded stack must be in one of the following
	// states: DELETE_IN_PROGRESS, DELETE_COMPLETE, or DELETE_FAILED.
	//
	// Don't confuse a child stack's name with its corresponding logical ID defined
	// in the parent stack. For an example of a continue update rollback operation
	// with nested stacks, see Using ResourcesToSkip to recover a nested stacks
	// hierarchy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html#nested-stacks).
	ResourcesToSkip []string `type:"list"`

	// The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM)
	// role that AWS CloudFormation assumes to roll back the stack. AWS CloudFormation
	// uses the role's credentials to make calls on your behalf. AWS CloudFormation
	// always uses this role for all future operations on the stack. As long as
	// users have permission to operate on the stack, AWS CloudFormation uses this
	// role even if the users don't have permission to pass it. Ensure that the
	// role grants least privilege.
	//
	// If you don't specify a value, AWS CloudFormation uses the role that was previously
	// associated with the stack. If no role is available, AWS CloudFormation uses
	// a temporary session that is generated from your user credentials.
	RoleARN *string `min:"20" type:"string"`

	// The name or the unique ID of the stack that you want to continue rolling
	// back.
	//
	// Don't specify the name of a nested stack (a stack that was created by using
	// the AWS::CloudFormation::Stack resource). Instead, use this operation on
	// the parent stack (the stack that contains the AWS::CloudFormation::Stack
	// resource).
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ContinueUpdateRollbackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContinueUpdateRollbackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContinueUpdateRollbackInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ContinueUpdateRollbackInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleARN", 20))
	}

	if s.StackName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output for a ContinueUpdateRollback action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ContinueUpdateRollbackOutput
type ContinueUpdateRollbackOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s ContinueUpdateRollbackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContinueUpdateRollbackOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s ContinueUpdateRollbackOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// The input for the CreateChangeSet action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSetInput
type CreateChangeSetInput struct {
	_ struct{} `type:"structure"`

	// A list of values that you must specify before AWS CloudFormation can update
	// certain stacks. Some stack templates might include resources that can affect
	// permissions in your AWS account, for example, by creating new AWS Identity
	// and Access Management (IAM) users. For those stacks, you must explicitly
	// acknowledge their capabilities by specifying this parameter.
	//
	// The only valid values are CAPABILITY_IAM and CAPABILITY_NAMED_IAM. The following
	// resources require you to specify this parameter:  AWS::IAM::AccessKey (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html),
	//  AWS::IAM::Group (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html),
	//  AWS::IAM::InstanceProfile (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html),
	//  AWS::IAM::Policy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html),
	//  AWS::IAM::Role (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html),
	//  AWS::IAM::User (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html),
	// and  AWS::IAM::UserToGroupAddition (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html).
	// If your stack template contains these resources, we recommend that you review
	// all permissions associated with them and edit their permissions if necessary.
	//
	// If you have IAM resources, you can specify either capability. If you have
	// IAM resources with custom names, you must specify CAPABILITY_NAMED_IAM. If
	// you don't specify this parameter, this action returns an InsufficientCapabilities
	// error.
	//
	// For more information, see Acknowledging IAM Resources in AWS CloudFormation
	// Templates (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities).
	Capabilities []Capability `type:"list"`

	// The name of the change set. The name must be unique among all change sets
	// that are associated with the specified stack.
	//
	// A change set name can contain only alphanumeric, case sensitive characters
	// and hyphens. It must start with an alphabetic character and cannot exceed
	// 128 characters.
	//
	// ChangeSetName is a required field
	ChangeSetName *string `min:"1" type:"string" required:"true"`

	// The type of change set operation. To create a change set for a new stack,
	// specify CREATE. To create a change set for an existing stack, specify UPDATE.
	//
	// If you create a change set for a new stack, AWS Cloudformation creates a
	// stack with a unique stack ID, but no template or resources. The stack will
	// be in the REVIEW_IN_PROGRESS (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-describing-stacks.html#d0e11995)
	// state until you execute the change set.
	//
	// By default, AWS CloudFormation specifies UPDATE. You can't use the UPDATE
	// type to create a change set for a new stack or the CREATE type to create
	// a change set for an existing stack.
	ChangeSetType ChangeSetType `type:"string" enum:"true"`

	// A unique identifier for this CreateChangeSet request. Specify this token
	// if you plan to retry requests so that AWS CloudFormation knows that you're
	// not attempting to create another change set with the same name. You might
	// retry CreateChangeSet requests to ensure that AWS CloudFormation successfully
	// received them.
	ClientToken *string `min:"1" type:"string"`

	// A description to help you identify this change set.
	Description *string `min:"1" type:"string"`

	// The Amazon Resource Names (ARNs) of Amazon Simple Notification Service (Amazon
	// SNS) topics that AWS CloudFormation associates with the stack. To remove
	// all associated notification topics, specify an empty list.
	NotificationARNs []string `type:"list"`

	// A list of Parameter structures that specify input parameters for the change
	// set. For more information, see the Parameter (http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html)
	// data type.
	Parameters []Parameter `type:"list"`

	// The template resource types that you have permissions to work with if you
	// execute this change set, such as AWS::EC2::Instance, AWS::EC2::*, or Custom::MyCustomInstance.
	//
	// If the list of resource types doesn't include a resource type that you're
	// updating, the stack update fails. By default, AWS CloudFormation grants permissions
	// to all resource types. AWS Identity and Access Management (IAM) uses this
	// parameter for condition keys in IAM policies for AWS CloudFormation. For
	// more information, see Controlling Access with AWS Identity and Access Management
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html)
	// in the AWS CloudFormation User Guide.
	ResourceTypes []string `type:"list"`

	// The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM)
	// role that AWS CloudFormation assumes when executing the change set. AWS CloudFormation
	// uses the role's credentials to make calls on your behalf. AWS CloudFormation
	// uses this role for all future operations on the stack. As long as users have
	// permission to operate on the stack, AWS CloudFormation uses this role even
	// if the users don't have permission to pass it. Ensure that the role grants
	// least privilege.
	//
	// If you don't specify a value, AWS CloudFormation uses the role that was previously
	// associated with the stack. If no role is available, AWS CloudFormation uses
	// a temporary session that is generated from your user credentials.
	RoleARN *string `min:"20" type:"string"`

	// The rollback triggers for AWS CloudFormation to monitor during stack creation
	// and updating operations, and for the specified monitoring period afterwards.
	RollbackConfiguration *RollbackConfiguration `type:"structure"`

	// The name or the unique ID of the stack for which you are creating a change
	// set. AWS CloudFormation generates the change set by comparing this stack's
	// information with the information that you submit, such as a modified template
	// or different parameter input values.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`

	// Key-value pairs to associate with this stack. AWS CloudFormation also propagates
	// these tags to resources in the stack. You can specify a maximum of 50 tags.
	Tags []Tag `type:"list"`

	// A structure that contains the body of the revised template, with a minimum
	// length of 1 byte and a maximum length of 51,200 bytes. AWS CloudFormation
	// generates the change set by comparing this template with the template of
	// the stack that you specified.
	//
	// Conditional: You must specify only TemplateBody or TemplateURL.
	TemplateBody *string `min:"1" type:"string"`

	// The location of the file that contains the revised template. The URL must
	// point to a template (max size: 460,800 bytes) that is located in an S3 bucket.
	// AWS CloudFormation generates the change set by comparing this template with
	// the stack that you specified.
	//
	// Conditional: You must specify only TemplateBody or TemplateURL.
	TemplateURL *string `min:"1" type:"string"`

	// Whether to reuse the template that is associated with the stack to create
	// the change set.
	UsePreviousTemplate *bool `type:"boolean"`
}

// String returns the string representation
func (s CreateChangeSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateChangeSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateChangeSetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateChangeSetInput"}

	if s.ChangeSetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChangeSetName"))
	}
	if s.ChangeSetName != nil && len(*s.ChangeSetName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChangeSetName", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleARN", 20))
	}

	if s.StackName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StackName", 1))
	}
	if s.TemplateBody != nil && len(*s.TemplateBody) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TemplateBody", 1))
	}
	if s.TemplateURL != nil && len(*s.TemplateURL) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TemplateURL", 1))
	}
	if s.RollbackConfiguration != nil {
		if err := s.RollbackConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RollbackConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output for the CreateChangeSet action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSetOutput
type CreateChangeSetOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The Amazon Resource Name (ARN) of the change set.
	Id *string `min:"1" type:"string"`

	// The unique ID of the stack.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s CreateChangeSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateChangeSetOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s CreateChangeSetOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// The input for CreateStack action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackInput
type CreateStackInput struct {
	_ struct{} `type:"structure"`

	// A list of values that you must specify before AWS CloudFormation can create
	// certain stacks. Some stack templates might include resources that can affect
	// permissions in your AWS account, for example, by creating new AWS Identity
	// and Access Management (IAM) users. For those stacks, you must explicitly
	// acknowledge their capabilities by specifying this parameter.
	//
	// The only valid values are CAPABILITY_IAM and CAPABILITY_NAMED_IAM. The following
	// resources require you to specify this parameter:  AWS::IAM::AccessKey (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html),
	//  AWS::IAM::Group (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html),
	//  AWS::IAM::InstanceProfile (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html),
	//  AWS::IAM::Policy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html),
	//  AWS::IAM::Role (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html),
	//  AWS::IAM::User (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html),
	// and  AWS::IAM::UserToGroupAddition (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html).
	// If your stack template contains these resources, we recommend that you review
	// all permissions associated with them and edit their permissions if necessary.
	//
	// If you have IAM resources, you can specify either capability. If you have
	// IAM resources with custom names, you must specify CAPABILITY_NAMED_IAM. If
	// you don't specify this parameter, this action returns an InsufficientCapabilities
	// error.
	//
	// For more information, see Acknowledging IAM Resources in AWS CloudFormation
	// Templates (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities).
	Capabilities []Capability `type:"list"`

	// A unique identifier for this CreateStack request. Specify this token if you
	// plan to retry requests so that AWS CloudFormation knows that you're not attempting
	// to create a stack with the same name. You might retry CreateStack requests
	// to ensure that AWS CloudFormation successfully received them.
	//
	// All events triggered by a given stack operation are assigned the same client
	// request token, which you can use to track operations. For example, if you
	// execute a CreateStack operation with the token token1, then all the StackEvents
	// generated by that operation will have ClientRequestToken set as token1.
	//
	// In the console, stack operations display the client request token on the
	// Events tab. Stack operations that are initiated from the console use the
	// token format Console-StackOperation-ID, which helps you easily identify the
	// stack operation . For example, if you create a stack using the console, each
	// stack event would be assigned the same token in the following format: Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002.
	ClientRequestToken *string `min:"1" type:"string"`

	// Set to true to disable rollback of the stack if stack creation failed. You
	// can specify either DisableRollback or OnFailure, but not both.
	//
	// Default: false
	DisableRollback *bool `type:"boolean"`

	// Whether to enable termination protection on the specified stack. If a user
	// attempts to delete a stack with termination protection enabled, the operation
	// fails and the stack remains unchanged. For more information, see Protecting
	// a Stack From Being Deleted (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html)
	// in the AWS CloudFormation User Guide. Termination protection is disabled
	// on stacks by default.
	//
	// For nested stacks (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html),
	// termination protection is set on the root stack and cannot be changed directly
	// on the nested stack.
	EnableTerminationProtection *bool `type:"boolean"`

	// The Simple Notification Service (SNS) topic ARNs to publish stack related
	// events. You can find your SNS topic ARNs using the SNS console or your Command
	// Line Interface (CLI).
	NotificationARNs []string `type:"list"`

	// Determines what action will be taken if stack creation fails. This must be
	// one of: DO_NOTHING, ROLLBACK, or DELETE. You can specify either OnFailure
	// or DisableRollback, but not both.
	//
	// Default: ROLLBACK
	OnFailure OnFailure `type:"string" enum:"true"`

	// A list of Parameter structures that specify input parameters for the stack.
	// For more information, see the Parameter (http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html)
	// data type.
	Parameters []Parameter `type:"list"`

	// The template resource types that you have permissions to work with for this
	// create stack action, such as AWS::EC2::Instance, AWS::EC2::*, or Custom::MyCustomInstance.
	// Use the following syntax to describe template resource types: AWS::* (for
	// all AWS resource), Custom::* (for all custom resources), Custom::logical_ID
	// (for a specific custom resource), AWS::service_name::* (for all resources
	// of a particular AWS service), and AWS::service_name::resource_logical_ID
	// (for a specific AWS resource).
	//
	// If the list of resource types doesn't include a resource that you're creating,
	// the stack creation fails. By default, AWS CloudFormation grants permissions
	// to all resource types. AWS Identity and Access Management (IAM) uses this
	// parameter for AWS CloudFormation-specific condition keys in IAM policies.
	// For more information, see Controlling Access with AWS Identity and Access
	// Management (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html).
	ResourceTypes []string `type:"list"`

	// The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM)
	// role that AWS CloudFormation assumes to create the stack. AWS CloudFormation
	// uses the role's credentials to make calls on your behalf. AWS CloudFormation
	// always uses this role for all future operations on the stack. As long as
	// users have permission to operate on the stack, AWS CloudFormation uses this
	// role even if the users don't have permission to pass it. Ensure that the
	// role grants least privilege.
	//
	// If you don't specify a value, AWS CloudFormation uses the role that was previously
	// associated with the stack. If no role is available, AWS CloudFormation uses
	// a temporary session that is generated from your user credentials.
	RoleARN *string `min:"20" type:"string"`

	// The rollback triggers for AWS CloudFormation to monitor during stack creation
	// and updating operations, and for the specified monitoring period afterwards.
	RollbackConfiguration *RollbackConfiguration `type:"structure"`

	// The name that is associated with the stack. The name must be unique in the
	// region in which you are creating the stack.
	//
	// A stack name can contain only alphanumeric characters (case sensitive) and
	// hyphens. It must start with an alphabetic character and cannot be longer
	// than 128 characters.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`

	// Structure containing the stack policy body. For more information, go to
	// Prevent Updates to Stack Resources (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html)
	// in the AWS CloudFormation User Guide. You can specify either the StackPolicyBody
	// or the StackPolicyURL parameter, but not both.
	StackPolicyBody *string `min:"1" type:"string"`

	// Location of a file containing the stack policy. The URL must point to a policy
	// (maximum size: 16 KB) located in an S3 bucket in the same region as the stack.
	// You can specify either the StackPolicyBody or the StackPolicyURL parameter,
	// but not both.
	StackPolicyURL *string `min:"1" type:"string"`

	// Key-value pairs to associate with this stack. AWS CloudFormation also propagates
	// these tags to the resources created in the stack. A maximum number of 50
	// tags can be specified.
	Tags []Tag `type:"list"`

	// Structure containing the template body with a minimum length of 1 byte and
	// a maximum length of 51,200 bytes. For more information, go to Template Anatomy
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must specify either the TemplateBody or the TemplateURL
	// parameter, but not both.
	TemplateBody *string `min:"1" type:"string"`

	// Location of file containing the template body. The URL must point to a template
	// (max size: 460,800 bytes) that is located in an Amazon S3 bucket. For more
	// information, go to the Template Anatomy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must specify either the TemplateBody or the TemplateURL
	// parameter, but not both.
	TemplateURL *string `min:"1" type:"string"`

	// The amount of time that can pass before the stack status becomes CREATE_FAILED;
	// if DisableRollback is not set or is set to false, the stack will be rolled
	// back.
	TimeoutInMinutes *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s CreateStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStackInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateStackInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleARN", 20))
	}

	if s.StackName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackName"))
	}
	if s.StackPolicyBody != nil && len(*s.StackPolicyBody) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StackPolicyBody", 1))
	}
	if s.StackPolicyURL != nil && len(*s.StackPolicyURL) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StackPolicyURL", 1))
	}
	if s.TemplateBody != nil && len(*s.TemplateBody) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TemplateBody", 1))
	}
	if s.TemplateURL != nil && len(*s.TemplateURL) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TemplateURL", 1))
	}
	if s.TimeoutInMinutes != nil && *s.TimeoutInMinutes < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("TimeoutInMinutes", 1))
	}
	if s.RollbackConfiguration != nil {
		if err := s.RollbackConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RollbackConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackInstancesInput
type CreateStackInstancesInput struct {
	_ struct{} `type:"structure"`

	// The names of one or more AWS accounts that you want to create stack instances
	// in the specified region(s) for.
	//
	// Accounts is a required field
	Accounts []string `type:"list" required:"true"`

	// The unique identifier for this stack set operation.
	//
	// The operation ID also functions as an idempotency token, to ensure that AWS
	// CloudFormation performs the stack set operation only once, even if you retry
	// the request multiple times. You might retry stack set operation requests
	// to ensure that AWS CloudFormation successfully received them.
	//
	// If you don't specify an operation ID, the SDK generates one automatically.
	//
	// Repeating this stack set operation with a new operation ID retries all stack
	// instances whose status is OUTDATED.
	OperationId *string `min:"1" type:"string" idempotencyToken:"true"`

	// Preferences for how AWS CloudFormation performs this stack set operation.
	OperationPreferences *StackSetOperationPreferences `type:"structure"`

	// A list of stack set parameters whose values you want to override in the selected
	// stack instances.
	//
	// Any overridden parameter values will be applied to all stack instances in
	// the specified accounts and regions. When specifying parameters and their
	// values, be aware of how AWS CloudFormation sets parameter values during stack
	// instance operations:
	//
	//    * To override the current value for a parameter, include the parameter
	//    and specify its value.
	//
	//    * To leave a parameter set to its present value, you can do one of the
	//    following:
	//
	// Do not include the parameter in the list.
	//
	// Include the parameter and specify UsePreviousValue as true. (You cannot specify
	//    both a value and set UsePreviousValue to true.)
	//
	//    * To set all overridden parameter back to the values specified in the
	//    stack set, specify a parameter list but do not include any parameters.
	//
	//    * To leave all parameters set to their present values, do not specify
	//    this property at all.
	//
	// During stack set updates, any parameter values overridden for a stack instance
	// are not updated, but retain their overridden value.
	//
	// You can only override the parameter values that are specified in the stack
	// set; to add or delete a parameter itself, use UpdateStackSet (http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html)
	// to update the stack set template.
	ParameterOverrides []Parameter `type:"list"`

	// The names of one or more regions where you want to create stack instances
	// using the specified AWS account(s).
	//
	// Regions is a required field
	Regions []string `type:"list" required:"true"`

	// The name or unique ID of the stack set that you want to create stack instances
	// from.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateStackInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStackInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStackInstancesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateStackInstancesInput"}

	if s.Accounts == nil {
		invalidParams.Add(aws.NewErrParamRequired("Accounts"))
	}
	if s.OperationId != nil && len(*s.OperationId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OperationId", 1))
	}

	if s.Regions == nil {
		invalidParams.Add(aws.NewErrParamRequired("Regions"))
	}

	if s.StackSetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackSetName"))
	}
	if s.OperationPreferences != nil {
		if err := s.OperationPreferences.Validate(); err != nil {
			invalidParams.AddNested("OperationPreferences", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackInstancesOutput
type CreateStackInstancesOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The unique identifier for this stack set operation.
	OperationId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateStackInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStackInstancesOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s CreateStackInstancesOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// The output for a CreateStack action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackOutput
type CreateStackOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// Unique identifier of the stack.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s CreateStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStackOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s CreateStackOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackSetInput
type CreateStackSetInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the IAM role to use to create this stack
	// set.
	//
	// Specify an IAM role only if you are using customized administrator roles
	// to control which users or groups can manage specific stack sets within the
	// same administrator account. For more information, see Prerequisites: Granting
	// Permissions for Stack Set Operations (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html)
	// in the AWS CloudFormation User Guide.
	AdministrationRoleARN *string `min:"20" type:"string"`

	// A list of values that you must specify before AWS CloudFormation can create
	// certain stack sets. Some stack set templates might include resources that
	// can affect permissions in your AWS account—for example, by creating new AWS
	// Identity and Access Management (IAM) users. For those stack sets, you must
	// explicitly acknowledge their capabilities by specifying this parameter.
	//
	// The only valid values are CAPABILITY_IAM and CAPABILITY_NAMED_IAM. The following
	// resources require you to specify this parameter:
	//
	//    * AWS::IAM::AccessKey
	//
	//    * AWS::IAM::Group
	//
	//    * AWS::IAM::InstanceProfile
	//
	//    * AWS::IAM::Policy
	//
	//    * AWS::IAM::Role
	//
	//    * AWS::IAM::User
	//
	//    * AWS::IAM::UserToGroupAddition
	//
	// If your stack template contains these resources, we recommend that you review
	// all permissions that are associated with them and edit their permissions
	// if necessary.
	//
	// If you have IAM resources, you can specify either capability. If you have
	// IAM resources with custom names, you must specify CAPABILITY_NAMED_IAM. If
	// you don't specify this parameter, this action returns an InsufficientCapabilities
	// error.
	//
	// For more information, see Acknowledging IAM Resources in AWS CloudFormation
	// Templates. (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities)
	Capabilities []Capability `type:"list"`

	// A unique identifier for this CreateStackSet request. Specify this token if
	// you plan to retry requests so that AWS CloudFormation knows that you're not
	// attempting to create another stack set with the same name. You might retry
	// CreateStackSet requests to ensure that AWS CloudFormation successfully received
	// them.
	//
	// If you don't specify an operation ID, the SDK generates one automatically.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// A description of the stack set. You can use the description to identify the
	// stack set's purpose or other important information.
	Description *string `min:"1" type:"string"`

	// The name of the IAM execution role to use to create the stack set. If you
	// do not specify an execution role, AWS CloudFormation uses the AWSCloudFormationStackSetExecutionRole
	// role for the stack set operation.
	//
	// Specify an IAM role only if you are using customized execution roles to control
	// which stack resources users and groups can include in their stack sets.
	ExecutionRoleName *string `min:"1" type:"string"`

	// The input parameters for the stack set template.
	Parameters []Parameter `type:"list"`

	// The name to associate with the stack set. The name must be unique in the
	// region where you create your stack set.
	//
	// A stack name can contain only alphanumeric characters (case-sensitive) and
	// hyphens. It must start with an alphabetic character and can't be longer than
	// 128 characters.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`

	// The key-value pairs to associate with this stack set and the stacks created
	// from it. AWS CloudFormation also propagates these tags to supported resources
	// that are created in the stacks. A maximum number of 50 tags can be specified.
	//
	// If you specify tags as part of a CreateStackSet action, AWS CloudFormation
	// checks to see if you have the required IAM permission to tag resources. If
	// you don't, the entire CreateStackSet action fails with an access denied error,
	// and the stack set is not created.
	Tags []Tag `type:"list"`

	// The structure that contains the template body, with a minimum length of 1
	// byte and a maximum length of 51,200 bytes. For more information, see Template
	// Anatomy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must specify either the TemplateBody or the TemplateURL
	// parameter, but not both.
	TemplateBody *string `min:"1" type:"string"`

	// The location of the file that contains the template body. The URL must point
	// to a template (maximum size: 460,800 bytes) that's located in an Amazon S3
	// bucket. For more information, see Template Anatomy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must specify either the TemplateBody or the TemplateURL
	// parameter, but not both.
	TemplateURL *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateStackSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStackSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStackSetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateStackSetInput"}
	if s.AdministrationRoleARN != nil && len(*s.AdministrationRoleARN) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("AdministrationRoleARN", 20))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}
	if s.ExecutionRoleName != nil && len(*s.ExecutionRoleName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ExecutionRoleName", 1))
	}

	if s.StackSetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackSetName"))
	}
	if s.TemplateBody != nil && len(*s.TemplateBody) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TemplateBody", 1))
	}
	if s.TemplateURL != nil && len(*s.TemplateURL) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TemplateURL", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackSetOutput
type CreateStackSetOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The ID of the stack set that you're creating.
	StackSetId *string `type:"string"`
}

// String returns the string representation
func (s CreateStackSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStackSetOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s CreateStackSetOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// The input for the DeleteChangeSet action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteChangeSetInput
type DeleteChangeSetInput struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of the change set that you want to
	// delete.
	//
	// ChangeSetName is a required field
	ChangeSetName *string `min:"1" type:"string" required:"true"`

	// If you specified the name of a change set to delete, specify the stack name
	// or ID (ARN) that is associated with it.
	StackName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteChangeSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteChangeSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteChangeSetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteChangeSetInput"}

	if s.ChangeSetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChangeSetName"))
	}
	if s.ChangeSetName != nil && len(*s.ChangeSetName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChangeSetName", 1))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output for the DeleteChangeSet action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteChangeSetOutput
type DeleteChangeSetOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s DeleteChangeSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteChangeSetOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DeleteChangeSetOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// The input for DeleteStack action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackInput
type DeleteStackInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for this DeleteStack request. Specify this token if you
	// plan to retry requests so that AWS CloudFormation knows that you're not attempting
	// to delete a stack with the same name. You might retry DeleteStack requests
	// to ensure that AWS CloudFormation successfully received them.
	//
	// All events triggered by a given stack operation are assigned the same client
	// request token, which you can use to track operations. For example, if you
	// execute a CreateStack operation with the token token1, then all the StackEvents
	// generated by that operation will have ClientRequestToken set as token1.
	//
	// In the console, stack operations display the client request token on the
	// Events tab. Stack operations that are initiated from the console use the
	// token format Console-StackOperation-ID, which helps you easily identify the
	// stack operation . For example, if you create a stack using the console, each
	// stack event would be assigned the same token in the following format: Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002.
	ClientRequestToken *string `min:"1" type:"string"`

	// For stacks in the DELETE_FAILED state, a list of resource logical IDs that
	// are associated with the resources you want to retain. During deletion, AWS
	// CloudFormation deletes the stack but does not delete the retained resources.
	//
	// Retaining resources is useful when you cannot delete a resource, such as
	// a non-empty S3 bucket, but you want to delete the stack.
	RetainResources []string `type:"list"`

	// The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM)
	// role that AWS CloudFormation assumes to delete the stack. AWS CloudFormation
	// uses the role's credentials to make calls on your behalf.
	//
	// If you don't specify a value, AWS CloudFormation uses the role that was previously
	// associated with the stack. If no role is available, AWS CloudFormation uses
	// a temporary session that is generated from your user credentials.
	RoleARN *string `min:"20" type:"string"`

	// The name or the unique stack ID that is associated with the stack.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStackInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteStackInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleARN", 20))
	}

	if s.StackName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackInstancesInput
type DeleteStackInstancesInput struct {
	_ struct{} `type:"structure"`

	// The names of the AWS accounts that you want to delete stack instances for.
	//
	// Accounts is a required field
	Accounts []string `type:"list" required:"true"`

	// The unique identifier for this stack set operation.
	//
	// If you don't specify an operation ID, the SDK generates one automatically.
	//
	// The operation ID also functions as an idempotency token, to ensure that AWS
	// CloudFormation performs the stack set operation only once, even if you retry
	// the request multiple times. You can retry stack set operation requests to
	// ensure that AWS CloudFormation successfully received them.
	//
	// Repeating this stack set operation with a new operation ID retries all stack
	// instances whose status is OUTDATED.
	OperationId *string `min:"1" type:"string" idempotencyToken:"true"`

	// Preferences for how AWS CloudFormation performs this stack set operation.
	OperationPreferences *StackSetOperationPreferences `type:"structure"`

	// The regions where you want to delete stack set instances.
	//
	// Regions is a required field
	Regions []string `type:"list" required:"true"`

	// Removes the stack instances from the specified stack set, but doesn't delete
	// the stacks. You can't reassociate a retained stack or add an existing, saved
	// stack to a new stack set.
	//
	// For more information, see Stack set operation options (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options).
	//
	// RetainStacks is a required field
	RetainStacks *bool `type:"boolean" required:"true"`

	// The name or unique ID of the stack set that you want to delete stack instances
	// for.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteStackInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStackInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStackInstancesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteStackInstancesInput"}

	if s.Accounts == nil {
		invalidParams.Add(aws.NewErrParamRequired("Accounts"))
	}
	if s.OperationId != nil && len(*s.OperationId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OperationId", 1))
	}

	if s.Regions == nil {
		invalidParams.Add(aws.NewErrParamRequired("Regions"))
	}

	if s.RetainStacks == nil {
		invalidParams.Add(aws.NewErrParamRequired("RetainStacks"))
	}

	if s.StackSetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackSetName"))
	}
	if s.OperationPreferences != nil {
		if err := s.OperationPreferences.Validate(); err != nil {
			invalidParams.AddNested("OperationPreferences", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackInstancesOutput
type DeleteStackInstancesOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The unique identifier for this stack set operation.
	OperationId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteStackInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStackInstancesOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DeleteStackInstancesOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackOutput
type DeleteStackOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s DeleteStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStackOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DeleteStackOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackSetInput
type DeleteStackSetInput struct {
	_ struct{} `type:"structure"`

	// The name or unique ID of the stack set that you're deleting. You can obtain
	// this value by running ListStackSets.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteStackSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStackSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStackSetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteStackSetInput"}

	if s.StackSetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackSetOutput
type DeleteStackSetOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s DeleteStackSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStackSetOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DeleteStackSetOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// The input for the DescribeAccountLimits action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimitsInput
type DescribeAccountLimitsInput struct {
	_ struct{} `type:"structure"`

	// A string that identifies the next page of limits that you want to retrieve.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeAccountLimitsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountLimitsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAccountLimitsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeAccountLimitsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output for the DescribeAccountLimits action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimitsOutput
type DescribeAccountLimitsOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// An account limit structure that contain a list of AWS CloudFormation account
	// limits and their values.
	AccountLimits []AccountLimit `type:"list"`

	// If the output exceeds 1 MB in size, a string that identifies the next page
	// of limits. If no additional page exists, this value is null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeAccountLimitsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountLimitsOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DescribeAccountLimitsOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// The input for the DescribeChangeSet action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeChangeSetInput
type DescribeChangeSetInput struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of the change set that you want to
	// describe.
	//
	// ChangeSetName is a required field
	ChangeSetName *string `min:"1" type:"string" required:"true"`

	// A string (provided by the DescribeChangeSet response output) that identifies
	// the next page of information that you want to retrieve.
	NextToken *string `min:"1" type:"string"`

	// If you specified the name of a change set, specify the stack name or ID (ARN)
	// of the change set you want to describe.
	StackName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeChangeSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChangeSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeChangeSetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeChangeSetInput"}

	if s.ChangeSetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChangeSetName"))
	}
	if s.ChangeSetName != nil && len(*s.ChangeSetName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChangeSetName", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output for the DescribeChangeSet action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeChangeSetOutput
type DescribeChangeSetOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// If you execute the change set, the list of capabilities that were explicitly
	// acknowledged when the change set was created.
	Capabilities []Capability `type:"list"`

	// The ARN of the change set.
	ChangeSetId *string `min:"1" type:"string"`

	// The name of the change set.
	ChangeSetName *string `min:"1" type:"string"`

	// A list of Change structures that describes the resources AWS CloudFormation
	// changes if you execute the change set.
	Changes []Change `type:"list"`

	// The start time when the change set was created, in UTC.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Information about the change set.
	Description *string `min:"1" type:"string"`

	// If the change set execution status is AVAILABLE, you can execute the change
	// set. If you can’t execute the change set, the status indicates why. For example,
	// a change set might be in an UNAVAILABLE state because AWS CloudFormation
	// is still creating it or in an OBSOLETE state because the stack was already
	// updated.
	ExecutionStatus ExecutionStatus `type:"string" enum:"true"`

	// If the output exceeds 1 MB, a string that identifies the next page of changes.
	// If there is no additional page, this value is null.
	NextToken *string `min:"1" type:"string"`

	// The ARNs of the Amazon Simple Notification Service (Amazon SNS) topics that
	// will be associated with the stack if you execute the change set.
	NotificationARNs []string `type:"list"`

	// A list of Parameter structures that describes the input parameters and their
	// values used to create the change set. For more information, see the Parameter
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html)
	// data type.
	Parameters []Parameter `type:"list"`

	// The rollback triggers for AWS CloudFormation to monitor during stack creation
	// and updating operations, and for the specified monitoring period afterwards.
	RollbackConfiguration *RollbackConfiguration `type:"structure"`

	// The ARN of the stack that is associated with the change set.
	StackId *string `type:"string"`

	// The name of the stack that is associated with the change set.
	StackName *string `type:"string"`

	// The current status of the change set, such as CREATE_IN_PROGRESS, CREATE_COMPLETE,
	// or FAILED.
	Status ChangeSetStatus `type:"string" enum:"true"`

	// A description of the change set's status. For example, if your attempt to
	// create a change set failed, AWS CloudFormation shows the error message.
	StatusReason *string `type:"string"`

	// If you execute the change set, the tags that will be associated with the
	// stack.
	Tags []Tag `type:"list"`
}

// String returns the string representation
func (s DescribeChangeSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChangeSetOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DescribeChangeSetOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// The input for DescribeStackEvents action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackEventsInput
type DescribeStackEventsInput struct {
	_ struct{} `type:"structure"`

	// A string that identifies the next page of events that you want to retrieve.
	NextToken *string `min:"1" type:"string"`

	// The name or the unique stack ID that is associated with the stack, which
	// are not always interchangeable:
	//
	//    * Running stacks: You can specify either the stack's name or its unique
	//    stack ID.
	//
	//    * Deleted stacks: You must specify the unique stack ID.
	//
	// Default: There is no default value.
	StackName *string `type:"string"`
}

// String returns the string representation
func (s DescribeStackEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStackEventsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeStackEventsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output for a DescribeStackEvents action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackEventsOutput
type DescribeStackEventsOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// If the output exceeds 1 MB in size, a string that identifies the next page
	// of events. If no additional page exists, this value is null.
	NextToken *string `min:"1" type:"string"`

	// A list of StackEvents structures.
	StackEvents []StackEvent `type:"list"`
}

// String returns the string representation
func (s DescribeStackEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackEventsOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DescribeStackEventsOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackInstanceInput
type DescribeStackInstanceInput struct {
	_ struct{} `type:"structure"`

	// The ID of an AWS account that's associated with this stack instance.
	//
	// StackInstanceAccount is a required field
	StackInstanceAccount *string `type:"string" required:"true"`

	// The name of a region that's associated with this stack instance.
	//
	// StackInstanceRegion is a required field
	StackInstanceRegion *string `type:"string" required:"true"`

	// The name or the unique stack ID of the stack set that you want to get stack
	// instance information for.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeStackInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStackInstanceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeStackInstanceInput"}

	if s.StackInstanceAccount == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackInstanceAccount"))
	}

	if s.StackInstanceRegion == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackInstanceRegion"))
	}

	if s.StackSetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackInstanceOutput
type DescribeStackInstanceOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The stack instance that matches the specified request parameters.
	StackInstance *StackInstance `type:"structure"`
}

// String returns the string representation
func (s DescribeStackInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackInstanceOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DescribeStackInstanceOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// The input for DescribeStackResource action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResourceInput
type DescribeStackResourceInput struct {
	_ struct{} `type:"structure"`

	// The logical name of the resource as specified in the template.
	//
	// Default: There is no default value.
	//
	// LogicalResourceId is a required field
	LogicalResourceId *string `type:"string" required:"true"`

	// The name or the unique stack ID that is associated with the stack, which
	// are not always interchangeable:
	//
	//    * Running stacks: You can specify either the stack's name or its unique
	//    stack ID.
	//
	//    * Deleted stacks: You must specify the unique stack ID.
	//
	// Default: There is no default value.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeStackResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStackResourceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeStackResourceInput"}

	if s.LogicalResourceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogicalResourceId"))
	}

	if s.StackName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output for a DescribeStackResource action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResourceOutput
type DescribeStackResourceOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// A StackResourceDetail structure containing the description of the specified
	// resource in the specified stack.
	StackResourceDetail *StackResourceDetail `type:"structure"`
}

// String returns the string representation
func (s DescribeStackResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackResourceOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DescribeStackResourceOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// The input for DescribeStackResources action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResourcesInput
type DescribeStackResourcesInput struct {
	_ struct{} `type:"structure"`

	// The logical name of the resource as specified in the template.
	//
	// Default: There is no default value.
	LogicalResourceId *string `type:"string"`

	// The name or unique identifier that corresponds to a physical instance ID
	// of a resource supported by AWS CloudFormation.
	//
	// For example, for an Amazon Elastic Compute Cloud (EC2) instance, PhysicalResourceId
	// corresponds to the InstanceId. You can pass the EC2 InstanceId to DescribeStackResources
	// to find which stack the instance belongs to and what other resources are
	// part of the stack.
	//
	// Required: Conditional. If you do not specify PhysicalResourceId, you must
	// specify StackName.
	//
	// Default: There is no default value.
	PhysicalResourceId *string `type:"string"`

	// The name or the unique stack ID that is associated with the stack, which
	// are not always interchangeable:
	//
	//    * Running stacks: You can specify either the stack's name or its unique
	//    stack ID.
	//
	//    * Deleted stacks: You must specify the unique stack ID.
	//
	// Default: There is no default value.
	//
	// Required: Conditional. If you do not specify StackName, you must specify
	// PhysicalResourceId.
	StackName *string `type:"string"`
}

// String returns the string representation
func (s DescribeStackResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackResourcesInput) GoString() string {
	return s.String()
}

// The output for a DescribeStackResources action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResourcesOutput
type DescribeStackResourcesOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// A list of StackResource structures.
	StackResources []StackResource `type:"list"`
}

// String returns the string representation
func (s DescribeStackResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackResourcesOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DescribeStackResourcesOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSetInput
type DescribeStackSetInput struct {
	_ struct{} `type:"structure"`

	// The name or unique ID of the stack set whose description you want.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeStackSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStackSetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeStackSetInput"}

	if s.StackSetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSetOperationInput
type DescribeStackSetOperationInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the stack set operation.
	//
	// OperationId is a required field
	OperationId *string `min:"1" type:"string" required:"true"`

	// The name or the unique stack ID of the stack set for the stack operation.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeStackSetOperationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackSetOperationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStackSetOperationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeStackSetOperationInput"}

	if s.OperationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("OperationId"))
	}
	if s.OperationId != nil && len(*s.OperationId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OperationId", 1))
	}

	if s.StackSetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSetOperationOutput
type DescribeStackSetOperationOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The specified stack set operation.
	StackSetOperation *StackSetOperation `type:"structure"`
}

// String returns the string representation
func (s DescribeStackSetOperationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackSetOperationOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DescribeStackSetOperationOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSetOutput
type DescribeStackSetOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The specified stack set.
	StackSet *StackSet `type:"structure"`
}

// String returns the string representation
func (s DescribeStackSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackSetOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DescribeStackSetOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// The input for DescribeStacks action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacksInput
type DescribeStacksInput struct {
	_ struct{} `type:"structure"`

	// A string that identifies the next page of stacks that you want to retrieve.
	NextToken *string `min:"1" type:"string"`

	// The name or the unique stack ID that is associated with the stack, which
	// are not always interchangeable:
	//
	//    * Running stacks: You can specify either the stack's name or its unique
	//    stack ID.
	//
	//    * Deleted stacks: You must specify the unique stack ID.
	//
	// Default: There is no default value.
	StackName *string `type:"string"`
}

// String returns the string representation
func (s DescribeStacksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStacksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStacksInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeStacksInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output for a DescribeStacks action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacksOutput
type DescribeStacksOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// If the output exceeds 1 MB in size, a string that identifies the next page
	// of stacks. If no additional page exists, this value is null.
	NextToken *string `min:"1" type:"string"`

	// A list of stack structures.
	Stacks []Stack `type:"list"`
}

// String returns the string representation
func (s DescribeStacksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStacksOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DescribeStacksOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// The input for an EstimateTemplateCost action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/EstimateTemplateCostInput
type EstimateTemplateCostInput struct {
	_ struct{} `type:"structure"`

	// A list of Parameter structures that specify input parameters.
	Parameters []Parameter `type:"list"`

	// Structure containing the template body with a minimum length of 1 byte and
	// a maximum length of 51,200 bytes. (For more information, go to Template Anatomy
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.)
	//
	// Conditional: You must pass TemplateBody or TemplateURL. If both are passed,
	// only TemplateBody is used.
	TemplateBody *string `min:"1" type:"string"`

	// Location of file containing the template body. The URL must point to a template
	// that is located in an Amazon S3 bucket. For more information, go to Template
	// Anatomy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must pass TemplateURL or TemplateBody. If both are passed,
	// only TemplateBody is used.
	TemplateURL *string `min:"1" type:"string"`
}

// String returns the string representation
func (s EstimateTemplateCostInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EstimateTemplateCostInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EstimateTemplateCostInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EstimateTemplateCostInput"}
	if s.TemplateBody != nil && len(*s.TemplateBody) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TemplateBody", 1))
	}
	if s.TemplateURL != nil && len(*s.TemplateURL) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TemplateURL", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output for a EstimateTemplateCost action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/EstimateTemplateCostOutput
type EstimateTemplateCostOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// An AWS Simple Monthly Calculator URL with a query string that describes the
	// resources required to run the template.
	Url *string `type:"string"`
}

// String returns the string representation
func (s EstimateTemplateCostOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EstimateTemplateCostOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s EstimateTemplateCostOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// The input for the ExecuteChangeSet action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ExecuteChangeSetInput
type ExecuteChangeSetInput struct {
	_ struct{} `type:"structure"`

	// The name or ARN of the change set that you want use to update the specified
	// stack.
	//
	// ChangeSetName is a required field
	ChangeSetName *string `min:"1" type:"string" required:"true"`

	// A unique identifier for this ExecuteChangeSet request. Specify this token
	// if you plan to retry requests so that AWS CloudFormation knows that you're
	// not attempting to execute a change set to update a stack with the same name.
	// You might retry ExecuteChangeSet requests to ensure that AWS CloudFormation
	// successfully received them.
	ClientRequestToken *string `min:"1" type:"string"`

	// If you specified the name of a change set, specify the stack name or ID (ARN)
	// that is associated with the change set you want to execute.
	StackName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ExecuteChangeSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecuteChangeSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExecuteChangeSetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ExecuteChangeSetInput"}

	if s.ChangeSetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChangeSetName"))
	}
	if s.ChangeSetName != nil && len(*s.ChangeSetName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChangeSetName", 1))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output for the ExecuteChangeSet action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ExecuteChangeSetOutput
type ExecuteChangeSetOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s ExecuteChangeSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecuteChangeSetOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s ExecuteChangeSetOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// The Export structure describes the exported output values for a stack.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/Export
type Export struct {
	_ struct{} `type:"structure"`

	// The stack that contains the exported output name and value.
	ExportingStackId *string `type:"string"`

	// The name of exported output value. Use this name and the Fn::ImportValue
	// function to import the associated value into other stacks. The name is defined
	// in the Export field in the associated stack's Outputs section.
	Name *string `type:"string"`

	// The value of the exported output, such as a resource physical ID. This value
	// is defined in the Export field in the associated stack's Outputs section.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Export) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Export) GoString() string {
	return s.String()
}

// The input for the GetStackPolicy action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetStackPolicyInput
type GetStackPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name or unique stack ID that is associated with the stack whose policy
	// you want to get.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetStackPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStackPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStackPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetStackPolicyInput"}

	if s.StackName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output for the GetStackPolicy action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetStackPolicyOutput
type GetStackPolicyOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// Structure containing the stack policy body. (For more information, go to
	//  Prevent Updates to Stack Resources (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html)
	// in the AWS CloudFormation User Guide.)
	StackPolicyBody *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetStackPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStackPolicyOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s GetStackPolicyOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// The input for a GetTemplate action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplateInput
type GetTemplateInput struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of a change set for which AWS CloudFormation
	// returns the associated template. If you specify a name, you must also specify
	// the StackName.
	ChangeSetName *string `min:"1" type:"string"`

	// The name or the unique stack ID that is associated with the stack, which
	// are not always interchangeable:
	//
	//    * Running stacks: You can specify either the stack's name or its unique
	//    stack ID.
	//
	//    * Deleted stacks: You must specify the unique stack ID.
	//
	// Default: There is no default value.
	StackName *string `type:"string"`

	// For templates that include transforms, the stage of the template that AWS
	// CloudFormation returns. To get the user-submitted template, specify Original.
	// To get the template after AWS CloudFormation has processed all transforms,
	// specify Processed.
	//
	// If the template doesn't include transforms, Original and Processed return
	// the same template. By default, AWS CloudFormation specifies Original.
	TemplateStage TemplateStage `type:"string" enum:"true"`
}

// String returns the string representation
func (s GetTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTemplateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetTemplateInput"}
	if s.ChangeSetName != nil && len(*s.ChangeSetName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChangeSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output for GetTemplate action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplateOutput
type GetTemplateOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The stage of the template that you can retrieve. For stacks, the Original
	// and Processed templates are always available. For change sets, the Original
	// template is always available. After AWS CloudFormation finishes creating
	// the change set, the Processed template becomes available.
	StagesAvailable []TemplateStage `type:"list"`

	// Structure containing the template body. (For more information, go to Template
	// Anatomy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.)
	//
	// AWS CloudFormation returns the same template that was used when the stack
	// was created.
	TemplateBody *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTemplateOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s GetTemplateOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// The input for the GetTemplateSummary action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplateSummaryInput
type GetTemplateSummaryInput struct {
	_ struct{} `type:"structure"`

	// The name or the stack ID that is associated with the stack, which are not
	// always interchangeable. For running stacks, you can specify either the stack's
	// name or its unique stack ID. For deleted stack, you must specify the unique
	// stack ID.
	//
	// Conditional: You must specify only one of the following parameters: StackName,
	// StackSetName, TemplateBody, or TemplateURL.
	StackName *string `min:"1" type:"string"`

	// The name or unique ID of the stack set from which the stack was created.
	//
	// Conditional: You must specify only one of the following parameters: StackName,
	// StackSetName, TemplateBody, or TemplateURL.
	StackSetName *string `type:"string"`

	// Structure containing the template body with a minimum length of 1 byte and
	// a maximum length of 51,200 bytes. For more information about templates, see
	// Template Anatomy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must specify only one of the following parameters: StackName,
	// StackSetName, TemplateBody, or TemplateURL.
	TemplateBody *string `min:"1" type:"string"`

	// Location of file containing the template body. The URL must point to a template
	// (max size: 460,800 bytes) that is located in an Amazon S3 bucket. For more
	// information about templates, see Template Anatomy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must specify only one of the following parameters: StackName,
	// StackSetName, TemplateBody, or TemplateURL.
	TemplateURL *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetTemplateSummaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTemplateSummaryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTemplateSummaryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetTemplateSummaryInput"}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StackName", 1))
	}
	if s.TemplateBody != nil && len(*s.TemplateBody) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TemplateBody", 1))
	}
	if s.TemplateURL != nil && len(*s.TemplateURL) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TemplateURL", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output for the GetTemplateSummary action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplateSummaryOutput
type GetTemplateSummaryOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The capabilities found within the template. If your template contains IAM
	// resources, you must specify the CAPABILITY_IAM or CAPABILITY_NAMED_IAM value
	// for this parameter when you use the CreateStack or UpdateStack actions with
	// your template; otherwise, those actions return an InsufficientCapabilities
	// error.
	//
	// For more information, see Acknowledging IAM Resources in AWS CloudFormation
	// Templates (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities).
	Capabilities []Capability `type:"list"`

	// The list of resources that generated the values in the Capabilities response
	// element.
	CapabilitiesReason *string `type:"string"`

	// A list of the transforms that are declared in the template.
	DeclaredTransforms []string `type:"list"`

	// The value that is defined in the Description property of the template.
	Description *string `min:"1" type:"string"`

	// The value that is defined for the Metadata property of the template.
	Metadata *string `type:"string"`

	// A list of parameter declarations that describe various properties for each
	// parameter.
	Parameters []ParameterDeclaration `type:"list"`

	// A list of all the template resource types that are defined in the template,
	// such as AWS::EC2::Instance, AWS::Dynamo::Table, and Custom::MyCustomInstance.
	ResourceTypes []string `type:"list"`

	// The AWS template format version, which identifies the capabilities of the
	// template.
	Version *string `type:"string"`
}

// String returns the string representation
func (s GetTemplateSummaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTemplateSummaryOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s GetTemplateSummaryOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// The input for the ListChangeSets action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListChangeSetsInput
type ListChangeSetsInput struct {
	_ struct{} `type:"structure"`

	// A string (provided by the ListChangeSets response output) that identifies
	// the next page of change sets that you want to retrieve.
	NextToken *string `min:"1" type:"string"`

	// The name or the Amazon Resource Name (ARN) of the stack for which you want
	// to list change sets.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListChangeSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChangeSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChangeSetsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListChangeSetsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if s.StackName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output for the ListChangeSets action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListChangeSetsOutput
type ListChangeSetsOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// If the output exceeds 1 MB, a string that identifies the next page of change
	// sets. If there is no additional page, this value is null.
	NextToken *string `min:"1" type:"string"`

	// A list of ChangeSetSummary structures that provides the ID and status of
	// each change set for the specified stack.
	Summaries []ChangeSetSummary `type:"list"`
}

// String returns the string representation
func (s ListChangeSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChangeSetsOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s ListChangeSetsOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExportsInput
type ListExportsInput struct {
	_ struct{} `type:"structure"`

	// A string (provided by the ListExports response output) that identifies the
	// next page of exported output values that you asked to retrieve.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListExportsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListExportsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListExportsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListExportsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExportsOutput
type ListExportsOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The output for the ListExports action.
	Exports []Export `type:"list"`

	// If the output exceeds 100 exported output values, a string that identifies
	// the next page of exports. If there is no additional page, this value is null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListExportsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListExportsOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s ListExportsOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListImportsInput
type ListImportsInput struct {
	_ struct{} `type:"structure"`

	// The name of the exported output value. AWS CloudFormation returns the stack
	// names that are importing this value.
	//
	// ExportName is a required field
	ExportName *string `type:"string" required:"true"`

	// A string (provided by the ListImports response output) that identifies the
	// next page of stacks that are importing the specified exported output value.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListImportsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListImportsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListImportsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListImportsInput"}

	if s.ExportName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ExportName"))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListImportsOutput
type ListImportsOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// A list of stack names that are importing the specified exported output value.
	Imports []string `type:"list"`

	// A string that identifies the next page of exports. If there is no additional
	// page, this value is null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListImportsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListImportsOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s ListImportsOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackInstancesInput
type ListStackInstancesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to be returned with a single call. If the number
	// of available results exceeds this maximum, the response includes a NextToken
	// value that you can assign to the NextToken request parameter to get the next
	// set of results.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous request didn't return all of the remaining results, the response's
	// NextToken parameter value is set to a token. To retrieve the next set of
	// results, call ListStackInstances again and assign that token to the request
	// object's NextToken parameter. If there are no remaining results, the previous
	// response object's NextToken parameter is set to null.
	NextToken *string `min:"1" type:"string"`

	// The name of the AWS account that you want to list stack instances for.
	StackInstanceAccount *string `type:"string"`

	// The name of the region where you want to list stack instances.
	StackInstanceRegion *string `type:"string"`

	// The name or unique ID of the stack set that you want to list stack instances
	// for.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListStackInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStackInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStackInstancesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListStackInstancesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if s.StackSetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackInstancesOutput
type ListStackInstancesOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// If the request doesn't return all of the remaining results, NextToken is
	// set to a token. To retrieve the next set of results, call ListStackInstances
	// again and assign that token to the request object's NextToken parameter.
	// If the request returns all results, NextToken is set to null.
	NextToken *string `min:"1" type:"string"`

	// A list of StackInstanceSummary structures that contain information about
	// the specified stack instances.
	Summaries []StackInstanceSummary `type:"list"`
}

// String returns the string representation
func (s ListStackInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStackInstancesOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s ListStackInstancesOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// The input for the ListStackResource action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackResourcesInput
type ListStackResourcesInput struct {
	_ struct{} `type:"structure"`

	// A string that identifies the next page of stack resources that you want to
	// retrieve.
	NextToken *string `min:"1" type:"string"`

	// The name or the unique stack ID that is associated with the stack, which
	// are not always interchangeable:
	//
	//    * Running stacks: You can specify either the stack's name or its unique
	//    stack ID.
	//
	//    * Deleted stacks: You must specify the unique stack ID.
	//
	// Default: There is no default value.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListStackResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStackResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStackResourcesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListStackResourcesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if s.StackName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output for a ListStackResources action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackResourcesOutput
type ListStackResourcesOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// If the output exceeds 1 MB, a string that identifies the next page of stack
	// resources. If no additional page exists, this value is null.
	NextToken *string `min:"1" type:"string"`

	// A list of StackResourceSummary structures.
	StackResourceSummaries []StackResourceSummary `type:"list"`
}

// String returns the string representation
func (s ListStackResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStackResourcesOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s ListStackResourcesOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperationResultsInput
type ListStackSetOperationResultsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to be returned with a single call. If the number
	// of available results exceeds this maximum, the response includes a NextToken
	// value that you can assign to the NextToken request parameter to get the next
	// set of results.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous request didn't return all of the remaining results, the response
	// object's NextToken parameter value is set to a token. To retrieve the next
	// set of results, call ListStackSetOperationResults again and assign that token
	// to the request object's NextToken parameter. If there are no remaining results,
	// the previous response object's NextToken parameter is set to null.
	NextToken *string `min:"1" type:"string"`

	// The ID of the stack set operation.
	//
	// OperationId is a required field
	OperationId *string `min:"1" type:"string" required:"true"`

	// The name or unique ID of the stack set that you want to get operation results
	// for.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListStackSetOperationResultsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStackSetOperationResultsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStackSetOperationResultsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListStackSetOperationResultsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if s.OperationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("OperationId"))
	}
	if s.OperationId != nil && len(*s.OperationId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OperationId", 1))
	}

	if s.StackSetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperationResultsOutput
type ListStackSetOperationResultsOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// If the request doesn't return all results, NextToken is set to a token. To
	// retrieve the next set of results, call ListOperationResults again and assign
	// that token to the request object's NextToken parameter. If there are no remaining
	// results, NextToken is set to null.
	NextToken *string `min:"1" type:"string"`

	// A list of StackSetOperationResultSummary structures that contain information
	// about the specified operation results, for accounts and regions that are
	// included in the operation.
	Summaries []StackSetOperationResultSummary `type:"list"`
}

// String returns the string representation
func (s ListStackSetOperationResultsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStackSetOperationResultsOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s ListStackSetOperationResultsOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperationsInput
type ListStackSetOperationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to be returned with a single call. If the number
	// of available results exceeds this maximum, the response includes a NextToken
	// value that you can assign to the NextToken request parameter to get the next
	// set of results.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous paginated request didn't return all of the remaining results,
	// the response object's NextToken parameter value is set to a token. To retrieve
	// the next set of results, call ListStackSetOperations again and assign that
	// token to the request object's NextToken parameter. If there are no remaining
	// results, the previous response object's NextToken parameter is set to null.
	NextToken *string `min:"1" type:"string"`

	// The name or unique ID of the stack set that you want to get operation summaries
	// for.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListStackSetOperationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStackSetOperationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStackSetOperationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListStackSetOperationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if s.StackSetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperationsOutput
type ListStackSetOperationsOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// If the request doesn't return all results, NextToken is set to a token. To
	// retrieve the next set of results, call ListOperationResults again and assign
	// that token to the request object's NextToken parameter. If there are no remaining
	// results, NextToken is set to null.
	NextToken *string `min:"1" type:"string"`

	// A list of StackSetOperationSummary structures that contain summary information
	// about operations for the specified stack set.
	Summaries []StackSetOperationSummary `type:"list"`
}

// String returns the string representation
func (s ListStackSetOperationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStackSetOperationsOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s ListStackSetOperationsOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetsInput
type ListStackSetsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to be returned with a single call. If the number
	// of available results exceeds this maximum, the response includes a NextToken
	// value that you can assign to the NextToken request parameter to get the next
	// set of results.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous paginated request didn't return all of the remaining results,
	// the response object's NextToken parameter value is set to a token. To retrieve
	// the next set of results, call ListStackSets again and assign that token to
	// the request object's NextToken parameter. If there are no remaining results,
	// the previous response object's NextToken parameter is set to null.
	NextToken *string `min:"1" type:"string"`

	// The status of the stack sets that you want to get summary information about.
	Status StackSetStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s ListStackSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStackSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStackSetsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListStackSetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetsOutput
type ListStackSetsOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// If the request doesn't return all of the remaining results, NextToken is
	// set to a token. To retrieve the next set of results, call ListStackInstances
	// again and assign that token to the request object's NextToken parameter.
	// If the request returns all results, NextToken is set to null.
	NextToken *string `min:"1" type:"string"`

	// A list of StackSetSummary structures that contain information about the user's
	// stack sets.
	Summaries []StackSetSummary `type:"list"`
}

// String returns the string representation
func (s ListStackSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStackSetsOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s ListStackSetsOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// The input for ListStacks action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacksInput
type ListStacksInput struct {
	_ struct{} `type:"structure"`

	// A string that identifies the next page of stacks that you want to retrieve.
	NextToken *string `min:"1" type:"string"`

	// Stack status to use as a filter. Specify one or more stack status codes to
	// list only stacks with the specified status codes. For a complete list of
	// stack status codes, see the StackStatus parameter of the Stack data type.
	StackStatusFilter []StackStatus `type:"list"`
}

// String returns the string representation
func (s ListStacksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStacksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStacksInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListStacksInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output for ListStacks action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacksOutput
type ListStacksOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// If the output exceeds 1 MB in size, a string that identifies the next page
	// of stacks. If no additional page exists, this value is null.
	NextToken *string `min:"1" type:"string"`

	// A list of StackSummary structures containing information about the specified
	// stacks.
	StackSummaries []StackSummary `type:"list"`
}

// String returns the string representation
func (s ListStacksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStacksOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s ListStacksOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// The Output data type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/Output
type Output struct {
	_ struct{} `type:"structure"`

	// User defined description associated with the output.
	Description *string `min:"1" type:"string"`

	// The name of the export associated with the output.
	ExportName *string `type:"string"`

	// The key associated with the output.
	OutputKey *string `type:"string"`

	// The value associated with the output.
	OutputValue *string `type:"string"`
}

// String returns the string representation
func (s Output) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Output) GoString() string {
	return s.String()
}

// The Parameter data type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/Parameter
type Parameter struct {
	_ struct{} `type:"structure"`

	// The key associated with the parameter. If you don't specify a key and value
	// for a particular parameter, AWS CloudFormation uses the default value that
	// is specified in your template.
	ParameterKey *string `type:"string"`

	// The input value associated with the parameter.
	ParameterValue *string `type:"string"`

	// Read-only. The value that corresponds to a Systems Manager parameter key.
	// This field is returned only for SSM (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/parameters-section-structure.html#aws-ssm-parameter-types)
	// parameter types in the template.
	ResolvedValue *string `type:"string"`

	// During a stack update, use the existing parameter value that the stack is
	// using for a given parameter key. If you specify true, do not specify a parameter
	// value.
	UsePreviousValue *bool `type:"boolean"`
}

// String returns the string representation
func (s Parameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Parameter) GoString() string {
	return s.String()
}

// A set of criteria that AWS CloudFormation uses to validate parameter values.
// Although other constraints might be defined in the stack template, AWS CloudFormation
// returns only the AllowedValues property.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ParameterConstraints
type ParameterConstraints struct {
	_ struct{} `type:"structure"`

	// A list of values that are permitted for a parameter.
	AllowedValues []string `type:"list"`
}

// String returns the string representation
func (s ParameterConstraints) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ParameterConstraints) GoString() string {
	return s.String()
}

// The ParameterDeclaration data type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ParameterDeclaration
type ParameterDeclaration struct {
	_ struct{} `type:"structure"`

	// The default value of the parameter.
	DefaultValue *string `type:"string"`

	// The description that is associate with the parameter.
	Description *string `min:"1" type:"string"`

	// Flag that indicates whether the parameter value is shown as plain text in
	// logs and in the AWS Management Console.
	NoEcho *bool `type:"boolean"`

	// The criteria that AWS CloudFormation uses to validate parameter values.
	ParameterConstraints *ParameterConstraints `type:"structure"`

	// The name that is associated with the parameter.
	ParameterKey *string `type:"string"`

	// The type of parameter.
	ParameterType *string `type:"string"`
}

// String returns the string representation
func (s ParameterDeclaration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ParameterDeclaration) GoString() string {
	return s.String()
}

// The ResourceChange structure describes the resource and the action that AWS
// CloudFormation will perform on it if you execute this change set.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ResourceChange
type ResourceChange struct {
	_ struct{} `type:"structure"`

	// The action that AWS CloudFormation takes on the resource, such as Add (adds
	// a new resource), Modify (changes a resource), or Remove (deletes a resource).
	Action ChangeAction `type:"string" enum:"true"`

	// For the Modify action, a list of ResourceChangeDetail structures that describes
	// the changes that AWS CloudFormation will make to the resource.
	Details []ResourceChangeDetail `type:"list"`

	// The resource's logical ID, which is defined in the stack's template.
	LogicalResourceId *string `type:"string"`

	// The resource's physical ID (resource name). Resources that you are adding
	// don't have physical IDs because they haven't been created.
	PhysicalResourceId *string `type:"string"`

	// For the Modify action, indicates whether AWS CloudFormation will replace
	// the resource by creating a new one and deleting the old one. This value depends
	// on the value of the RequiresRecreation property in the ResourceTargetDefinition
	// structure. For example, if the RequiresRecreation field is Always and the
	// Evaluation field is Static, Replacement is True. If the RequiresRecreation
	// field is Always and the Evaluation field is Dynamic, Replacement is Conditionally.
	//
	// If you have multiple changes with different RequiresRecreation values, the
	// Replacement value depends on the change with the most impact. A RequiresRecreation
	// value of Always has the most impact, followed by Conditionally, and then
	// Never.
	Replacement Replacement `type:"string" enum:"true"`

	// The type of AWS CloudFormation resource, such as AWS::S3::Bucket.
	ResourceType *string `min:"1" type:"string"`

	// For the Modify action, indicates which resource attribute is triggering this
	// update, such as a change in the resource attribute's Metadata, Properties,
	// or Tags.
	Scope []ResourceAttribute `type:"list"`
}

// String returns the string representation
func (s ResourceChange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceChange) GoString() string {
	return s.String()
}

// For a resource with Modify as the action, the ResourceChange structure describes
// the changes AWS CloudFormation will make to that resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ResourceChangeDetail
type ResourceChangeDetail struct {
	_ struct{} `type:"structure"`

	// The identity of the entity that triggered this change. This entity is a member
	// of the group that is specified by the ChangeSource field. For example, if
	// you modified the value of the KeyPairName parameter, the CausingEntity is
	// the name of the parameter (KeyPairName).
	//
	// If the ChangeSource value is DirectModification, no value is given for CausingEntity.
	CausingEntity *string `type:"string"`

	// The group to which the CausingEntity value belongs. There are five entity
	// groups:
	//
	//    * ResourceReference entities are Ref intrinsic functions that refer to
	//    resources in the template, such as { "Ref" : "MyEC2InstanceResource" }.
	//
	//    * ParameterReference entities are Ref intrinsic functions that get template
	//    parameter values, such as { "Ref" : "MyPasswordParameter" }.
	//
	//    * ResourceAttribute entities are Fn::GetAtt intrinsic functions that get
	//    resource attribute values, such as { "Fn::GetAtt" : [ "MyEC2InstanceResource",
	//    "PublicDnsName" ] }.
	//
	//    * DirectModification entities are changes that are made directly to the
	//    template.
	//
	//    * Automatic entities are AWS::CloudFormation::Stack resource types, which
	//    are also known as nested stacks. If you made no changes to the AWS::CloudFormation::Stack
	//    resource, AWS CloudFormation sets the ChangeSource to Automatic because
	//    the nested stack's template might have changed. Changes to a nested stack's
	//    template aren't visible to AWS CloudFormation until you run an update
	//    on the parent stack.
	ChangeSource ChangeSource `type:"string" enum:"true"`

	// Indicates whether AWS CloudFormation can determine the target value, and
	// whether the target value will change before you execute a change set.
	//
	// For Static evaluations, AWS CloudFormation can determine that the target
	// value will change, and its value. For example, if you directly modify the
	// InstanceType property of an EC2 instance, AWS CloudFormation knows that this
	// property value will change, and its value, so this is a Static evaluation.
	//
	// For Dynamic evaluations, cannot determine the target value because it depends
	// on the result of an intrinsic function, such as a Ref or Fn::GetAtt intrinsic
	// function, when the stack is updated. For example, if your template includes
	// a reference to a resource that is conditionally recreated, the value of the
	// reference (the physical ID of the resource) might change, depending on if
	// the resource is recreated. If the resource is recreated, it will have a new
	// physical ID, so all references to that resource will also be updated.
	Evaluation EvaluationType `type:"string" enum:"true"`

	// A ResourceTargetDefinition structure that describes the field that AWS CloudFormation
	// will change and whether the resource will be recreated.
	Target *ResourceTargetDefinition `type:"structure"`
}

// String returns the string representation
func (s ResourceChangeDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceChangeDetail) GoString() string {
	return s.String()
}

// The field that AWS CloudFormation will change, such as the name of a resource's
// property, and whether the resource will be recreated.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ResourceTargetDefinition
type ResourceTargetDefinition struct {
	_ struct{} `type:"structure"`

	// Indicates which resource attribute is triggering this update, such as a change
	// in the resource attribute's Metadata, Properties, or Tags.
	Attribute ResourceAttribute `type:"string" enum:"true"`

	// If the Attribute value is Properties, the name of the property. For all other
	// attributes, the value is null.
	Name *string `type:"string"`

	// If the Attribute value is Properties, indicates whether a change to this
	// property causes the resource to be recreated. The value can be Never, Always,
	// or Conditionally. To determine the conditions for a Conditionally recreation,
	// see the update behavior for that property (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the AWS CloudFormation User Guide.
	RequiresRecreation RequiresRecreation `type:"string" enum:"true"`
}

// String returns the string representation
func (s ResourceTargetDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceTargetDefinition) GoString() string {
	return s.String()
}

// Structure containing the rollback triggers for AWS CloudFormation to monitor
// during stack creation and updating operations, and for the specified monitoring
// period afterwards.
//
// Rollback triggers enable you to have AWS CloudFormation monitor the state
// of your application during stack creation and updating, and to roll back
// that operation if the application breaches the threshold of any of the alarms
// you've specified. For more information, see Monitor and Roll Back Stack Operations
// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-rollback-triggers.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackConfiguration
type RollbackConfiguration struct {
	_ struct{} `type:"structure"`

	// The amount of time, in minutes, during which CloudFormation should monitor
	// all the rollback triggers after the stack creation or update operation deploys
	// all necessary resources.
	//
	// The default is 0 minutes.
	//
	// If you specify a monitoring period but do not specify any rollback triggers,
	// CloudFormation still waits the specified period of time before cleaning up
	// old resources after update operations. You can use this monitoring period
	// to perform any manual stack validation desired, and manually cancel the stack
	// creation or update (using CancelUpdateStack (http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CancelUpdateStack.html),
	// for example) as necessary.
	//
	// If you specify 0 for this parameter, CloudFormation still monitors the specified
	// rollback triggers during stack creation and update operations. Then, for
	// update operations, it begins disposing of old resources immediately once
	// the operation completes.
	MonitoringTimeInMinutes *int64 `type:"integer"`

	// The triggers to monitor during stack creation or update actions.
	//
	// By default, AWS CloudFormation saves the rollback triggers specified for
	// a stack and applies them to any subsequent update operations for the stack,
	// unless you specify otherwise. If you do specify rollback triggers for this
	// parameter, those triggers replace any list of triggers previously specified
	// for the stack. This means:
	//
	//    * To use the rollback triggers previously specified for this stack, if
	//    any, don't specify this parameter.
	//
	//    * To specify new or updated rollback triggers, you must specify all the
	//    triggers that you want used for this stack, even triggers you've specifed
	//    before (for example, when creating the stack or during a previous stack
	//    update). Any triggers that you don't include in the updated list of triggers
	//    are no longer applied to the stack.
	//
	//    * To remove all currently specified triggers, specify an empty list for
	//    this parameter.
	//
	// If a specified trigger is missing, the entire stack operation fails and is
	// rolled back.
	RollbackTriggers []RollbackTrigger `type:"list"`
}

// String returns the string representation
func (s RollbackConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RollbackConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RollbackConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RollbackConfiguration"}
	if s.RollbackTriggers != nil {
		for i, v := range s.RollbackTriggers {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RollbackTriggers", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A rollback trigger AWS CloudFormation monitors during creation and updating
// of stacks. If any of the alarms you specify goes to ALARM state during the
// stack operation or within the specified monitoring period afterwards, CloudFormation
// rolls back the entire stack operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackTrigger
type RollbackTrigger struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the rollback trigger.
	//
	// If a specified trigger is missing, the entire stack operation fails and is
	// rolled back.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The resource type of the rollback trigger. Currently, AWS::CloudWatch::Alarm
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html)
	// is the only supported resource type.
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RollbackTrigger) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RollbackTrigger) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RollbackTrigger) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RollbackTrigger"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}

	if s.Type == nil {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The input for the SetStackPolicy action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetStackPolicyInput
type SetStackPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name or unique stack ID that you want to associate a policy with.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`

	// Structure containing the stack policy body. For more information, go to
	// Prevent Updates to Stack Resources (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html)
	// in the AWS CloudFormation User Guide. You can specify either the StackPolicyBody
	// or the StackPolicyURL parameter, but not both.
	StackPolicyBody *string `min:"1" type:"string"`

	// Location of a file containing the stack policy. The URL must point to a policy
	// (maximum size: 16 KB) located in an S3 bucket in the same region as the stack.
	// You can specify either the StackPolicyBody or the StackPolicyURL parameter,
	// but not both.
	StackPolicyURL *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SetStackPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetStackPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetStackPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SetStackPolicyInput"}

	if s.StackName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackName"))
	}
	if s.StackPolicyBody != nil && len(*s.StackPolicyBody) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StackPolicyBody", 1))
	}
	if s.StackPolicyURL != nil && len(*s.StackPolicyURL) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StackPolicyURL", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetStackPolicyOutput
type SetStackPolicyOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s SetStackPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetStackPolicyOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s SetStackPolicyOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// The input for the SignalResource action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SignalResourceInput
type SignalResourceInput struct {
	_ struct{} `type:"structure"`

	// The logical ID of the resource that you want to signal. The logical ID is
	// the name of the resource that given in the template.
	//
	// LogicalResourceId is a required field
	LogicalResourceId *string `type:"string" required:"true"`

	// The stack name or unique stack ID that includes the resource that you want
	// to signal.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`

	// The status of the signal, which is either success or failure. A failure signal
	// causes AWS CloudFormation to immediately fail the stack creation or update.
	//
	// Status is a required field
	Status ResourceSignalStatus `type:"string" required:"true" enum:"true"`

	// A unique ID of the signal. When you signal Amazon EC2 instances or Auto Scaling
	// groups, specify the instance ID that you are signaling as the unique ID.
	// If you send multiple signals to a single resource (such as signaling a wait
	// condition), each signal requires a different unique ID.
	//
	// UniqueId is a required field
	UniqueId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SignalResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SignalResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SignalResourceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SignalResourceInput"}

	if s.LogicalResourceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogicalResourceId"))
	}

	if s.StackName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StackName", 1))
	}
	if len(s.Status) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}

	if s.UniqueId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UniqueId"))
	}
	if s.UniqueId != nil && len(*s.UniqueId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UniqueId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SignalResourceOutput
type SignalResourceOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s SignalResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SignalResourceOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s SignalResourceOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// The Stack data type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/Stack
type Stack struct {
	_ struct{} `type:"structure"`

	// The capabilities allowed in the stack.
	Capabilities []Capability `type:"list"`

	// The unique ID of the change set.
	ChangeSetId *string `min:"1" type:"string"`

	// The time at which the stack was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The time the stack was deleted.
	DeletionTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A user-defined description associated with the stack.
	Description *string `min:"1" type:"string"`

	// Boolean to enable or disable rollback on stack creation failures:
	//
	//    * true: disable rollback
	//
	//    * false: enable rollback
	DisableRollback *bool `type:"boolean"`

	// Whether termination protection is enabled for the stack.
	//
	// For nested stacks (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html),
	// termination protection is set on the root stack and cannot be changed directly
	// on the nested stack. For more information, see Protecting a Stack From Being
	// Deleted (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html)
	// in the AWS CloudFormation User Guide.
	EnableTerminationProtection *bool `type:"boolean"`

	// The time the stack was last updated. This field will only be returned if
	// the stack has been updated at least once.
	LastUpdatedTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// SNS topic ARNs to which stack related events are published.
	NotificationARNs []string `type:"list"`

	// A list of output structures.
	Outputs []Output `type:"list"`

	// A list of Parameter structures.
	Parameters []Parameter `type:"list"`

	// For nested stacks--stacks created as resources for another stack--the stack
	// ID of the direct parent of this stack. For the first level of nested stacks,
	// the root stack is also the parent stack.
	//
	// For more information, see Working with Nested Stacks (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html)
	// in the AWS CloudFormation User Guide.
	ParentId *string `type:"string"`

	// The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM)
	// role that is associated with the stack. During a stack operation, AWS CloudFormation
	// uses this role's credentials to make calls on your behalf.
	RoleARN *string `min:"20" type:"string"`

	// The rollback triggers for AWS CloudFormation to monitor during stack creation
	// and updating operations, and for the specified monitoring period afterwards.
	RollbackConfiguration *RollbackConfiguration `type:"structure"`

	// For nested stacks--stacks created as resources for another stack--the stack
	// ID of the the top-level stack to which the nested stack ultimately belongs.
	//
	// For more information, see Working with Nested Stacks (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html)
	// in the AWS CloudFormation User Guide.
	RootId *string `type:"string"`

	// Unique identifier of the stack.
	StackId *string `type:"string"`

	// The name associated with the stack.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`

	// Current status of the stack.
	//
	// StackStatus is a required field
	StackStatus StackStatus `type:"string" required:"true" enum:"true"`

	// Success/failure message associated with the stack status.
	StackStatusReason *string `type:"string"`

	// A list of Tags that specify information about the stack.
	Tags []Tag `type:"list"`

	// The amount of time within which stack creation should complete.
	TimeoutInMinutes *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s Stack) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Stack) GoString() string {
	return s.String()
}

// The StackEvent data type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackEvent
type StackEvent struct {
	_ struct{} `type:"structure"`

	// The token passed to the operation that generated this event.
	//
	// All events triggered by a given stack operation are assigned the same client
	// request token, which you can use to track operations. For example, if you
	// execute a CreateStack operation with the token token1, then all the StackEvents
	// generated by that operation will have ClientRequestToken set as token1.
	//
	// In the console, stack operations display the client request token on the
	// Events tab. Stack operations that are initiated from the console use the
	// token format Console-StackOperation-ID, which helps you easily identify the
	// stack operation . For example, if you create a stack using the console, each
	// stack event would be assigned the same token in the following format: Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002.
	ClientRequestToken *string `min:"1" type:"string"`

	// The unique ID of this event.
	//
	// EventId is a required field
	EventId *string `type:"string" required:"true"`

	// The logical name of the resource specified in the template.
	LogicalResourceId *string `type:"string"`

	// The name or unique identifier associated with the physical instance of the
	// resource.
	PhysicalResourceId *string `type:"string"`

	// BLOB of the properties used to create the resource.
	ResourceProperties *string `type:"string"`

	// Current status of the resource.
	ResourceStatus ResourceStatus `type:"string" enum:"true"`

	// Success/failure message associated with the resource.
	ResourceStatusReason *string `type:"string"`

	// Type of resource. (For more information, go to  AWS Resource Types Reference
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the AWS CloudFormation User Guide.)
	ResourceType *string `min:"1" type:"string"`

	// The unique ID name of the instance of the stack.
	//
	// StackId is a required field
	StackId *string `type:"string" required:"true"`

	// The name associated with a stack.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`

	// Time the status was updated.
	//
	// Timestamp is a required field
	Timestamp *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s StackEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackEvent) GoString() string {
	return s.String()
}

// An AWS CloudFormation stack, in a specific account and region, that's part
// of a stack set operation. A stack instance is a reference to an attempted
// or actual stack in a given account within a given region. A stack instance
// can exist without a stack—for example, if the stack couldn't be created for
// some reason. A stack instance is associated with only one stack set. Each
// stack instance contains the ID of its associated stack set, as well as the
// ID of the actual stack and the stack status.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackInstance
type StackInstance struct {
	_ struct{} `type:"structure"`

	// The name of the AWS account that the stack instance is associated with.
	Account *string `type:"string"`

	// A list of parameters from the stack set template whose values have been overridden
	// in this stack instance.
	ParameterOverrides []Parameter `type:"list"`

	// The name of the AWS region that the stack instance is associated with.
	Region *string `type:"string"`

	// The ID of the stack instance.
	StackId *string `type:"string"`

	// The name or unique ID of the stack set that the stack instance is associated
	// with.
	StackSetId *string `type:"string"`

	// The status of the stack instance, in terms of its synchronization with its
	// associated stack set.
	//
	//    * INOPERABLE: A DeleteStackInstances operation has failed and left the
	//    stack in an unstable state. Stacks in this state are excluded from further
	//    UpdateStackSet operations. You might need to perform a DeleteStackInstances
	//    operation, with RetainStacks set to true, to delete the stack instance,
	//    and then delete the stack manually.
	//
	//    * OUTDATED: The stack isn't currently up to date with the stack set because:
	//
	// The associated stack failed during a CreateStackSet or UpdateStackSet operation.
	//
	//
	// The stack was part of a CreateStackSet or UpdateStackSet operation that failed
	//    or was stopped before the stack was created or updated.
	//
	//    * CURRENT: The stack is currently up to date with the stack set.
	Status StackInstanceStatus `type:"string" enum:"true"`

	// The explanation for the specific status code that is assigned to this stack
	// instance.
	StatusReason *string `type:"string"`
}

// String returns the string representation
func (s StackInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackInstance) GoString() string {
	return s.String()
}

// The structure that contains summary information about a stack instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackInstanceSummary
type StackInstanceSummary struct {
	_ struct{} `type:"structure"`

	// The name of the AWS account that the stack instance is associated with.
	Account *string `type:"string"`

	// The name of the AWS region that the stack instance is associated with.
	Region *string `type:"string"`

	// The ID of the stack instance.
	StackId *string `type:"string"`

	// The name or unique ID of the stack set that the stack instance is associated
	// with.
	StackSetId *string `type:"string"`

	// The status of the stack instance, in terms of its synchronization with its
	// associated stack set.
	//
	//    * INOPERABLE: A DeleteStackInstances operation has failed and left the
	//    stack in an unstable state. Stacks in this state are excluded from further
	//    UpdateStackSet operations. You might need to perform a DeleteStackInstances
	//    operation, with RetainStacks set to true, to delete the stack instance,
	//    and then delete the stack manually.
	//
	//    * OUTDATED: The stack isn't currently up to date with the stack set because:
	//
	// The associated stack failed during a CreateStackSet or UpdateStackSet operation.
	//
	//
	// The stack was part of a CreateStackSet or UpdateStackSet operation that failed
	//    or was stopped before the stack was created or updated.
	//
	//    * CURRENT: The stack is currently up to date with the stack set.
	Status StackInstanceStatus `type:"string" enum:"true"`

	// The explanation for the specific status code assigned to this stack instance.
	StatusReason *string `type:"string"`
}

// String returns the string representation
func (s StackInstanceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackInstanceSummary) GoString() string {
	return s.String()
}

// The StackResource data type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackResource
type StackResource struct {
	_ struct{} `type:"structure"`

	// User defined description associated with the resource.
	Description *string `min:"1" type:"string"`

	// The logical name of the resource specified in the template.
	//
	// LogicalResourceId is a required field
	LogicalResourceId *string `type:"string" required:"true"`

	// The name or unique identifier that corresponds to a physical instance ID
	// of a resource supported by AWS CloudFormation.
	PhysicalResourceId *string `type:"string"`

	// Current status of the resource.
	//
	// ResourceStatus is a required field
	ResourceStatus ResourceStatus `type:"string" required:"true" enum:"true"`

	// Success/failure message associated with the resource.
	ResourceStatusReason *string `type:"string"`

	// Type of resource. (For more information, go to  AWS Resource Types Reference
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the AWS CloudFormation User Guide.)
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`

	// Unique identifier of the stack.
	StackId *string `type:"string"`

	// The name associated with the stack.
	StackName *string `type:"string"`

	// Time the status was updated.
	//
	// Timestamp is a required field
	Timestamp *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s StackResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackResource) GoString() string {
	return s.String()
}

// Contains detailed information about the specified stack resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackResourceDetail
type StackResourceDetail struct {
	_ struct{} `type:"structure"`

	// User defined description associated with the resource.
	Description *string `min:"1" type:"string"`

	// Time the status was updated.
	//
	// LastUpdatedTimestamp is a required field
	LastUpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The logical name of the resource specified in the template.
	//
	// LogicalResourceId is a required field
	LogicalResourceId *string `type:"string" required:"true"`

	// The content of the Metadata attribute declared for the resource. For more
	// information, see Metadata Attribute (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-metadata.html)
	// in the AWS CloudFormation User Guide.
	Metadata *string `type:"string"`

	// The name or unique identifier that corresponds to a physical instance ID
	// of a resource supported by AWS CloudFormation.
	PhysicalResourceId *string `type:"string"`

	// Current status of the resource.
	//
	// ResourceStatus is a required field
	ResourceStatus ResourceStatus `type:"string" required:"true" enum:"true"`

	// Success/failure message associated with the resource.
	ResourceStatusReason *string `type:"string"`

	// Type of resource. ((For more information, go to  AWS Resource Types Reference
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the AWS CloudFormation User Guide.)
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`

	// Unique identifier of the stack.
	StackId *string `type:"string"`

	// The name associated with the stack.
	StackName *string `type:"string"`
}

// String returns the string representation
func (s StackResourceDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackResourceDetail) GoString() string {
	return s.String()
}

// Contains high-level information about the specified stack resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackResourceSummary
type StackResourceSummary struct {
	_ struct{} `type:"structure"`

	// Time the status was updated.
	//
	// LastUpdatedTimestamp is a required field
	LastUpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The logical name of the resource specified in the template.
	//
	// LogicalResourceId is a required field
	LogicalResourceId *string `type:"string" required:"true"`

	// The name or unique identifier that corresponds to a physical instance ID
	// of the resource.
	PhysicalResourceId *string `type:"string"`

	// Current status of the resource.
	//
	// ResourceStatus is a required field
	ResourceStatus ResourceStatus `type:"string" required:"true" enum:"true"`

	// Success/failure message associated with the resource.
	ResourceStatusReason *string `type:"string"`

	// Type of resource. (For more information, go to  AWS Resource Types Reference
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the AWS CloudFormation User Guide.)
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StackResourceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackResourceSummary) GoString() string {
	return s.String()
}

// A structure that contains information about a stack set. A stack set enables
// you to provision stacks into AWS accounts and across regions by using a single
// CloudFormation template. In the stack set, you specify the template to use,
// as well as any parameters and capabilities that the template requires.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackSet
type StackSet struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the IAM role used to create or update
	// the stack set.
	//
	// Use customized administrator roles to control which users or groups can manage
	// specific stack sets within the same administrator account. For more information,
	// see Prerequisites: Granting Permissions for Stack Set Operations (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html)
	// in the AWS CloudFormation User Guide.
	AdministrationRoleARN *string `min:"20" type:"string"`

	// The capabilities that are allowed in the stack set. Some stack set templates
	// might include resources that can affect permissions in your AWS account—for
	// example, by creating new AWS Identity and Access Management (IAM) users.
	// For more information, see Acknowledging IAM Resources in AWS CloudFormation
	// Templates. (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities)
	Capabilities []Capability `type:"list"`

	// A description of the stack set that you specify when the stack set is created
	// or updated.
	Description *string `min:"1" type:"string"`

	// The name of the IAM execution role used to create or update the stack set.
	//
	// Use customized execution roles to control which stack resources users and
	// groups can include in their stack sets.
	ExecutionRoleName *string `min:"1" type:"string"`

	// A list of input parameters for a stack set.
	Parameters []Parameter `type:"list"`

	// The Amazon Resource Number (ARN) of the stack set.
	StackSetARN *string `type:"string"`

	// The ID of the stack set.
	StackSetId *string `type:"string"`

	// The name that's associated with the stack set.
	StackSetName *string `type:"string"`

	// The status of the stack set.
	Status StackSetStatus `type:"string" enum:"true"`

	// A list of tags that specify information about the stack set. A maximum number
	// of 50 tags can be specified.
	Tags []Tag `type:"list"`

	// The structure that contains the body of the template that was used to create
	// or update the stack set.
	TemplateBody *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StackSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackSet) GoString() string {
	return s.String()
}

// The structure that contains information about a stack set operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackSetOperation
type StackSetOperation struct {
	_ struct{} `type:"structure"`

	// The type of stack set operation: CREATE, UPDATE, or DELETE. Create and delete
	// operations affect only the specified stack set instances that are associated
	// with the specified stack set. Update operations affect both the stack set
	// itself, as well as all associated stack set instances.
	Action StackSetOperationAction `type:"string" enum:"true"`

	// The Amazon Resource Number (ARN) of the IAM role used to perform this stack
	// set operation.
	//
	// Use customized administrator roles to control which users or groups can manage
	// specific stack sets within the same administrator account. For more information,
	// see Define Permissions for Multiple Administrators (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html)
	// in the AWS CloudFormation User Guide.
	AdministrationRoleARN *string `min:"20" type:"string"`

	// The time at which the operation was initiated. Note that the creation times
	// for the stack set operation might differ from the creation time of the individual
	// stacks themselves. This is because AWS CloudFormation needs to perform preparatory
	// work for the operation, such as dispatching the work to the requested regions,
	// before actually creating the first stacks.
	CreationTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The time at which the stack set operation ended, across all accounts and
	// regions specified. Note that this doesn't necessarily mean that the stack
	// set operation was successful, or even attempted, in each account or region.
	EndTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The name of the IAM execution role used to create or update the stack set.
	//
	// Use customized execution roles to control which stack resources users and
	// groups can include in their stack sets.
	ExecutionRoleName *string `min:"1" type:"string"`

	// The unique ID of a stack set operation.
	OperationId *string `min:"1" type:"string"`

	// The preferences for how AWS CloudFormation performs this stack set operation.
	OperationPreferences *StackSetOperationPreferences `type:"structure"`

	// For stack set operations of action type DELETE, specifies whether to remove
	// the stack instances from the specified stack set, but doesn't delete the
	// stacks. You can't reassociate a retained stack, or add an existing, saved
	// stack to a new stack set.
	RetainStacks *bool `type:"boolean"`

	// The ID of the stack set.
	StackSetId *string `type:"string"`

	// The status of the operation.
	//
	//    * FAILED: The operation exceeded the specified failure tolerance. The
	//    failure tolerance value that you've set for an operation is applied for
	//    each region during stack create and update operations. If the number of
	//    failed stacks within a region exceeds the failure tolerance, the status
	//    of the operation in the region is set to FAILED. This in turn sets the
	//    status of the operation as a whole to FAILED, and AWS CloudFormation cancels
	//    the operation in any remaining regions.
	//
	//    * RUNNING: The operation is currently being performed.
	//
	//    * STOPPED: The user has cancelled the operation.
	//
	//    * STOPPING: The operation is in the process of stopping, at user request.
	//
	//
	//    * SUCCEEDED: The operation completed creating or updating all the specified
	//    stacks without exceeding the failure tolerance for the operation.
	Status StackSetOperationStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s StackSetOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackSetOperation) GoString() string {
	return s.String()
}

// The user-specified preferences for how AWS CloudFormation performs a stack
// set operation.
//
// For more information on maximum concurrent accounts and failure tolerance,
// see Stack set operation options (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackSetOperationPreferences
type StackSetOperationPreferences struct {
	_ struct{} `type:"structure"`

	// The number of accounts, per region, for which this operation can fail before
	// AWS CloudFormation stops the operation in that region. If the operation is
	// stopped in a region, AWS CloudFormation doesn't attempt the operation in
	// any subsequent regions.
	//
	// Conditional: You must specify either FailureToleranceCount or FailureTolerancePercentage
	// (but not both).
	FailureToleranceCount *int64 `type:"integer"`

	// The percentage of accounts, per region, for which this stack operation can
	// fail before AWS CloudFormation stops the operation in that region. If the
	// operation is stopped in a region, AWS CloudFormation doesn't attempt the
	// operation in any subsequent regions.
	//
	// When calculating the number of accounts based on the specified percentage,
	// AWS CloudFormation rounds down to the next whole number.
	//
	// Conditional: You must specify either FailureToleranceCount or FailureTolerancePercentage,
	// but not both.
	FailureTolerancePercentage *int64 `type:"integer"`

	// The maximum number of accounts in which to perform this operation at one
	// time. This is dependent on the value of FailureToleranceCount—MaxConcurrentCount
	// is at most one more than the FailureToleranceCount .
	//
	// Note that this setting lets you specify the maximum for operations. For large
	// deployments, under certain circumstances the actual number of accounts acted
	// upon concurrently may be lower due to service throttling.
	//
	// Conditional: You must specify either MaxConcurrentCount or MaxConcurrentPercentage,
	// but not both.
	MaxConcurrentCount *int64 `min:"1" type:"integer"`

	// The maximum percentage of accounts in which to perform this operation at
	// one time.
	//
	// When calculating the number of accounts based on the specified percentage,
	// AWS CloudFormation rounds down to the next whole number. This is true except
	// in cases where rounding down would result is zero. In this case, CloudFormation
	// sets the number as one instead.
	//
	// Note that this setting lets you specify the maximum for operations. For large
	// deployments, under certain circumstances the actual number of accounts acted
	// upon concurrently may be lower due to service throttling.
	//
	// Conditional: You must specify either MaxConcurrentCount or MaxConcurrentPercentage,
	// but not both.
	MaxConcurrentPercentage *int64 `min:"1" type:"integer"`

	// The order of the regions in where you want to perform the stack operation.
	RegionOrder []string `type:"list"`
}

// String returns the string representation
func (s StackSetOperationPreferences) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackSetOperationPreferences) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StackSetOperationPreferences) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StackSetOperationPreferences"}
	if s.MaxConcurrentCount != nil && *s.MaxConcurrentCount < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxConcurrentCount", 1))
	}
	if s.MaxConcurrentPercentage != nil && *s.MaxConcurrentPercentage < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxConcurrentPercentage", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The structure that contains information about a specified operation's results
// for a given account in a given region.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackSetOperationResultSummary
type StackSetOperationResultSummary struct {
	_ struct{} `type:"structure"`

	// The name of the AWS account for this operation result.
	Account *string `type:"string"`

	// The results of the account gate function AWS CloudFormation invokes, if present,
	// before proceeding with stack set operations in an account
	AccountGateResult *AccountGateResult `type:"structure"`

	// The name of the AWS region for this operation result.
	Region *string `type:"string"`

	// The result status of the stack set operation for the given account in the
	// given region.
	//
	//    * CANCELLED: The operation in the specified account and region has been
	//    cancelled. This is either because a user has stopped the stack set operation,
	//    or because the failure tolerance of the stack set operation has been exceeded.
	//
	//    * FAILED: The operation in the specified account and region failed.
	//
	// If the stack set operation fails in enough accounts within a region, the
	//    failure tolerance for the stack set operation as a whole might be exceeded.
	//
	//
	//    * RUNNING: The operation in the specified account and region is currently
	//    in progress.
	//
	//    * PENDING: The operation in the specified account and region has yet to
	//    start.
	//
	//    * SUCCEEDED: The operation in the specified account and region completed
	//    successfully.
	Status StackSetOperationResultStatus `type:"string" enum:"true"`

	// The reason for the assigned result status.
	StatusReason *string `type:"string"`
}

// String returns the string representation
func (s StackSetOperationResultSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackSetOperationResultSummary) GoString() string {
	return s.String()
}

// The structures that contain summary information about the specified operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackSetOperationSummary
type StackSetOperationSummary struct {
	_ struct{} `type:"structure"`

	// The type of operation: CREATE, UPDATE, or DELETE. Create and delete operations
	// affect only the specified stack instances that are associated with the specified
	// stack set. Update operations affect both the stack set itself as well as
	// all associated stack set instances.
	Action StackSetOperationAction `type:"string" enum:"true"`

	// The time at which the operation was initiated. Note that the creation times
	// for the stack set operation might differ from the creation time of the individual
	// stacks themselves. This is because AWS CloudFormation needs to perform preparatory
	// work for the operation, such as dispatching the work to the requested regions,
	// before actually creating the first stacks.
	CreationTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The time at which the stack set operation ended, across all accounts and
	// regions specified. Note that this doesn't necessarily mean that the stack
	// set operation was successful, or even attempted, in each account or region.
	EndTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The unique ID of the stack set operation.
	OperationId *string `min:"1" type:"string"`

	// The overall status of the operation.
	//
	//    * FAILED: The operation exceeded the specified failure tolerance. The
	//    failure tolerance value that you've set for an operation is applied for
	//    each region during stack create and update operations. If the number of
	//    failed stacks within a region exceeds the failure tolerance, the status
	//    of the operation in the region is set to FAILED. This in turn sets the
	//    status of the operation as a whole to FAILED, and AWS CloudFormation cancels
	//    the operation in any remaining regions.
	//
	//    * RUNNING: The operation is currently being performed.
	//
	//    * STOPPED: The user has cancelled the operation.
	//
	//    * STOPPING: The operation is in the process of stopping, at user request.
	//
	//
	//    * SUCCEEDED: The operation completed creating or updating all the specified
	//    stacks without exceeding the failure tolerance for the operation.
	Status StackSetOperationStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s StackSetOperationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackSetOperationSummary) GoString() string {
	return s.String()
}

// The structures that contain summary information about the specified stack
// set.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackSetSummary
type StackSetSummary struct {
	_ struct{} `type:"structure"`

	// A description of the stack set that you specify when the stack set is created
	// or updated.
	Description *string `min:"1" type:"string"`

	// The ID of the stack set.
	StackSetId *string `type:"string"`

	// The name of the stack set.
	StackSetName *string `type:"string"`

	// The status of the stack set.
	Status StackSetStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s StackSetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackSetSummary) GoString() string {
	return s.String()
}

// The StackSummary Data Type
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackSummary
type StackSummary struct {
	_ struct{} `type:"structure"`

	// The time the stack was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The time the stack was deleted.
	DeletionTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The time the stack was last updated. This field will only be returned if
	// the stack has been updated at least once.
	LastUpdatedTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// For nested stacks--stacks created as resources for another stack--the stack
	// ID of the direct parent of this stack. For the first level of nested stacks,
	// the root stack is also the parent stack.
	//
	// For more information, see Working with Nested Stacks (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html)
	// in the AWS CloudFormation User Guide.
	ParentId *string `type:"string"`

	// For nested stacks--stacks created as resources for another stack--the stack
	// ID of the the top-level stack to which the nested stack ultimately belongs.
	//
	// For more information, see Working with Nested Stacks (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html)
	// in the AWS CloudFormation User Guide.
	RootId *string `type:"string"`

	// Unique stack identifier.
	StackId *string `type:"string"`

	// The name associated with the stack.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`

	// The current status of the stack.
	//
	// StackStatus is a required field
	StackStatus StackStatus `type:"string" required:"true" enum:"true"`

	// Success/Failure message associated with the stack status.
	StackStatusReason *string `type:"string"`

	// The template description of the template used to create the stack.
	TemplateDescription *string `type:"string"`
}

// String returns the string representation
func (s StackSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackSummary) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StopStackSetOperationInput
type StopStackSetOperationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the stack operation.
	//
	// OperationId is a required field
	OperationId *string `min:"1" type:"string" required:"true"`

	// The name or unique ID of the stack set that you want to stop the operation
	// for.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StopStackSetOperationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopStackSetOperationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopStackSetOperationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopStackSetOperationInput"}

	if s.OperationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("OperationId"))
	}
	if s.OperationId != nil && len(*s.OperationId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OperationId", 1))
	}

	if s.StackSetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StopStackSetOperationOutput
type StopStackSetOperationOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s StopStackSetOperationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopStackSetOperationOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s StopStackSetOperationOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// The Tag type enables you to specify a key-value pair that can be used to
// store information about an AWS CloudFormation stack.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// Required. A string used to identify this tag. You can specify a maximum of
	// 128 characters for a tag key. Tags owned by Amazon Web Services (AWS) have
	// the reserved prefix: aws:.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Required. A string containing the value for this tag. You can specify a maximum
	// of 256 characters for a tag value.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The TemplateParameter data type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/TemplateParameter
type TemplateParameter struct {
	_ struct{} `type:"structure"`

	// The default value associated with the parameter.
	DefaultValue *string `type:"string"`

	// User defined description associated with the parameter.
	Description *string `min:"1" type:"string"`

	// Flag indicating whether the parameter should be displayed as plain text in
	// logs and UIs.
	NoEcho *bool `type:"boolean"`

	// The name associated with the parameter.
	ParameterKey *string `type:"string"`
}

// String returns the string representation
func (s TemplateParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TemplateParameter) GoString() string {
	return s.String()
}

// The input for an UpdateStack action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackInput
type UpdateStackInput struct {
	_ struct{} `type:"structure"`

	// A list of values that you must specify before AWS CloudFormation can update
	// certain stacks. Some stack templates might include resources that can affect
	// permissions in your AWS account, for example, by creating new AWS Identity
	// and Access Management (IAM) users. For those stacks, you must explicitly
	// acknowledge their capabilities by specifying this parameter.
	//
	// The only valid values are CAPABILITY_IAM and CAPABILITY_NAMED_IAM. The following
	// resources require you to specify this parameter:  AWS::IAM::AccessKey (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html),
	//  AWS::IAM::Group (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html),
	//  AWS::IAM::InstanceProfile (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html),
	//  AWS::IAM::Policy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html),
	//  AWS::IAM::Role (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html),
	//  AWS::IAM::User (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html),
	// and  AWS::IAM::UserToGroupAddition (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html).
	// If your stack template contains these resources, we recommend that you review
	// all permissions associated with them and edit their permissions if necessary.
	//
	// If you have IAM resources, you can specify either capability. If you have
	// IAM resources with custom names, you must specify CAPABILITY_NAMED_IAM. If
	// you don't specify this parameter, this action returns an InsufficientCapabilities
	// error.
	//
	// For more information, see Acknowledging IAM Resources in AWS CloudFormation
	// Templates (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities).
	Capabilities []Capability `type:"list"`

	// A unique identifier for this UpdateStack request. Specify this token if you
	// plan to retry requests so that AWS CloudFormation knows that you're not attempting
	// to update a stack with the same name. You might retry UpdateStack requests
	// to ensure that AWS CloudFormation successfully received them.
	//
	// All events triggered by a given stack operation are assigned the same client
	// request token, which you can use to track operations. For example, if you
	// execute a CreateStack operation with the token token1, then all the StackEvents
	// generated by that operation will have ClientRequestToken set as token1.
	//
	// In the console, stack operations display the client request token on the
	// Events tab. Stack operations that are initiated from the console use the
	// token format Console-StackOperation-ID, which helps you easily identify the
	// stack operation . For example, if you create a stack using the console, each
	// stack event would be assigned the same token in the following format: Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002.
	ClientRequestToken *string `min:"1" type:"string"`

	// Amazon Simple Notification Service topic Amazon Resource Names (ARNs) that
	// AWS CloudFormation associates with the stack. Specify an empty list to remove
	// all notification topics.
	NotificationARNs []string `type:"list"`

	// A list of Parameter structures that specify input parameters for the stack.
	// For more information, see the Parameter (http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html)
	// data type.
	Parameters []Parameter `type:"list"`

	// The template resource types that you have permissions to work with for this
	// update stack action, such as AWS::EC2::Instance, AWS::EC2::*, or Custom::MyCustomInstance.
	//
	// If the list of resource types doesn't include a resource that you're updating,
	// the stack update fails. By default, AWS CloudFormation grants permissions
	// to all resource types. AWS Identity and Access Management (IAM) uses this
	// parameter for AWS CloudFormation-specific condition keys in IAM policies.
	// For more information, see Controlling Access with AWS Identity and Access
	// Management (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html).
	ResourceTypes []string `type:"list"`

	// The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM)
	// role that AWS CloudFormation assumes to update the stack. AWS CloudFormation
	// uses the role's credentials to make calls on your behalf. AWS CloudFormation
	// always uses this role for all future operations on the stack. As long as
	// users have permission to operate on the stack, AWS CloudFormation uses this
	// role even if the users don't have permission to pass it. Ensure that the
	// role grants least privilege.
	//
	// If you don't specify a value, AWS CloudFormation uses the role that was previously
	// associated with the stack. If no role is available, AWS CloudFormation uses
	// a temporary session that is generated from your user credentials.
	RoleARN *string `min:"20" type:"string"`

	// The rollback triggers for AWS CloudFormation to monitor during stack creation
	// and updating operations, and for the specified monitoring period afterwards.
	RollbackConfiguration *RollbackConfiguration `type:"structure"`

	// The name or unique stack ID of the stack to update.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`

	// Structure containing a new stack policy body. You can specify either the
	// StackPolicyBody or the StackPolicyURL parameter, but not both.
	//
	// You might update the stack policy, for example, in order to protect a new
	// resource that you created during a stack update. If you do not specify a
	// stack policy, the current policy that is associated with the stack is unchanged.
	StackPolicyBody *string `min:"1" type:"string"`

	// Structure containing the temporary overriding stack policy body. You can
	// specify either the StackPolicyDuringUpdateBody or the StackPolicyDuringUpdateURL
	// parameter, but not both.
	//
	// If you want to update protected resources, specify a temporary overriding
	// stack policy during this update. If you do not specify a stack policy, the
	// current policy that is associated with the stack will be used.
	StackPolicyDuringUpdateBody *string `min:"1" type:"string"`

	// Location of a file containing the temporary overriding stack policy. The
	// URL must point to a policy (max size: 16KB) located in an S3 bucket in the
	// same region as the stack. You can specify either the StackPolicyDuringUpdateBody
	// or the StackPolicyDuringUpdateURL parameter, but not both.
	//
	// If you want to update protected resources, specify a temporary overriding
	// stack policy during this update. If you do not specify a stack policy, the
	// current policy that is associated with the stack will be used.
	StackPolicyDuringUpdateURL *string `min:"1" type:"string"`

	// Location of a file containing the updated stack policy. The URL must point
	// to a policy (max size: 16KB) located in an S3 bucket in the same region as
	// the stack. You can specify either the StackPolicyBody or the StackPolicyURL
	// parameter, but not both.
	//
	// You might update the stack policy, for example, in order to protect a new
	// resource that you created during a stack update. If you do not specify a
	// stack policy, the current policy that is associated with the stack is unchanged.
	StackPolicyURL *string `min:"1" type:"string"`

	// Key-value pairs to associate with this stack. AWS CloudFormation also propagates
	// these tags to supported resources in the stack. You can specify a maximum
	// number of 50 tags.
	//
	// If you don't specify this parameter, AWS CloudFormation doesn't modify the
	// stack's tags. If you specify an empty value, AWS CloudFormation removes all
	// associated tags.
	Tags []Tag `type:"list"`

	// Structure containing the template body with a minimum length of 1 byte and
	// a maximum length of 51,200 bytes. (For more information, go to Template Anatomy
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.)
	//
	// Conditional: You must specify only one of the following parameters: TemplateBody,
	// TemplateURL, or set the UsePreviousTemplate to true.
	TemplateBody *string `min:"1" type:"string"`

	// Location of file containing the template body. The URL must point to a template
	// that is located in an Amazon S3 bucket. For more information, go to Template
	// Anatomy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must specify only one of the following parameters: TemplateBody,
	// TemplateURL, or set the UsePreviousTemplate to true.
	TemplateURL *string `min:"1" type:"string"`

	// Reuse the existing template that is associated with the stack that you are
	// updating.
	//
	// Conditional: You must specify only one of the following parameters: TemplateBody,
	// TemplateURL, or set the UsePreviousTemplate to true.
	UsePreviousTemplate *bool `type:"boolean"`
}

// String returns the string representation
func (s UpdateStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStackInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateStackInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleARN", 20))
	}

	if s.StackName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackName"))
	}
	if s.StackPolicyBody != nil && len(*s.StackPolicyBody) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StackPolicyBody", 1))
	}
	if s.StackPolicyDuringUpdateBody != nil && len(*s.StackPolicyDuringUpdateBody) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StackPolicyDuringUpdateBody", 1))
	}
	if s.StackPolicyDuringUpdateURL != nil && len(*s.StackPolicyDuringUpdateURL) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StackPolicyDuringUpdateURL", 1))
	}
	if s.StackPolicyURL != nil && len(*s.StackPolicyURL) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StackPolicyURL", 1))
	}
	if s.TemplateBody != nil && len(*s.TemplateBody) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TemplateBody", 1))
	}
	if s.TemplateURL != nil && len(*s.TemplateURL) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TemplateURL", 1))
	}
	if s.RollbackConfiguration != nil {
		if err := s.RollbackConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RollbackConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackInstancesInput
type UpdateStackInstancesInput struct {
	_ struct{} `type:"structure"`

	// The names of one or more AWS accounts for which you want to update parameter
	// values for stack instances. The overridden parameter values will be applied
	// to all stack instances in the specified accounts and regions.
	//
	// Accounts is a required field
	Accounts []string `type:"list" required:"true"`

	// The unique identifier for this stack set operation.
	//
	// The operation ID also functions as an idempotency token, to ensure that AWS
	// CloudFormation performs the stack set operation only once, even if you retry
	// the request multiple times. You might retry stack set operation requests
	// to ensure that AWS CloudFormation successfully received them.
	//
	// If you don't specify an operation ID, the SDK generates one automatically.
	OperationId *string `min:"1" type:"string" idempotencyToken:"true"`

	// Preferences for how AWS CloudFormation performs this stack set operation.
	OperationPreferences *StackSetOperationPreferences `type:"structure"`

	// A list of input parameters whose values you want to update for the specified
	// stack instances.
	//
	// Any overridden parameter values will be applied to all stack instances in
	// the specified accounts and regions. When specifying parameters and their
	// values, be aware of how AWS CloudFormation sets parameter values during stack
	// instance update operations:
	//
	//    * To override the current value for a parameter, include the parameter
	//    and specify its value.
	//
	//    * To leave a parameter set to its present value, you can do one of the
	//    following:
	//
	// Do not include the parameter in the list.
	//
	// Include the parameter and specify UsePreviousValue as true. (You cannot specify
	//    both a value and set UsePreviousValue to true.)
	//
	//    * To set all overridden parameter back to the values specified in the
	//    stack set, specify a parameter list but do not include any parameters.
	//
	//    * To leave all parameters set to their present values, do not specify
	//    this property at all.
	//
	// During stack set updates, any parameter values overridden for a stack instance
	// are not updated, but retain their overridden value.
	//
	// You can only override the parameter values that are specified in the stack
	// set; to add or delete a parameter itself, use UpdateStackSet to update the
	// stack set template. If you add a parameter to a template, before you can
	// override the parameter value specified in the stack set you must first use
	// UpdateStackSet (http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html)
	// to update all stack instances with the updated template and parameter value
	// specified in the stack set. Once a stack instance has been updated with the
	// new parameter, you can then override the parameter value using UpdateStackInstances.
	ParameterOverrides []Parameter `type:"list"`

	// The names of one or more regions in which you want to update parameter values
	// for stack instances. The overridden parameter values will be applied to all
	// stack instances in the specified accounts and regions.
	//
	// Regions is a required field
	Regions []string `type:"list" required:"true"`

	// The name or unique ID of the stack set associated with the stack instances.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateStackInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStackInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStackInstancesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateStackInstancesInput"}

	if s.Accounts == nil {
		invalidParams.Add(aws.NewErrParamRequired("Accounts"))
	}
	if s.OperationId != nil && len(*s.OperationId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OperationId", 1))
	}

	if s.Regions == nil {
		invalidParams.Add(aws.NewErrParamRequired("Regions"))
	}

	if s.StackSetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackSetName"))
	}
	if s.OperationPreferences != nil {
		if err := s.OperationPreferences.Validate(); err != nil {
			invalidParams.AddNested("OperationPreferences", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackInstancesOutput
type UpdateStackInstancesOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The unique identifier for this stack set operation.
	OperationId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateStackInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStackInstancesOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s UpdateStackInstancesOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// The output for an UpdateStack action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackOutput
type UpdateStackOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// Unique identifier of the stack.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s UpdateStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStackOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s UpdateStackOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackSetInput
type UpdateStackSetInput struct {
	_ struct{} `type:"structure"`

	// The accounts in which to update associated stack instances. If you specify
	// accounts, you must also specify the regions in which to update stack set
	// instances.
	//
	// To update all the stack instances associated with this stack set, do not
	// specify the Accounts or Regions properties.
	//
	// If the stack set update includes changes to the template (that is, if the
	// TemplateBody or TemplateURL properties are specified), or the Parameters
	// property, AWS CloudFormation marks all stack instances with a status of OUTDATED
	// prior to updating the stack instances in the specified accounts and regions.
	// If the stack set update does not include changes to the template or parameters,
	// AWS CloudFormation updates the stack instances in the specified accounts
	// and regions, while leaving all other stack instances with their existing
	// stack instance status.
	Accounts []string `type:"list"`

	// The Amazon Resource Number (ARN) of the IAM role to use to update this stack
	// set.
	//
	// Specify an IAM role only if you are using customized administrator roles
	// to control which users or groups can manage specific stack sets within the
	// same administrator account. For more information, see Define Permissions
	// for Multiple Administrators (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html)
	// in the AWS CloudFormation User Guide.
	//
	// If you specify a customized administrator role, AWS CloudFormation uses that
	// role to update the stack. If you do not specify a customized administrator
	// role, AWS CloudFormation performs the update using the role previously associated
	// with the stack set, so long as you have permissions to perform operations
	// on the stack set.
	AdministrationRoleARN *string `min:"20" type:"string"`

	// A list of values that you must specify before AWS CloudFormation can create
	// certain stack sets. Some stack set templates might include resources that
	// can affect permissions in your AWS account—for example, by creating new AWS
	// Identity and Access Management (IAM) users. For those stack sets, you must
	// explicitly acknowledge their capabilities by specifying this parameter.
	//
	// The only valid values are CAPABILITY_IAM and CAPABILITY_NAMED_IAM. The following
	// resources require you to specify this parameter:
	//
	//    * AWS::IAM::AccessKey
	//
	//    * AWS::IAM::Group
	//
	//    * AWS::IAM::InstanceProfile
	//
	//    * AWS::IAM::Policy
	//
	//    * AWS::IAM::Role
	//
	//    * AWS::IAM::User
	//
	//    * AWS::IAM::UserToGroupAddition
	//
	// If your stack template contains these resources, we recommend that you review
	// all permissions that are associated with them and edit their permissions
	// if necessary.
	//
	// If you have IAM resources, you can specify either capability. If you have
	// IAM resources with custom names, you must specify CAPABILITY_NAMED_IAM. If
	// you don't specify this parameter, this action returns an InsufficientCapabilities
	// error.
	//
	// For more information, see Acknowledging IAM Resources in AWS CloudFormation
	// Templates. (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities)
	Capabilities []Capability `type:"list"`

	// A brief description of updates that you are making.
	Description *string `min:"1" type:"string"`

	// The name of the IAM execution role to use to update the stack set. If you
	// do not specify an execution role, AWS CloudFormation uses the AWSCloudFormationStackSetExecutionRole
	// role for the stack set operation.
	//
	// Specify an IAM role only if you are using customized execution roles to control
	// which stack resources users and groups can include in their stack sets.
	//
	// If you specify a customized execution role, AWS CloudFormation uses that
	// role to update the stack. If you do not specify a customized execution role,
	// AWS CloudFormation performs the update using the role previously associated
	// with the stack set, so long as you have permissions to perform operations
	// on the stack set.
	ExecutionRoleName *string `min:"1" type:"string"`

	// The unique ID for this stack set operation.
	//
	// The operation ID also functions as an idempotency token, to ensure that AWS
	// CloudFormation performs the stack set operation only once, even if you retry
	// the request multiple times. You might retry stack set operation requests
	// to ensure that AWS CloudFormation successfully received them.
	//
	// If you don't specify an operation ID, AWS CloudFormation generates one automatically.
	//
	// Repeating this stack set operation with a new operation ID retries all stack
	// instances whose status is OUTDATED.
	OperationId *string `min:"1" type:"string" idempotencyToken:"true"`

	// Preferences for how AWS CloudFormation performs this stack set operation.
	OperationPreferences *StackSetOperationPreferences `type:"structure"`

	// A list of input parameters for the stack set template.
	Parameters []Parameter `type:"list"`

	// The regions in which to update associated stack instances. If you specify
	// regions, you must also specify accounts in which to update stack set instances.
	//
	// To update all the stack instances associated with this stack set, do not
	// specify the Accounts or Regions properties.
	//
	// If the stack set update includes changes to the template (that is, if the
	// TemplateBody or TemplateURL properties are specified), or the Parameters
	// property, AWS CloudFormation marks all stack instances with a status of OUTDATED
	// prior to updating the stack instances in the specified accounts and regions.
	// If the stack set update does not include changes to the template or parameters,
	// AWS CloudFormation updates the stack instances in the specified accounts
	// and regions, while leaving all other stack instances with their existing
	// stack instance status.
	Regions []string `type:"list"`

	// The name or unique ID of the stack set that you want to update.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`

	// The key-value pairs to associate with this stack set and the stacks created
	// from it. AWS CloudFormation also propagates these tags to supported resources
	// that are created in the stacks. You can specify a maximum number of 50 tags.
	//
	// If you specify tags for this parameter, those tags replace any list of tags
	// that are currently associated with this stack set. This means:
	//
	//    * If you don't specify this parameter, AWS CloudFormation doesn't modify
	//    the stack's tags.
	//
	//    * If you specify any tags using this parameter, you must specify all the
	//    tags that you want associated with this stack set, even tags you've specifed
	//    before (for example, when creating the stack set or during a previous
	//    update of the stack set.). Any tags that you don't include in the updated
	//    list of tags are removed from the stack set, and therefore from the stacks
	//    and resources as well.
	//
	//    * If you specify an empty value, AWS CloudFormation removes all currently
	//    associated tags.
	//
	// If you specify new tags as part of an UpdateStackSet action, AWS CloudFormation
	// checks to see if you have the required IAM permission to tag resources. If
	// you omit tags that are currently associated with the stack set from the list
	// of tags you specify, AWS CloudFormation assumes that you want to remove those
	// tags from the stack set, and checks to see if you have permission to untag
	// resources. If you don't have the necessary permission(s), the entire UpdateStackSet
	// action fails with an access denied error, and the stack set is not updated.
	Tags []Tag `type:"list"`

	// The structure that contains the template body, with a minimum length of 1
	// byte and a maximum length of 51,200 bytes. For more information, see Template
	// Anatomy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must specify only one of the following parameters: TemplateBody
	// or TemplateURL—or set UsePreviousTemplate to true.
	TemplateBody *string `min:"1" type:"string"`

	// The location of the file that contains the template body. The URL must point
	// to a template (maximum size: 460,800 bytes) that is located in an Amazon
	// S3 bucket. For more information, see Template Anatomy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must specify only one of the following parameters: TemplateBody
	// or TemplateURL—or set UsePreviousTemplate to true.
	TemplateURL *string `min:"1" type:"string"`

	// Use the existing template that's associated with the stack set that you're
	// updating.
	//
	// Conditional: You must specify only one of the following parameters: TemplateBody
	// or TemplateURL—or set UsePreviousTemplate to true.
	UsePreviousTemplate *bool `type:"boolean"`
}

// String returns the string representation
func (s UpdateStackSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStackSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStackSetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateStackSetInput"}
	if s.AdministrationRoleARN != nil && len(*s.AdministrationRoleARN) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("AdministrationRoleARN", 20))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}
	if s.ExecutionRoleName != nil && len(*s.ExecutionRoleName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ExecutionRoleName", 1))
	}
	if s.OperationId != nil && len(*s.OperationId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OperationId", 1))
	}

	if s.StackSetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackSetName"))
	}
	if s.TemplateBody != nil && len(*s.TemplateBody) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TemplateBody", 1))
	}
	if s.TemplateURL != nil && len(*s.TemplateURL) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TemplateURL", 1))
	}
	if s.OperationPreferences != nil {
		if err := s.OperationPreferences.Validate(); err != nil {
			invalidParams.AddNested("OperationPreferences", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackSetOutput
type UpdateStackSetOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The unique ID for this stack set operation.
	OperationId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateStackSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStackSetOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s UpdateStackSetOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateTerminationProtectionInput
type UpdateTerminationProtectionInput struct {
	_ struct{} `type:"structure"`

	// Whether to enable termination protection on the specified stack.
	//
	// EnableTerminationProtection is a required field
	EnableTerminationProtection *bool `type:"boolean" required:"true"`

	// The name or unique ID of the stack for which you want to set termination
	// protection.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateTerminationProtectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTerminationProtectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTerminationProtectionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateTerminationProtectionInput"}

	if s.EnableTerminationProtection == nil {
		invalidParams.Add(aws.NewErrParamRequired("EnableTerminationProtection"))
	}

	if s.StackName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateTerminationProtectionOutput
type UpdateTerminationProtectionOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The unique ID of the stack.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s UpdateTerminationProtectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTerminationProtectionOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s UpdateTerminationProtectionOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// The input for ValidateTemplate action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ValidateTemplateInput
type ValidateTemplateInput struct {
	_ struct{} `type:"structure"`

	// Structure containing the template body with a minimum length of 1 byte and
	// a maximum length of 51,200 bytes. For more information, go to Template Anatomy
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must pass TemplateURL or TemplateBody. If both are passed,
	// only TemplateBody is used.
	TemplateBody *string `min:"1" type:"string"`

	// Location of file containing the template body. The URL must point to a template
	// (max size: 460,800 bytes) that is located in an Amazon S3 bucket. For more
	// information, go to Template Anatomy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must pass TemplateURL or TemplateBody. If both are passed,
	// only TemplateBody is used.
	TemplateURL *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ValidateTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidateTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ValidateTemplateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ValidateTemplateInput"}
	if s.TemplateBody != nil && len(*s.TemplateBody) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TemplateBody", 1))
	}
	if s.TemplateURL != nil && len(*s.TemplateURL) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TemplateURL", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output for ValidateTemplate action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ValidateTemplateOutput
type ValidateTemplateOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The capabilities found within the template. If your template contains IAM
	// resources, you must specify the CAPABILITY_IAM or CAPABILITY_NAMED_IAM value
	// for this parameter when you use the CreateStack or UpdateStack actions with
	// your template; otherwise, those actions return an InsufficientCapabilities
	// error.
	//
	// For more information, see Acknowledging IAM Resources in AWS CloudFormation
	// Templates (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities).
	Capabilities []Capability `type:"list"`

	// The list of resources that generated the values in the Capabilities response
	// element.
	CapabilitiesReason *string `type:"string"`

	// A list of the transforms that are declared in the template.
	DeclaredTransforms []string `type:"list"`

	// The description found within the template.
	Description *string `min:"1" type:"string"`

	// A list of TemplateParameter structures.
	Parameters []TemplateParameter `type:"list"`
}

// String returns the string representation
func (s ValidateTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidateTemplateOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s ValidateTemplateOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

type AccountGateStatus string

// Enum values for AccountGateStatus
const (
	AccountGateStatusSucceeded AccountGateStatus = "SUCCEEDED"
	AccountGateStatusFailed    AccountGateStatus = "FAILED"
	AccountGateStatusSkipped   AccountGateStatus = "SKIPPED"
)

func (enum AccountGateStatus) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum AccountGateStatus) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type Capability string

// Enum values for Capability
const (
	CapabilityCapabilityIam      Capability = "CAPABILITY_IAM"
	CapabilityCapabilityNamedIam Capability = "CAPABILITY_NAMED_IAM"
)

func (enum Capability) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Capability) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type ChangeAction string

// Enum values for ChangeAction
const (
	ChangeActionAdd    ChangeAction = "Add"
	ChangeActionModify ChangeAction = "Modify"
	ChangeActionRemove ChangeAction = "Remove"
)

func (enum ChangeAction) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ChangeAction) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type ChangeSetStatus string

// Enum values for ChangeSetStatus
const (
	ChangeSetStatusCreatePending    ChangeSetStatus = "CREATE_PENDING"
	ChangeSetStatusCreateInProgress ChangeSetStatus = "CREATE_IN_PROGRESS"
	ChangeSetStatusCreateComplete   ChangeSetStatus = "CREATE_COMPLETE"
	ChangeSetStatusDeleteComplete   ChangeSetStatus = "DELETE_COMPLETE"
	ChangeSetStatusFailed           ChangeSetStatus = "FAILED"
)

func (enum ChangeSetStatus) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ChangeSetStatus) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type ChangeSetType string

// Enum values for ChangeSetType
const (
	ChangeSetTypeCreate ChangeSetType = "CREATE"
	ChangeSetTypeUpdate ChangeSetType = "UPDATE"
)

func (enum ChangeSetType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ChangeSetType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type ChangeSource string

// Enum values for ChangeSource
const (
	ChangeSourceResourceReference  ChangeSource = "ResourceReference"
	ChangeSourceParameterReference ChangeSource = "ParameterReference"
	ChangeSourceResourceAttribute  ChangeSource = "ResourceAttribute"
	ChangeSourceDirectModification ChangeSource = "DirectModification"
	ChangeSourceAutomatic          ChangeSource = "Automatic"
)

func (enum ChangeSource) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ChangeSource) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type ChangeType string

// Enum values for ChangeType
const (
	ChangeTypeResource ChangeType = "Resource"
)

func (enum ChangeType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ChangeType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type EvaluationType string

// Enum values for EvaluationType
const (
	EvaluationTypeStatic  EvaluationType = "Static"
	EvaluationTypeDynamic EvaluationType = "Dynamic"
)

func (enum EvaluationType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum EvaluationType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type ExecutionStatus string

// Enum values for ExecutionStatus
const (
	ExecutionStatusUnavailable       ExecutionStatus = "UNAVAILABLE"
	ExecutionStatusAvailable         ExecutionStatus = "AVAILABLE"
	ExecutionStatusExecuteInProgress ExecutionStatus = "EXECUTE_IN_PROGRESS"
	ExecutionStatusExecuteComplete   ExecutionStatus = "EXECUTE_COMPLETE"
	ExecutionStatusExecuteFailed     ExecutionStatus = "EXECUTE_FAILED"
	ExecutionStatusObsolete          ExecutionStatus = "OBSOLETE"
)

func (enum ExecutionStatus) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ExecutionStatus) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type OnFailure string

// Enum values for OnFailure
const (
	OnFailureDoNothing OnFailure = "DO_NOTHING"
	OnFailureRollback  OnFailure = "ROLLBACK"
	OnFailureDelete    OnFailure = "DELETE"
)

func (enum OnFailure) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum OnFailure) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type Replacement string

// Enum values for Replacement
const (
	ReplacementTrue        Replacement = "True"
	ReplacementFalse       Replacement = "False"
	ReplacementConditional Replacement = "Conditional"
)

func (enum Replacement) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Replacement) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type RequiresRecreation string

// Enum values for RequiresRecreation
const (
	RequiresRecreationNever         RequiresRecreation = "Never"
	RequiresRecreationConditionally RequiresRecreation = "Conditionally"
	RequiresRecreationAlways        RequiresRecreation = "Always"
)

func (enum RequiresRecreation) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum RequiresRecreation) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type ResourceAttribute string

// Enum values for ResourceAttribute
const (
	ResourceAttributeProperties     ResourceAttribute = "Properties"
	ResourceAttributeMetadata       ResourceAttribute = "Metadata"
	ResourceAttributeCreationPolicy ResourceAttribute = "CreationPolicy"
	ResourceAttributeUpdatePolicy   ResourceAttribute = "UpdatePolicy"
	ResourceAttributeDeletionPolicy ResourceAttribute = "DeletionPolicy"
	ResourceAttributeTags           ResourceAttribute = "Tags"
)

func (enum ResourceAttribute) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ResourceAttribute) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type ResourceSignalStatus string

// Enum values for ResourceSignalStatus
const (
	ResourceSignalStatusSuccess ResourceSignalStatus = "SUCCESS"
	ResourceSignalStatusFailure ResourceSignalStatus = "FAILURE"
)

func (enum ResourceSignalStatus) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ResourceSignalStatus) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type ResourceStatus string

// Enum values for ResourceStatus
const (
	ResourceStatusCreateInProgress ResourceStatus = "CREATE_IN_PROGRESS"
	ResourceStatusCreateFailed     ResourceStatus = "CREATE_FAILED"
	ResourceStatusCreateComplete   ResourceStatus = "CREATE_COMPLETE"
	ResourceStatusDeleteInProgress ResourceStatus = "DELETE_IN_PROGRESS"
	ResourceStatusDeleteFailed     ResourceStatus = "DELETE_FAILED"
	ResourceStatusDeleteComplete   ResourceStatus = "DELETE_COMPLETE"
	ResourceStatusDeleteSkipped    ResourceStatus = "DELETE_SKIPPED"
	ResourceStatusUpdateInProgress ResourceStatus = "UPDATE_IN_PROGRESS"
	ResourceStatusUpdateFailed     ResourceStatus = "UPDATE_FAILED"
	ResourceStatusUpdateComplete   ResourceStatus = "UPDATE_COMPLETE"
)

func (enum ResourceStatus) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ResourceStatus) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type StackInstanceStatus string

// Enum values for StackInstanceStatus
const (
	StackInstanceStatusCurrent    StackInstanceStatus = "CURRENT"
	StackInstanceStatusOutdated   StackInstanceStatus = "OUTDATED"
	StackInstanceStatusInoperable StackInstanceStatus = "INOPERABLE"
)

func (enum StackInstanceStatus) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum StackInstanceStatus) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type StackSetOperationAction string

// Enum values for StackSetOperationAction
const (
	StackSetOperationActionCreate StackSetOperationAction = "CREATE"
	StackSetOperationActionUpdate StackSetOperationAction = "UPDATE"
	StackSetOperationActionDelete StackSetOperationAction = "DELETE"
)

func (enum StackSetOperationAction) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum StackSetOperationAction) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type StackSetOperationResultStatus string

// Enum values for StackSetOperationResultStatus
const (
	StackSetOperationResultStatusPending   StackSetOperationResultStatus = "PENDING"
	StackSetOperationResultStatusRunning   StackSetOperationResultStatus = "RUNNING"
	StackSetOperationResultStatusSucceeded StackSetOperationResultStatus = "SUCCEEDED"
	StackSetOperationResultStatusFailed    StackSetOperationResultStatus = "FAILED"
	StackSetOperationResultStatusCancelled StackSetOperationResultStatus = "CANCELLED"
)

func (enum StackSetOperationResultStatus) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum StackSetOperationResultStatus) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type StackSetOperationStatus string

// Enum values for StackSetOperationStatus
const (
	StackSetOperationStatusRunning   StackSetOperationStatus = "RUNNING"
	StackSetOperationStatusSucceeded StackSetOperationStatus = "SUCCEEDED"
	StackSetOperationStatusFailed    StackSetOperationStatus = "FAILED"
	StackSetOperationStatusStopping  StackSetOperationStatus = "STOPPING"
	StackSetOperationStatusStopped   StackSetOperationStatus = "STOPPED"
)

func (enum StackSetOperationStatus) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum StackSetOperationStatus) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type StackSetStatus string

// Enum values for StackSetStatus
const (
	StackSetStatusActive  StackSetStatus = "ACTIVE"
	StackSetStatusDeleted StackSetStatus = "DELETED"
)

func (enum StackSetStatus) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum StackSetStatus) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type StackStatus string

// Enum values for StackStatus
const (
	StackStatusCreateInProgress                        StackStatus = "CREATE_IN_PROGRESS"
	StackStatusCreateFailed                            StackStatus = "CREATE_FAILED"
	StackStatusCreateComplete                          StackStatus = "CREATE_COMPLETE"
	StackStatusRollbackInProgress                      StackStatus = "ROLLBACK_IN_PROGRESS"
	StackStatusRollbackFailed                          StackStatus = "ROLLBACK_FAILED"
	StackStatusRollbackComplete                        StackStatus = "ROLLBACK_COMPLETE"
	StackStatusDeleteInProgress                        StackStatus = "DELETE_IN_PROGRESS"
	StackStatusDeleteFailed                            StackStatus = "DELETE_FAILED"
	StackStatusDeleteComplete                          StackStatus = "DELETE_COMPLETE"
	StackStatusUpdateInProgress                        StackStatus = "UPDATE_IN_PROGRESS"
	StackStatusUpdateCompleteCleanupInProgress         StackStatus = "UPDATE_COMPLETE_CLEANUP_IN_PROGRESS"
	StackStatusUpdateComplete                          StackStatus = "UPDATE_COMPLETE"
	StackStatusUpdateRollbackInProgress                StackStatus = "UPDATE_ROLLBACK_IN_PROGRESS"
	StackStatusUpdateRollbackFailed                    StackStatus = "UPDATE_ROLLBACK_FAILED"
	StackStatusUpdateRollbackCompleteCleanupInProgress StackStatus = "UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS"
	StackStatusUpdateRollbackComplete                  StackStatus = "UPDATE_ROLLBACK_COMPLETE"
	StackStatusReviewInProgress                        StackStatus = "REVIEW_IN_PROGRESS"
)

func (enum StackStatus) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum StackStatus) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type TemplateStage string

// Enum values for TemplateStage
const (
	TemplateStageOriginal  TemplateStage = "Original"
	TemplateStageProcessed TemplateStage = "Processed"
)

func (enum TemplateStage) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum TemplateStage) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}
