// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3

import (
	"fmt"
	"io"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restxml"
)

const opAbortMultipartUpload = "AbortMultipartUpload"

// AbortMultipartUploadRequest is a API request type for the AbortMultipartUpload API operation.
type AbortMultipartUploadRequest struct {
	*aws.Request
	Input *AbortMultipartUploadInput
	Copy  func(*AbortMultipartUploadInput) AbortMultipartUploadRequest
}

// Send marshals and sends the AbortMultipartUpload API request.
func (r AbortMultipartUploadRequest) Send() (*AbortMultipartUploadOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*AbortMultipartUploadOutput), nil
}

// AbortMultipartUploadRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Aborts a multipart upload.
//
// To verify that all parts have been removed, so you don't get charged for
// the part storage, you should call the List Parts operation and ensure the
// parts list is empty.
//
//    // Example sending a request using the AbortMultipartUploadRequest method.
//    req := client.AbortMultipartUploadRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AbortMultipartUpload
func (c *S3) AbortMultipartUploadRequest(input *AbortMultipartUploadInput) AbortMultipartUploadRequest {
	op := &aws.Operation{
		Name:       opAbortMultipartUpload,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &AbortMultipartUploadInput{}
	}

	output := &AbortMultipartUploadOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return AbortMultipartUploadRequest{Request: req, Input: input, Copy: c.AbortMultipartUploadRequest}
}

const opCompleteMultipartUpload = "CompleteMultipartUpload"

// CompleteMultipartUploadRequest is a API request type for the CompleteMultipartUpload API operation.
type CompleteMultipartUploadRequest struct {
	*aws.Request
	Input *CompleteMultipartUploadInput
	Copy  func(*CompleteMultipartUploadInput) CompleteMultipartUploadRequest
}

// Send marshals and sends the CompleteMultipartUpload API request.
func (r CompleteMultipartUploadRequest) Send() (*CompleteMultipartUploadOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*CompleteMultipartUploadOutput), nil
}

// CompleteMultipartUploadRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Completes a multipart upload by assembling previously uploaded parts.
//
//    // Example sending a request using the CompleteMultipartUploadRequest method.
//    req := client.CompleteMultipartUploadRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CompleteMultipartUpload
func (c *S3) CompleteMultipartUploadRequest(input *CompleteMultipartUploadInput) CompleteMultipartUploadRequest {
	op := &aws.Operation{
		Name:       opCompleteMultipartUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &CompleteMultipartUploadInput{}
	}

	output := &CompleteMultipartUploadOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return CompleteMultipartUploadRequest{Request: req, Input: input, Copy: c.CompleteMultipartUploadRequest}
}

const opCopyObject = "CopyObject"

// CopyObjectRequest is a API request type for the CopyObject API operation.
type CopyObjectRequest struct {
	*aws.Request
	Input *CopyObjectInput
	Copy  func(*CopyObjectInput) CopyObjectRequest
}

// Send marshals and sends the CopyObject API request.
func (r CopyObjectRequest) Send() (*CopyObjectOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*CopyObjectOutput), nil
}

// CopyObjectRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Creates a copy of an object that is already stored in Amazon S3.
//
//    // Example sending a request using the CopyObjectRequest method.
//    req := client.CopyObjectRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CopyObject
func (c *S3) CopyObjectRequest(input *CopyObjectInput) CopyObjectRequest {
	op := &aws.Operation{
		Name:       opCopyObject,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &CopyObjectInput{}
	}

	output := &CopyObjectOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return CopyObjectRequest{Request: req, Input: input, Copy: c.CopyObjectRequest}
}

const opCreateBucket = "CreateBucket"

// CreateBucketRequest is a API request type for the CreateBucket API operation.
type CreateBucketRequest struct {
	*aws.Request
	Input *CreateBucketInput
	Copy  func(*CreateBucketInput) CreateBucketRequest
}

// Send marshals and sends the CreateBucket API request.
func (r CreateBucketRequest) Send() (*CreateBucketOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*CreateBucketOutput), nil
}

// CreateBucketRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Creates a new bucket.
//
//    // Example sending a request using the CreateBucketRequest method.
//    req := client.CreateBucketRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CreateBucket
func (c *S3) CreateBucketRequest(input *CreateBucketInput) CreateBucketRequest {
	op := &aws.Operation{
		Name:       opCreateBucket,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}",
	}

	if input == nil {
		input = &CreateBucketInput{}
	}

	output := &CreateBucketOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return CreateBucketRequest{Request: req, Input: input, Copy: c.CreateBucketRequest}
}

const opCreateMultipartUpload = "CreateMultipartUpload"

// CreateMultipartUploadRequest is a API request type for the CreateMultipartUpload API operation.
type CreateMultipartUploadRequest struct {
	*aws.Request
	Input *CreateMultipartUploadInput
	Copy  func(*CreateMultipartUploadInput) CreateMultipartUploadRequest
}

// Send marshals and sends the CreateMultipartUpload API request.
func (r CreateMultipartUploadRequest) Send() (*CreateMultipartUploadOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*CreateMultipartUploadOutput), nil
}

// CreateMultipartUploadRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Initiates a multipart upload and returns an upload ID.
//
// Note: After you initiate multipart upload and upload one or more parts, you
// must either complete or abort multipart upload in order to stop getting charged
// for storage of the uploaded parts. Only after you either complete or abort
// multipart upload, Amazon S3 frees up the parts storage and stops charging
// you for the parts storage.
//
//    // Example sending a request using the CreateMultipartUploadRequest method.
//    req := client.CreateMultipartUploadRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CreateMultipartUpload
func (c *S3) CreateMultipartUploadRequest(input *CreateMultipartUploadInput) CreateMultipartUploadRequest {
	op := &aws.Operation{
		Name:       opCreateMultipartUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/{Bucket}/{Key+}?uploads",
	}

	if input == nil {
		input = &CreateMultipartUploadInput{}
	}

	output := &CreateMultipartUploadOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return CreateMultipartUploadRequest{Request: req, Input: input, Copy: c.CreateMultipartUploadRequest}
}

const opDeleteBucket = "DeleteBucket"

// DeleteBucketRequest is a API request type for the DeleteBucket API operation.
type DeleteBucketRequest struct {
	*aws.Request
	Input *DeleteBucketInput
	Copy  func(*DeleteBucketInput) DeleteBucketRequest
}

// Send marshals and sends the DeleteBucket API request.
func (r DeleteBucketRequest) Send() (*DeleteBucketOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DeleteBucketOutput), nil
}

// DeleteBucketRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Deletes the bucket. All objects (including all object versions and Delete
// Markers) in the bucket must be deleted before the bucket itself can be deleted.
//
//    // Example sending a request using the DeleteBucketRequest method.
//    req := client.DeleteBucketRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucket
func (c *S3) DeleteBucketRequest(input *DeleteBucketInput) DeleteBucketRequest {
	op := &aws.Operation{
		Name:       opDeleteBucket,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}",
	}

	if input == nil {
		input = &DeleteBucketInput{}
	}

	output := &DeleteBucketOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return DeleteBucketRequest{Request: req, Input: input, Copy: c.DeleteBucketRequest}
}

const opDeleteBucketAnalyticsConfiguration = "DeleteBucketAnalyticsConfiguration"

// DeleteBucketAnalyticsConfigurationRequest is a API request type for the DeleteBucketAnalyticsConfiguration API operation.
type DeleteBucketAnalyticsConfigurationRequest struct {
	*aws.Request
	Input *DeleteBucketAnalyticsConfigurationInput
	Copy  func(*DeleteBucketAnalyticsConfigurationInput) DeleteBucketAnalyticsConfigurationRequest
}

// Send marshals and sends the DeleteBucketAnalyticsConfiguration API request.
func (r DeleteBucketAnalyticsConfigurationRequest) Send() (*DeleteBucketAnalyticsConfigurationOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DeleteBucketAnalyticsConfigurationOutput), nil
}

// DeleteBucketAnalyticsConfigurationRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Deletes an analytics configuration for the bucket (specified by the analytics
// configuration ID).
//
//    // Example sending a request using the DeleteBucketAnalyticsConfigurationRequest method.
//    req := client.DeleteBucketAnalyticsConfigurationRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketAnalyticsConfiguration
func (c *S3) DeleteBucketAnalyticsConfigurationRequest(input *DeleteBucketAnalyticsConfigurationInput) DeleteBucketAnalyticsConfigurationRequest {
	op := &aws.Operation{
		Name:       opDeleteBucketAnalyticsConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?analytics",
	}

	if input == nil {
		input = &DeleteBucketAnalyticsConfigurationInput{}
	}

	output := &DeleteBucketAnalyticsConfigurationOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return DeleteBucketAnalyticsConfigurationRequest{Request: req, Input: input, Copy: c.DeleteBucketAnalyticsConfigurationRequest}
}

const opDeleteBucketCors = "DeleteBucketCors"

// DeleteBucketCorsRequest is a API request type for the DeleteBucketCors API operation.
type DeleteBucketCorsRequest struct {
	*aws.Request
	Input *DeleteBucketCorsInput
	Copy  func(*DeleteBucketCorsInput) DeleteBucketCorsRequest
}

// Send marshals and sends the DeleteBucketCors API request.
func (r DeleteBucketCorsRequest) Send() (*DeleteBucketCorsOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DeleteBucketCorsOutput), nil
}

// DeleteBucketCorsRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Deletes the cors configuration information set for the bucket.
//
//    // Example sending a request using the DeleteBucketCorsRequest method.
//    req := client.DeleteBucketCorsRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketCors
func (c *S3) DeleteBucketCorsRequest(input *DeleteBucketCorsInput) DeleteBucketCorsRequest {
	op := &aws.Operation{
		Name:       opDeleteBucketCors,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?cors",
	}

	if input == nil {
		input = &DeleteBucketCorsInput{}
	}

	output := &DeleteBucketCorsOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return DeleteBucketCorsRequest{Request: req, Input: input, Copy: c.DeleteBucketCorsRequest}
}

const opDeleteBucketEncryption = "DeleteBucketEncryption"

// DeleteBucketEncryptionRequest is a API request type for the DeleteBucketEncryption API operation.
type DeleteBucketEncryptionRequest struct {
	*aws.Request
	Input *DeleteBucketEncryptionInput
	Copy  func(*DeleteBucketEncryptionInput) DeleteBucketEncryptionRequest
}

// Send marshals and sends the DeleteBucketEncryption API request.
func (r DeleteBucketEncryptionRequest) Send() (*DeleteBucketEncryptionOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DeleteBucketEncryptionOutput), nil
}

// DeleteBucketEncryptionRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Deletes the server-side encryption configuration from the bucket.
//
//    // Example sending a request using the DeleteBucketEncryptionRequest method.
//    req := client.DeleteBucketEncryptionRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketEncryption
func (c *S3) DeleteBucketEncryptionRequest(input *DeleteBucketEncryptionInput) DeleteBucketEncryptionRequest {
	op := &aws.Operation{
		Name:       opDeleteBucketEncryption,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?encryption",
	}

	if input == nil {
		input = &DeleteBucketEncryptionInput{}
	}

	output := &DeleteBucketEncryptionOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return DeleteBucketEncryptionRequest{Request: req, Input: input, Copy: c.DeleteBucketEncryptionRequest}
}

const opDeleteBucketInventoryConfiguration = "DeleteBucketInventoryConfiguration"

// DeleteBucketInventoryConfigurationRequest is a API request type for the DeleteBucketInventoryConfiguration API operation.
type DeleteBucketInventoryConfigurationRequest struct {
	*aws.Request
	Input *DeleteBucketInventoryConfigurationInput
	Copy  func(*DeleteBucketInventoryConfigurationInput) DeleteBucketInventoryConfigurationRequest
}

// Send marshals and sends the DeleteBucketInventoryConfiguration API request.
func (r DeleteBucketInventoryConfigurationRequest) Send() (*DeleteBucketInventoryConfigurationOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DeleteBucketInventoryConfigurationOutput), nil
}

// DeleteBucketInventoryConfigurationRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Deletes an inventory configuration (identified by the inventory ID) from
// the bucket.
//
//    // Example sending a request using the DeleteBucketInventoryConfigurationRequest method.
//    req := client.DeleteBucketInventoryConfigurationRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketInventoryConfiguration
func (c *S3) DeleteBucketInventoryConfigurationRequest(input *DeleteBucketInventoryConfigurationInput) DeleteBucketInventoryConfigurationRequest {
	op := &aws.Operation{
		Name:       opDeleteBucketInventoryConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?inventory",
	}

	if input == nil {
		input = &DeleteBucketInventoryConfigurationInput{}
	}

	output := &DeleteBucketInventoryConfigurationOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return DeleteBucketInventoryConfigurationRequest{Request: req, Input: input, Copy: c.DeleteBucketInventoryConfigurationRequest}
}

const opDeleteBucketLifecycle = "DeleteBucketLifecycle"

// DeleteBucketLifecycleRequest is a API request type for the DeleteBucketLifecycle API operation.
type DeleteBucketLifecycleRequest struct {
	*aws.Request
	Input *DeleteBucketLifecycleInput
	Copy  func(*DeleteBucketLifecycleInput) DeleteBucketLifecycleRequest
}

// Send marshals and sends the DeleteBucketLifecycle API request.
func (r DeleteBucketLifecycleRequest) Send() (*DeleteBucketLifecycleOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DeleteBucketLifecycleOutput), nil
}

// DeleteBucketLifecycleRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Deletes the lifecycle configuration from the bucket.
//
//    // Example sending a request using the DeleteBucketLifecycleRequest method.
//    req := client.DeleteBucketLifecycleRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketLifecycle
func (c *S3) DeleteBucketLifecycleRequest(input *DeleteBucketLifecycleInput) DeleteBucketLifecycleRequest {
	op := &aws.Operation{
		Name:       opDeleteBucketLifecycle,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?lifecycle",
	}

	if input == nil {
		input = &DeleteBucketLifecycleInput{}
	}

	output := &DeleteBucketLifecycleOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return DeleteBucketLifecycleRequest{Request: req, Input: input, Copy: c.DeleteBucketLifecycleRequest}
}

const opDeleteBucketMetricsConfiguration = "DeleteBucketMetricsConfiguration"

// DeleteBucketMetricsConfigurationRequest is a API request type for the DeleteBucketMetricsConfiguration API operation.
type DeleteBucketMetricsConfigurationRequest struct {
	*aws.Request
	Input *DeleteBucketMetricsConfigurationInput
	Copy  func(*DeleteBucketMetricsConfigurationInput) DeleteBucketMetricsConfigurationRequest
}

// Send marshals and sends the DeleteBucketMetricsConfiguration API request.
func (r DeleteBucketMetricsConfigurationRequest) Send() (*DeleteBucketMetricsConfigurationOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DeleteBucketMetricsConfigurationOutput), nil
}

// DeleteBucketMetricsConfigurationRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Deletes a metrics configuration (specified by the metrics configuration ID)
// from the bucket.
//
//    // Example sending a request using the DeleteBucketMetricsConfigurationRequest method.
//    req := client.DeleteBucketMetricsConfigurationRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketMetricsConfiguration
func (c *S3) DeleteBucketMetricsConfigurationRequest(input *DeleteBucketMetricsConfigurationInput) DeleteBucketMetricsConfigurationRequest {
	op := &aws.Operation{
		Name:       opDeleteBucketMetricsConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?metrics",
	}

	if input == nil {
		input = &DeleteBucketMetricsConfigurationInput{}
	}

	output := &DeleteBucketMetricsConfigurationOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return DeleteBucketMetricsConfigurationRequest{Request: req, Input: input, Copy: c.DeleteBucketMetricsConfigurationRequest}
}

const opDeleteBucketPolicy = "DeleteBucketPolicy"

// DeleteBucketPolicyRequest is a API request type for the DeleteBucketPolicy API operation.
type DeleteBucketPolicyRequest struct {
	*aws.Request
	Input *DeleteBucketPolicyInput
	Copy  func(*DeleteBucketPolicyInput) DeleteBucketPolicyRequest
}

// Send marshals and sends the DeleteBucketPolicy API request.
func (r DeleteBucketPolicyRequest) Send() (*DeleteBucketPolicyOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DeleteBucketPolicyOutput), nil
}

// DeleteBucketPolicyRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Deletes the policy from the bucket.
//
//    // Example sending a request using the DeleteBucketPolicyRequest method.
//    req := client.DeleteBucketPolicyRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketPolicy
func (c *S3) DeleteBucketPolicyRequest(input *DeleteBucketPolicyInput) DeleteBucketPolicyRequest {
	op := &aws.Operation{
		Name:       opDeleteBucketPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?policy",
	}

	if input == nil {
		input = &DeleteBucketPolicyInput{}
	}

	output := &DeleteBucketPolicyOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return DeleteBucketPolicyRequest{Request: req, Input: input, Copy: c.DeleteBucketPolicyRequest}
}

const opDeleteBucketReplication = "DeleteBucketReplication"

// DeleteBucketReplicationRequest is a API request type for the DeleteBucketReplication API operation.
type DeleteBucketReplicationRequest struct {
	*aws.Request
	Input *DeleteBucketReplicationInput
	Copy  func(*DeleteBucketReplicationInput) DeleteBucketReplicationRequest
}

// Send marshals and sends the DeleteBucketReplication API request.
func (r DeleteBucketReplicationRequest) Send() (*DeleteBucketReplicationOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DeleteBucketReplicationOutput), nil
}

// DeleteBucketReplicationRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Deletes the replication configuration from the bucket.
//
//    // Example sending a request using the DeleteBucketReplicationRequest method.
//    req := client.DeleteBucketReplicationRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketReplication
func (c *S3) DeleteBucketReplicationRequest(input *DeleteBucketReplicationInput) DeleteBucketReplicationRequest {
	op := &aws.Operation{
		Name:       opDeleteBucketReplication,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?replication",
	}

	if input == nil {
		input = &DeleteBucketReplicationInput{}
	}

	output := &DeleteBucketReplicationOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return DeleteBucketReplicationRequest{Request: req, Input: input, Copy: c.DeleteBucketReplicationRequest}
}

const opDeleteBucketTagging = "DeleteBucketTagging"

// DeleteBucketTaggingRequest is a API request type for the DeleteBucketTagging API operation.
type DeleteBucketTaggingRequest struct {
	*aws.Request
	Input *DeleteBucketTaggingInput
	Copy  func(*DeleteBucketTaggingInput) DeleteBucketTaggingRequest
}

// Send marshals and sends the DeleteBucketTagging API request.
func (r DeleteBucketTaggingRequest) Send() (*DeleteBucketTaggingOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DeleteBucketTaggingOutput), nil
}

// DeleteBucketTaggingRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Deletes the tags from the bucket.
//
//    // Example sending a request using the DeleteBucketTaggingRequest method.
//    req := client.DeleteBucketTaggingRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketTagging
func (c *S3) DeleteBucketTaggingRequest(input *DeleteBucketTaggingInput) DeleteBucketTaggingRequest {
	op := &aws.Operation{
		Name:       opDeleteBucketTagging,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?tagging",
	}

	if input == nil {
		input = &DeleteBucketTaggingInput{}
	}

	output := &DeleteBucketTaggingOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return DeleteBucketTaggingRequest{Request: req, Input: input, Copy: c.DeleteBucketTaggingRequest}
}

const opDeleteBucketWebsite = "DeleteBucketWebsite"

// DeleteBucketWebsiteRequest is a API request type for the DeleteBucketWebsite API operation.
type DeleteBucketWebsiteRequest struct {
	*aws.Request
	Input *DeleteBucketWebsiteInput
	Copy  func(*DeleteBucketWebsiteInput) DeleteBucketWebsiteRequest
}

// Send marshals and sends the DeleteBucketWebsite API request.
func (r DeleteBucketWebsiteRequest) Send() (*DeleteBucketWebsiteOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DeleteBucketWebsiteOutput), nil
}

// DeleteBucketWebsiteRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// This operation removes the website configuration from the bucket.
//
//    // Example sending a request using the DeleteBucketWebsiteRequest method.
//    req := client.DeleteBucketWebsiteRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketWebsite
func (c *S3) DeleteBucketWebsiteRequest(input *DeleteBucketWebsiteInput) DeleteBucketWebsiteRequest {
	op := &aws.Operation{
		Name:       opDeleteBucketWebsite,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?website",
	}

	if input == nil {
		input = &DeleteBucketWebsiteInput{}
	}

	output := &DeleteBucketWebsiteOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return DeleteBucketWebsiteRequest{Request: req, Input: input, Copy: c.DeleteBucketWebsiteRequest}
}

const opDeleteObject = "DeleteObject"

// DeleteObjectRequest is a API request type for the DeleteObject API operation.
type DeleteObjectRequest struct {
	*aws.Request
	Input *DeleteObjectInput
	Copy  func(*DeleteObjectInput) DeleteObjectRequest
}

// Send marshals and sends the DeleteObject API request.
func (r DeleteObjectRequest) Send() (*DeleteObjectOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DeleteObjectOutput), nil
}

// DeleteObjectRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Removes the null version (if there is one) of an object and inserts a delete
// marker, which becomes the latest version of the object. If there isn't a
// null version, Amazon S3 does not remove any objects.
//
//    // Example sending a request using the DeleteObjectRequest method.
//    req := client.DeleteObjectRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObject
func (c *S3) DeleteObjectRequest(input *DeleteObjectInput) DeleteObjectRequest {
	op := &aws.Operation{
		Name:       opDeleteObject,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &DeleteObjectInput{}
	}

	output := &DeleteObjectOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return DeleteObjectRequest{Request: req, Input: input, Copy: c.DeleteObjectRequest}
}

const opDeleteObjectTagging = "DeleteObjectTagging"

// DeleteObjectTaggingRequest is a API request type for the DeleteObjectTagging API operation.
type DeleteObjectTaggingRequest struct {
	*aws.Request
	Input *DeleteObjectTaggingInput
	Copy  func(*DeleteObjectTaggingInput) DeleteObjectTaggingRequest
}

// Send marshals and sends the DeleteObjectTagging API request.
func (r DeleteObjectTaggingRequest) Send() (*DeleteObjectTaggingOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DeleteObjectTaggingOutput), nil
}

// DeleteObjectTaggingRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Removes the tag-set from an existing object.
//
//    // Example sending a request using the DeleteObjectTaggingRequest method.
//    req := client.DeleteObjectTaggingRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObjectTagging
func (c *S3) DeleteObjectTaggingRequest(input *DeleteObjectTaggingInput) DeleteObjectTaggingRequest {
	op := &aws.Operation{
		Name:       opDeleteObjectTagging,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}/{Key+}?tagging",
	}

	if input == nil {
		input = &DeleteObjectTaggingInput{}
	}

	output := &DeleteObjectTaggingOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return DeleteObjectTaggingRequest{Request: req, Input: input, Copy: c.DeleteObjectTaggingRequest}
}

const opDeleteObjects = "DeleteObjects"

// DeleteObjectsRequest is a API request type for the DeleteObjects API operation.
type DeleteObjectsRequest struct {
	*aws.Request
	Input *DeleteObjectsInput
	Copy  func(*DeleteObjectsInput) DeleteObjectsRequest
}

// Send marshals and sends the DeleteObjects API request.
func (r DeleteObjectsRequest) Send() (*DeleteObjectsOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DeleteObjectsOutput), nil
}

// DeleteObjectsRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// This operation enables you to delete multiple objects from a bucket using
// a single HTTP request. You may specify up to 1000 keys.
//
//    // Example sending a request using the DeleteObjectsRequest method.
//    req := client.DeleteObjectsRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObjects
func (c *S3) DeleteObjectsRequest(input *DeleteObjectsInput) DeleteObjectsRequest {
	op := &aws.Operation{
		Name:       opDeleteObjects,
		HTTPMethod: "POST",
		HTTPPath:   "/{Bucket}?delete",
	}

	if input == nil {
		input = &DeleteObjectsInput{}
	}

	output := &DeleteObjectsOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return DeleteObjectsRequest{Request: req, Input: input, Copy: c.DeleteObjectsRequest}
}

const opGetBucketAccelerateConfiguration = "GetBucketAccelerateConfiguration"

// GetBucketAccelerateConfigurationRequest is a API request type for the GetBucketAccelerateConfiguration API operation.
type GetBucketAccelerateConfigurationRequest struct {
	*aws.Request
	Input *GetBucketAccelerateConfigurationInput
	Copy  func(*GetBucketAccelerateConfigurationInput) GetBucketAccelerateConfigurationRequest
}

// Send marshals and sends the GetBucketAccelerateConfiguration API request.
func (r GetBucketAccelerateConfigurationRequest) Send() (*GetBucketAccelerateConfigurationOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*GetBucketAccelerateConfigurationOutput), nil
}

// GetBucketAccelerateConfigurationRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Returns the accelerate configuration of a bucket.
//
//    // Example sending a request using the GetBucketAccelerateConfigurationRequest method.
//    req := client.GetBucketAccelerateConfigurationRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAccelerateConfiguration
func (c *S3) GetBucketAccelerateConfigurationRequest(input *GetBucketAccelerateConfigurationInput) GetBucketAccelerateConfigurationRequest {
	op := &aws.Operation{
		Name:       opGetBucketAccelerateConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?accelerate",
	}

	if input == nil {
		input = &GetBucketAccelerateConfigurationInput{}
	}

	output := &GetBucketAccelerateConfigurationOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return GetBucketAccelerateConfigurationRequest{Request: req, Input: input, Copy: c.GetBucketAccelerateConfigurationRequest}
}

const opGetBucketAcl = "GetBucketAcl"

// GetBucketAclRequest is a API request type for the GetBucketAcl API operation.
type GetBucketAclRequest struct {
	*aws.Request
	Input *GetBucketAclInput
	Copy  func(*GetBucketAclInput) GetBucketAclRequest
}

// Send marshals and sends the GetBucketAcl API request.
func (r GetBucketAclRequest) Send() (*GetBucketAclOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*GetBucketAclOutput), nil
}

// GetBucketAclRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Gets the access control policy for the bucket.
//
//    // Example sending a request using the GetBucketAclRequest method.
//    req := client.GetBucketAclRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAcl
func (c *S3) GetBucketAclRequest(input *GetBucketAclInput) GetBucketAclRequest {
	op := &aws.Operation{
		Name:       opGetBucketAcl,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?acl",
	}

	if input == nil {
		input = &GetBucketAclInput{}
	}

	output := &GetBucketAclOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return GetBucketAclRequest{Request: req, Input: input, Copy: c.GetBucketAclRequest}
}

const opGetBucketAnalyticsConfiguration = "GetBucketAnalyticsConfiguration"

// GetBucketAnalyticsConfigurationRequest is a API request type for the GetBucketAnalyticsConfiguration API operation.
type GetBucketAnalyticsConfigurationRequest struct {
	*aws.Request
	Input *GetBucketAnalyticsConfigurationInput
	Copy  func(*GetBucketAnalyticsConfigurationInput) GetBucketAnalyticsConfigurationRequest
}

// Send marshals and sends the GetBucketAnalyticsConfiguration API request.
func (r GetBucketAnalyticsConfigurationRequest) Send() (*GetBucketAnalyticsConfigurationOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*GetBucketAnalyticsConfigurationOutput), nil
}

// GetBucketAnalyticsConfigurationRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Gets an analytics configuration for the bucket (specified by the analytics
// configuration ID).
//
//    // Example sending a request using the GetBucketAnalyticsConfigurationRequest method.
//    req := client.GetBucketAnalyticsConfigurationRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAnalyticsConfiguration
func (c *S3) GetBucketAnalyticsConfigurationRequest(input *GetBucketAnalyticsConfigurationInput) GetBucketAnalyticsConfigurationRequest {
	op := &aws.Operation{
		Name:       opGetBucketAnalyticsConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?analytics",
	}

	if input == nil {
		input = &GetBucketAnalyticsConfigurationInput{}
	}

	output := &GetBucketAnalyticsConfigurationOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return GetBucketAnalyticsConfigurationRequest{Request: req, Input: input, Copy: c.GetBucketAnalyticsConfigurationRequest}
}

const opGetBucketCors = "GetBucketCors"

// GetBucketCorsRequest is a API request type for the GetBucketCors API operation.
type GetBucketCorsRequest struct {
	*aws.Request
	Input *GetBucketCorsInput
	Copy  func(*GetBucketCorsInput) GetBucketCorsRequest
}

// Send marshals and sends the GetBucketCors API request.
func (r GetBucketCorsRequest) Send() (*GetBucketCorsOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*GetBucketCorsOutput), nil
}

// GetBucketCorsRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Returns the cors configuration for the bucket.
//
//    // Example sending a request using the GetBucketCorsRequest method.
//    req := client.GetBucketCorsRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketCors
func (c *S3) GetBucketCorsRequest(input *GetBucketCorsInput) GetBucketCorsRequest {
	op := &aws.Operation{
		Name:       opGetBucketCors,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?cors",
	}

	if input == nil {
		input = &GetBucketCorsInput{}
	}

	output := &GetBucketCorsOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return GetBucketCorsRequest{Request: req, Input: input, Copy: c.GetBucketCorsRequest}
}

const opGetBucketEncryption = "GetBucketEncryption"

// GetBucketEncryptionRequest is a API request type for the GetBucketEncryption API operation.
type GetBucketEncryptionRequest struct {
	*aws.Request
	Input *GetBucketEncryptionInput
	Copy  func(*GetBucketEncryptionInput) GetBucketEncryptionRequest
}

// Send marshals and sends the GetBucketEncryption API request.
func (r GetBucketEncryptionRequest) Send() (*GetBucketEncryptionOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*GetBucketEncryptionOutput), nil
}

// GetBucketEncryptionRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Returns the server-side encryption configuration of a bucket.
//
//    // Example sending a request using the GetBucketEncryptionRequest method.
//    req := client.GetBucketEncryptionRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketEncryption
func (c *S3) GetBucketEncryptionRequest(input *GetBucketEncryptionInput) GetBucketEncryptionRequest {
	op := &aws.Operation{
		Name:       opGetBucketEncryption,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?encryption",
	}

	if input == nil {
		input = &GetBucketEncryptionInput{}
	}

	output := &GetBucketEncryptionOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return GetBucketEncryptionRequest{Request: req, Input: input, Copy: c.GetBucketEncryptionRequest}
}

const opGetBucketInventoryConfiguration = "GetBucketInventoryConfiguration"

// GetBucketInventoryConfigurationRequest is a API request type for the GetBucketInventoryConfiguration API operation.
type GetBucketInventoryConfigurationRequest struct {
	*aws.Request
	Input *GetBucketInventoryConfigurationInput
	Copy  func(*GetBucketInventoryConfigurationInput) GetBucketInventoryConfigurationRequest
}

// Send marshals and sends the GetBucketInventoryConfiguration API request.
func (r GetBucketInventoryConfigurationRequest) Send() (*GetBucketInventoryConfigurationOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*GetBucketInventoryConfigurationOutput), nil
}

// GetBucketInventoryConfigurationRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Returns an inventory configuration (identified by the inventory ID) from
// the bucket.
//
//    // Example sending a request using the GetBucketInventoryConfigurationRequest method.
//    req := client.GetBucketInventoryConfigurationRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketInventoryConfiguration
func (c *S3) GetBucketInventoryConfigurationRequest(input *GetBucketInventoryConfigurationInput) GetBucketInventoryConfigurationRequest {
	op := &aws.Operation{
		Name:       opGetBucketInventoryConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?inventory",
	}

	if input == nil {
		input = &GetBucketInventoryConfigurationInput{}
	}

	output := &GetBucketInventoryConfigurationOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return GetBucketInventoryConfigurationRequest{Request: req, Input: input, Copy: c.GetBucketInventoryConfigurationRequest}
}

const opGetBucketLifecycle = "GetBucketLifecycle"

// GetBucketLifecycleRequest is a API request type for the GetBucketLifecycle API operation.
type GetBucketLifecycleRequest struct {
	*aws.Request
	Input *GetBucketLifecycleInput
	Copy  func(*GetBucketLifecycleInput) GetBucketLifecycleRequest
}

// Send marshals and sends the GetBucketLifecycle API request.
func (r GetBucketLifecycleRequest) Send() (*GetBucketLifecycleOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*GetBucketLifecycleOutput), nil
}

// GetBucketLifecycleRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Deprecated, see the GetBucketLifecycleConfiguration operation.
//
//    // Example sending a request using the GetBucketLifecycleRequest method.
//    req := client.GetBucketLifecycleRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLifecycle
func (c *S3) GetBucketLifecycleRequest(input *GetBucketLifecycleInput) GetBucketLifecycleRequest {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, GetBucketLifecycle, has been deprecated")
	}
	op := &aws.Operation{
		Name:       opGetBucketLifecycle,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?lifecycle",
	}

	if input == nil {
		input = &GetBucketLifecycleInput{}
	}

	output := &GetBucketLifecycleOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return GetBucketLifecycleRequest{Request: req, Input: input, Copy: c.GetBucketLifecycleRequest}
}

const opGetBucketLifecycleConfiguration = "GetBucketLifecycleConfiguration"

// GetBucketLifecycleConfigurationRequest is a API request type for the GetBucketLifecycleConfiguration API operation.
type GetBucketLifecycleConfigurationRequest struct {
	*aws.Request
	Input *GetBucketLifecycleConfigurationInput
	Copy  func(*GetBucketLifecycleConfigurationInput) GetBucketLifecycleConfigurationRequest
}

// Send marshals and sends the GetBucketLifecycleConfiguration API request.
func (r GetBucketLifecycleConfigurationRequest) Send() (*GetBucketLifecycleConfigurationOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*GetBucketLifecycleConfigurationOutput), nil
}

// GetBucketLifecycleConfigurationRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Returns the lifecycle configuration information set on the bucket.
//
//    // Example sending a request using the GetBucketLifecycleConfigurationRequest method.
//    req := client.GetBucketLifecycleConfigurationRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLifecycleConfiguration
func (c *S3) GetBucketLifecycleConfigurationRequest(input *GetBucketLifecycleConfigurationInput) GetBucketLifecycleConfigurationRequest {
	op := &aws.Operation{
		Name:       opGetBucketLifecycleConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?lifecycle",
	}

	if input == nil {
		input = &GetBucketLifecycleConfigurationInput{}
	}

	output := &GetBucketLifecycleConfigurationOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return GetBucketLifecycleConfigurationRequest{Request: req, Input: input, Copy: c.GetBucketLifecycleConfigurationRequest}
}

const opGetBucketLocation = "GetBucketLocation"

// GetBucketLocationRequest is a API request type for the GetBucketLocation API operation.
type GetBucketLocationRequest struct {
	*aws.Request
	Input *GetBucketLocationInput
	Copy  func(*GetBucketLocationInput) GetBucketLocationRequest
}

// Send marshals and sends the GetBucketLocation API request.
func (r GetBucketLocationRequest) Send() (*GetBucketLocationOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*GetBucketLocationOutput), nil
}

// GetBucketLocationRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Returns the region the bucket resides in.
//
//    // Example sending a request using the GetBucketLocationRequest method.
//    req := client.GetBucketLocationRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLocation
func (c *S3) GetBucketLocationRequest(input *GetBucketLocationInput) GetBucketLocationRequest {
	op := &aws.Operation{
		Name:       opGetBucketLocation,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?location",
	}

	if input == nil {
		input = &GetBucketLocationInput{}
	}

	output := &GetBucketLocationOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return GetBucketLocationRequest{Request: req, Input: input, Copy: c.GetBucketLocationRequest}
}

const opGetBucketLogging = "GetBucketLogging"

// GetBucketLoggingRequest is a API request type for the GetBucketLogging API operation.
type GetBucketLoggingRequest struct {
	*aws.Request
	Input *GetBucketLoggingInput
	Copy  func(*GetBucketLoggingInput) GetBucketLoggingRequest
}

// Send marshals and sends the GetBucketLogging API request.
func (r GetBucketLoggingRequest) Send() (*GetBucketLoggingOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*GetBucketLoggingOutput), nil
}

// GetBucketLoggingRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Returns the logging status of a bucket and the permissions users have to
// view and modify that status. To use GET, you must be the bucket owner.
//
//    // Example sending a request using the GetBucketLoggingRequest method.
//    req := client.GetBucketLoggingRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLogging
func (c *S3) GetBucketLoggingRequest(input *GetBucketLoggingInput) GetBucketLoggingRequest {
	op := &aws.Operation{
		Name:       opGetBucketLogging,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?logging",
	}

	if input == nil {
		input = &GetBucketLoggingInput{}
	}

	output := &GetBucketLoggingOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return GetBucketLoggingRequest{Request: req, Input: input, Copy: c.GetBucketLoggingRequest}
}

const opGetBucketMetricsConfiguration = "GetBucketMetricsConfiguration"

// GetBucketMetricsConfigurationRequest is a API request type for the GetBucketMetricsConfiguration API operation.
type GetBucketMetricsConfigurationRequest struct {
	*aws.Request
	Input *GetBucketMetricsConfigurationInput
	Copy  func(*GetBucketMetricsConfigurationInput) GetBucketMetricsConfigurationRequest
}

// Send marshals and sends the GetBucketMetricsConfiguration API request.
func (r GetBucketMetricsConfigurationRequest) Send() (*GetBucketMetricsConfigurationOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*GetBucketMetricsConfigurationOutput), nil
}

// GetBucketMetricsConfigurationRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Gets a metrics configuration (specified by the metrics configuration ID)
// from the bucket.
//
//    // Example sending a request using the GetBucketMetricsConfigurationRequest method.
//    req := client.GetBucketMetricsConfigurationRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketMetricsConfiguration
func (c *S3) GetBucketMetricsConfigurationRequest(input *GetBucketMetricsConfigurationInput) GetBucketMetricsConfigurationRequest {
	op := &aws.Operation{
		Name:       opGetBucketMetricsConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?metrics",
	}

	if input == nil {
		input = &GetBucketMetricsConfigurationInput{}
	}

	output := &GetBucketMetricsConfigurationOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return GetBucketMetricsConfigurationRequest{Request: req, Input: input, Copy: c.GetBucketMetricsConfigurationRequest}
}

const opGetBucketNotification = "GetBucketNotification"

// GetBucketNotificationRequest is a API request type for the GetBucketNotification API operation.
type GetBucketNotificationRequest struct {
	*aws.Request
	Input *GetBucketNotificationConfigurationInput
	Copy  func(*GetBucketNotificationConfigurationInput) GetBucketNotificationRequest
}

// Send marshals and sends the GetBucketNotification API request.
func (r GetBucketNotificationRequest) Send() (*GetBucketNotificationOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*GetBucketNotificationOutput), nil
}

// GetBucketNotificationRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Deprecated, see the GetBucketNotificationConfiguration operation.
//
//    // Example sending a request using the GetBucketNotificationRequest method.
//    req := client.GetBucketNotificationRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketNotification
func (c *S3) GetBucketNotificationRequest(input *GetBucketNotificationConfigurationInput) GetBucketNotificationRequest {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, GetBucketNotification, has been deprecated")
	}
	op := &aws.Operation{
		Name:       opGetBucketNotification,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?notification",
	}

	if input == nil {
		input = &GetBucketNotificationConfigurationInput{}
	}

	output := &GetBucketNotificationOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return GetBucketNotificationRequest{Request: req, Input: input, Copy: c.GetBucketNotificationRequest}
}

const opGetBucketNotificationConfiguration = "GetBucketNotificationConfiguration"

// GetBucketNotificationConfigurationRequest is a API request type for the GetBucketNotificationConfiguration API operation.
type GetBucketNotificationConfigurationRequest struct {
	*aws.Request
	Input *GetBucketNotificationConfigurationInput
	Copy  func(*GetBucketNotificationConfigurationInput) GetBucketNotificationConfigurationRequest
}

// Send marshals and sends the GetBucketNotificationConfiguration API request.
func (r GetBucketNotificationConfigurationRequest) Send() (*GetBucketNotificationConfigurationOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*GetBucketNotificationConfigurationOutput), nil
}

// GetBucketNotificationConfigurationRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Returns the notification configuration of a bucket.
//
//    // Example sending a request using the GetBucketNotificationConfigurationRequest method.
//    req := client.GetBucketNotificationConfigurationRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketNotificationConfiguration
func (c *S3) GetBucketNotificationConfigurationRequest(input *GetBucketNotificationConfigurationInput) GetBucketNotificationConfigurationRequest {
	op := &aws.Operation{
		Name:       opGetBucketNotificationConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?notification",
	}

	if input == nil {
		input = &GetBucketNotificationConfigurationInput{}
	}

	output := &GetBucketNotificationConfigurationOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return GetBucketNotificationConfigurationRequest{Request: req, Input: input, Copy: c.GetBucketNotificationConfigurationRequest}
}

const opGetBucketPolicy = "GetBucketPolicy"

// GetBucketPolicyRequest is a API request type for the GetBucketPolicy API operation.
type GetBucketPolicyRequest struct {
	*aws.Request
	Input *GetBucketPolicyInput
	Copy  func(*GetBucketPolicyInput) GetBucketPolicyRequest
}

// Send marshals and sends the GetBucketPolicy API request.
func (r GetBucketPolicyRequest) Send() (*GetBucketPolicyOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*GetBucketPolicyOutput), nil
}

// GetBucketPolicyRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Returns the policy of a specified bucket.
//
//    // Example sending a request using the GetBucketPolicyRequest method.
//    req := client.GetBucketPolicyRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketPolicy
func (c *S3) GetBucketPolicyRequest(input *GetBucketPolicyInput) GetBucketPolicyRequest {
	op := &aws.Operation{
		Name:       opGetBucketPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?policy",
	}

	if input == nil {
		input = &GetBucketPolicyInput{}
	}

	output := &GetBucketPolicyOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return GetBucketPolicyRequest{Request: req, Input: input, Copy: c.GetBucketPolicyRequest}
}

const opGetBucketReplication = "GetBucketReplication"

// GetBucketReplicationRequest is a API request type for the GetBucketReplication API operation.
type GetBucketReplicationRequest struct {
	*aws.Request
	Input *GetBucketReplicationInput
	Copy  func(*GetBucketReplicationInput) GetBucketReplicationRequest
}

// Send marshals and sends the GetBucketReplication API request.
func (r GetBucketReplicationRequest) Send() (*GetBucketReplicationOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*GetBucketReplicationOutput), nil
}

// GetBucketReplicationRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Returns the replication configuration of a bucket.
//
//    // Example sending a request using the GetBucketReplicationRequest method.
//    req := client.GetBucketReplicationRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketReplication
func (c *S3) GetBucketReplicationRequest(input *GetBucketReplicationInput) GetBucketReplicationRequest {
	op := &aws.Operation{
		Name:       opGetBucketReplication,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?replication",
	}

	if input == nil {
		input = &GetBucketReplicationInput{}
	}

	output := &GetBucketReplicationOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return GetBucketReplicationRequest{Request: req, Input: input, Copy: c.GetBucketReplicationRequest}
}

const opGetBucketRequestPayment = "GetBucketRequestPayment"

// GetBucketRequestPaymentRequest is a API request type for the GetBucketRequestPayment API operation.
type GetBucketRequestPaymentRequest struct {
	*aws.Request
	Input *GetBucketRequestPaymentInput
	Copy  func(*GetBucketRequestPaymentInput) GetBucketRequestPaymentRequest
}

// Send marshals and sends the GetBucketRequestPayment API request.
func (r GetBucketRequestPaymentRequest) Send() (*GetBucketRequestPaymentOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*GetBucketRequestPaymentOutput), nil
}

// GetBucketRequestPaymentRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Returns the request payment configuration of a bucket.
//
//    // Example sending a request using the GetBucketRequestPaymentRequest method.
//    req := client.GetBucketRequestPaymentRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketRequestPayment
func (c *S3) GetBucketRequestPaymentRequest(input *GetBucketRequestPaymentInput) GetBucketRequestPaymentRequest {
	op := &aws.Operation{
		Name:       opGetBucketRequestPayment,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?requestPayment",
	}

	if input == nil {
		input = &GetBucketRequestPaymentInput{}
	}

	output := &GetBucketRequestPaymentOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return GetBucketRequestPaymentRequest{Request: req, Input: input, Copy: c.GetBucketRequestPaymentRequest}
}

const opGetBucketTagging = "GetBucketTagging"

// GetBucketTaggingRequest is a API request type for the GetBucketTagging API operation.
type GetBucketTaggingRequest struct {
	*aws.Request
	Input *GetBucketTaggingInput
	Copy  func(*GetBucketTaggingInput) GetBucketTaggingRequest
}

// Send marshals and sends the GetBucketTagging API request.
func (r GetBucketTaggingRequest) Send() (*GetBucketTaggingOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*GetBucketTaggingOutput), nil
}

// GetBucketTaggingRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Returns the tag set associated with the bucket.
//
//    // Example sending a request using the GetBucketTaggingRequest method.
//    req := client.GetBucketTaggingRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketTagging
func (c *S3) GetBucketTaggingRequest(input *GetBucketTaggingInput) GetBucketTaggingRequest {
	op := &aws.Operation{
		Name:       opGetBucketTagging,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?tagging",
	}

	if input == nil {
		input = &GetBucketTaggingInput{}
	}

	output := &GetBucketTaggingOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return GetBucketTaggingRequest{Request: req, Input: input, Copy: c.GetBucketTaggingRequest}
}

const opGetBucketVersioning = "GetBucketVersioning"

// GetBucketVersioningRequest is a API request type for the GetBucketVersioning API operation.
type GetBucketVersioningRequest struct {
	*aws.Request
	Input *GetBucketVersioningInput
	Copy  func(*GetBucketVersioningInput) GetBucketVersioningRequest
}

// Send marshals and sends the GetBucketVersioning API request.
func (r GetBucketVersioningRequest) Send() (*GetBucketVersioningOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*GetBucketVersioningOutput), nil
}

// GetBucketVersioningRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Returns the versioning state of a bucket.
//
//    // Example sending a request using the GetBucketVersioningRequest method.
//    req := client.GetBucketVersioningRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketVersioning
func (c *S3) GetBucketVersioningRequest(input *GetBucketVersioningInput) GetBucketVersioningRequest {
	op := &aws.Operation{
		Name:       opGetBucketVersioning,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?versioning",
	}

	if input == nil {
		input = &GetBucketVersioningInput{}
	}

	output := &GetBucketVersioningOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return GetBucketVersioningRequest{Request: req, Input: input, Copy: c.GetBucketVersioningRequest}
}

const opGetBucketWebsite = "GetBucketWebsite"

// GetBucketWebsiteRequest is a API request type for the GetBucketWebsite API operation.
type GetBucketWebsiteRequest struct {
	*aws.Request
	Input *GetBucketWebsiteInput
	Copy  func(*GetBucketWebsiteInput) GetBucketWebsiteRequest
}

// Send marshals and sends the GetBucketWebsite API request.
func (r GetBucketWebsiteRequest) Send() (*GetBucketWebsiteOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*GetBucketWebsiteOutput), nil
}

// GetBucketWebsiteRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Returns the website configuration for a bucket.
//
//    // Example sending a request using the GetBucketWebsiteRequest method.
//    req := client.GetBucketWebsiteRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketWebsite
func (c *S3) GetBucketWebsiteRequest(input *GetBucketWebsiteInput) GetBucketWebsiteRequest {
	op := &aws.Operation{
		Name:       opGetBucketWebsite,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?website",
	}

	if input == nil {
		input = &GetBucketWebsiteInput{}
	}

	output := &GetBucketWebsiteOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return GetBucketWebsiteRequest{Request: req, Input: input, Copy: c.GetBucketWebsiteRequest}
}

const opGetObject = "GetObject"

// GetObjectRequest is a API request type for the GetObject API operation.
type GetObjectRequest struct {
	*aws.Request
	Input *GetObjectInput
	Copy  func(*GetObjectInput) GetObjectRequest
}

// Send marshals and sends the GetObject API request.
func (r GetObjectRequest) Send() (*GetObjectOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*GetObjectOutput), nil
}

// GetObjectRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Retrieves objects from Amazon S3.
//
//    // Example sending a request using the GetObjectRequest method.
//    req := client.GetObjectRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObject
func (c *S3) GetObjectRequest(input *GetObjectInput) GetObjectRequest {
	op := &aws.Operation{
		Name:       opGetObject,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &GetObjectInput{}
	}

	output := &GetObjectOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return GetObjectRequest{Request: req, Input: input, Copy: c.GetObjectRequest}
}

const opGetObjectAcl = "GetObjectAcl"

// GetObjectAclRequest is a API request type for the GetObjectAcl API operation.
type GetObjectAclRequest struct {
	*aws.Request
	Input *GetObjectAclInput
	Copy  func(*GetObjectAclInput) GetObjectAclRequest
}

// Send marshals and sends the GetObjectAcl API request.
func (r GetObjectAclRequest) Send() (*GetObjectAclOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*GetObjectAclOutput), nil
}

// GetObjectAclRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Returns the access control list (ACL) of an object.
//
//    // Example sending a request using the GetObjectAclRequest method.
//    req := client.GetObjectAclRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectAcl
func (c *S3) GetObjectAclRequest(input *GetObjectAclInput) GetObjectAclRequest {
	op := &aws.Operation{
		Name:       opGetObjectAcl,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}/{Key+}?acl",
	}

	if input == nil {
		input = &GetObjectAclInput{}
	}

	output := &GetObjectAclOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return GetObjectAclRequest{Request: req, Input: input, Copy: c.GetObjectAclRequest}
}

const opGetObjectTagging = "GetObjectTagging"

// GetObjectTaggingRequest is a API request type for the GetObjectTagging API operation.
type GetObjectTaggingRequest struct {
	*aws.Request
	Input *GetObjectTaggingInput
	Copy  func(*GetObjectTaggingInput) GetObjectTaggingRequest
}

// Send marshals and sends the GetObjectTagging API request.
func (r GetObjectTaggingRequest) Send() (*GetObjectTaggingOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*GetObjectTaggingOutput), nil
}

// GetObjectTaggingRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Returns the tag-set of an object.
//
//    // Example sending a request using the GetObjectTaggingRequest method.
//    req := client.GetObjectTaggingRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectTagging
func (c *S3) GetObjectTaggingRequest(input *GetObjectTaggingInput) GetObjectTaggingRequest {
	op := &aws.Operation{
		Name:       opGetObjectTagging,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}/{Key+}?tagging",
	}

	if input == nil {
		input = &GetObjectTaggingInput{}
	}

	output := &GetObjectTaggingOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return GetObjectTaggingRequest{Request: req, Input: input, Copy: c.GetObjectTaggingRequest}
}

const opGetObjectTorrent = "GetObjectTorrent"

// GetObjectTorrentRequest is a API request type for the GetObjectTorrent API operation.
type GetObjectTorrentRequest struct {
	*aws.Request
	Input *GetObjectTorrentInput
	Copy  func(*GetObjectTorrentInput) GetObjectTorrentRequest
}

// Send marshals and sends the GetObjectTorrent API request.
func (r GetObjectTorrentRequest) Send() (*GetObjectTorrentOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*GetObjectTorrentOutput), nil
}

// GetObjectTorrentRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Return torrent files from a bucket.
//
//    // Example sending a request using the GetObjectTorrentRequest method.
//    req := client.GetObjectTorrentRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectTorrent
func (c *S3) GetObjectTorrentRequest(input *GetObjectTorrentInput) GetObjectTorrentRequest {
	op := &aws.Operation{
		Name:       opGetObjectTorrent,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}/{Key+}?torrent",
	}

	if input == nil {
		input = &GetObjectTorrentInput{}
	}

	output := &GetObjectTorrentOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return GetObjectTorrentRequest{Request: req, Input: input, Copy: c.GetObjectTorrentRequest}
}

const opHeadBucket = "HeadBucket"

// HeadBucketRequest is a API request type for the HeadBucket API operation.
type HeadBucketRequest struct {
	*aws.Request
	Input *HeadBucketInput
	Copy  func(*HeadBucketInput) HeadBucketRequest
}

// Send marshals and sends the HeadBucket API request.
func (r HeadBucketRequest) Send() (*HeadBucketOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*HeadBucketOutput), nil
}

// HeadBucketRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// This operation is useful to determine if a bucket exists and you have permission
// to access it.
//
//    // Example sending a request using the HeadBucketRequest method.
//    req := client.HeadBucketRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/HeadBucket
func (c *S3) HeadBucketRequest(input *HeadBucketInput) HeadBucketRequest {
	op := &aws.Operation{
		Name:       opHeadBucket,
		HTTPMethod: "HEAD",
		HTTPPath:   "/{Bucket}",
	}

	if input == nil {
		input = &HeadBucketInput{}
	}

	output := &HeadBucketOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return HeadBucketRequest{Request: req, Input: input, Copy: c.HeadBucketRequest}
}

const opHeadObject = "HeadObject"

// HeadObjectRequest is a API request type for the HeadObject API operation.
type HeadObjectRequest struct {
	*aws.Request
	Input *HeadObjectInput
	Copy  func(*HeadObjectInput) HeadObjectRequest
}

// Send marshals and sends the HeadObject API request.
func (r HeadObjectRequest) Send() (*HeadObjectOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*HeadObjectOutput), nil
}

// HeadObjectRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// The HEAD operation retrieves metadata from an object without returning the
// object itself. This operation is useful if you're only interested in an object's
// metadata. To use HEAD, you must have READ access to the object.
//
// See http://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#RESTErrorResponses
// for more information on returned errors.
//
//    // Example sending a request using the HeadObjectRequest method.
//    req := client.HeadObjectRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/HeadObject
func (c *S3) HeadObjectRequest(input *HeadObjectInput) HeadObjectRequest {
	op := &aws.Operation{
		Name:       opHeadObject,
		HTTPMethod: "HEAD",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &HeadObjectInput{}
	}

	output := &HeadObjectOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return HeadObjectRequest{Request: req, Input: input, Copy: c.HeadObjectRequest}
}

const opListBucketAnalyticsConfigurations = "ListBucketAnalyticsConfigurations"

// ListBucketAnalyticsConfigurationsRequest is a API request type for the ListBucketAnalyticsConfigurations API operation.
type ListBucketAnalyticsConfigurationsRequest struct {
	*aws.Request
	Input *ListBucketAnalyticsConfigurationsInput
	Copy  func(*ListBucketAnalyticsConfigurationsInput) ListBucketAnalyticsConfigurationsRequest
}

// Send marshals and sends the ListBucketAnalyticsConfigurations API request.
func (r ListBucketAnalyticsConfigurationsRequest) Send() (*ListBucketAnalyticsConfigurationsOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*ListBucketAnalyticsConfigurationsOutput), nil
}

// ListBucketAnalyticsConfigurationsRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Lists the analytics configurations for the bucket.
//
//    // Example sending a request using the ListBucketAnalyticsConfigurationsRequest method.
//    req := client.ListBucketAnalyticsConfigurationsRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketAnalyticsConfigurations
func (c *S3) ListBucketAnalyticsConfigurationsRequest(input *ListBucketAnalyticsConfigurationsInput) ListBucketAnalyticsConfigurationsRequest {
	op := &aws.Operation{
		Name:       opListBucketAnalyticsConfigurations,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?analytics",
	}

	if input == nil {
		input = &ListBucketAnalyticsConfigurationsInput{}
	}

	output := &ListBucketAnalyticsConfigurationsOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return ListBucketAnalyticsConfigurationsRequest{Request: req, Input: input, Copy: c.ListBucketAnalyticsConfigurationsRequest}
}

const opListBucketInventoryConfigurations = "ListBucketInventoryConfigurations"

// ListBucketInventoryConfigurationsRequest is a API request type for the ListBucketInventoryConfigurations API operation.
type ListBucketInventoryConfigurationsRequest struct {
	*aws.Request
	Input *ListBucketInventoryConfigurationsInput
	Copy  func(*ListBucketInventoryConfigurationsInput) ListBucketInventoryConfigurationsRequest
}

// Send marshals and sends the ListBucketInventoryConfigurations API request.
func (r ListBucketInventoryConfigurationsRequest) Send() (*ListBucketInventoryConfigurationsOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*ListBucketInventoryConfigurationsOutput), nil
}

// ListBucketInventoryConfigurationsRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Returns a list of inventory configurations for the bucket.
//
//    // Example sending a request using the ListBucketInventoryConfigurationsRequest method.
//    req := client.ListBucketInventoryConfigurationsRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketInventoryConfigurations
func (c *S3) ListBucketInventoryConfigurationsRequest(input *ListBucketInventoryConfigurationsInput) ListBucketInventoryConfigurationsRequest {
	op := &aws.Operation{
		Name:       opListBucketInventoryConfigurations,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?inventory",
	}

	if input == nil {
		input = &ListBucketInventoryConfigurationsInput{}
	}

	output := &ListBucketInventoryConfigurationsOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return ListBucketInventoryConfigurationsRequest{Request: req, Input: input, Copy: c.ListBucketInventoryConfigurationsRequest}
}

const opListBucketMetricsConfigurations = "ListBucketMetricsConfigurations"

// ListBucketMetricsConfigurationsRequest is a API request type for the ListBucketMetricsConfigurations API operation.
type ListBucketMetricsConfigurationsRequest struct {
	*aws.Request
	Input *ListBucketMetricsConfigurationsInput
	Copy  func(*ListBucketMetricsConfigurationsInput) ListBucketMetricsConfigurationsRequest
}

// Send marshals and sends the ListBucketMetricsConfigurations API request.
func (r ListBucketMetricsConfigurationsRequest) Send() (*ListBucketMetricsConfigurationsOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*ListBucketMetricsConfigurationsOutput), nil
}

// ListBucketMetricsConfigurationsRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Lists the metrics configurations for the bucket.
//
//    // Example sending a request using the ListBucketMetricsConfigurationsRequest method.
//    req := client.ListBucketMetricsConfigurationsRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketMetricsConfigurations
func (c *S3) ListBucketMetricsConfigurationsRequest(input *ListBucketMetricsConfigurationsInput) ListBucketMetricsConfigurationsRequest {
	op := &aws.Operation{
		Name:       opListBucketMetricsConfigurations,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?metrics",
	}

	if input == nil {
		input = &ListBucketMetricsConfigurationsInput{}
	}

	output := &ListBucketMetricsConfigurationsOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return ListBucketMetricsConfigurationsRequest{Request: req, Input: input, Copy: c.ListBucketMetricsConfigurationsRequest}
}

const opListBuckets = "ListBuckets"

// ListBucketsRequest is a API request type for the ListBuckets API operation.
type ListBucketsRequest struct {
	*aws.Request
	Input *ListBucketsInput
	Copy  func(*ListBucketsInput) ListBucketsRequest
}

// Send marshals and sends the ListBuckets API request.
func (r ListBucketsRequest) Send() (*ListBucketsOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*ListBucketsOutput), nil
}

// ListBucketsRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Returns a list of all buckets owned by the authenticated sender of the request.
//
//    // Example sending a request using the ListBucketsRequest method.
//    req := client.ListBucketsRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBuckets
func (c *S3) ListBucketsRequest(input *ListBucketsInput) ListBucketsRequest {
	op := &aws.Operation{
		Name:       opListBuckets,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListBucketsInput{}
	}

	output := &ListBucketsOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return ListBucketsRequest{Request: req, Input: input, Copy: c.ListBucketsRequest}
}

const opListMultipartUploads = "ListMultipartUploads"

// ListMultipartUploadsRequest is a API request type for the ListMultipartUploads API operation.
type ListMultipartUploadsRequest struct {
	*aws.Request
	Input *ListMultipartUploadsInput
	Copy  func(*ListMultipartUploadsInput) ListMultipartUploadsRequest
}

// Send marshals and sends the ListMultipartUploads API request.
func (r ListMultipartUploadsRequest) Send() (*ListMultipartUploadsOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*ListMultipartUploadsOutput), nil
}

// ListMultipartUploadsRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// This operation lists in-progress multipart uploads.
//
//    // Example sending a request using the ListMultipartUploadsRequest method.
//    req := client.ListMultipartUploadsRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListMultipartUploads
func (c *S3) ListMultipartUploadsRequest(input *ListMultipartUploadsInput) ListMultipartUploadsRequest {
	op := &aws.Operation{
		Name:       opListMultipartUploads,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?uploads",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"KeyMarker", "UploadIdMarker"},
			OutputTokens:    []string{"NextKeyMarker", "NextUploadIdMarker"},
			LimitToken:      "MaxUploads",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListMultipartUploadsInput{}
	}

	output := &ListMultipartUploadsOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return ListMultipartUploadsRequest{Request: req, Input: input, Copy: c.ListMultipartUploadsRequest}
}

// Paginate pages iterates over the pages of a ListMultipartUploadsRequest operation,
// calling the Next method for each page. Using the paginators Next
// method will depict whether or not there are more pages.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMultipartUploads operation.
//		req := client.ListMultipartUploadsRequest(input)
//		p := req.Paginate()
//		for p.Next() {
//			page := p.CurrentPage()
//		}
//
//		if err := p.Err(); err != nil {
//			return err
//		}
//
func (p *ListMultipartUploadsRequest) Paginate(opts ...aws.Option) ListMultipartUploadsPager {
	return ListMultipartUploadsPager{
		Pager: aws.Pager{
			NewRequest: func() (*aws.Request, error) {
				var inCpy *ListMultipartUploadsInput
				if p.Input != nil {
					tmp := *p.Input
					inCpy = &tmp
				}

				req := p.Copy(inCpy)
				req.ApplyOptions(opts...)

				return req.Request, nil
			},
		},
	}
}

// ListMultipartUploadsPager is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListMultipartUploadsPager struct {
	aws.Pager
}

func (p *ListMultipartUploadsPager) CurrentPage() *ListMultipartUploadsOutput {
	return p.Pager.CurrentPage().(*ListMultipartUploadsOutput)
}

const opListObjectVersions = "ListObjectVersions"

// ListObjectVersionsRequest is a API request type for the ListObjectVersions API operation.
type ListObjectVersionsRequest struct {
	*aws.Request
	Input *ListObjectVersionsInput
	Copy  func(*ListObjectVersionsInput) ListObjectVersionsRequest
}

// Send marshals and sends the ListObjectVersions API request.
func (r ListObjectVersionsRequest) Send() (*ListObjectVersionsOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*ListObjectVersionsOutput), nil
}

// ListObjectVersionsRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Returns metadata about all of the versions of objects in a bucket.
//
//    // Example sending a request using the ListObjectVersionsRequest method.
//    req := client.ListObjectVersionsRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjectVersions
func (c *S3) ListObjectVersionsRequest(input *ListObjectVersionsInput) ListObjectVersionsRequest {
	op := &aws.Operation{
		Name:       opListObjectVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?versions",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"KeyMarker", "VersionIdMarker"},
			OutputTokens:    []string{"NextKeyMarker", "NextVersionIdMarker"},
			LimitToken:      "MaxKeys",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListObjectVersionsInput{}
	}

	output := &ListObjectVersionsOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return ListObjectVersionsRequest{Request: req, Input: input, Copy: c.ListObjectVersionsRequest}
}

// Paginate pages iterates over the pages of a ListObjectVersionsRequest operation,
// calling the Next method for each page. Using the paginators Next
// method will depict whether or not there are more pages.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListObjectVersions operation.
//		req := client.ListObjectVersionsRequest(input)
//		p := req.Paginate()
//		for p.Next() {
//			page := p.CurrentPage()
//		}
//
//		if err := p.Err(); err != nil {
//			return err
//		}
//
func (p *ListObjectVersionsRequest) Paginate(opts ...aws.Option) ListObjectVersionsPager {
	return ListObjectVersionsPager{
		Pager: aws.Pager{
			NewRequest: func() (*aws.Request, error) {
				var inCpy *ListObjectVersionsInput
				if p.Input != nil {
					tmp := *p.Input
					inCpy = &tmp
				}

				req := p.Copy(inCpy)
				req.ApplyOptions(opts...)

				return req.Request, nil
			},
		},
	}
}

// ListObjectVersionsPager is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListObjectVersionsPager struct {
	aws.Pager
}

func (p *ListObjectVersionsPager) CurrentPage() *ListObjectVersionsOutput {
	return p.Pager.CurrentPage().(*ListObjectVersionsOutput)
}

const opListObjects = "ListObjects"

// ListObjectsRequest is a API request type for the ListObjects API operation.
type ListObjectsRequest struct {
	*aws.Request
	Input *ListObjectsInput
	Copy  func(*ListObjectsInput) ListObjectsRequest
}

// Send marshals and sends the ListObjects API request.
func (r ListObjectsRequest) Send() (*ListObjectsOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*ListObjectsOutput), nil
}

// ListObjectsRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Returns some or all (up to 1000) of the objects in a bucket. You can use
// the request parameters as selection criteria to return a subset of the objects
// in a bucket.
//
//    // Example sending a request using the ListObjectsRequest method.
//    req := client.ListObjectsRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjects
func (c *S3) ListObjectsRequest(input *ListObjectsInput) ListObjectsRequest {
	op := &aws.Operation{
		Name:       opListObjects,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker || Contents[-1].Key"},
			LimitToken:      "MaxKeys",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListObjectsInput{}
	}

	output := &ListObjectsOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return ListObjectsRequest{Request: req, Input: input, Copy: c.ListObjectsRequest}
}

// Paginate pages iterates over the pages of a ListObjectsRequest operation,
// calling the Next method for each page. Using the paginators Next
// method will depict whether or not there are more pages.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListObjects operation.
//		req := client.ListObjectsRequest(input)
//		p := req.Paginate()
//		for p.Next() {
//			page := p.CurrentPage()
//		}
//
//		if err := p.Err(); err != nil {
//			return err
//		}
//
func (p *ListObjectsRequest) Paginate(opts ...aws.Option) ListObjectsPager {
	return ListObjectsPager{
		Pager: aws.Pager{
			NewRequest: func() (*aws.Request, error) {
				var inCpy *ListObjectsInput
				if p.Input != nil {
					tmp := *p.Input
					inCpy = &tmp
				}

				req := p.Copy(inCpy)
				req.ApplyOptions(opts...)

				return req.Request, nil
			},
		},
	}
}

// ListObjectsPager is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListObjectsPager struct {
	aws.Pager
}

func (p *ListObjectsPager) CurrentPage() *ListObjectsOutput {
	return p.Pager.CurrentPage().(*ListObjectsOutput)
}

const opListObjectsV2 = "ListObjectsV2"

// ListObjectsV2Request is a API request type for the ListObjectsV2 API operation.
type ListObjectsV2Request struct {
	*aws.Request
	Input *ListObjectsV2Input
	Copy  func(*ListObjectsV2Input) ListObjectsV2Request
}

// Send marshals and sends the ListObjectsV2 API request.
func (r ListObjectsV2Request) Send() (*ListObjectsV2Output, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*ListObjectsV2Output), nil
}

// ListObjectsV2Request returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Returns some or all (up to 1000) of the objects in a bucket. You can use
// the request parameters as selection criteria to return a subset of the objects
// in a bucket. Note: ListObjectsV2 is the revised List Objects API and we recommend
// you use this revised API for new application development.
//
//    // Example sending a request using the ListObjectsV2Request method.
//    req := client.ListObjectsV2Request(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjectsV2
func (c *S3) ListObjectsV2Request(input *ListObjectsV2Input) ListObjectsV2Request {
	op := &aws.Operation{
		Name:       opListObjectsV2,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?list-type=2",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"ContinuationToken"},
			OutputTokens:    []string{"NextContinuationToken"},
			LimitToken:      "MaxKeys",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListObjectsV2Input{}
	}

	output := &ListObjectsV2Output{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return ListObjectsV2Request{Request: req, Input: input, Copy: c.ListObjectsV2Request}
}

// Paginate pages iterates over the pages of a ListObjectsV2Request operation,
// calling the Next method for each page. Using the paginators Next
// method will depict whether or not there are more pages.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListObjectsV2 operation.
//		req := client.ListObjectsV2Request(input)
//		p := req.Paginate()
//		for p.Next() {
//			page := p.CurrentPage()
//		}
//
//		if err := p.Err(); err != nil {
//			return err
//		}
//
func (p *ListObjectsV2Request) Paginate(opts ...aws.Option) ListObjectsV2Pager {
	return ListObjectsV2Pager{
		Pager: aws.Pager{
			NewRequest: func() (*aws.Request, error) {
				var inCpy *ListObjectsV2Input
				if p.Input != nil {
					tmp := *p.Input
					inCpy = &tmp
				}

				req := p.Copy(inCpy)
				req.ApplyOptions(opts...)

				return req.Request, nil
			},
		},
	}
}

// ListObjectsV2Pager is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListObjectsV2Pager struct {
	aws.Pager
}

func (p *ListObjectsV2Pager) CurrentPage() *ListObjectsV2Output {
	return p.Pager.CurrentPage().(*ListObjectsV2Output)
}

const opListParts = "ListParts"

// ListPartsRequest is a API request type for the ListParts API operation.
type ListPartsRequest struct {
	*aws.Request
	Input *ListPartsInput
	Copy  func(*ListPartsInput) ListPartsRequest
}

// Send marshals and sends the ListParts API request.
func (r ListPartsRequest) Send() (*ListPartsOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*ListPartsOutput), nil
}

// ListPartsRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Lists the parts that have been uploaded for a specific multipart upload.
//
//    // Example sending a request using the ListPartsRequest method.
//    req := client.ListPartsRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListParts
func (c *S3) ListPartsRequest(input *ListPartsInput) ListPartsRequest {
	op := &aws.Operation{
		Name:       opListParts,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}/{Key+}",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"PartNumberMarker"},
			OutputTokens:    []string{"NextPartNumberMarker"},
			LimitToken:      "MaxParts",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListPartsInput{}
	}

	output := &ListPartsOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return ListPartsRequest{Request: req, Input: input, Copy: c.ListPartsRequest}
}

// Paginate pages iterates over the pages of a ListPartsRequest operation,
// calling the Next method for each page. Using the paginators Next
// method will depict whether or not there are more pages.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListParts operation.
//		req := client.ListPartsRequest(input)
//		p := req.Paginate()
//		for p.Next() {
//			page := p.CurrentPage()
//		}
//
//		if err := p.Err(); err != nil {
//			return err
//		}
//
func (p *ListPartsRequest) Paginate(opts ...aws.Option) ListPartsPager {
	return ListPartsPager{
		Pager: aws.Pager{
			NewRequest: func() (*aws.Request, error) {
				var inCpy *ListPartsInput
				if p.Input != nil {
					tmp := *p.Input
					inCpy = &tmp
				}

				req := p.Copy(inCpy)
				req.ApplyOptions(opts...)

				return req.Request, nil
			},
		},
	}
}

// ListPartsPager is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListPartsPager struct {
	aws.Pager
}

func (p *ListPartsPager) CurrentPage() *ListPartsOutput {
	return p.Pager.CurrentPage().(*ListPartsOutput)
}

const opPutBucketAccelerateConfiguration = "PutBucketAccelerateConfiguration"

// PutBucketAccelerateConfigurationRequest is a API request type for the PutBucketAccelerateConfiguration API operation.
type PutBucketAccelerateConfigurationRequest struct {
	*aws.Request
	Input *PutBucketAccelerateConfigurationInput
	Copy  func(*PutBucketAccelerateConfigurationInput) PutBucketAccelerateConfigurationRequest
}

// Send marshals and sends the PutBucketAccelerateConfiguration API request.
func (r PutBucketAccelerateConfigurationRequest) Send() (*PutBucketAccelerateConfigurationOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*PutBucketAccelerateConfigurationOutput), nil
}

// PutBucketAccelerateConfigurationRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Sets the accelerate configuration of an existing bucket.
//
//    // Example sending a request using the PutBucketAccelerateConfigurationRequest method.
//    req := client.PutBucketAccelerateConfigurationRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketAccelerateConfiguration
func (c *S3) PutBucketAccelerateConfigurationRequest(input *PutBucketAccelerateConfigurationInput) PutBucketAccelerateConfigurationRequest {
	op := &aws.Operation{
		Name:       opPutBucketAccelerateConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?accelerate",
	}

	if input == nil {
		input = &PutBucketAccelerateConfigurationInput{}
	}

	output := &PutBucketAccelerateConfigurationOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return PutBucketAccelerateConfigurationRequest{Request: req, Input: input, Copy: c.PutBucketAccelerateConfigurationRequest}
}

const opPutBucketAcl = "PutBucketAcl"

// PutBucketAclRequest is a API request type for the PutBucketAcl API operation.
type PutBucketAclRequest struct {
	*aws.Request
	Input *PutBucketAclInput
	Copy  func(*PutBucketAclInput) PutBucketAclRequest
}

// Send marshals and sends the PutBucketAcl API request.
func (r PutBucketAclRequest) Send() (*PutBucketAclOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*PutBucketAclOutput), nil
}

// PutBucketAclRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Sets the permissions on a bucket using access control lists (ACL).
//
//    // Example sending a request using the PutBucketAclRequest method.
//    req := client.PutBucketAclRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketAcl
func (c *S3) PutBucketAclRequest(input *PutBucketAclInput) PutBucketAclRequest {
	op := &aws.Operation{
		Name:       opPutBucketAcl,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?acl",
	}

	if input == nil {
		input = &PutBucketAclInput{}
	}

	output := &PutBucketAclOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return PutBucketAclRequest{Request: req, Input: input, Copy: c.PutBucketAclRequest}
}

const opPutBucketAnalyticsConfiguration = "PutBucketAnalyticsConfiguration"

// PutBucketAnalyticsConfigurationRequest is a API request type for the PutBucketAnalyticsConfiguration API operation.
type PutBucketAnalyticsConfigurationRequest struct {
	*aws.Request
	Input *PutBucketAnalyticsConfigurationInput
	Copy  func(*PutBucketAnalyticsConfigurationInput) PutBucketAnalyticsConfigurationRequest
}

// Send marshals and sends the PutBucketAnalyticsConfiguration API request.
func (r PutBucketAnalyticsConfigurationRequest) Send() (*PutBucketAnalyticsConfigurationOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*PutBucketAnalyticsConfigurationOutput), nil
}

// PutBucketAnalyticsConfigurationRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Sets an analytics configuration for the bucket (specified by the analytics
// configuration ID).
//
//    // Example sending a request using the PutBucketAnalyticsConfigurationRequest method.
//    req := client.PutBucketAnalyticsConfigurationRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketAnalyticsConfiguration
func (c *S3) PutBucketAnalyticsConfigurationRequest(input *PutBucketAnalyticsConfigurationInput) PutBucketAnalyticsConfigurationRequest {
	op := &aws.Operation{
		Name:       opPutBucketAnalyticsConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?analytics",
	}

	if input == nil {
		input = &PutBucketAnalyticsConfigurationInput{}
	}

	output := &PutBucketAnalyticsConfigurationOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return PutBucketAnalyticsConfigurationRequest{Request: req, Input: input, Copy: c.PutBucketAnalyticsConfigurationRequest}
}

const opPutBucketCors = "PutBucketCors"

// PutBucketCorsRequest is a API request type for the PutBucketCors API operation.
type PutBucketCorsRequest struct {
	*aws.Request
	Input *PutBucketCorsInput
	Copy  func(*PutBucketCorsInput) PutBucketCorsRequest
}

// Send marshals and sends the PutBucketCors API request.
func (r PutBucketCorsRequest) Send() (*PutBucketCorsOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*PutBucketCorsOutput), nil
}

// PutBucketCorsRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Sets the cors configuration for a bucket.
//
//    // Example sending a request using the PutBucketCorsRequest method.
//    req := client.PutBucketCorsRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketCors
func (c *S3) PutBucketCorsRequest(input *PutBucketCorsInput) PutBucketCorsRequest {
	op := &aws.Operation{
		Name:       opPutBucketCors,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?cors",
	}

	if input == nil {
		input = &PutBucketCorsInput{}
	}

	output := &PutBucketCorsOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return PutBucketCorsRequest{Request: req, Input: input, Copy: c.PutBucketCorsRequest}
}

const opPutBucketEncryption = "PutBucketEncryption"

// PutBucketEncryptionRequest is a API request type for the PutBucketEncryption API operation.
type PutBucketEncryptionRequest struct {
	*aws.Request
	Input *PutBucketEncryptionInput
	Copy  func(*PutBucketEncryptionInput) PutBucketEncryptionRequest
}

// Send marshals and sends the PutBucketEncryption API request.
func (r PutBucketEncryptionRequest) Send() (*PutBucketEncryptionOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*PutBucketEncryptionOutput), nil
}

// PutBucketEncryptionRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Creates a new server-side encryption configuration (or replaces an existing
// one, if present).
//
//    // Example sending a request using the PutBucketEncryptionRequest method.
//    req := client.PutBucketEncryptionRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketEncryption
func (c *S3) PutBucketEncryptionRequest(input *PutBucketEncryptionInput) PutBucketEncryptionRequest {
	op := &aws.Operation{
		Name:       opPutBucketEncryption,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?encryption",
	}

	if input == nil {
		input = &PutBucketEncryptionInput{}
	}

	output := &PutBucketEncryptionOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return PutBucketEncryptionRequest{Request: req, Input: input, Copy: c.PutBucketEncryptionRequest}
}

const opPutBucketInventoryConfiguration = "PutBucketInventoryConfiguration"

// PutBucketInventoryConfigurationRequest is a API request type for the PutBucketInventoryConfiguration API operation.
type PutBucketInventoryConfigurationRequest struct {
	*aws.Request
	Input *PutBucketInventoryConfigurationInput
	Copy  func(*PutBucketInventoryConfigurationInput) PutBucketInventoryConfigurationRequest
}

// Send marshals and sends the PutBucketInventoryConfiguration API request.
func (r PutBucketInventoryConfigurationRequest) Send() (*PutBucketInventoryConfigurationOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*PutBucketInventoryConfigurationOutput), nil
}

// PutBucketInventoryConfigurationRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Adds an inventory configuration (identified by the inventory ID) from the
// bucket.
//
//    // Example sending a request using the PutBucketInventoryConfigurationRequest method.
//    req := client.PutBucketInventoryConfigurationRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketInventoryConfiguration
func (c *S3) PutBucketInventoryConfigurationRequest(input *PutBucketInventoryConfigurationInput) PutBucketInventoryConfigurationRequest {
	op := &aws.Operation{
		Name:       opPutBucketInventoryConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?inventory",
	}

	if input == nil {
		input = &PutBucketInventoryConfigurationInput{}
	}

	output := &PutBucketInventoryConfigurationOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return PutBucketInventoryConfigurationRequest{Request: req, Input: input, Copy: c.PutBucketInventoryConfigurationRequest}
}

const opPutBucketLifecycle = "PutBucketLifecycle"

// PutBucketLifecycleRequest is a API request type for the PutBucketLifecycle API operation.
type PutBucketLifecycleRequest struct {
	*aws.Request
	Input *PutBucketLifecycleInput
	Copy  func(*PutBucketLifecycleInput) PutBucketLifecycleRequest
}

// Send marshals and sends the PutBucketLifecycle API request.
func (r PutBucketLifecycleRequest) Send() (*PutBucketLifecycleOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*PutBucketLifecycleOutput), nil
}

// PutBucketLifecycleRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Deprecated, see the PutBucketLifecycleConfiguration operation.
//
//    // Example sending a request using the PutBucketLifecycleRequest method.
//    req := client.PutBucketLifecycleRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLifecycle
func (c *S3) PutBucketLifecycleRequest(input *PutBucketLifecycleInput) PutBucketLifecycleRequest {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, PutBucketLifecycle, has been deprecated")
	}
	op := &aws.Operation{
		Name:       opPutBucketLifecycle,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?lifecycle",
	}

	if input == nil {
		input = &PutBucketLifecycleInput{}
	}

	output := &PutBucketLifecycleOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return PutBucketLifecycleRequest{Request: req, Input: input, Copy: c.PutBucketLifecycleRequest}
}

const opPutBucketLifecycleConfiguration = "PutBucketLifecycleConfiguration"

// PutBucketLifecycleConfigurationRequest is a API request type for the PutBucketLifecycleConfiguration API operation.
type PutBucketLifecycleConfigurationRequest struct {
	*aws.Request
	Input *PutBucketLifecycleConfigurationInput
	Copy  func(*PutBucketLifecycleConfigurationInput) PutBucketLifecycleConfigurationRequest
}

// Send marshals and sends the PutBucketLifecycleConfiguration API request.
func (r PutBucketLifecycleConfigurationRequest) Send() (*PutBucketLifecycleConfigurationOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*PutBucketLifecycleConfigurationOutput), nil
}

// PutBucketLifecycleConfigurationRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Sets lifecycle configuration for your bucket. If a lifecycle configuration
// exists, it replaces it.
//
//    // Example sending a request using the PutBucketLifecycleConfigurationRequest method.
//    req := client.PutBucketLifecycleConfigurationRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLifecycleConfiguration
func (c *S3) PutBucketLifecycleConfigurationRequest(input *PutBucketLifecycleConfigurationInput) PutBucketLifecycleConfigurationRequest {
	op := &aws.Operation{
		Name:       opPutBucketLifecycleConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?lifecycle",
	}

	if input == nil {
		input = &PutBucketLifecycleConfigurationInput{}
	}

	output := &PutBucketLifecycleConfigurationOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return PutBucketLifecycleConfigurationRequest{Request: req, Input: input, Copy: c.PutBucketLifecycleConfigurationRequest}
}

const opPutBucketLogging = "PutBucketLogging"

// PutBucketLoggingRequest is a API request type for the PutBucketLogging API operation.
type PutBucketLoggingRequest struct {
	*aws.Request
	Input *PutBucketLoggingInput
	Copy  func(*PutBucketLoggingInput) PutBucketLoggingRequest
}

// Send marshals and sends the PutBucketLogging API request.
func (r PutBucketLoggingRequest) Send() (*PutBucketLoggingOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*PutBucketLoggingOutput), nil
}

// PutBucketLoggingRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Set the logging parameters for a bucket and to specify permissions for who
// can view and modify the logging parameters. To set the logging status of
// a bucket, you must be the bucket owner.
//
//    // Example sending a request using the PutBucketLoggingRequest method.
//    req := client.PutBucketLoggingRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLogging
func (c *S3) PutBucketLoggingRequest(input *PutBucketLoggingInput) PutBucketLoggingRequest {
	op := &aws.Operation{
		Name:       opPutBucketLogging,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?logging",
	}

	if input == nil {
		input = &PutBucketLoggingInput{}
	}

	output := &PutBucketLoggingOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return PutBucketLoggingRequest{Request: req, Input: input, Copy: c.PutBucketLoggingRequest}
}

const opPutBucketMetricsConfiguration = "PutBucketMetricsConfiguration"

// PutBucketMetricsConfigurationRequest is a API request type for the PutBucketMetricsConfiguration API operation.
type PutBucketMetricsConfigurationRequest struct {
	*aws.Request
	Input *PutBucketMetricsConfigurationInput
	Copy  func(*PutBucketMetricsConfigurationInput) PutBucketMetricsConfigurationRequest
}

// Send marshals and sends the PutBucketMetricsConfiguration API request.
func (r PutBucketMetricsConfigurationRequest) Send() (*PutBucketMetricsConfigurationOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*PutBucketMetricsConfigurationOutput), nil
}

// PutBucketMetricsConfigurationRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Sets a metrics configuration (specified by the metrics configuration ID)
// for the bucket.
//
//    // Example sending a request using the PutBucketMetricsConfigurationRequest method.
//    req := client.PutBucketMetricsConfigurationRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketMetricsConfiguration
func (c *S3) PutBucketMetricsConfigurationRequest(input *PutBucketMetricsConfigurationInput) PutBucketMetricsConfigurationRequest {
	op := &aws.Operation{
		Name:       opPutBucketMetricsConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?metrics",
	}

	if input == nil {
		input = &PutBucketMetricsConfigurationInput{}
	}

	output := &PutBucketMetricsConfigurationOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return PutBucketMetricsConfigurationRequest{Request: req, Input: input, Copy: c.PutBucketMetricsConfigurationRequest}
}

const opPutBucketNotification = "PutBucketNotification"

// PutBucketNotificationRequest is a API request type for the PutBucketNotification API operation.
type PutBucketNotificationRequest struct {
	*aws.Request
	Input *PutBucketNotificationInput
	Copy  func(*PutBucketNotificationInput) PutBucketNotificationRequest
}

// Send marshals and sends the PutBucketNotification API request.
func (r PutBucketNotificationRequest) Send() (*PutBucketNotificationOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*PutBucketNotificationOutput), nil
}

// PutBucketNotificationRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Deprecated, see the PutBucketNotificationConfiguraiton operation.
//
//    // Example sending a request using the PutBucketNotificationRequest method.
//    req := client.PutBucketNotificationRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketNotification
func (c *S3) PutBucketNotificationRequest(input *PutBucketNotificationInput) PutBucketNotificationRequest {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, PutBucketNotification, has been deprecated")
	}
	op := &aws.Operation{
		Name:       opPutBucketNotification,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?notification",
	}

	if input == nil {
		input = &PutBucketNotificationInput{}
	}

	output := &PutBucketNotificationOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return PutBucketNotificationRequest{Request: req, Input: input, Copy: c.PutBucketNotificationRequest}
}

const opPutBucketNotificationConfiguration = "PutBucketNotificationConfiguration"

// PutBucketNotificationConfigurationRequest is a API request type for the PutBucketNotificationConfiguration API operation.
type PutBucketNotificationConfigurationRequest struct {
	*aws.Request
	Input *PutBucketNotificationConfigurationInput
	Copy  func(*PutBucketNotificationConfigurationInput) PutBucketNotificationConfigurationRequest
}

// Send marshals and sends the PutBucketNotificationConfiguration API request.
func (r PutBucketNotificationConfigurationRequest) Send() (*PutBucketNotificationConfigurationOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*PutBucketNotificationConfigurationOutput), nil
}

// PutBucketNotificationConfigurationRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Enables notifications of specified events for a bucket.
//
//    // Example sending a request using the PutBucketNotificationConfigurationRequest method.
//    req := client.PutBucketNotificationConfigurationRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketNotificationConfiguration
func (c *S3) PutBucketNotificationConfigurationRequest(input *PutBucketNotificationConfigurationInput) PutBucketNotificationConfigurationRequest {
	op := &aws.Operation{
		Name:       opPutBucketNotificationConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?notification",
	}

	if input == nil {
		input = &PutBucketNotificationConfigurationInput{}
	}

	output := &PutBucketNotificationConfigurationOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return PutBucketNotificationConfigurationRequest{Request: req, Input: input, Copy: c.PutBucketNotificationConfigurationRequest}
}

const opPutBucketPolicy = "PutBucketPolicy"

// PutBucketPolicyRequest is a API request type for the PutBucketPolicy API operation.
type PutBucketPolicyRequest struct {
	*aws.Request
	Input *PutBucketPolicyInput
	Copy  func(*PutBucketPolicyInput) PutBucketPolicyRequest
}

// Send marshals and sends the PutBucketPolicy API request.
func (r PutBucketPolicyRequest) Send() (*PutBucketPolicyOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*PutBucketPolicyOutput), nil
}

// PutBucketPolicyRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Replaces a policy on a bucket. If the bucket already has a policy, the one
// in this request completely replaces it.
//
//    // Example sending a request using the PutBucketPolicyRequest method.
//    req := client.PutBucketPolicyRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketPolicy
func (c *S3) PutBucketPolicyRequest(input *PutBucketPolicyInput) PutBucketPolicyRequest {
	op := &aws.Operation{
		Name:       opPutBucketPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?policy",
	}

	if input == nil {
		input = &PutBucketPolicyInput{}
	}

	output := &PutBucketPolicyOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return PutBucketPolicyRequest{Request: req, Input: input, Copy: c.PutBucketPolicyRequest}
}

const opPutBucketReplication = "PutBucketReplication"

// PutBucketReplicationRequest is a API request type for the PutBucketReplication API operation.
type PutBucketReplicationRequest struct {
	*aws.Request
	Input *PutBucketReplicationInput
	Copy  func(*PutBucketReplicationInput) PutBucketReplicationRequest
}

// Send marshals and sends the PutBucketReplication API request.
func (r PutBucketReplicationRequest) Send() (*PutBucketReplicationOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*PutBucketReplicationOutput), nil
}

// PutBucketReplicationRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Creates a new replication configuration (or replaces an existing one, if
// present). For more information, see Cross-Region Replication (CRR) ( https://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html)
// in the Amazon S3 Developer Guide.
//
//    // Example sending a request using the PutBucketReplicationRequest method.
//    req := client.PutBucketReplicationRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketReplication
func (c *S3) PutBucketReplicationRequest(input *PutBucketReplicationInput) PutBucketReplicationRequest {
	op := &aws.Operation{
		Name:       opPutBucketReplication,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?replication",
	}

	if input == nil {
		input = &PutBucketReplicationInput{}
	}

	output := &PutBucketReplicationOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return PutBucketReplicationRequest{Request: req, Input: input, Copy: c.PutBucketReplicationRequest}
}

const opPutBucketRequestPayment = "PutBucketRequestPayment"

// PutBucketRequestPaymentRequest is a API request type for the PutBucketRequestPayment API operation.
type PutBucketRequestPaymentRequest struct {
	*aws.Request
	Input *PutBucketRequestPaymentInput
	Copy  func(*PutBucketRequestPaymentInput) PutBucketRequestPaymentRequest
}

// Send marshals and sends the PutBucketRequestPayment API request.
func (r PutBucketRequestPaymentRequest) Send() (*PutBucketRequestPaymentOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*PutBucketRequestPaymentOutput), nil
}

// PutBucketRequestPaymentRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Sets the request payment configuration for a bucket. By default, the bucket
// owner pays for downloads from the bucket. This configuration parameter enables
// the bucket owner (only) to specify that the person requesting the download
// will be charged for the download. Documentation on requester pays buckets
// can be found at http://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html
//
//    // Example sending a request using the PutBucketRequestPaymentRequest method.
//    req := client.PutBucketRequestPaymentRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketRequestPayment
func (c *S3) PutBucketRequestPaymentRequest(input *PutBucketRequestPaymentInput) PutBucketRequestPaymentRequest {
	op := &aws.Operation{
		Name:       opPutBucketRequestPayment,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?requestPayment",
	}

	if input == nil {
		input = &PutBucketRequestPaymentInput{}
	}

	output := &PutBucketRequestPaymentOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return PutBucketRequestPaymentRequest{Request: req, Input: input, Copy: c.PutBucketRequestPaymentRequest}
}

const opPutBucketTagging = "PutBucketTagging"

// PutBucketTaggingRequest is a API request type for the PutBucketTagging API operation.
type PutBucketTaggingRequest struct {
	*aws.Request
	Input *PutBucketTaggingInput
	Copy  func(*PutBucketTaggingInput) PutBucketTaggingRequest
}

// Send marshals and sends the PutBucketTagging API request.
func (r PutBucketTaggingRequest) Send() (*PutBucketTaggingOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*PutBucketTaggingOutput), nil
}

// PutBucketTaggingRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Sets the tags for a bucket.
//
//    // Example sending a request using the PutBucketTaggingRequest method.
//    req := client.PutBucketTaggingRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketTagging
func (c *S3) PutBucketTaggingRequest(input *PutBucketTaggingInput) PutBucketTaggingRequest {
	op := &aws.Operation{
		Name:       opPutBucketTagging,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?tagging",
	}

	if input == nil {
		input = &PutBucketTaggingInput{}
	}

	output := &PutBucketTaggingOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return PutBucketTaggingRequest{Request: req, Input: input, Copy: c.PutBucketTaggingRequest}
}

const opPutBucketVersioning = "PutBucketVersioning"

// PutBucketVersioningRequest is a API request type for the PutBucketVersioning API operation.
type PutBucketVersioningRequest struct {
	*aws.Request
	Input *PutBucketVersioningInput
	Copy  func(*PutBucketVersioningInput) PutBucketVersioningRequest
}

// Send marshals and sends the PutBucketVersioning API request.
func (r PutBucketVersioningRequest) Send() (*PutBucketVersioningOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*PutBucketVersioningOutput), nil
}

// PutBucketVersioningRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Sets the versioning state of an existing bucket. To set the versioning state,
// you must be the bucket owner.
//
//    // Example sending a request using the PutBucketVersioningRequest method.
//    req := client.PutBucketVersioningRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketVersioning
func (c *S3) PutBucketVersioningRequest(input *PutBucketVersioningInput) PutBucketVersioningRequest {
	op := &aws.Operation{
		Name:       opPutBucketVersioning,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?versioning",
	}

	if input == nil {
		input = &PutBucketVersioningInput{}
	}

	output := &PutBucketVersioningOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return PutBucketVersioningRequest{Request: req, Input: input, Copy: c.PutBucketVersioningRequest}
}

const opPutBucketWebsite = "PutBucketWebsite"

// PutBucketWebsiteRequest is a API request type for the PutBucketWebsite API operation.
type PutBucketWebsiteRequest struct {
	*aws.Request
	Input *PutBucketWebsiteInput
	Copy  func(*PutBucketWebsiteInput) PutBucketWebsiteRequest
}

// Send marshals and sends the PutBucketWebsite API request.
func (r PutBucketWebsiteRequest) Send() (*PutBucketWebsiteOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*PutBucketWebsiteOutput), nil
}

// PutBucketWebsiteRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Set the website configuration for a bucket.
//
//    // Example sending a request using the PutBucketWebsiteRequest method.
//    req := client.PutBucketWebsiteRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketWebsite
func (c *S3) PutBucketWebsiteRequest(input *PutBucketWebsiteInput) PutBucketWebsiteRequest {
	op := &aws.Operation{
		Name:       opPutBucketWebsite,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?website",
	}

	if input == nil {
		input = &PutBucketWebsiteInput{}
	}

	output := &PutBucketWebsiteOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return PutBucketWebsiteRequest{Request: req, Input: input, Copy: c.PutBucketWebsiteRequest}
}

const opPutObject = "PutObject"

// PutObjectRequest is a API request type for the PutObject API operation.
type PutObjectRequest struct {
	*aws.Request
	Input *PutObjectInput
	Copy  func(*PutObjectInput) PutObjectRequest
}

// Send marshals and sends the PutObject API request.
func (r PutObjectRequest) Send() (*PutObjectOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*PutObjectOutput), nil
}

// PutObjectRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Adds an object to a bucket.
//
//    // Example sending a request using the PutObjectRequest method.
//    req := client.PutObjectRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObject
func (c *S3) PutObjectRequest(input *PutObjectInput) PutObjectRequest {
	op := &aws.Operation{
		Name:       opPutObject,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &PutObjectInput{}
	}

	output := &PutObjectOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return PutObjectRequest{Request: req, Input: input, Copy: c.PutObjectRequest}
}

const opPutObjectAcl = "PutObjectAcl"

// PutObjectAclRequest is a API request type for the PutObjectAcl API operation.
type PutObjectAclRequest struct {
	*aws.Request
	Input *PutObjectAclInput
	Copy  func(*PutObjectAclInput) PutObjectAclRequest
}

// Send marshals and sends the PutObjectAcl API request.
func (r PutObjectAclRequest) Send() (*PutObjectAclOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*PutObjectAclOutput), nil
}

// PutObjectAclRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// uses the acl subresource to set the access control list (ACL) permissions
// for an object that already exists in a bucket
//
//    // Example sending a request using the PutObjectAclRequest method.
//    req := client.PutObjectAclRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectAcl
func (c *S3) PutObjectAclRequest(input *PutObjectAclInput) PutObjectAclRequest {
	op := &aws.Operation{
		Name:       opPutObjectAcl,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}?acl",
	}

	if input == nil {
		input = &PutObjectAclInput{}
	}

	output := &PutObjectAclOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return PutObjectAclRequest{Request: req, Input: input, Copy: c.PutObjectAclRequest}
}

const opPutObjectTagging = "PutObjectTagging"

// PutObjectTaggingRequest is a API request type for the PutObjectTagging API operation.
type PutObjectTaggingRequest struct {
	*aws.Request
	Input *PutObjectTaggingInput
	Copy  func(*PutObjectTaggingInput) PutObjectTaggingRequest
}

// Send marshals and sends the PutObjectTagging API request.
func (r PutObjectTaggingRequest) Send() (*PutObjectTaggingOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*PutObjectTaggingOutput), nil
}

// PutObjectTaggingRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Sets the supplied tag-set to an object that already exists in a bucket
//
//    // Example sending a request using the PutObjectTaggingRequest method.
//    req := client.PutObjectTaggingRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectTagging
func (c *S3) PutObjectTaggingRequest(input *PutObjectTaggingInput) PutObjectTaggingRequest {
	op := &aws.Operation{
		Name:       opPutObjectTagging,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}?tagging",
	}

	if input == nil {
		input = &PutObjectTaggingInput{}
	}

	output := &PutObjectTaggingOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return PutObjectTaggingRequest{Request: req, Input: input, Copy: c.PutObjectTaggingRequest}
}

const opRestoreObject = "RestoreObject"

// RestoreObjectRequest is a API request type for the RestoreObject API operation.
type RestoreObjectRequest struct {
	*aws.Request
	Input *RestoreObjectInput
	Copy  func(*RestoreObjectInput) RestoreObjectRequest
}

// Send marshals and sends the RestoreObject API request.
func (r RestoreObjectRequest) Send() (*RestoreObjectOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*RestoreObjectOutput), nil
}

// RestoreObjectRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Restores an archived copy of an object back into Amazon S3
//
//    // Example sending a request using the RestoreObjectRequest method.
//    req := client.RestoreObjectRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/RestoreObject
func (c *S3) RestoreObjectRequest(input *RestoreObjectInput) RestoreObjectRequest {
	op := &aws.Operation{
		Name:       opRestoreObject,
		HTTPMethod: "POST",
		HTTPPath:   "/{Bucket}/{Key+}?restore",
	}

	if input == nil {
		input = &RestoreObjectInput{}
	}

	output := &RestoreObjectOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return RestoreObjectRequest{Request: req, Input: input, Copy: c.RestoreObjectRequest}
}

const opUploadPart = "UploadPart"

// UploadPartRequest is a API request type for the UploadPart API operation.
type UploadPartRequest struct {
	*aws.Request
	Input *UploadPartInput
	Copy  func(*UploadPartInput) UploadPartRequest
}

// Send marshals and sends the UploadPart API request.
func (r UploadPartRequest) Send() (*UploadPartOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*UploadPartOutput), nil
}

// UploadPartRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Uploads a part in a multipart upload.
//
// Note: After you initiate multipart upload and upload one or more parts, you
// must either complete or abort multipart upload in order to stop getting charged
// for storage of the uploaded parts. Only after you either complete or abort
// multipart upload, Amazon S3 frees up the parts storage and stops charging
// you for the parts storage.
//
//    // Example sending a request using the UploadPartRequest method.
//    req := client.UploadPartRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/UploadPart
func (c *S3) UploadPartRequest(input *UploadPartInput) UploadPartRequest {
	op := &aws.Operation{
		Name:       opUploadPart,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &UploadPartInput{}
	}

	output := &UploadPartOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return UploadPartRequest{Request: req, Input: input, Copy: c.UploadPartRequest}
}

const opUploadPartCopy = "UploadPartCopy"

// UploadPartCopyRequest is a API request type for the UploadPartCopy API operation.
type UploadPartCopyRequest struct {
	*aws.Request
	Input *UploadPartCopyInput
	Copy  func(*UploadPartCopyInput) UploadPartCopyRequest
}

// Send marshals and sends the UploadPartCopy API request.
func (r UploadPartCopyRequest) Send() (*UploadPartCopyOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*UploadPartCopyOutput), nil
}

// UploadPartCopyRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Uploads a part by copying data from an existing object as data source.
//
//    // Example sending a request using the UploadPartCopyRequest method.
//    req := client.UploadPartCopyRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/UploadPartCopy
func (c *S3) UploadPartCopyRequest(input *UploadPartCopyInput) UploadPartCopyRequest {
	op := &aws.Operation{
		Name:       opUploadPartCopy,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &UploadPartCopyInput{}
	}

	output := &UploadPartCopyOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return UploadPartCopyRequest{Request: req, Input: input, Copy: c.UploadPartCopyRequest}
}

// Specifies the days since the initiation of an Incomplete Multipart Upload
// that Lifecycle will wait before permanently removing all parts of the upload.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AbortIncompleteMultipartUpload
type AbortIncompleteMultipartUpload struct {
	_ struct{} `type:"structure"`

	// Indicates the number of days that must pass since initiation for Lifecycle
	// to abort an Incomplete Multipart Upload.
	DaysAfterInitiation *int64 `type:"integer"`
}

// String returns the string representation
func (s AbortIncompleteMultipartUpload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AbortIncompleteMultipartUpload) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AbortIncompleteMultipartUpload) MarshalFields(e protocol.FieldEncoder) error {
	if s.DaysAfterInitiation != nil {
		v := *s.DaysAfterInitiation

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DaysAfterInitiation", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AbortMultipartUploadRequest
type AbortMultipartUploadInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer RequestPayer `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"true"`

	// UploadId is a required field
	UploadId *string `location:"querystring" locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation
func (s AbortMultipartUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AbortMultipartUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AbortMultipartUploadInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AbortMultipartUploadInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.UploadId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UploadId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *AbortMultipartUploadInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AbortMultipartUploadInput) MarshalFields(e protocol.FieldEncoder) error {

	if len(s.RequestPayer) > 0 {
		v := s.RequestPayer

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-payer", v, metadata)
	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.UploadId != nil {
		v := *s.UploadId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "uploadId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AbortMultipartUploadOutput
type AbortMultipartUploadOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged RequestCharged `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"true"`
}

// String returns the string representation
func (s AbortMultipartUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AbortMultipartUploadOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s AbortMultipartUploadOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AbortMultipartUploadOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.RequestCharged) > 0 {
		v := s.RequestCharged

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-charged", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AccelerateConfiguration
type AccelerateConfiguration struct {
	_ struct{} `type:"structure"`

	// The accelerate configuration of the bucket.
	Status BucketAccelerateStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s AccelerateConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccelerateConfiguration) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AccelerateConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AccessControlPolicy
type AccessControlPolicy struct {
	_ struct{} `type:"structure"`

	// A list of grants.
	Grants []Grant `locationName:"AccessControlList" locationNameList:"Grant" type:"list"`

	Owner *Owner `type:"structure"`
}

// String returns the string representation
func (s AccessControlPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessControlPolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccessControlPolicy) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AccessControlPolicy"}
	if s.Grants != nil {
		for i, v := range s.Grants {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Grants", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AccessControlPolicy) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Grants) > 0 {
		v := s.Grants

		metadata := protocol.Metadata{ListLocationName: "Grant"}
		ls0 := e.List(protocol.BodyTarget, "AccessControlList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Owner != nil {
		v := s.Owner

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Owner", v, metadata)
	}
	return nil
}

// Container for information regarding the access control for replicas.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AccessControlTranslation
type AccessControlTranslation struct {
	_ struct{} `type:"structure"`

	// The override value for the owner of the replica object.
	//
	// Owner is a required field
	Owner OwnerOverride `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s AccessControlTranslation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessControlTranslation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccessControlTranslation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AccessControlTranslation"}
	if len(s.Owner) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Owner"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AccessControlTranslation) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Owner) > 0 {
		v := s.Owner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Owner", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AnalyticsAndOperator
type AnalyticsAndOperator struct {
	_ struct{} `type:"structure"`

	// The prefix to use when evaluating an AND predicate.
	Prefix *string `type:"string"`

	// The list of tags to use when evaluating an AND predicate.
	Tags []Tag `locationName:"Tag" locationNameList:"Tag" type:"list" flattened:"true"`
}

// String returns the string representation
func (s AnalyticsAndOperator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AnalyticsAndOperator) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsAndOperator) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AnalyticsAndOperator"}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AnalyticsAndOperator) MarshalFields(e protocol.FieldEncoder) error {
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Tag", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AnalyticsConfiguration
type AnalyticsConfiguration struct {
	_ struct{} `type:"structure"`

	// The filter used to describe a set of objects for analyses. A filter must
	// have exactly one prefix, one tag, or one conjunction (AnalyticsAndOperator).
	// If no filter is provided, all objects will be considered in any analysis.
	Filter *AnalyticsFilter `type:"structure"`

	// The identifier used to represent an analytics configuration.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// If present, it indicates that data related to access patterns will be collected
	// and made available to analyze the tradeoffs between different storage classes.
	//
	// StorageClassAnalysis is a required field
	StorageClassAnalysis *StorageClassAnalysis `type:"structure" required:"true"`
}

// String returns the string representation
func (s AnalyticsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AnalyticsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AnalyticsConfiguration"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if s.StorageClassAnalysis == nil {
		invalidParams.Add(aws.NewErrParamRequired("StorageClassAnalysis"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(aws.ErrInvalidParams))
		}
	}
	if s.StorageClassAnalysis != nil {
		if err := s.StorageClassAnalysis.Validate(); err != nil {
			invalidParams.AddNested("StorageClassAnalysis", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AnalyticsConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.Filter != nil {
		v := s.Filter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Filter", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.StorageClassAnalysis != nil {
		v := s.StorageClassAnalysis

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "StorageClassAnalysis", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AnalyticsExportDestination
type AnalyticsExportDestination struct {
	_ struct{} `type:"structure"`

	// A destination signifying output to an S3 bucket.
	//
	// S3BucketDestination is a required field
	S3BucketDestination *AnalyticsS3BucketDestination `type:"structure" required:"true"`
}

// String returns the string representation
func (s AnalyticsExportDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AnalyticsExportDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsExportDestination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AnalyticsExportDestination"}

	if s.S3BucketDestination == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3BucketDestination"))
	}
	if s.S3BucketDestination != nil {
		if err := s.S3BucketDestination.Validate(); err != nil {
			invalidParams.AddNested("S3BucketDestination", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AnalyticsExportDestination) MarshalFields(e protocol.FieldEncoder) error {
	if s.S3BucketDestination != nil {
		v := s.S3BucketDestination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "S3BucketDestination", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AnalyticsFilter
type AnalyticsFilter struct {
	_ struct{} `type:"structure"`

	// A conjunction (logical AND) of predicates, which is used in evaluating an
	// analytics filter. The operator must have at least two predicates.
	And *AnalyticsAndOperator `type:"structure"`

	// The prefix to use when evaluating an analytics filter.
	Prefix *string `type:"string"`

	// The tag to use when evaluating an analytics filter.
	Tag *Tag `type:"structure"`
}

// String returns the string representation
func (s AnalyticsFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AnalyticsFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AnalyticsFilter"}
	if s.And != nil {
		if err := s.And.Validate(); err != nil {
			invalidParams.AddNested("And", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tag != nil {
		if err := s.Tag.Validate(); err != nil {
			invalidParams.AddNested("Tag", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AnalyticsFilter) MarshalFields(e protocol.FieldEncoder) error {
	if s.And != nil {
		v := s.And

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "And", v, metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if s.Tag != nil {
		v := s.Tag

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Tag", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AnalyticsS3BucketDestination
type AnalyticsS3BucketDestination struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) of the bucket to which data is exported.
	//
	// Bucket is a required field
	Bucket *string `type:"string" required:"true"`

	// The account ID that owns the destination bucket. If no account ID is provided,
	// the owner will not be validated prior to exporting data.
	BucketAccountId *string `type:"string"`

	// The file format used when exporting data to Amazon S3.
	//
	// Format is a required field
	Format AnalyticsS3ExportFileFormat `type:"string" required:"true" enum:"true"`

	// The prefix to use when exporting data. The exported data begins with this
	// prefix.
	Prefix *string `type:"string"`
}

// String returns the string representation
func (s AnalyticsS3BucketDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AnalyticsS3BucketDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsS3BucketDestination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AnalyticsS3BucketDestination"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}
	if len(s.Format) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Format"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *AnalyticsS3BucketDestination) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AnalyticsS3BucketDestination) MarshalFields(e protocol.FieldEncoder) error {
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.BucketAccountId != nil {
		v := *s.BucketAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BucketAccountId", protocol.StringValue(v), metadata)
	}
	if len(s.Format) > 0 {
		v := s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Format", v, metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Bucket
type Bucket struct {
	_ struct{} `type:"structure"`

	// Date the bucket was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The name of the bucket.
	Name *string `type:"string"`
}

// String returns the string representation
func (s Bucket) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Bucket) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Bucket) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormat}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/BucketLifecycleConfiguration
type BucketLifecycleConfiguration struct {
	_ struct{} `type:"structure"`

	// Rules is a required field
	Rules []LifecycleRule `locationName:"Rule" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s BucketLifecycleConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BucketLifecycleConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BucketLifecycleConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BucketLifecycleConfiguration"}

	if s.Rules == nil {
		invalidParams.Add(aws.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BucketLifecycleConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Rules) > 0 {
		v := s.Rules

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Rule", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/BucketLoggingStatus
type BucketLoggingStatus struct {
	_ struct{} `type:"structure"`

	// Container for logging information. Presence of this element indicates that
	// logging is enabled. Parameters TargetBucket and TargetPrefix are required
	// in this case.
	LoggingEnabled *LoggingEnabled `type:"structure"`
}

// String returns the string representation
func (s BucketLoggingStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BucketLoggingStatus) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BucketLoggingStatus) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BucketLoggingStatus"}
	if s.LoggingEnabled != nil {
		if err := s.LoggingEnabled.Validate(); err != nil {
			invalidParams.AddNested("LoggingEnabled", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BucketLoggingStatus) MarshalFields(e protocol.FieldEncoder) error {
	if s.LoggingEnabled != nil {
		v := s.LoggingEnabled

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LoggingEnabled", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CORSConfiguration
type CORSConfiguration struct {
	_ struct{} `type:"structure"`

	// CORSRules is a required field
	CORSRules []CORSRule `locationName:"CORSRule" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s CORSConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CORSConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CORSConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CORSConfiguration"}

	if s.CORSRules == nil {
		invalidParams.Add(aws.NewErrParamRequired("CORSRules"))
	}
	if s.CORSRules != nil {
		for i, v := range s.CORSRules {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CORSRules", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CORSConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.CORSRules) > 0 {
		v := s.CORSRules

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "CORSRule", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CORSRule
type CORSRule struct {
	_ struct{} `type:"structure"`

	// Specifies which headers are allowed in a pre-flight OPTIONS request.
	AllowedHeaders []string `locationName:"AllowedHeader" type:"list" flattened:"true"`

	// Identifies HTTP methods that the domain/origin specified in the rule is allowed
	// to execute.
	//
	// AllowedMethods is a required field
	AllowedMethods []string `locationName:"AllowedMethod" type:"list" flattened:"true" required:"true"`

	// One or more origins you want customers to be able to access the bucket from.
	//
	// AllowedOrigins is a required field
	AllowedOrigins []string `locationName:"AllowedOrigin" type:"list" flattened:"true" required:"true"`

	// One or more headers in the response that you want customers to be able to
	// access from their applications (for example, from a JavaScript XMLHttpRequest
	// object).
	ExposeHeaders []string `locationName:"ExposeHeader" type:"list" flattened:"true"`

	// The time in seconds that your browser is to cache the preflight response
	// for the specified resource.
	MaxAgeSeconds *int64 `type:"integer"`
}

// String returns the string representation
func (s CORSRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CORSRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CORSRule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CORSRule"}

	if s.AllowedMethods == nil {
		invalidParams.Add(aws.NewErrParamRequired("AllowedMethods"))
	}

	if s.AllowedOrigins == nil {
		invalidParams.Add(aws.NewErrParamRequired("AllowedOrigins"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CORSRule) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AllowedHeaders) > 0 {
		v := s.AllowedHeaders

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "AllowedHeader", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if len(s.AllowedMethods) > 0 {
		v := s.AllowedMethods

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "AllowedMethod", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if len(s.AllowedOrigins) > 0 {
		v := s.AllowedOrigins

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "AllowedOrigin", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if len(s.ExposeHeaders) > 0 {
		v := s.ExposeHeaders

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "ExposeHeader", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.MaxAgeSeconds != nil {
		v := *s.MaxAgeSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxAgeSeconds", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Describes how a CSV-formatted input object is formatted.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CSVInput
type CSVInput struct {
	_ struct{} `type:"structure"`

	// Specifies that CSV field values may contain quoted record delimiters and
	// such records should be allowed. Default value is FALSE. Setting this value
	// to TRUE may lower performance.
	AllowQuotedRecordDelimiter *bool `type:"boolean"`

	// Single character used to indicate a row should be ignored when present at
	// the start of a row.
	Comments *string `type:"string"`

	// Value used to separate individual fields in a record.
	FieldDelimiter *string `type:"string"`

	// Describes the first line of input. Valid values: None, Ignore, Use.
	FileHeaderInfo FileHeaderInfo `type:"string" enum:"true"`

	// Value used for escaping where the field delimiter is part of the value.
	QuoteCharacter *string `type:"string"`

	// Single character used for escaping the quote character inside an already
	// escaped value.
	QuoteEscapeCharacter *string `type:"string"`

	// Value used to separate individual records.
	RecordDelimiter *string `type:"string"`
}

// String returns the string representation
func (s CSVInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CSVInput) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CSVInput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AllowQuotedRecordDelimiter != nil {
		v := *s.AllowQuotedRecordDelimiter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AllowQuotedRecordDelimiter", protocol.BoolValue(v), metadata)
	}
	if s.Comments != nil {
		v := *s.Comments

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Comments", protocol.StringValue(v), metadata)
	}
	if s.FieldDelimiter != nil {
		v := *s.FieldDelimiter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FieldDelimiter", protocol.StringValue(v), metadata)
	}
	if len(s.FileHeaderInfo) > 0 {
		v := s.FileHeaderInfo

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FileHeaderInfo", v, metadata)
	}
	if s.QuoteCharacter != nil {
		v := *s.QuoteCharacter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "QuoteCharacter", protocol.StringValue(v), metadata)
	}
	if s.QuoteEscapeCharacter != nil {
		v := *s.QuoteEscapeCharacter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "QuoteEscapeCharacter", protocol.StringValue(v), metadata)
	}
	if s.RecordDelimiter != nil {
		v := *s.RecordDelimiter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RecordDelimiter", protocol.StringValue(v), metadata)
	}
	return nil
}

// Describes how CSV-formatted results are formatted.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CSVOutput
type CSVOutput struct {
	_ struct{} `type:"structure"`

	// Value used to separate individual fields in a record.
	FieldDelimiter *string `type:"string"`

	// Value used for escaping where the field delimiter is part of the value.
	QuoteCharacter *string `type:"string"`

	// Single character used for escaping the quote character inside an already
	// escaped value.
	QuoteEscapeCharacter *string `type:"string"`

	// Indicates whether or not all output fields should be quoted.
	QuoteFields QuoteFields `type:"string" enum:"true"`

	// Value used to separate individual records.
	RecordDelimiter *string `type:"string"`
}

// String returns the string representation
func (s CSVOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CSVOutput) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CSVOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.FieldDelimiter != nil {
		v := *s.FieldDelimiter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FieldDelimiter", protocol.StringValue(v), metadata)
	}
	if s.QuoteCharacter != nil {
		v := *s.QuoteCharacter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "QuoteCharacter", protocol.StringValue(v), metadata)
	}
	if s.QuoteEscapeCharacter != nil {
		v := *s.QuoteEscapeCharacter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "QuoteEscapeCharacter", protocol.StringValue(v), metadata)
	}
	if len(s.QuoteFields) > 0 {
		v := s.QuoteFields

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "QuoteFields", v, metadata)
	}
	if s.RecordDelimiter != nil {
		v := *s.RecordDelimiter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RecordDelimiter", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CloudFunctionConfiguration
type CloudFunctionConfiguration struct {
	_ struct{} `type:"structure"`

	CloudFunction *string `type:"string"`

	// Bucket event for which to send notifications.
	Event Event `deprecated:"true" type:"string" enum:"true"`

	Events []Event `locationName:"Event" type:"list" flattened:"true"`

	// Optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	InvocationRole *string `type:"string"`
}

// String returns the string representation
func (s CloudFunctionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudFunctionConfiguration) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CloudFunctionConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.CloudFunction != nil {
		v := *s.CloudFunction

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CloudFunction", protocol.StringValue(v), metadata)
	}
	if len(s.Event) > 0 {
		v := s.Event

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Event", v, metadata)
	}
	if len(s.Events) > 0 {
		v := s.Events

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Event", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.InvocationRole != nil {
		v := *s.InvocationRole

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InvocationRole", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CommonPrefix
type CommonPrefix struct {
	_ struct{} `type:"structure"`

	Prefix *string `type:"string"`
}

// String returns the string representation
func (s CommonPrefix) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CommonPrefix) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CommonPrefix) MarshalFields(e protocol.FieldEncoder) error {
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CompleteMultipartUploadRequest
type CompleteMultipartUploadInput struct {
	_ struct{} `type:"structure" payload:"MultipartUpload"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	MultipartUpload *CompletedMultipartUpload `locationName:"CompleteMultipartUpload" type:"structure" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer RequestPayer `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"true"`

	// UploadId is a required field
	UploadId *string `location:"querystring" locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation
func (s CompleteMultipartUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompleteMultipartUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompleteMultipartUploadInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CompleteMultipartUploadInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.UploadId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UploadId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *CompleteMultipartUploadInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CompleteMultipartUploadInput) MarshalFields(e protocol.FieldEncoder) error {

	if len(s.RequestPayer) > 0 {
		v := s.RequestPayer

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-payer", v, metadata)
	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.MultipartUpload != nil {
		v := s.MultipartUpload

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "CompleteMultipartUpload", v, metadata)
	}
	if s.UploadId != nil {
		v := *s.UploadId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "uploadId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CompleteMultipartUploadOutput
type CompleteMultipartUploadOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	Bucket *string `type:"string"`

	// Entity tag of the object.
	ETag *string `type:"string"`

	// If the object expiration is configured, this will contain the expiration
	// date (expiry-date) and rule ID (rule-id). The value of rule-id is URL encoded.
	Expiration *string `location:"header" locationName:"x-amz-expiration" type:"string"`

	Key *string `min:"1" type:"string"`

	Location *string `type:"string"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged RequestCharged `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"true"`

	// If present, specifies the ID of the AWS Key Management Service (KMS) master
	// encryption key that was used for the object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption ServerSideEncryption `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"true"`

	// Version of the object.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation
func (s CompleteMultipartUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompleteMultipartUploadOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s CompleteMultipartUploadOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

func (s *CompleteMultipartUploadOutput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CompleteMultipartUploadOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.Location != nil {
		v := *s.Location

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Location", protocol.StringValue(v), metadata)
	}
	if s.Expiration != nil {
		v := *s.Expiration

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-expiration", protocol.StringValue(v), metadata)
	}
	if len(s.RequestCharged) > 0 {
		v := s.RequestCharged

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-charged", v, metadata)
	}
	if s.SSEKMSKeyId != nil {
		v := *s.SSEKMSKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-aws-kms-key-id", protocol.StringValue(v), metadata)
	}
	if len(s.ServerSideEncryption) > 0 {
		v := s.ServerSideEncryption

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption", v, metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-version-id", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CompletedMultipartUpload
type CompletedMultipartUpload struct {
	_ struct{} `type:"structure"`

	Parts []CompletedPart `locationName:"Part" type:"list" flattened:"true"`
}

// String returns the string representation
func (s CompletedMultipartUpload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompletedMultipartUpload) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CompletedMultipartUpload) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Parts) > 0 {
		v := s.Parts

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Part", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CompletedPart
type CompletedPart struct {
	_ struct{} `type:"structure"`

	// Entity tag returned when the part was uploaded.
	ETag *string `type:"string"`

	// Part number that identifies the part. This is a positive integer between
	// 1 and 10,000.
	PartNumber *int64 `type:"integer"`
}

// String returns the string representation
func (s CompletedPart) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompletedPart) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CompletedPart) MarshalFields(e protocol.FieldEncoder) error {
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.PartNumber != nil {
		v := *s.PartNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PartNumber", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Condition
type Condition struct {
	_ struct{} `type:"structure"`

	// The HTTP error code when the redirect is applied. In the event of an error,
	// if the error code equals this value, then the specified redirect is applied.
	// Required when parent element Condition is specified and sibling KeyPrefixEquals
	// is not specified. If both are specified, then both must be true for the redirect
	// to be applied.
	HttpErrorCodeReturnedEquals *string `type:"string"`

	// The object key name prefix when the redirect is applied. For example, to
	// redirect requests for ExamplePage.html, the key prefix will be ExamplePage.html.
	// To redirect request for all pages with the prefix docs/, the key prefix will
	// be /docs, which identifies all objects in the docs/ folder. Required when
	// the parent element Condition is specified and sibling HttpErrorCodeReturnedEquals
	// is not specified. If both conditions are specified, both must be true for
	// the redirect to be applied.
	KeyPrefixEquals *string `type:"string"`
}

// String returns the string representation
func (s Condition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Condition) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Condition) MarshalFields(e protocol.FieldEncoder) error {
	if s.HttpErrorCodeReturnedEquals != nil {
		v := *s.HttpErrorCodeReturnedEquals

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HttpErrorCodeReturnedEquals", protocol.StringValue(v), metadata)
	}
	if s.KeyPrefixEquals != nil {
		v := *s.KeyPrefixEquals

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KeyPrefixEquals", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CopyObjectRequest
type CopyObjectInput struct {
	_ struct{} `type:"structure"`

	// The canned ACL to apply to the object.
	ACL ObjectCannedACL `location:"header" locationName:"x-amz-acl" type:"string" enum:"true"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Specifies caching behavior along the request/reply chain.
	CacheControl *string `location:"header" locationName:"Cache-Control" type:"string"`

	// Specifies presentational information for the object.
	ContentDisposition *string `location:"header" locationName:"Content-Disposition" type:"string"`

	// Specifies what content encodings have been applied to the object and thus
	// what decoding mechanisms must be applied to obtain the media-type referenced
	// by the Content-Type header field.
	ContentEncoding *string `location:"header" locationName:"Content-Encoding" type:"string"`

	// The language the content is in.
	ContentLanguage *string `location:"header" locationName:"Content-Language" type:"string"`

	// A standard MIME type describing the format of the object data.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// The name of the source bucket and key name of the source object, separated
	// by a slash (/). Must be URL-encoded.
	//
	// CopySource is a required field
	CopySource *string `location:"header" locationName:"x-amz-copy-source" type:"string" required:"true"`

	// Copies the object if its entity tag (ETag) matches the specified tag.
	CopySourceIfMatch *string `location:"header" locationName:"x-amz-copy-source-if-match" type:"string"`

	// Copies the object if it has been modified since the specified time.
	CopySourceIfModifiedSince *time.Time `location:"header" locationName:"x-amz-copy-source-if-modified-since" type:"timestamp" timestampFormat:"rfc822"`

	// Copies the object if its entity tag (ETag) is different than the specified
	// ETag.
	CopySourceIfNoneMatch *string `location:"header" locationName:"x-amz-copy-source-if-none-match" type:"string"`

	// Copies the object if it hasn't been modified since the specified time.
	CopySourceIfUnmodifiedSince *time.Time `location:"header" locationName:"x-amz-copy-source-if-unmodified-since" type:"timestamp" timestampFormat:"rfc822"`

	// Specifies the algorithm to use when decrypting the source object (e.g., AES256).
	CopySourceSSECustomerAlgorithm *string `location:"header" locationName:"x-amz-copy-source-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use to decrypt
	// the source object. The encryption key provided in this header must be one
	// that was used when the source object was created.
	CopySourceSSECustomerKey *string `location:"header" locationName:"x-amz-copy-source-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	CopySourceSSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-copy-source-server-side-encryption-customer-key-MD5" type:"string"`

	// The date and time at which the object is no longer cacheable.
	Expires *time.Time `location:"header" locationName:"Expires" type:"timestamp" timestampFormat:"rfc822"`

	// Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to read the object data and its metadata.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the object ACL.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to write the ACL for the applicable object.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// A map of metadata to store with the object in S3.
	Metadata map[string]string `location:"headers" locationName:"x-amz-meta-" type:"map"`

	// Specifies whether the metadata is copied from the source object or replaced
	// with metadata provided in the request.
	MetadataDirective MetadataDirective `location:"header" locationName:"x-amz-metadata-directive" type:"string" enum:"true"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer RequestPayer `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"true"`

	// Specifies the algorithm to use to when encrypting the object (e.g., AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// does not store the encryption key. The key must be appropriate for use with
	// the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm
	// header.
	SSECustomerKey *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// Specifies the AWS KMS key ID to use for object encryption. All GET and PUT
	// requests for an object protected by AWS KMS will fail if not made via SSL
	// or using SigV4. Documentation on configuring any of the officially supported
	// AWS SDKs and CLI can be found at http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption ServerSideEncryption `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"true"`

	// The type of storage to use for the object. Defaults to 'STANDARD'.
	StorageClass StorageClass `location:"header" locationName:"x-amz-storage-class" type:"string" enum:"true"`

	// The tag-set for the object destination object this value must be used in
	// conjunction with the TaggingDirective. The tag-set must be encoded as URL
	// Query parameters
	Tagging *string `location:"header" locationName:"x-amz-tagging" type:"string"`

	// Specifies whether the object tag-set are copied from the source object or
	// replaced with tag-set provided in the request.
	TaggingDirective TaggingDirective `location:"header" locationName:"x-amz-tagging-directive" type:"string" enum:"true"`

	// If the bucket is configured as a website, redirects requests for this object
	// to another object in the same bucket or to an external URL. Amazon S3 stores
	// the value of this header in the object metadata.
	WebsiteRedirectLocation *string `location:"header" locationName:"x-amz-website-redirect-location" type:"string"`
}

// String returns the string representation
func (s CopyObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyObjectInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CopyObjectInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.CopySource == nil {
		invalidParams.Add(aws.NewErrParamRequired("CopySource"))
	}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *CopyObjectInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

func (s *CopyObjectInput) getCopySourceSSECustomerKey() (v string) {
	if s.CopySourceSSECustomerKey == nil {
		return v
	}
	return *s.CopySourceSSECustomerKey
}

func (s *CopyObjectInput) getSSECustomerKey() (v string) {
	if s.SSECustomerKey == nil {
		return v
	}
	return *s.SSECustomerKey
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CopyObjectInput) MarshalFields(e protocol.FieldEncoder) error {

	if len(s.ACL) > 0 {
		v := s.ACL

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-acl", v, metadata)
	}
	if s.CacheControl != nil {
		v := *s.CacheControl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Cache-Control", protocol.StringValue(v), metadata)
	}
	if s.ContentDisposition != nil {
		v := *s.ContentDisposition

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Content-Disposition", protocol.StringValue(v), metadata)
	}
	if s.ContentEncoding != nil {
		v := *s.ContentEncoding

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Content-Encoding", protocol.StringValue(v), metadata)
	}
	if s.ContentLanguage != nil {
		v := *s.ContentLanguage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Content-Language", protocol.StringValue(v), metadata)
	}
	if s.ContentType != nil {
		v := *s.ContentType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue(v), metadata)
	}
	if s.CopySource != nil {
		v := *s.CopySource

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-copy-source", protocol.StringValue(v), metadata)
	}
	if s.CopySourceIfMatch != nil {
		v := *s.CopySourceIfMatch

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-copy-source-if-match", protocol.StringValue(v), metadata)
	}
	if s.CopySourceIfModifiedSince != nil {
		v := *s.CopySourceIfModifiedSince

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-copy-source-if-modified-since", protocol.TimeValue{V: v, Format: protocol.RFC822TimeFromat}, metadata)
	}
	if s.CopySourceIfNoneMatch != nil {
		v := *s.CopySourceIfNoneMatch

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-copy-source-if-none-match", protocol.StringValue(v), metadata)
	}
	if s.CopySourceIfUnmodifiedSince != nil {
		v := *s.CopySourceIfUnmodifiedSince

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-copy-source-if-unmodified-since", protocol.TimeValue{V: v, Format: protocol.RFC822TimeFromat}, metadata)
	}
	if s.CopySourceSSECustomerAlgorithm != nil {
		v := *s.CopySourceSSECustomerAlgorithm

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-copy-source-server-side-encryption-customer-algorithm", protocol.StringValue(v), metadata)
	}
	if s.CopySourceSSECustomerKey != nil {
		v := *s.CopySourceSSECustomerKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-copy-source-server-side-encryption-customer-key", protocol.StringValue(v), metadata)
	}
	if s.CopySourceSSECustomerKeyMD5 != nil {
		v := *s.CopySourceSSECustomerKeyMD5

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-copy-source-server-side-encryption-customer-key-MD5", protocol.StringValue(v), metadata)
	}
	if s.Expires != nil {
		v := *s.Expires

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Expires", protocol.TimeValue{V: v, Format: protocol.RFC822TimeFromat}, metadata)
	}
	if s.GrantFullControl != nil {
		v := *s.GrantFullControl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-grant-full-control", protocol.StringValue(v), metadata)
	}
	if s.GrantRead != nil {
		v := *s.GrantRead

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-grant-read", protocol.StringValue(v), metadata)
	}
	if s.GrantReadACP != nil {
		v := *s.GrantReadACP

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-grant-read-acp", protocol.StringValue(v), metadata)
	}
	if s.GrantWriteACP != nil {
		v := *s.GrantWriteACP

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-grant-write-acp", protocol.StringValue(v), metadata)
	}
	if len(s.MetadataDirective) > 0 {
		v := s.MetadataDirective

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-metadata-directive", v, metadata)
	}
	if len(s.RequestPayer) > 0 {
		v := s.RequestPayer

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-payer", v, metadata)
	}
	if s.SSECustomerAlgorithm != nil {
		v := *s.SSECustomerAlgorithm

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-customer-algorithm", protocol.StringValue(v), metadata)
	}
	if s.SSECustomerKey != nil {
		v := *s.SSECustomerKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-customer-key", protocol.StringValue(v), metadata)
	}
	if s.SSECustomerKeyMD5 != nil {
		v := *s.SSECustomerKeyMD5

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-customer-key-MD5", protocol.StringValue(v), metadata)
	}
	if s.SSEKMSKeyId != nil {
		v := *s.SSEKMSKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-aws-kms-key-id", protocol.StringValue(v), metadata)
	}
	if len(s.ServerSideEncryption) > 0 {
		v := s.ServerSideEncryption

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption", v, metadata)
	}
	if len(s.StorageClass) > 0 {
		v := s.StorageClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-storage-class", v, metadata)
	}
	if s.Tagging != nil {
		v := *s.Tagging

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-tagging", protocol.StringValue(v), metadata)
	}
	if len(s.TaggingDirective) > 0 {
		v := s.TaggingDirective

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-tagging-directive", v, metadata)
	}
	if s.WebsiteRedirectLocation != nil {
		v := *s.WebsiteRedirectLocation

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-website-redirect-location", protocol.StringValue(v), metadata)
	}
	if len(s.Metadata) > 0 {
		v := s.Metadata

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.HeadersTarget, "x-amz-meta-", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.StringValue(v1))
		}
		ms0.End()

	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Key", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CopyObjectOutput
type CopyObjectOutput struct {
	_ struct{} `type:"structure" payload:"CopyObjectResult"`

	responseMetadata aws.Response

	CopyObjectResult *CopyObjectResult `type:"structure"`

	CopySourceVersionId *string `location:"header" locationName:"x-amz-copy-source-version-id" type:"string"`

	// If the object expiration is configured, the response includes this header.
	Expiration *string `location:"header" locationName:"x-amz-expiration" type:"string"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged RequestCharged `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"true"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the ID of the AWS Key Management Service (KMS) master
	// encryption key that was used for the object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption ServerSideEncryption `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"true"`

	// Version ID of the newly created copy.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation
func (s CopyObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyObjectOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s CopyObjectOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CopyObjectOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CopySourceVersionId != nil {
		v := *s.CopySourceVersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-copy-source-version-id", protocol.StringValue(v), metadata)
	}
	if s.Expiration != nil {
		v := *s.Expiration

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-expiration", protocol.StringValue(v), metadata)
	}
	if len(s.RequestCharged) > 0 {
		v := s.RequestCharged

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-charged", v, metadata)
	}
	if s.SSECustomerAlgorithm != nil {
		v := *s.SSECustomerAlgorithm

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-customer-algorithm", protocol.StringValue(v), metadata)
	}
	if s.SSECustomerKeyMD5 != nil {
		v := *s.SSECustomerKeyMD5

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-customer-key-MD5", protocol.StringValue(v), metadata)
	}
	if s.SSEKMSKeyId != nil {
		v := *s.SSEKMSKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-aws-kms-key-id", protocol.StringValue(v), metadata)
	}
	if len(s.ServerSideEncryption) > 0 {
		v := s.ServerSideEncryption

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption", v, metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-version-id", protocol.StringValue(v), metadata)
	}
	if s.CopyObjectResult != nil {
		v := s.CopyObjectResult

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "CopyObjectResult", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CopyObjectResult
type CopyObjectResult struct {
	_ struct{} `type:"structure"`

	ETag *string `type:"string"`

	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s CopyObjectResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyObjectResult) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CopyObjectResult) MarshalFields(e protocol.FieldEncoder) error {
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.LastModified != nil {
		v := *s.LastModified

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModified", protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormat}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CopyPartResult
type CopyPartResult struct {
	_ struct{} `type:"structure"`

	// Entity tag of the object.
	ETag *string `type:"string"`

	// Date and time at which the object was uploaded.
	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s CopyPartResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyPartResult) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CopyPartResult) MarshalFields(e protocol.FieldEncoder) error {
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.LastModified != nil {
		v := *s.LastModified

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModified", protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormat}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CreateBucketConfiguration
type CreateBucketConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies the region where the bucket will be created. If you don't specify
	// a region, the bucket will be created in US Standard.
	LocationConstraint BucketLocationConstraint `type:"string" enum:"true"`
}

// String returns the string representation
func (s CreateBucketConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBucketConfiguration) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateBucketConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.LocationConstraint) > 0 {
		v := s.LocationConstraint

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LocationConstraint", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CreateBucketRequest
type CreateBucketInput struct {
	_ struct{} `type:"structure" payload:"CreateBucketConfiguration"`

	// The canned ACL to apply to the bucket.
	ACL BucketCannedACL `location:"header" locationName:"x-amz-acl" type:"string" enum:"true"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	CreateBucketConfiguration *CreateBucketConfiguration `locationName:"CreateBucketConfiguration" type:"structure" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	// Allows grantee the read, write, read ACP, and write ACP permissions on the
	// bucket.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to list the objects in the bucket.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the bucket ACL.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to create, overwrite, and delete any object in the bucket.
	GrantWrite *string `location:"header" locationName:"x-amz-grant-write" type:"string"`

	// Allows grantee to write the ACL for the applicable bucket.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`
}

// String returns the string representation
func (s CreateBucketInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBucketInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBucketInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateBucketInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *CreateBucketInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateBucketInput) MarshalFields(e protocol.FieldEncoder) error {

	if len(s.ACL) > 0 {
		v := s.ACL

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-acl", v, metadata)
	}
	if s.GrantFullControl != nil {
		v := *s.GrantFullControl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-grant-full-control", protocol.StringValue(v), metadata)
	}
	if s.GrantRead != nil {
		v := *s.GrantRead

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-grant-read", protocol.StringValue(v), metadata)
	}
	if s.GrantReadACP != nil {
		v := *s.GrantReadACP

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-grant-read-acp", protocol.StringValue(v), metadata)
	}
	if s.GrantWrite != nil {
		v := *s.GrantWrite

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-grant-write", protocol.StringValue(v), metadata)
	}
	if s.GrantWriteACP != nil {
		v := *s.GrantWriteACP

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-grant-write-acp", protocol.StringValue(v), metadata)
	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.CreateBucketConfiguration != nil {
		v := s.CreateBucketConfiguration

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "CreateBucketConfiguration", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CreateBucketOutput
type CreateBucketOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	Location *string `location:"header" locationName:"Location" type:"string"`
}

// String returns the string representation
func (s CreateBucketOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBucketOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s CreateBucketOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateBucketOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Location != nil {
		v := *s.Location

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Location", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CreateMultipartUploadRequest
type CreateMultipartUploadInput struct {
	_ struct{} `type:"structure"`

	// The canned ACL to apply to the object.
	ACL ObjectCannedACL `location:"header" locationName:"x-amz-acl" type:"string" enum:"true"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Specifies caching behavior along the request/reply chain.
	CacheControl *string `location:"header" locationName:"Cache-Control" type:"string"`

	// Specifies presentational information for the object.
	ContentDisposition *string `location:"header" locationName:"Content-Disposition" type:"string"`

	// Specifies what content encodings have been applied to the object and thus
	// what decoding mechanisms must be applied to obtain the media-type referenced
	// by the Content-Type header field.
	ContentEncoding *string `location:"header" locationName:"Content-Encoding" type:"string"`

	// The language the content is in.
	ContentLanguage *string `location:"header" locationName:"Content-Language" type:"string"`

	// A standard MIME type describing the format of the object data.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// The date and time at which the object is no longer cacheable.
	Expires *time.Time `location:"header" locationName:"Expires" type:"timestamp" timestampFormat:"rfc822"`

	// Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to read the object data and its metadata.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the object ACL.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to write the ACL for the applicable object.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// A map of metadata to store with the object in S3.
	Metadata map[string]string `location:"headers" locationName:"x-amz-meta-" type:"map"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer RequestPayer `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"true"`

	// Specifies the algorithm to use to when encrypting the object (e.g., AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// does not store the encryption key. The key must be appropriate for use with
	// the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm
	// header.
	SSECustomerKey *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// Specifies the AWS KMS key ID to use for object encryption. All GET and PUT
	// requests for an object protected by AWS KMS will fail if not made via SSL
	// or using SigV4. Documentation on configuring any of the officially supported
	// AWS SDKs and CLI can be found at http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption ServerSideEncryption `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"true"`

	// The type of storage to use for the object. Defaults to 'STANDARD'.
	StorageClass StorageClass `location:"header" locationName:"x-amz-storage-class" type:"string" enum:"true"`

	// The tag-set for the object. The tag-set must be encoded as URL Query parameters
	Tagging *string `location:"header" locationName:"x-amz-tagging" type:"string"`

	// If the bucket is configured as a website, redirects requests for this object
	// to another object in the same bucket or to an external URL. Amazon S3 stores
	// the value of this header in the object metadata.
	WebsiteRedirectLocation *string `location:"header" locationName:"x-amz-website-redirect-location" type:"string"`
}

// String returns the string representation
func (s CreateMultipartUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMultipartUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMultipartUploadInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateMultipartUploadInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *CreateMultipartUploadInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

func (s *CreateMultipartUploadInput) getSSECustomerKey() (v string) {
	if s.SSECustomerKey == nil {
		return v
	}
	return *s.SSECustomerKey
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateMultipartUploadInput) MarshalFields(e protocol.FieldEncoder) error {

	if len(s.ACL) > 0 {
		v := s.ACL

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-acl", v, metadata)
	}
	if s.CacheControl != nil {
		v := *s.CacheControl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Cache-Control", protocol.StringValue(v), metadata)
	}
	if s.ContentDisposition != nil {
		v := *s.ContentDisposition

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Content-Disposition", protocol.StringValue(v), metadata)
	}
	if s.ContentEncoding != nil {
		v := *s.ContentEncoding

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Content-Encoding", protocol.StringValue(v), metadata)
	}
	if s.ContentLanguage != nil {
		v := *s.ContentLanguage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Content-Language", protocol.StringValue(v), metadata)
	}
	if s.ContentType != nil {
		v := *s.ContentType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue(v), metadata)
	}
	if s.Expires != nil {
		v := *s.Expires

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Expires", protocol.TimeValue{V: v, Format: protocol.RFC822TimeFromat}, metadata)
	}
	if s.GrantFullControl != nil {
		v := *s.GrantFullControl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-grant-full-control", protocol.StringValue(v), metadata)
	}
	if s.GrantRead != nil {
		v := *s.GrantRead

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-grant-read", protocol.StringValue(v), metadata)
	}
	if s.GrantReadACP != nil {
		v := *s.GrantReadACP

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-grant-read-acp", protocol.StringValue(v), metadata)
	}
	if s.GrantWriteACP != nil {
		v := *s.GrantWriteACP

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-grant-write-acp", protocol.StringValue(v), metadata)
	}
	if len(s.RequestPayer) > 0 {
		v := s.RequestPayer

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-payer", v, metadata)
	}
	if s.SSECustomerAlgorithm != nil {
		v := *s.SSECustomerAlgorithm

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-customer-algorithm", protocol.StringValue(v), metadata)
	}
	if s.SSECustomerKey != nil {
		v := *s.SSECustomerKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-customer-key", protocol.StringValue(v), metadata)
	}
	if s.SSECustomerKeyMD5 != nil {
		v := *s.SSECustomerKeyMD5

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-customer-key-MD5", protocol.StringValue(v), metadata)
	}
	if s.SSEKMSKeyId != nil {
		v := *s.SSEKMSKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-aws-kms-key-id", protocol.StringValue(v), metadata)
	}
	if len(s.ServerSideEncryption) > 0 {
		v := s.ServerSideEncryption

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption", v, metadata)
	}
	if len(s.StorageClass) > 0 {
		v := s.StorageClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-storage-class", v, metadata)
	}
	if s.Tagging != nil {
		v := *s.Tagging

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-tagging", protocol.StringValue(v), metadata)
	}
	if s.WebsiteRedirectLocation != nil {
		v := *s.WebsiteRedirectLocation

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-website-redirect-location", protocol.StringValue(v), metadata)
	}
	if len(s.Metadata) > 0 {
		v := s.Metadata

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.HeadersTarget, "x-amz-meta-", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.StringValue(v1))
		}
		ms0.End()

	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Key", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CreateMultipartUploadOutput
type CreateMultipartUploadOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// Date when multipart upload will become eligible for abort operation by lifecycle.
	AbortDate *time.Time `location:"header" locationName:"x-amz-abort-date" type:"timestamp" timestampFormat:"rfc822"`

	// Id of the lifecycle rule that makes a multipart upload eligible for abort
	// operation.
	AbortRuleId *string `location:"header" locationName:"x-amz-abort-rule-id" type:"string"`

	// Name of the bucket to which the multipart upload was initiated.
	Bucket *string `locationName:"Bucket" type:"string"`

	// Object key for which the multipart upload was initiated.
	Key *string `min:"1" type:"string"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged RequestCharged `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"true"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the ID of the AWS Key Management Service (KMS) master
	// encryption key that was used for the object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption ServerSideEncryption `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"true"`

	// ID for the initiated multipart upload.
	UploadId *string `type:"string"`
}

// String returns the string representation
func (s CreateMultipartUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMultipartUploadOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s CreateMultipartUploadOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

func (s *CreateMultipartUploadOutput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateMultipartUploadOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.UploadId != nil {
		v := *s.UploadId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UploadId", protocol.StringValue(v), metadata)
	}
	if s.AbortDate != nil {
		v := *s.AbortDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-abort-date", protocol.TimeValue{V: v, Format: protocol.RFC822TimeFromat}, metadata)
	}
	if s.AbortRuleId != nil {
		v := *s.AbortRuleId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-abort-rule-id", protocol.StringValue(v), metadata)
	}
	if len(s.RequestCharged) > 0 {
		v := s.RequestCharged

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-charged", v, metadata)
	}
	if s.SSECustomerAlgorithm != nil {
		v := *s.SSECustomerAlgorithm

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-customer-algorithm", protocol.StringValue(v), metadata)
	}
	if s.SSECustomerKeyMD5 != nil {
		v := *s.SSECustomerKeyMD5

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-customer-key-MD5", protocol.StringValue(v), metadata)
	}
	if s.SSEKMSKeyId != nil {
		v := *s.SSEKMSKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-aws-kms-key-id", protocol.StringValue(v), metadata)
	}
	if len(s.ServerSideEncryption) > 0 {
		v := s.ServerSideEncryption

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Delete
type Delete struct {
	_ struct{} `type:"structure"`

	// Objects is a required field
	Objects []ObjectIdentifier `locationName:"Object" type:"list" flattened:"true" required:"true"`

	// Element to enable quiet mode for the request. When you add this element,
	// you must set its value to true.
	Quiet *bool `type:"boolean"`
}

// String returns the string representation
func (s Delete) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Delete) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Delete) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Delete"}

	if s.Objects == nil {
		invalidParams.Add(aws.NewErrParamRequired("Objects"))
	}
	if s.Objects != nil {
		for i, v := range s.Objects {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Objects", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Delete) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Objects) > 0 {
		v := s.Objects

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Object", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Quiet != nil {
		v := *s.Quiet

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Quiet", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketAnalyticsConfigurationRequest
type DeleteBucketAnalyticsConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the bucket from which an analytics configuration is deleted.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The identifier used to represent an analytics configuration.
	//
	// Id is a required field
	Id *string `location:"querystring" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketAnalyticsConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketAnalyticsConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketAnalyticsConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteBucketAnalyticsConfigurationInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *DeleteBucketAnalyticsConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteBucketAnalyticsConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "id", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketAnalyticsConfigurationOutput
type DeleteBucketAnalyticsConfigurationOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s DeleteBucketAnalyticsConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketAnalyticsConfigurationOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DeleteBucketAnalyticsConfigurationOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteBucketAnalyticsConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketCorsRequest
type DeleteBucketCorsInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketCorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketCorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketCorsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteBucketCorsInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *DeleteBucketCorsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteBucketCorsInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketCorsOutput
type DeleteBucketCorsOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s DeleteBucketCorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketCorsOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DeleteBucketCorsOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteBucketCorsOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketEncryptionRequest
type DeleteBucketEncryptionInput struct {
	_ struct{} `type:"structure"`

	// The name of the bucket containing the server-side encryption configuration
	// to delete.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketEncryptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketEncryptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketEncryptionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteBucketEncryptionInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *DeleteBucketEncryptionInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteBucketEncryptionInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketEncryptionOutput
type DeleteBucketEncryptionOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s DeleteBucketEncryptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketEncryptionOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DeleteBucketEncryptionOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteBucketEncryptionOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketRequest
type DeleteBucketInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteBucketInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *DeleteBucketInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteBucketInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketInventoryConfigurationRequest
type DeleteBucketInventoryConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the bucket containing the inventory configuration to delete.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The ID used to identify the inventory configuration.
	//
	// Id is a required field
	Id *string `location:"querystring" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketInventoryConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketInventoryConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketInventoryConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteBucketInventoryConfigurationInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *DeleteBucketInventoryConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteBucketInventoryConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "id", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketInventoryConfigurationOutput
type DeleteBucketInventoryConfigurationOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s DeleteBucketInventoryConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketInventoryConfigurationOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DeleteBucketInventoryConfigurationOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteBucketInventoryConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketLifecycleRequest
type DeleteBucketLifecycleInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketLifecycleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketLifecycleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketLifecycleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteBucketLifecycleInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *DeleteBucketLifecycleInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteBucketLifecycleInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketLifecycleOutput
type DeleteBucketLifecycleOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s DeleteBucketLifecycleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketLifecycleOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DeleteBucketLifecycleOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteBucketLifecycleOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketMetricsConfigurationRequest
type DeleteBucketMetricsConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the bucket containing the metrics configuration to delete.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The ID used to identify the metrics configuration.
	//
	// Id is a required field
	Id *string `location:"querystring" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketMetricsConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketMetricsConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketMetricsConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteBucketMetricsConfigurationInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *DeleteBucketMetricsConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteBucketMetricsConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "id", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketMetricsConfigurationOutput
type DeleteBucketMetricsConfigurationOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s DeleteBucketMetricsConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketMetricsConfigurationOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DeleteBucketMetricsConfigurationOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteBucketMetricsConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketOutput
type DeleteBucketOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s DeleteBucketOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DeleteBucketOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteBucketOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketPolicyRequest
type DeleteBucketPolicyInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteBucketPolicyInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *DeleteBucketPolicyInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteBucketPolicyInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketPolicyOutput
type DeleteBucketPolicyOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s DeleteBucketPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketPolicyOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DeleteBucketPolicyOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteBucketPolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketReplicationRequest
type DeleteBucketReplicationInput struct {
	_ struct{} `type:"structure"`

	// Deletes the replication subresource associated with the specified bucket.
	//
	// There is usually some time lag before replication configuration deletion
	// is fully propagated to all the Amazon S3 systems.
	//
	// For more information, see Cross-Region Replication (CRR) ( https://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html)
	// in the Amazon S3 Developer Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketReplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketReplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketReplicationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteBucketReplicationInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *DeleteBucketReplicationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteBucketReplicationInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketReplicationOutput
type DeleteBucketReplicationOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s DeleteBucketReplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketReplicationOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DeleteBucketReplicationOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteBucketReplicationOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketTaggingRequest
type DeleteBucketTaggingInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketTaggingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteBucketTaggingInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *DeleteBucketTaggingInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteBucketTaggingInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketTaggingOutput
type DeleteBucketTaggingOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s DeleteBucketTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketTaggingOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DeleteBucketTaggingOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteBucketTaggingOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketWebsiteRequest
type DeleteBucketWebsiteInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketWebsiteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketWebsiteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketWebsiteInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteBucketWebsiteInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *DeleteBucketWebsiteInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteBucketWebsiteInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketWebsiteOutput
type DeleteBucketWebsiteOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s DeleteBucketWebsiteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketWebsiteOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DeleteBucketWebsiteOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteBucketWebsiteOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteMarkerEntry
type DeleteMarkerEntry struct {
	_ struct{} `type:"structure"`

	// Specifies whether the object is (true) or is not (false) the latest version
	// of an object.
	IsLatest *bool `type:"boolean"`

	// The object key.
	Key *string `min:"1" type:"string"`

	// Date and time the object was last modified.
	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	Owner *Owner `type:"structure"`

	// Version ID of an object.
	VersionId *string `type:"string"`
}

// String returns the string representation
func (s DeleteMarkerEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMarkerEntry) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteMarkerEntry) MarshalFields(e protocol.FieldEncoder) error {
	if s.IsLatest != nil {
		v := *s.IsLatest

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsLatest", protocol.BoolValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.LastModified != nil {
		v := *s.LastModified

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModified", protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormat}, metadata)
	}
	if s.Owner != nil {
		v := s.Owner

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Owner", v, metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Specifies whether Amazon S3 should replicate delete makers.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteMarkerReplication
type DeleteMarkerReplication struct {
	_ struct{} `type:"structure"`

	// The status of the delete marker replication.
	//
	// In the current implementation, Amazon S3 does not replicate the delete markers.
	// Therefore, the status must be Disabled.
	Status DeleteMarkerReplicationStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s DeleteMarkerReplication) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMarkerReplication) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteMarkerReplication) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObjectRequest
type DeleteObjectInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// The concatenation of the authentication device's serial number, a space,
	// and the value that is displayed on your authentication device.
	MFA *string `location:"header" locationName:"x-amz-mfa" type:"string"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer RequestPayer `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"true"`

	// VersionId used to reference a specific version of the object.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s DeleteObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteObjectInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteObjectInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *DeleteObjectInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteObjectInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.MFA != nil {
		v := *s.MFA

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-mfa", protocol.StringValue(v), metadata)
	}
	if len(s.RequestPayer) > 0 {
		v := s.RequestPayer

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-payer", v, metadata)
	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "versionId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObjectOutput
type DeleteObjectOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// Specifies whether the versioned object that was permanently deleted was (true)
	// or was not (false) a delete marker.
	DeleteMarker *bool `location:"header" locationName:"x-amz-delete-marker" type:"boolean"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged RequestCharged `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"true"`

	// Returns the version ID of the delete marker created as a result of the DELETE
	// operation.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation
func (s DeleteObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteObjectOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DeleteObjectOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteObjectOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DeleteMarker != nil {
		v := *s.DeleteMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-delete-marker", protocol.BoolValue(v), metadata)
	}
	if len(s.RequestCharged) > 0 {
		v := s.RequestCharged

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-charged", v, metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-version-id", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObjectTaggingRequest
type DeleteObjectTaggingInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// The versionId of the object that the tag-set will be removed from.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s DeleteObjectTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteObjectTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteObjectTaggingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteObjectTaggingInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *DeleteObjectTaggingInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteObjectTaggingInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "versionId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObjectTaggingOutput
type DeleteObjectTaggingOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The versionId of the object the tag-set was removed from.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation
func (s DeleteObjectTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteObjectTaggingOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DeleteObjectTaggingOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteObjectTaggingOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-version-id", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObjectsRequest
type DeleteObjectsInput struct {
	_ struct{} `type:"structure" payload:"Delete"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Delete is a required field
	Delete *Delete `locationName:"Delete" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	// The concatenation of the authentication device's serial number, a space,
	// and the value that is displayed on your authentication device.
	MFA *string `location:"header" locationName:"x-amz-mfa" type:"string"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer RequestPayer `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"true"`
}

// String returns the string representation
func (s DeleteObjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteObjectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteObjectsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteObjectsInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Delete == nil {
		invalidParams.Add(aws.NewErrParamRequired("Delete"))
	}
	if s.Delete != nil {
		if err := s.Delete.Validate(); err != nil {
			invalidParams.AddNested("Delete", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *DeleteObjectsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteObjectsInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.MFA != nil {
		v := *s.MFA

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-mfa", protocol.StringValue(v), metadata)
	}
	if len(s.RequestPayer) > 0 {
		v := s.RequestPayer

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-payer", v, metadata)
	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Delete != nil {
		v := s.Delete

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "Delete", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObjectsOutput
type DeleteObjectsOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	Deleted []DeletedObject `type:"list" flattened:"true"`

	Errors []Error `locationName:"Error" type:"list" flattened:"true"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged RequestCharged `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"true"`
}

// String returns the string representation
func (s DeleteObjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteObjectsOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DeleteObjectsOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteObjectsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Deleted) > 0 {
		v := s.Deleted

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Deleted", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Errors) > 0 {
		v := s.Errors

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Error", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.RequestCharged) > 0 {
		v := s.RequestCharged

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-charged", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeletedObject
type DeletedObject struct {
	_ struct{} `type:"structure"`

	DeleteMarker *bool `type:"boolean"`

	DeleteMarkerVersionId *string `type:"string"`

	Key *string `min:"1" type:"string"`

	VersionId *string `type:"string"`
}

// String returns the string representation
func (s DeletedObject) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletedObject) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeletedObject) MarshalFields(e protocol.FieldEncoder) error {
	if s.DeleteMarker != nil {
		v := *s.DeleteMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeleteMarker", protocol.BoolValue(v), metadata)
	}
	if s.DeleteMarkerVersionId != nil {
		v := *s.DeleteMarkerVersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeleteMarkerVersionId", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Container for replication destination information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Destination
type Destination struct {
	_ struct{} `type:"structure"`

	// Container for information regarding the access control for replicas.
	//
	// Use only in a cross-account scenario, where source and destination bucket
	// owners are not the same, when you want to change replica ownership to the
	// AWS account that owns the destination bucket. If you don't add this element
	// to the replication configuration, the replicas are owned by same AWS account
	// that owns the source object.
	AccessControlTranslation *AccessControlTranslation `type:"structure"`

	// Account ID of the destination bucket. Currently Amazon S3 verifies this value
	// only if Access Control Translation is enabled.
	//
	// In a cross-account scenario, if you tell Amazon S3 to change replica ownership
	// to the AWS account that owns the destination bucket by adding the AccessControlTranslation
	// element, this is the account ID of the destination bucket owner.
	Account *string `type:"string"`

	// Amazon resource name (ARN) of the bucket where you want Amazon S3 to store
	// replicas of the object identified by the rule.
	//
	// If you have multiple rules in your replication configuration, all rules must
	// specify the same bucket as the destination. A replication configuration can
	// replicate objects only to one destination bucket.
	//
	// Bucket is a required field
	Bucket *string `type:"string" required:"true"`

	// Container that provides encryption-related information. You must specify
	// this element if the SourceSelectionCriteria is specified.
	EncryptionConfiguration *EncryptionConfiguration `type:"structure"`

	// The class of storage used to store the object.
	StorageClass StorageClass `type:"string" enum:"true"`
}

// String returns the string representation
func (s Destination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Destination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Destination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Destination"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}
	if s.AccessControlTranslation != nil {
		if err := s.AccessControlTranslation.Validate(); err != nil {
			invalidParams.AddNested("AccessControlTranslation", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *Destination) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Destination) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccessControlTranslation != nil {
		v := s.AccessControlTranslation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AccessControlTranslation", v, metadata)
	}
	if s.Account != nil {
		v := *s.Account

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Account", protocol.StringValue(v), metadata)
	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.EncryptionConfiguration != nil {
		v := s.EncryptionConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "EncryptionConfiguration", v, metadata)
	}
	if len(s.StorageClass) > 0 {
		v := s.StorageClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StorageClass", v, metadata)
	}
	return nil
}

// Describes the server-side encryption that will be applied to the restore
// results.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Encryption
type Encryption struct {
	_ struct{} `type:"structure"`

	// The server-side encryption algorithm used when storing job results in Amazon
	// S3 (e.g., AES256, aws:kms).
	//
	// EncryptionType is a required field
	EncryptionType ServerSideEncryption `type:"string" required:"true" enum:"true"`

	// If the encryption type is aws:kms, this optional value can be used to specify
	// the encryption context for the restore results.
	KMSContext *string `type:"string"`

	// If the encryption type is aws:kms, this optional value specifies the AWS
	// KMS key ID to use for encryption of job results.
	KMSKeyId *string `type:"string"`
}

// String returns the string representation
func (s Encryption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Encryption) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Encryption) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Encryption"}
	if len(s.EncryptionType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("EncryptionType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Encryption) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.EncryptionType) > 0 {
		v := s.EncryptionType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EncryptionType", v, metadata)
	}
	if s.KMSContext != nil {
		v := *s.KMSContext

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KMSContext", protocol.StringValue(v), metadata)
	}
	if s.KMSKeyId != nil {
		v := *s.KMSKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KMSKeyId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Container for information regarding encryption based configuration for replicas.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/EncryptionConfiguration
type EncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS KMS key for the region where the destination bucket resides.
	// Amazon S3 uses this key to encrypt the replica object.
	ReplicaKmsKeyID *string `type:"string"`
}

// String returns the string representation
func (s EncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptionConfiguration) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EncryptionConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.ReplicaKmsKeyID != nil {
		v := *s.ReplicaKmsKeyID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReplicaKmsKeyID", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Error
type Error struct {
	_ struct{} `type:"structure"`

	Code *string `type:"string"`

	Key *string `min:"1" type:"string"`

	Message *string `type:"string"`

	VersionId *string `type:"string"`
}

// String returns the string representation
func (s Error) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Error) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Error) MarshalFields(e protocol.FieldEncoder) error {
	if s.Code != nil {
		v := *s.Code

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Code", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Message", protocol.StringValue(v), metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ErrorDocument
type ErrorDocument struct {
	_ struct{} `type:"structure"`

	// The object key name to use when a 4XX class error occurs.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ErrorDocument) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorDocument) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ErrorDocument) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ErrorDocument"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ErrorDocument) MarshalFields(e protocol.FieldEncoder) error {
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.StringValue(v), metadata)
	}
	return nil
}

// Container for key value pair that defines the criteria for the filter rule.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/FilterRule
type FilterRule struct {
	_ struct{} `type:"structure"`

	// Object key name prefix or suffix identifying one or more objects to which
	// the filtering rule applies. Maximum prefix length can be up to 1,024 characters.
	// Overlapping prefixes and suffixes are not supported. For more information,
	// go to Configuring Event Notifications (http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
	// in the Amazon Simple Storage Service Developer Guide.
	Name FilterRuleName `type:"string" enum:"true"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s FilterRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FilterRule) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FilterRule) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Name) > 0 {
		v := s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", v, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAccelerateConfigurationRequest
type GetBucketAccelerateConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Name of the bucket for which the accelerate configuration is retrieved.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketAccelerateConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketAccelerateConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketAccelerateConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetBucketAccelerateConfigurationInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *GetBucketAccelerateConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketAccelerateConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAccelerateConfigurationOutput
type GetBucketAccelerateConfigurationOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The accelerate configuration of the bucket.
	Status BucketAccelerateStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s GetBucketAccelerateConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketAccelerateConfigurationOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s GetBucketAccelerateConfigurationOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketAccelerateConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAclRequest
type GetBucketAclInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketAclInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketAclInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketAclInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetBucketAclInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *GetBucketAclInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketAclInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAclOutput
type GetBucketAclOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// A list of grants.
	Grants []Grant `locationName:"AccessControlList" locationNameList:"Grant" type:"list"`

	Owner *Owner `type:"structure"`
}

// String returns the string representation
func (s GetBucketAclOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketAclOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s GetBucketAclOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketAclOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Grants) > 0 {
		v := s.Grants

		metadata := protocol.Metadata{ListLocationName: "Grant"}
		ls0 := e.List(protocol.BodyTarget, "AccessControlList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Owner != nil {
		v := s.Owner

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Owner", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAnalyticsConfigurationRequest
type GetBucketAnalyticsConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the bucket from which an analytics configuration is retrieved.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The identifier used to represent an analytics configuration.
	//
	// Id is a required field
	Id *string `location:"querystring" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketAnalyticsConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketAnalyticsConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketAnalyticsConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetBucketAnalyticsConfigurationInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *GetBucketAnalyticsConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketAnalyticsConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "id", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAnalyticsConfigurationOutput
type GetBucketAnalyticsConfigurationOutput struct {
	_ struct{} `type:"structure" payload:"AnalyticsConfiguration"`

	responseMetadata aws.Response

	// The configuration and any analyses for the analytics filter.
	AnalyticsConfiguration *AnalyticsConfiguration `type:"structure"`
}

// String returns the string representation
func (s GetBucketAnalyticsConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketAnalyticsConfigurationOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s GetBucketAnalyticsConfigurationOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketAnalyticsConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AnalyticsConfiguration != nil {
		v := s.AnalyticsConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "AnalyticsConfiguration", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketCorsRequest
type GetBucketCorsInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketCorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketCorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketCorsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetBucketCorsInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *GetBucketCorsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketCorsInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketCorsOutput
type GetBucketCorsOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	CORSRules []CORSRule `locationName:"CORSRule" type:"list" flattened:"true"`
}

// String returns the string representation
func (s GetBucketCorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketCorsOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s GetBucketCorsOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketCorsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.CORSRules) > 0 {
		v := s.CORSRules

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "CORSRule", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketEncryptionRequest
type GetBucketEncryptionInput struct {
	_ struct{} `type:"structure"`

	// The name of the bucket from which the server-side encryption configuration
	// is retrieved.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketEncryptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketEncryptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketEncryptionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetBucketEncryptionInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *GetBucketEncryptionInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketEncryptionInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketEncryptionOutput
type GetBucketEncryptionOutput struct {
	_ struct{} `type:"structure" payload:"ServerSideEncryptionConfiguration"`

	responseMetadata aws.Response

	// Container for server-side encryption configuration rules. Currently S3 supports
	// one rule only.
	ServerSideEncryptionConfiguration *ServerSideEncryptionConfiguration `type:"structure"`
}

// String returns the string representation
func (s GetBucketEncryptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketEncryptionOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s GetBucketEncryptionOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketEncryptionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ServerSideEncryptionConfiguration != nil {
		v := s.ServerSideEncryptionConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "ServerSideEncryptionConfiguration", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketInventoryConfigurationRequest
type GetBucketInventoryConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the bucket containing the inventory configuration to retrieve.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The ID used to identify the inventory configuration.
	//
	// Id is a required field
	Id *string `location:"querystring" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketInventoryConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketInventoryConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketInventoryConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetBucketInventoryConfigurationInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *GetBucketInventoryConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketInventoryConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "id", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketInventoryConfigurationOutput
type GetBucketInventoryConfigurationOutput struct {
	_ struct{} `type:"structure" payload:"InventoryConfiguration"`

	responseMetadata aws.Response

	// Specifies the inventory configuration.
	InventoryConfiguration *InventoryConfiguration `type:"structure"`
}

// String returns the string representation
func (s GetBucketInventoryConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketInventoryConfigurationOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s GetBucketInventoryConfigurationOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketInventoryConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.InventoryConfiguration != nil {
		v := s.InventoryConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "InventoryConfiguration", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLifecycleConfigurationRequest
type GetBucketLifecycleConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketLifecycleConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLifecycleConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketLifecycleConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetBucketLifecycleConfigurationInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *GetBucketLifecycleConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketLifecycleConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLifecycleConfigurationOutput
type GetBucketLifecycleConfigurationOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	Rules []LifecycleRule `locationName:"Rule" type:"list" flattened:"true"`
}

// String returns the string representation
func (s GetBucketLifecycleConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLifecycleConfigurationOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s GetBucketLifecycleConfigurationOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketLifecycleConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Rules) > 0 {
		v := s.Rules

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Rule", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLifecycleRequest
type GetBucketLifecycleInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketLifecycleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLifecycleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketLifecycleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetBucketLifecycleInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *GetBucketLifecycleInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketLifecycleInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLifecycleOutput
type GetBucketLifecycleOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	Rules []Rule `locationName:"Rule" type:"list" flattened:"true"`
}

// String returns the string representation
func (s GetBucketLifecycleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLifecycleOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s GetBucketLifecycleOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketLifecycleOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Rules) > 0 {
		v := s.Rules

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Rule", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLocationRequest
type GetBucketLocationInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketLocationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLocationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketLocationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetBucketLocationInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *GetBucketLocationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketLocationInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLocationOutput
type GetBucketLocationOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	LocationConstraint BucketLocationConstraint `type:"string" enum:"true"`
}

// String returns the string representation
func (s GetBucketLocationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLocationOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s GetBucketLocationOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketLocationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.LocationConstraint) > 0 {
		v := s.LocationConstraint

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LocationConstraint", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLoggingRequest
type GetBucketLoggingInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketLoggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLoggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketLoggingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetBucketLoggingInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *GetBucketLoggingInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketLoggingInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLoggingOutput
type GetBucketLoggingOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// Container for logging information. Presence of this element indicates that
	// logging is enabled. Parameters TargetBucket and TargetPrefix are required
	// in this case.
	LoggingEnabled *LoggingEnabled `type:"structure"`
}

// String returns the string representation
func (s GetBucketLoggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLoggingOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s GetBucketLoggingOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketLoggingOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.LoggingEnabled != nil {
		v := s.LoggingEnabled

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LoggingEnabled", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketMetricsConfigurationRequest
type GetBucketMetricsConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the bucket containing the metrics configuration to retrieve.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The ID used to identify the metrics configuration.
	//
	// Id is a required field
	Id *string `location:"querystring" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketMetricsConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketMetricsConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketMetricsConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetBucketMetricsConfigurationInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *GetBucketMetricsConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketMetricsConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "id", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketMetricsConfigurationOutput
type GetBucketMetricsConfigurationOutput struct {
	_ struct{} `type:"structure" payload:"MetricsConfiguration"`

	responseMetadata aws.Response

	// Specifies the metrics configuration.
	MetricsConfiguration *MetricsConfiguration `type:"structure"`
}

// String returns the string representation
func (s GetBucketMetricsConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketMetricsConfigurationOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s GetBucketMetricsConfigurationOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketMetricsConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.MetricsConfiguration != nil {
		v := s.MetricsConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "MetricsConfiguration", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketNotificationInput
type GetBucketNotificationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Name of the bucket to get the notification configuration for.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketNotificationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketNotificationConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketNotificationConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetBucketNotificationConfigurationInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *GetBucketNotificationConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketNotificationConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	return nil
}

// Container for specifying the notification configuration of the bucket. If
// this element is empty, notifications are turned off on the bucket.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/NotificationConfiguration
type GetBucketNotificationConfigurationOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	LambdaFunctionConfigurations []LambdaFunctionConfiguration `locationName:"CloudFunctionConfiguration" type:"list" flattened:"true"`

	QueueConfigurations []QueueConfiguration `locationName:"QueueConfiguration" type:"list" flattened:"true"`

	TopicConfigurations []TopicConfiguration `locationName:"TopicConfiguration" type:"list" flattened:"true"`
}

// String returns the string representation
func (s GetBucketNotificationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketNotificationConfigurationOutput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketNotificationConfigurationOutput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetBucketNotificationConfigurationOutput"}
	if s.LambdaFunctionConfigurations != nil {
		for i, v := range s.LambdaFunctionConfigurations {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LambdaFunctionConfigurations", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.QueueConfigurations != nil {
		for i, v := range s.QueueConfigurations {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "QueueConfigurations", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.TopicConfigurations != nil {
		for i, v := range s.TopicConfigurations {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TopicConfigurations", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s GetBucketNotificationConfigurationOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketNotificationConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.LambdaFunctionConfigurations) > 0 {
		v := s.LambdaFunctionConfigurations

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "CloudFunctionConfiguration", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.QueueConfigurations) > 0 {
		v := s.QueueConfigurations

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "QueueConfiguration", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.TopicConfigurations) > 0 {
		v := s.TopicConfigurations

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "TopicConfiguration", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/NotificationConfigurationDeprecated
type GetBucketNotificationOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	CloudFunctionConfiguration *CloudFunctionConfiguration `type:"structure"`

	QueueConfiguration *QueueConfigurationDeprecated `type:"structure"`

	TopicConfiguration *TopicConfigurationDeprecated `type:"structure"`
}

// String returns the string representation
func (s GetBucketNotificationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketNotificationOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s GetBucketNotificationOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketNotificationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CloudFunctionConfiguration != nil {
		v := s.CloudFunctionConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CloudFunctionConfiguration", v, metadata)
	}
	if s.QueueConfiguration != nil {
		v := s.QueueConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "QueueConfiguration", v, metadata)
	}
	if s.TopicConfiguration != nil {
		v := s.TopicConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TopicConfiguration", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketPolicyRequest
type GetBucketPolicyInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetBucketPolicyInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *GetBucketPolicyInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketPolicyInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketPolicyOutput
type GetBucketPolicyOutput struct {
	_ struct{} `type:"structure" payload:"Policy"`

	responseMetadata aws.Response

	// The bucket policy as a JSON document.
	Policy *string `type:"string"`
}

// String returns the string representation
func (s GetBucketPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketPolicyOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s GetBucketPolicyOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketPolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Policy != nil {
		v := *s.Policy

		metadata := protocol.Metadata{}
		e.SetStream(protocol.PayloadTarget, "Policy", protocol.StringStream(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketReplicationRequest
type GetBucketReplicationInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketReplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketReplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketReplicationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetBucketReplicationInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *GetBucketReplicationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketReplicationInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketReplicationOutput
type GetBucketReplicationOutput struct {
	_ struct{} `type:"structure" payload:"ReplicationConfiguration"`

	responseMetadata aws.Response

	// Container for replication rules. You can add as many as 1,000 rules. Total
	// replication configuration size can be up to 2 MB.
	ReplicationConfiguration *ReplicationConfiguration `type:"structure"`
}

// String returns the string representation
func (s GetBucketReplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketReplicationOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s GetBucketReplicationOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketReplicationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ReplicationConfiguration != nil {
		v := s.ReplicationConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "ReplicationConfiguration", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketRequestPaymentRequest
type GetBucketRequestPaymentInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketRequestPaymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketRequestPaymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketRequestPaymentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetBucketRequestPaymentInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *GetBucketRequestPaymentInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketRequestPaymentInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketRequestPaymentOutput
type GetBucketRequestPaymentOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// Specifies who pays for the download and request fees.
	Payer Payer `type:"string" enum:"true"`
}

// String returns the string representation
func (s GetBucketRequestPaymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketRequestPaymentOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s GetBucketRequestPaymentOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketRequestPaymentOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Payer) > 0 {
		v := s.Payer

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Payer", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketTaggingRequest
type GetBucketTaggingInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketTaggingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetBucketTaggingInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *GetBucketTaggingInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketTaggingInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketTaggingOutput
type GetBucketTaggingOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// TagSet is a required field
	TagSet []Tag `locationNameList:"Tag" type:"list" required:"true"`
}

// String returns the string representation
func (s GetBucketTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketTaggingOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s GetBucketTaggingOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketTaggingOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.TagSet) > 0 {
		v := s.TagSet

		metadata := protocol.Metadata{ListLocationName: "Tag"}
		ls0 := e.List(protocol.BodyTarget, "TagSet", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketVersioningRequest
type GetBucketVersioningInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketVersioningInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketVersioningInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketVersioningInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetBucketVersioningInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *GetBucketVersioningInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketVersioningInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketVersioningOutput
type GetBucketVersioningOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// Specifies whether MFA delete is enabled in the bucket versioning configuration.
	// This element is only returned if the bucket has been configured with MFA
	// delete. If the bucket has never been so configured, this element is not returned.
	MFADelete MFADeleteStatus `locationName:"MfaDelete" type:"string" enum:"true"`

	// The versioning state of the bucket.
	Status BucketVersioningStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s GetBucketVersioningOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketVersioningOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s GetBucketVersioningOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketVersioningOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.MFADelete) > 0 {
		v := s.MFADelete

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MfaDelete", v, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketWebsiteRequest
type GetBucketWebsiteInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketWebsiteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketWebsiteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketWebsiteInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetBucketWebsiteInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *GetBucketWebsiteInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketWebsiteInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketWebsiteOutput
type GetBucketWebsiteOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	ErrorDocument *ErrorDocument `type:"structure"`

	IndexDocument *IndexDocument `type:"structure"`

	RedirectAllRequestsTo *RedirectAllRequestsTo `type:"structure"`

	RoutingRules []RoutingRule `locationNameList:"RoutingRule" type:"list"`
}

// String returns the string representation
func (s GetBucketWebsiteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketWebsiteOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s GetBucketWebsiteOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketWebsiteOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ErrorDocument != nil {
		v := s.ErrorDocument

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ErrorDocument", v, metadata)
	}
	if s.IndexDocument != nil {
		v := s.IndexDocument

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "IndexDocument", v, metadata)
	}
	if s.RedirectAllRequestsTo != nil {
		v := s.RedirectAllRequestsTo

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "RedirectAllRequestsTo", v, metadata)
	}
	if len(s.RoutingRules) > 0 {
		v := s.RoutingRules

		metadata := protocol.Metadata{ListLocationName: "RoutingRule"}
		ls0 := e.List(protocol.BodyTarget, "RoutingRules", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectAclRequest
type GetObjectAclInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer RequestPayer `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"true"`

	// VersionId used to reference a specific version of the object.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s GetObjectAclInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectAclInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetObjectAclInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetObjectAclInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *GetObjectAclInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetObjectAclInput) MarshalFields(e protocol.FieldEncoder) error {

	if len(s.RequestPayer) > 0 {
		v := s.RequestPayer

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-payer", v, metadata)
	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "versionId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectAclOutput
type GetObjectAclOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// A list of grants.
	Grants []Grant `locationName:"AccessControlList" locationNameList:"Grant" type:"list"`

	Owner *Owner `type:"structure"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged RequestCharged `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"true"`
}

// String returns the string representation
func (s GetObjectAclOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectAclOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s GetObjectAclOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetObjectAclOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Grants) > 0 {
		v := s.Grants

		metadata := protocol.Metadata{ListLocationName: "Grant"}
		ls0 := e.List(protocol.BodyTarget, "AccessControlList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Owner != nil {
		v := s.Owner

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Owner", v, metadata)
	}
	if len(s.RequestCharged) > 0 {
		v := s.RequestCharged

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-charged", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectRequest
type GetObjectInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Return the object only if its entity tag (ETag) is the same as the one specified,
	// otherwise return a 412 (precondition failed).
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`

	// Return the object only if it has been modified since the specified time,
	// otherwise return a 304 (not modified).
	IfModifiedSince *time.Time `location:"header" locationName:"If-Modified-Since" type:"timestamp" timestampFormat:"rfc822"`

	// Return the object only if its entity tag (ETag) is different from the one
	// specified, otherwise return a 304 (not modified).
	IfNoneMatch *string `location:"header" locationName:"If-None-Match" type:"string"`

	// Return the object only if it has not been modified since the specified time,
	// otherwise return a 412 (precondition failed).
	IfUnmodifiedSince *time.Time `location:"header" locationName:"If-Unmodified-Since" type:"timestamp" timestampFormat:"rfc822"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Part number of the object being read. This is a positive integer between
	// 1 and 10,000. Effectively performs a 'ranged' GET request for the part specified.
	// Useful for downloading just a part of an object.
	PartNumber *int64 `location:"querystring" locationName:"partNumber" type:"integer"`

	// Downloads the specified range bytes of an object. For more information about
	// the HTTP Range header, go to http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35.
	Range *string `location:"header" locationName:"Range" type:"string"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer RequestPayer `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"true"`

	// Sets the Cache-Control header of the response.
	ResponseCacheControl *string `location:"querystring" locationName:"response-cache-control" type:"string"`

	// Sets the Content-Disposition header of the response
	ResponseContentDisposition *string `location:"querystring" locationName:"response-content-disposition" type:"string"`

	// Sets the Content-Encoding header of the response.
	ResponseContentEncoding *string `location:"querystring" locationName:"response-content-encoding" type:"string"`

	// Sets the Content-Language header of the response.
	ResponseContentLanguage *string `location:"querystring" locationName:"response-content-language" type:"string"`

	// Sets the Content-Type header of the response.
	ResponseContentType *string `location:"querystring" locationName:"response-content-type" type:"string"`

	// Sets the Expires header of the response.
	ResponseExpires *time.Time `location:"querystring" locationName:"response-expires" type:"timestamp" timestampFormat:"iso8601"`

	// Specifies the algorithm to use to when encrypting the object (e.g., AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// does not store the encryption key. The key must be appropriate for use with
	// the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm
	// header.
	SSECustomerKey *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// VersionId used to reference a specific version of the object.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s GetObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetObjectInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetObjectInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *GetObjectInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

func (s *GetObjectInput) getSSECustomerKey() (v string) {
	if s.SSECustomerKey == nil {
		return v
	}
	return *s.SSECustomerKey
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetObjectInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.IfMatch != nil {
		v := *s.IfMatch

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "If-Match", protocol.StringValue(v), metadata)
	}
	if s.IfModifiedSince != nil {
		v := *s.IfModifiedSince

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "If-Modified-Since", protocol.TimeValue{V: v, Format: protocol.RFC822TimeFromat}, metadata)
	}
	if s.IfNoneMatch != nil {
		v := *s.IfNoneMatch

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "If-None-Match", protocol.StringValue(v), metadata)
	}
	if s.IfUnmodifiedSince != nil {
		v := *s.IfUnmodifiedSince

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "If-Unmodified-Since", protocol.TimeValue{V: v, Format: protocol.RFC822TimeFromat}, metadata)
	}
	if s.Range != nil {
		v := *s.Range

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Range", protocol.StringValue(v), metadata)
	}
	if len(s.RequestPayer) > 0 {
		v := s.RequestPayer

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-payer", v, metadata)
	}
	if s.SSECustomerAlgorithm != nil {
		v := *s.SSECustomerAlgorithm

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-customer-algorithm", protocol.StringValue(v), metadata)
	}
	if s.SSECustomerKey != nil {
		v := *s.SSECustomerKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-customer-key", protocol.StringValue(v), metadata)
	}
	if s.SSECustomerKeyMD5 != nil {
		v := *s.SSECustomerKeyMD5

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-customer-key-MD5", protocol.StringValue(v), metadata)
	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.PartNumber != nil {
		v := *s.PartNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "partNumber", protocol.Int64Value(v), metadata)
	}
	if s.ResponseCacheControl != nil {
		v := *s.ResponseCacheControl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "response-cache-control", protocol.StringValue(v), metadata)
	}
	if s.ResponseContentDisposition != nil {
		v := *s.ResponseContentDisposition

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "response-content-disposition", protocol.StringValue(v), metadata)
	}
	if s.ResponseContentEncoding != nil {
		v := *s.ResponseContentEncoding

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "response-content-encoding", protocol.StringValue(v), metadata)
	}
	if s.ResponseContentLanguage != nil {
		v := *s.ResponseContentLanguage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "response-content-language", protocol.StringValue(v), metadata)
	}
	if s.ResponseContentType != nil {
		v := *s.ResponseContentType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "response-content-type", protocol.StringValue(v), metadata)
	}
	if s.ResponseExpires != nil {
		v := *s.ResponseExpires

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "response-expires", protocol.TimeValue{V: v, Format: protocol.RFC822TimeFromat}, metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "versionId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectOutput
type GetObjectOutput struct {
	_ struct{} `type:"structure" payload:"Body"`

	responseMetadata aws.Response

	AcceptRanges *string `location:"header" locationName:"accept-ranges" type:"string"`

	// Object data.
	Body io.ReadCloser `type:"blob"`

	// Specifies caching behavior along the request/reply chain.
	CacheControl *string `location:"header" locationName:"Cache-Control" type:"string"`

	// Specifies presentational information for the object.
	ContentDisposition *string `location:"header" locationName:"Content-Disposition" type:"string"`

	// Specifies what content encodings have been applied to the object and thus
	// what decoding mechanisms must be applied to obtain the media-type referenced
	// by the Content-Type header field.
	ContentEncoding *string `location:"header" locationName:"Content-Encoding" type:"string"`

	// The language the content is in.
	ContentLanguage *string `location:"header" locationName:"Content-Language" type:"string"`

	// Size of the body in bytes.
	ContentLength *int64 `location:"header" locationName:"Content-Length" type:"long"`

	// The portion of the object returned in the response.
	ContentRange *string `location:"header" locationName:"Content-Range" type:"string"`

	// A standard MIME type describing the format of the object data.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// Specifies whether the object retrieved was (true) or was not (false) a Delete
	// Marker. If false, this response header does not appear in the response.
	DeleteMarker *bool `location:"header" locationName:"x-amz-delete-marker" type:"boolean"`

	// An ETag is an opaque identifier assigned by a web server to a specific version
	// of a resource found at a URL
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// If the object expiration is configured (see PUT Bucket lifecycle), the response
	// includes this header. It includes the expiry-date and rule-id key value pairs
	// providing object expiration information. The value of the rule-id is URL
	// encoded.
	Expiration *string `location:"header" locationName:"x-amz-expiration" type:"string"`

	// The date and time at which the object is no longer cacheable.
	Expires *string `location:"header" locationName:"Expires" type:"string"`

	// Last modified date of the object
	LastModified *time.Time `location:"header" locationName:"Last-Modified" type:"timestamp" timestampFormat:"rfc822"`

	// A map of metadata to store with the object in S3.
	Metadata map[string]string `location:"headers" locationName:"x-amz-meta-" type:"map"`

	// This is set to the number of metadata entries not returned in x-amz-meta
	// headers. This can happen if you create metadata using an API like SOAP that
	// supports more flexible metadata than the REST API. For example, using SOAP,
	// you can create metadata whose values are not legal HTTP headers.
	MissingMeta *int64 `location:"header" locationName:"x-amz-missing-meta" type:"integer"`

	// The count of parts this object has.
	PartsCount *int64 `location:"header" locationName:"x-amz-mp-parts-count" type:"integer"`

	ReplicationStatus ReplicationStatus `location:"header" locationName:"x-amz-replication-status" type:"string" enum:"true"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged RequestCharged `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"true"`

	// Provides information about object restoration operation and expiration time
	// of the restored object copy.
	Restore *string `location:"header" locationName:"x-amz-restore" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the ID of the AWS Key Management Service (KMS) master
	// encryption key that was used for the object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption ServerSideEncryption `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"true"`

	StorageClass StorageClass `location:"header" locationName:"x-amz-storage-class" type:"string" enum:"true"`

	// The number of tags, if any, on the object.
	TagCount *int64 `location:"header" locationName:"x-amz-tagging-count" type:"integer"`

	// Version of the object.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`

	// If the bucket is configured as a website, redirects requests for this object
	// to another object in the same bucket or to an external URL. Amazon S3 stores
	// the value of this header in the object metadata.
	WebsiteRedirectLocation *string `location:"header" locationName:"x-amz-website-redirect-location" type:"string"`
}

// String returns the string representation
func (s GetObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s GetObjectOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetObjectOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AcceptRanges != nil {
		v := *s.AcceptRanges

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "accept-ranges", protocol.StringValue(v), metadata)
	}
	if s.CacheControl != nil {
		v := *s.CacheControl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Cache-Control", protocol.StringValue(v), metadata)
	}
	if s.ContentDisposition != nil {
		v := *s.ContentDisposition

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Content-Disposition", protocol.StringValue(v), metadata)
	}
	if s.ContentEncoding != nil {
		v := *s.ContentEncoding

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Content-Encoding", protocol.StringValue(v), metadata)
	}
	if s.ContentLanguage != nil {
		v := *s.ContentLanguage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Content-Language", protocol.StringValue(v), metadata)
	}
	if s.ContentLength != nil {
		v := *s.ContentLength

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Content-Length", protocol.Int64Value(v), metadata)
	}
	if s.ContentRange != nil {
		v := *s.ContentRange

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Content-Range", protocol.StringValue(v), metadata)
	}
	if s.ContentType != nil {
		v := *s.ContentType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue(v), metadata)
	}
	if s.DeleteMarker != nil {
		v := *s.DeleteMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-delete-marker", protocol.BoolValue(v), metadata)
	}
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.Expiration != nil {
		v := *s.Expiration

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-expiration", protocol.StringValue(v), metadata)
	}
	if s.Expires != nil {
		v := *s.Expires

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Expires", protocol.StringValue(v), metadata)
	}
	if s.LastModified != nil {
		v := *s.LastModified

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Last-Modified", protocol.TimeValue{V: v, Format: protocol.RFC822TimeFromat}, metadata)
	}
	if s.MissingMeta != nil {
		v := *s.MissingMeta

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-missing-meta", protocol.Int64Value(v), metadata)
	}
	if s.PartsCount != nil {
		v := *s.PartsCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-mp-parts-count", protocol.Int64Value(v), metadata)
	}
	if len(s.ReplicationStatus) > 0 {
		v := s.ReplicationStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-replication-status", v, metadata)
	}
	if len(s.RequestCharged) > 0 {
		v := s.RequestCharged

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-charged", v, metadata)
	}
	if s.Restore != nil {
		v := *s.Restore

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-restore", protocol.StringValue(v), metadata)
	}
	if s.SSECustomerAlgorithm != nil {
		v := *s.SSECustomerAlgorithm

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-customer-algorithm", protocol.StringValue(v), metadata)
	}
	if s.SSECustomerKeyMD5 != nil {
		v := *s.SSECustomerKeyMD5

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-customer-key-MD5", protocol.StringValue(v), metadata)
	}
	if s.SSEKMSKeyId != nil {
		v := *s.SSEKMSKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-aws-kms-key-id", protocol.StringValue(v), metadata)
	}
	if len(s.ServerSideEncryption) > 0 {
		v := s.ServerSideEncryption

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption", v, metadata)
	}
	if len(s.StorageClass) > 0 {
		v := s.StorageClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-storage-class", v, metadata)
	}
	if s.TagCount != nil {
		v := *s.TagCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-tagging-count", protocol.Int64Value(v), metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-version-id", protocol.StringValue(v), metadata)
	}
	if s.WebsiteRedirectLocation != nil {
		v := *s.WebsiteRedirectLocation

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-website-redirect-location", protocol.StringValue(v), metadata)
	}
	if len(s.Metadata) > 0 {
		v := s.Metadata

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.HeadersTarget, "x-amz-meta-", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.StringValue(v1))
		}
		ms0.End()

	}
	// Skipping Body Output type's body not valid.
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectTaggingRequest
type GetObjectTaggingInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s GetObjectTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetObjectTaggingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetObjectTaggingInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *GetObjectTaggingInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetObjectTaggingInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "versionId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectTaggingOutput
type GetObjectTaggingOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// TagSet is a required field
	TagSet []Tag `locationNameList:"Tag" type:"list" required:"true"`

	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation
func (s GetObjectTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectTaggingOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s GetObjectTaggingOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetObjectTaggingOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.TagSet) > 0 {
		v := s.TagSet

		metadata := protocol.Metadata{ListLocationName: "Tag"}
		ls0 := e.List(protocol.BodyTarget, "TagSet", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-version-id", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectTorrentRequest
type GetObjectTorrentInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer RequestPayer `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"true"`
}

// String returns the string representation
func (s GetObjectTorrentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectTorrentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetObjectTorrentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetObjectTorrentInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *GetObjectTorrentInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetObjectTorrentInput) MarshalFields(e protocol.FieldEncoder) error {

	if len(s.RequestPayer) > 0 {
		v := s.RequestPayer

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-payer", v, metadata)
	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Key", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectTorrentOutput
type GetObjectTorrentOutput struct {
	_ struct{} `type:"structure" payload:"Body"`

	responseMetadata aws.Response

	Body io.ReadCloser `type:"blob"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged RequestCharged `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"true"`
}

// String returns the string representation
func (s GetObjectTorrentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectTorrentOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s GetObjectTorrentOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetObjectTorrentOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.RequestCharged) > 0 {
		v := s.RequestCharged

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-charged", v, metadata)
	}
	// Skipping Body Output type's body not valid.
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GlacierJobParameters
type GlacierJobParameters struct {
	_ struct{} `type:"structure"`

	// Glacier retrieval tier at which the restore will be processed.
	//
	// Tier is a required field
	Tier Tier `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s GlacierJobParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GlacierJobParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GlacierJobParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GlacierJobParameters"}
	if len(s.Tier) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Tier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GlacierJobParameters) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Tier) > 0 {
		v := s.Tier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Tier", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Grant
type Grant struct {
	_ struct{} `type:"structure"`

	Grantee *Grantee `type:"structure" xmlPrefix:"xsi" xmlURI:"http://www.w3.org/2001/XMLSchema-instance"`

	// Specifies the permission given to the grantee.
	Permission Permission `type:"string" enum:"true"`
}

// String returns the string representation
func (s Grant) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Grant) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Grant) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Grant"}
	if s.Grantee != nil {
		if err := s.Grantee.Validate(); err != nil {
			invalidParams.AddNested("Grantee", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Grant) MarshalFields(e protocol.FieldEncoder) error {
	if s.Grantee != nil {
		v := s.Grantee
		attrs := make([]protocol.Attribute, 0, 1)

		if len(s.Grantee.Type) > 0 {

			v := s.Grantee.Type
			attrs = append(attrs, protocol.Attribute{Name: "xsi:type", Value: v, Meta: protocol.Metadata{}})
		}
		metadata := protocol.Metadata{Attributes: attrs, XMLNamespacePrefix: "xsi", XMLNamespaceURI: "http://www.w3.org/2001/XMLSchema-instance"}
		e.SetFields(protocol.BodyTarget, "Grantee", v, metadata)
	}
	if len(s.Permission) > 0 {
		v := s.Permission

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Permission", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Grantee
type Grantee struct {
	_ struct{} `type:"structure" xmlPrefix:"xsi" xmlURI:"http://www.w3.org/2001/XMLSchema-instance"`

	// Screen name of the grantee.
	DisplayName *string `type:"string"`

	// Email address of the grantee.
	EmailAddress *string `type:"string"`

	// The canonical user ID of the grantee.
	ID *string `type:"string"`

	// Type of grantee
	//
	// Type is a required field
	Type Type `locationName:"xsi:type" type:"string" xmlAttribute:"true" required:"true" enum:"true"`

	// URI of the grantee group.
	URI *string `type:"string"`
}

// String returns the string representation
func (s Grantee) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Grantee) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Grantee) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Grantee"}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Grantee) MarshalFields(e protocol.FieldEncoder) error {
	if s.DisplayName != nil {
		v := *s.DisplayName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DisplayName", protocol.StringValue(v), metadata)
	}
	if s.EmailAddress != nil {
		v := *s.EmailAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EmailAddress", protocol.StringValue(v), metadata)
	}
	if s.ID != nil {
		v := *s.ID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ID", protocol.StringValue(v), metadata)
	}
	// Skipping Type XML Attribute.
	if s.URI != nil {
		v := *s.URI

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "URI", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/HeadBucketRequest
type HeadBucketInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s HeadBucketInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HeadBucketInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HeadBucketInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HeadBucketInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *HeadBucketInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HeadBucketInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/HeadBucketOutput
type HeadBucketOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s HeadBucketOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HeadBucketOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s HeadBucketOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HeadBucketOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/HeadObjectRequest
type HeadObjectInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Return the object only if its entity tag (ETag) is the same as the one specified,
	// otherwise return a 412 (precondition failed).
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`

	// Return the object only if it has been modified since the specified time,
	// otherwise return a 304 (not modified).
	IfModifiedSince *time.Time `location:"header" locationName:"If-Modified-Since" type:"timestamp" timestampFormat:"rfc822"`

	// Return the object only if its entity tag (ETag) is different from the one
	// specified, otherwise return a 304 (not modified).
	IfNoneMatch *string `location:"header" locationName:"If-None-Match" type:"string"`

	// Return the object only if it has not been modified since the specified time,
	// otherwise return a 412 (precondition failed).
	IfUnmodifiedSince *time.Time `location:"header" locationName:"If-Unmodified-Since" type:"timestamp" timestampFormat:"rfc822"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Part number of the object being read. This is a positive integer between
	// 1 and 10,000. Effectively performs a 'ranged' HEAD request for the part specified.
	// Useful querying about the size of the part and the number of parts in this
	// object.
	PartNumber *int64 `location:"querystring" locationName:"partNumber" type:"integer"`

	// Downloads the specified range bytes of an object. For more information about
	// the HTTP Range header, go to http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35.
	Range *string `location:"header" locationName:"Range" type:"string"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer RequestPayer `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"true"`

	// Specifies the algorithm to use to when encrypting the object (e.g., AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// does not store the encryption key. The key must be appropriate for use with
	// the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm
	// header.
	SSECustomerKey *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// VersionId used to reference a specific version of the object.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s HeadObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HeadObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HeadObjectInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HeadObjectInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *HeadObjectInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

func (s *HeadObjectInput) getSSECustomerKey() (v string) {
	if s.SSECustomerKey == nil {
		return v
	}
	return *s.SSECustomerKey
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HeadObjectInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.IfMatch != nil {
		v := *s.IfMatch

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "If-Match", protocol.StringValue(v), metadata)
	}
	if s.IfModifiedSince != nil {
		v := *s.IfModifiedSince

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "If-Modified-Since", protocol.TimeValue{V: v, Format: protocol.RFC822TimeFromat}, metadata)
	}
	if s.IfNoneMatch != nil {
		v := *s.IfNoneMatch

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "If-None-Match", protocol.StringValue(v), metadata)
	}
	if s.IfUnmodifiedSince != nil {
		v := *s.IfUnmodifiedSince

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "If-Unmodified-Since", protocol.TimeValue{V: v, Format: protocol.RFC822TimeFromat}, metadata)
	}
	if s.Range != nil {
		v := *s.Range

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Range", protocol.StringValue(v), metadata)
	}
	if len(s.RequestPayer) > 0 {
		v := s.RequestPayer

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-payer", v, metadata)
	}
	if s.SSECustomerAlgorithm != nil {
		v := *s.SSECustomerAlgorithm

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-customer-algorithm", protocol.StringValue(v), metadata)
	}
	if s.SSECustomerKey != nil {
		v := *s.SSECustomerKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-customer-key", protocol.StringValue(v), metadata)
	}
	if s.SSECustomerKeyMD5 != nil {
		v := *s.SSECustomerKeyMD5

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-customer-key-MD5", protocol.StringValue(v), metadata)
	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.PartNumber != nil {
		v := *s.PartNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "partNumber", protocol.Int64Value(v), metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "versionId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/HeadObjectOutput
type HeadObjectOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	AcceptRanges *string `location:"header" locationName:"accept-ranges" type:"string"`

	// Specifies caching behavior along the request/reply chain.
	CacheControl *string `location:"header" locationName:"Cache-Control" type:"string"`

	// Specifies presentational information for the object.
	ContentDisposition *string `location:"header" locationName:"Content-Disposition" type:"string"`

	// Specifies what content encodings have been applied to the object and thus
	// what decoding mechanisms must be applied to obtain the media-type referenced
	// by the Content-Type header field.
	ContentEncoding *string `location:"header" locationName:"Content-Encoding" type:"string"`

	// The language the content is in.
	ContentLanguage *string `location:"header" locationName:"Content-Language" type:"string"`

	// Size of the body in bytes.
	ContentLength *int64 `location:"header" locationName:"Content-Length" type:"long"`

	// A standard MIME type describing the format of the object data.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// Specifies whether the object retrieved was (true) or was not (false) a Delete
	// Marker. If false, this response header does not appear in the response.
	DeleteMarker *bool `location:"header" locationName:"x-amz-delete-marker" type:"boolean"`

	// An ETag is an opaque identifier assigned by a web server to a specific version
	// of a resource found at a URL
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// If the object expiration is configured (see PUT Bucket lifecycle), the response
	// includes this header. It includes the expiry-date and rule-id key value pairs
	// providing object expiration information. The value of the rule-id is URL
	// encoded.
	Expiration *string `location:"header" locationName:"x-amz-expiration" type:"string"`

	// The date and time at which the object is no longer cacheable.
	Expires *string `location:"header" locationName:"Expires" type:"string"`

	// Last modified date of the object
	LastModified *time.Time `location:"header" locationName:"Last-Modified" type:"timestamp" timestampFormat:"rfc822"`

	// A map of metadata to store with the object in S3.
	Metadata map[string]string `location:"headers" locationName:"x-amz-meta-" type:"map"`

	// This is set to the number of metadata entries not returned in x-amz-meta
	// headers. This can happen if you create metadata using an API like SOAP that
	// supports more flexible metadata than the REST API. For example, using SOAP,
	// you can create metadata whose values are not legal HTTP headers.
	MissingMeta *int64 `location:"header" locationName:"x-amz-missing-meta" type:"integer"`

	// The count of parts this object has.
	PartsCount *int64 `location:"header" locationName:"x-amz-mp-parts-count" type:"integer"`

	ReplicationStatus ReplicationStatus `location:"header" locationName:"x-amz-replication-status" type:"string" enum:"true"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged RequestCharged `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"true"`

	// Provides information about object restoration operation and expiration time
	// of the restored object copy.
	Restore *string `location:"header" locationName:"x-amz-restore" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the ID of the AWS Key Management Service (KMS) master
	// encryption key that was used for the object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption ServerSideEncryption `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"true"`

	StorageClass StorageClass `location:"header" locationName:"x-amz-storage-class" type:"string" enum:"true"`

	// Version of the object.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`

	// If the bucket is configured as a website, redirects requests for this object
	// to another object in the same bucket or to an external URL. Amazon S3 stores
	// the value of this header in the object metadata.
	WebsiteRedirectLocation *string `location:"header" locationName:"x-amz-website-redirect-location" type:"string"`
}

// String returns the string representation
func (s HeadObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HeadObjectOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s HeadObjectOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HeadObjectOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AcceptRanges != nil {
		v := *s.AcceptRanges

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "accept-ranges", protocol.StringValue(v), metadata)
	}
	if s.CacheControl != nil {
		v := *s.CacheControl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Cache-Control", protocol.StringValue(v), metadata)
	}
	if s.ContentDisposition != nil {
		v := *s.ContentDisposition

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Content-Disposition", protocol.StringValue(v), metadata)
	}
	if s.ContentEncoding != nil {
		v := *s.ContentEncoding

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Content-Encoding", protocol.StringValue(v), metadata)
	}
	if s.ContentLanguage != nil {
		v := *s.ContentLanguage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Content-Language", protocol.StringValue(v), metadata)
	}
	if s.ContentLength != nil {
		v := *s.ContentLength

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Content-Length", protocol.Int64Value(v), metadata)
	}
	if s.ContentType != nil {
		v := *s.ContentType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue(v), metadata)
	}
	if s.DeleteMarker != nil {
		v := *s.DeleteMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-delete-marker", protocol.BoolValue(v), metadata)
	}
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.Expiration != nil {
		v := *s.Expiration

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-expiration", protocol.StringValue(v), metadata)
	}
	if s.Expires != nil {
		v := *s.Expires

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Expires", protocol.StringValue(v), metadata)
	}
	if s.LastModified != nil {
		v := *s.LastModified

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Last-Modified", protocol.TimeValue{V: v, Format: protocol.RFC822TimeFromat}, metadata)
	}
	if s.MissingMeta != nil {
		v := *s.MissingMeta

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-missing-meta", protocol.Int64Value(v), metadata)
	}
	if s.PartsCount != nil {
		v := *s.PartsCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-mp-parts-count", protocol.Int64Value(v), metadata)
	}
	if len(s.ReplicationStatus) > 0 {
		v := s.ReplicationStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-replication-status", v, metadata)
	}
	if len(s.RequestCharged) > 0 {
		v := s.RequestCharged

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-charged", v, metadata)
	}
	if s.Restore != nil {
		v := *s.Restore

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-restore", protocol.StringValue(v), metadata)
	}
	if s.SSECustomerAlgorithm != nil {
		v := *s.SSECustomerAlgorithm

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-customer-algorithm", protocol.StringValue(v), metadata)
	}
	if s.SSECustomerKeyMD5 != nil {
		v := *s.SSECustomerKeyMD5

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-customer-key-MD5", protocol.StringValue(v), metadata)
	}
	if s.SSEKMSKeyId != nil {
		v := *s.SSEKMSKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-aws-kms-key-id", protocol.StringValue(v), metadata)
	}
	if len(s.ServerSideEncryption) > 0 {
		v := s.ServerSideEncryption

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption", v, metadata)
	}
	if len(s.StorageClass) > 0 {
		v := s.StorageClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-storage-class", v, metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-version-id", protocol.StringValue(v), metadata)
	}
	if s.WebsiteRedirectLocation != nil {
		v := *s.WebsiteRedirectLocation

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-website-redirect-location", protocol.StringValue(v), metadata)
	}
	if len(s.Metadata) > 0 {
		v := s.Metadata

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.HeadersTarget, "x-amz-meta-", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.StringValue(v1))
		}
		ms0.End()

	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/IndexDocument
type IndexDocument struct {
	_ struct{} `type:"structure"`

	// A suffix that is appended to a request that is for a directory on the website
	// endpoint (e.g. if the suffix is index.html and you make a request to samplebucket/images/
	// the data that is returned will be for the object with the key name images/index.html)
	// The suffix must not be empty and must not include a slash character.
	//
	// Suffix is a required field
	Suffix *string `type:"string" required:"true"`
}

// String returns the string representation
func (s IndexDocument) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IndexDocument) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IndexDocument) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "IndexDocument"}

	if s.Suffix == nil {
		invalidParams.Add(aws.NewErrParamRequired("Suffix"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s IndexDocument) MarshalFields(e protocol.FieldEncoder) error {
	if s.Suffix != nil {
		v := *s.Suffix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Suffix", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Initiator
type Initiator struct {
	_ struct{} `type:"structure"`

	// Name of the Principal.
	DisplayName *string `type:"string"`

	// If the principal is an AWS account, it provides the Canonical User ID. If
	// the principal is an IAM User, it provides a user ARN value.
	ID *string `type:"string"`
}

// String returns the string representation
func (s Initiator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Initiator) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Initiator) MarshalFields(e protocol.FieldEncoder) error {
	if s.DisplayName != nil {
		v := *s.DisplayName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DisplayName", protocol.StringValue(v), metadata)
	}
	if s.ID != nil {
		v := *s.ID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ID", protocol.StringValue(v), metadata)
	}
	return nil
}

// Describes the serialization format of the object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/InputSerialization
type InputSerialization struct {
	_ struct{} `type:"structure"`

	// Describes the serialization of a CSV-encoded object.
	CSV *CSVInput `type:"structure"`

	// Specifies object's compression format. Valid values: NONE, GZIP, BZIP2. Default
	// Value: NONE.
	CompressionType CompressionType `type:"string" enum:"true"`

	// Specifies JSON as object's input serialization format.
	JSON *JSONInput `type:"structure"`

	// Specifies Parquet as object's input serialization format.
	Parquet *ParquetInput `type:"structure"`
}

// String returns the string representation
func (s InputSerialization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputSerialization) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InputSerialization) MarshalFields(e protocol.FieldEncoder) error {
	if s.CSV != nil {
		v := s.CSV

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CSV", v, metadata)
	}
	if len(s.CompressionType) > 0 {
		v := s.CompressionType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CompressionType", v, metadata)
	}
	if s.JSON != nil {
		v := s.JSON

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "JSON", v, metadata)
	}
	if s.Parquet != nil {
		v := s.Parquet

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Parquet", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/InventoryConfiguration
type InventoryConfiguration struct {
	_ struct{} `type:"structure"`

	// Contains information about where to publish the inventory results.
	//
	// Destination is a required field
	Destination *InventoryDestination `type:"structure" required:"true"`

	// Specifies an inventory filter. The inventory only includes objects that meet
	// the filter's criteria.
	Filter *InventoryFilter `type:"structure"`

	// The ID used to identify the inventory configuration.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// Specifies which object version(s) to included in the inventory results.
	//
	// IncludedObjectVersions is a required field
	IncludedObjectVersions InventoryIncludedObjectVersions `type:"string" required:"true" enum:"true"`

	// Specifies whether the inventory is enabled or disabled.
	//
	// IsEnabled is a required field
	IsEnabled *bool `type:"boolean" required:"true"`

	// Contains the optional fields that are included in the inventory results.
	OptionalFields []InventoryOptionalField `locationNameList:"Field" type:"list"`

	// Specifies the schedule for generating inventory results.
	//
	// Schedule is a required field
	Schedule *InventorySchedule `type:"structure" required:"true"`
}

// String returns the string representation
func (s InventoryConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InventoryConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InventoryConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InventoryConfiguration"}

	if s.Destination == nil {
		invalidParams.Add(aws.NewErrParamRequired("Destination"))
	}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if len(s.IncludedObjectVersions) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("IncludedObjectVersions"))
	}

	if s.IsEnabled == nil {
		invalidParams.Add(aws.NewErrParamRequired("IsEnabled"))
	}

	if s.Schedule == nil {
		invalidParams.Add(aws.NewErrParamRequired("Schedule"))
	}
	if s.Destination != nil {
		if err := s.Destination.Validate(); err != nil {
			invalidParams.AddNested("Destination", err.(aws.ErrInvalidParams))
		}
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(aws.ErrInvalidParams))
		}
	}
	if s.Schedule != nil {
		if err := s.Schedule.Validate(); err != nil {
			invalidParams.AddNested("Schedule", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InventoryConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.Destination != nil {
		v := s.Destination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Destination", v, metadata)
	}
	if s.Filter != nil {
		v := s.Filter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Filter", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if len(s.IncludedObjectVersions) > 0 {
		v := s.IncludedObjectVersions

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IncludedObjectVersions", v, metadata)
	}
	if s.IsEnabled != nil {
		v := *s.IsEnabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsEnabled", protocol.BoolValue(v), metadata)
	}
	if len(s.OptionalFields) > 0 {
		v := s.OptionalFields

		metadata := protocol.Metadata{ListLocationName: "Field"}
		ls0 := e.List(protocol.BodyTarget, "OptionalFields", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.Schedule != nil {
		v := s.Schedule

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Schedule", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/InventoryDestination
type InventoryDestination struct {
	_ struct{} `type:"structure"`

	// Contains the bucket name, file format, bucket owner (optional), and prefix
	// (optional) where inventory results are published.
	//
	// S3BucketDestination is a required field
	S3BucketDestination *InventoryS3BucketDestination `type:"structure" required:"true"`
}

// String returns the string representation
func (s InventoryDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InventoryDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InventoryDestination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InventoryDestination"}

	if s.S3BucketDestination == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3BucketDestination"))
	}
	if s.S3BucketDestination != nil {
		if err := s.S3BucketDestination.Validate(); err != nil {
			invalidParams.AddNested("S3BucketDestination", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InventoryDestination) MarshalFields(e protocol.FieldEncoder) error {
	if s.S3BucketDestination != nil {
		v := s.S3BucketDestination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "S3BucketDestination", v, metadata)
	}
	return nil
}

// Contains the type of server-side encryption used to encrypt the inventory
// results.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/InventoryEncryption
type InventoryEncryption struct {
	_ struct{} `type:"structure"`

	// Specifies the use of SSE-KMS to encrypt delievered Inventory reports.
	SSEKMS *SSEKMS `locationName:"SSE-KMS" type:"structure"`

	// Specifies the use of SSE-S3 to encrypt delievered Inventory reports.
	SSES3 *SSES3 `locationName:"SSE-S3" type:"structure"`
}

// String returns the string representation
func (s InventoryEncryption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InventoryEncryption) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InventoryEncryption) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InventoryEncryption"}
	if s.SSEKMS != nil {
		if err := s.SSEKMS.Validate(); err != nil {
			invalidParams.AddNested("SSEKMS", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InventoryEncryption) MarshalFields(e protocol.FieldEncoder) error {
	if s.SSEKMS != nil {
		v := s.SSEKMS

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SSE-KMS", v, metadata)
	}
	if s.SSES3 != nil {
		v := s.SSES3

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SSE-S3", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/InventoryFilter
type InventoryFilter struct {
	_ struct{} `type:"structure"`

	// The prefix that an object must have to be included in the inventory results.
	//
	// Prefix is a required field
	Prefix *string `type:"string" required:"true"`
}

// String returns the string representation
func (s InventoryFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InventoryFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InventoryFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InventoryFilter"}

	if s.Prefix == nil {
		invalidParams.Add(aws.NewErrParamRequired("Prefix"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InventoryFilter) MarshalFields(e protocol.FieldEncoder) error {
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/InventoryS3BucketDestination
type InventoryS3BucketDestination struct {
	_ struct{} `type:"structure"`

	// The ID of the account that owns the destination bucket.
	AccountId *string `type:"string"`

	// The Amazon resource name (ARN) of the bucket where inventory results will
	// be published.
	//
	// Bucket is a required field
	Bucket *string `type:"string" required:"true"`

	// Contains the type of server-side encryption used to encrypt the inventory
	// results.
	Encryption *InventoryEncryption `type:"structure"`

	// Specifies the output format of the inventory results.
	//
	// Format is a required field
	Format InventoryFormat `type:"string" required:"true" enum:"true"`

	// The prefix that is prepended to all inventory results.
	Prefix *string `type:"string"`
}

// String returns the string representation
func (s InventoryS3BucketDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InventoryS3BucketDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InventoryS3BucketDestination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InventoryS3BucketDestination"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}
	if len(s.Format) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Format"))
	}
	if s.Encryption != nil {
		if err := s.Encryption.Validate(); err != nil {
			invalidParams.AddNested("Encryption", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *InventoryS3BucketDestination) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InventoryS3BucketDestination) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AccountId", protocol.StringValue(v), metadata)
	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Encryption != nil {
		v := s.Encryption

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Encryption", v, metadata)
	}
	if len(s.Format) > 0 {
		v := s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Format", v, metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/InventorySchedule
type InventorySchedule struct {
	_ struct{} `type:"structure"`

	// Specifies how frequently inventory results are produced.
	//
	// Frequency is a required field
	Frequency InventoryFrequency `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s InventorySchedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InventorySchedule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InventorySchedule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InventorySchedule"}
	if len(s.Frequency) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Frequency"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InventorySchedule) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Frequency) > 0 {
		v := s.Frequency

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Frequency", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/JSONInput
type JSONInput struct {
	_ struct{} `type:"structure"`

	// The type of JSON. Valid values: Document, Lines.
	Type JSONType `type:"string" enum:"true"`
}

// String returns the string representation
func (s JSONInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JSONInput) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JSONInput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/JSONOutput
type JSONOutput struct {
	_ struct{} `type:"structure"`

	// The value used to separate individual records in the output.
	RecordDelimiter *string `type:"string"`
}

// String returns the string representation
func (s JSONOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JSONOutput) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JSONOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.RecordDelimiter != nil {
		v := *s.RecordDelimiter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RecordDelimiter", protocol.StringValue(v), metadata)
	}
	return nil
}

// Container for object key name prefix and suffix filtering rules.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/S3KeyFilter
type KeyFilter struct {
	_ struct{} `type:"structure"`

	// A list of containers for key value pair that defines the criteria for the
	// filter rule.
	FilterRules []FilterRule `locationName:"FilterRule" type:"list" flattened:"true"`
}

// String returns the string representation
func (s KeyFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyFilter) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s KeyFilter) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.FilterRules) > 0 {
		v := s.FilterRules

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "FilterRule", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Container for specifying the AWS Lambda notification configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/LambdaFunctionConfiguration
type LambdaFunctionConfiguration struct {
	_ struct{} `type:"structure"`

	// Events is a required field
	Events []Event `locationName:"Event" type:"list" flattened:"true" required:"true"`

	// Container for object key name filtering rules. For information about key
	// name filtering, go to Configuring Event Notifications (http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
	// in the Amazon Simple Storage Service Developer Guide.
	Filter *NotificationConfigurationFilter `type:"structure"`

	// Optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	// Lambda cloud function ARN that Amazon S3 can invoke when it detects events
	// of the specified type.
	//
	// LambdaFunctionArn is a required field
	LambdaFunctionArn *string `locationName:"CloudFunction" type:"string" required:"true"`
}

// String returns the string representation
func (s LambdaFunctionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaFunctionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaFunctionConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LambdaFunctionConfiguration"}

	if s.Events == nil {
		invalidParams.Add(aws.NewErrParamRequired("Events"))
	}

	if s.LambdaFunctionArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("LambdaFunctionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LambdaFunctionConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Events) > 0 {
		v := s.Events

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Event", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.Filter != nil {
		v := s.Filter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Filter", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.LambdaFunctionArn != nil {
		v := *s.LambdaFunctionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CloudFunction", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/LifecycleConfiguration
type LifecycleConfiguration struct {
	_ struct{} `type:"structure"`

	// Rules is a required field
	Rules []Rule `locationName:"Rule" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s LifecycleConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LifecycleConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LifecycleConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LifecycleConfiguration"}

	if s.Rules == nil {
		invalidParams.Add(aws.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LifecycleConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Rules) > 0 {
		v := s.Rules

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Rule", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/LifecycleExpiration
type LifecycleExpiration struct {
	_ struct{} `type:"structure"`

	// Indicates at what date the object is to be moved or deleted. Should be in
	// GMT ISO 8601 Format.
	Date *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Indicates the lifetime, in days, of the objects that are subject to the rule.
	// The value must be a non-zero positive integer.
	Days *int64 `type:"integer"`

	// Indicates whether Amazon S3 will remove a delete marker with no noncurrent
	// versions. If set to true, the delete marker will be expired; if set to false
	// the policy takes no action. This cannot be specified with Days or Date in
	// a Lifecycle Expiration Policy.
	ExpiredObjectDeleteMarker *bool `type:"boolean"`
}

// String returns the string representation
func (s LifecycleExpiration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LifecycleExpiration) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LifecycleExpiration) MarshalFields(e protocol.FieldEncoder) error {
	if s.Date != nil {
		v := *s.Date

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Date", protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormat}, metadata)
	}
	if s.Days != nil {
		v := *s.Days

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Days", protocol.Int64Value(v), metadata)
	}
	if s.ExpiredObjectDeleteMarker != nil {
		v := *s.ExpiredObjectDeleteMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExpiredObjectDeleteMarker", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/LifecycleRule
type LifecycleRule struct {
	_ struct{} `type:"structure"`

	// Specifies the days since the initiation of an Incomplete Multipart Upload
	// that Lifecycle will wait before permanently removing all parts of the upload.
	AbortIncompleteMultipartUpload *AbortIncompleteMultipartUpload `type:"structure"`

	Expiration *LifecycleExpiration `type:"structure"`

	// The Filter is used to identify objects that a Lifecycle Rule applies to.
	// A Filter must have exactly one of Prefix, Tag, or And specified.
	Filter *LifecycleRuleFilter `type:"structure"`

	// Unique identifier for the rule. The value cannot be longer than 255 characters.
	ID *string `type:"string"`

	// Specifies when noncurrent object versions expire. Upon expiration, Amazon
	// S3 permanently deletes the noncurrent object versions. You set this lifecycle
	// configuration action on a bucket that has versioning enabled (or suspended)
	// to request that Amazon S3 delete noncurrent object versions at a specific
	// period in the object's lifetime.
	NoncurrentVersionExpiration *NoncurrentVersionExpiration `type:"structure"`

	NoncurrentVersionTransitions []NoncurrentVersionTransition `locationName:"NoncurrentVersionTransition" type:"list" flattened:"true"`

	// Prefix identifying one or more objects to which the rule applies. This is
	// deprecated; use Filter instead.
	Prefix *string `deprecated:"true" type:"string"`

	// If 'Enabled', the rule is currently being applied. If 'Disabled', the rule
	// is not currently being applied.
	//
	// Status is a required field
	Status ExpirationStatus `type:"string" required:"true" enum:"true"`

	Transitions []Transition `locationName:"Transition" type:"list" flattened:"true"`
}

// String returns the string representation
func (s LifecycleRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LifecycleRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LifecycleRule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LifecycleRule"}
	if len(s.Status) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LifecycleRule) MarshalFields(e protocol.FieldEncoder) error {
	if s.AbortIncompleteMultipartUpload != nil {
		v := s.AbortIncompleteMultipartUpload

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AbortIncompleteMultipartUpload", v, metadata)
	}
	if s.Expiration != nil {
		v := s.Expiration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Expiration", v, metadata)
	}
	if s.Filter != nil {
		v := s.Filter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Filter", v, metadata)
	}
	if s.ID != nil {
		v := *s.ID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ID", protocol.StringValue(v), metadata)
	}
	if s.NoncurrentVersionExpiration != nil {
		v := s.NoncurrentVersionExpiration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "NoncurrentVersionExpiration", v, metadata)
	}
	if len(s.NoncurrentVersionTransitions) > 0 {
		v := s.NoncurrentVersionTransitions

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "NoncurrentVersionTransition", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", v, metadata)
	}
	if len(s.Transitions) > 0 {
		v := s.Transitions

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Transition", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// This is used in a Lifecycle Rule Filter to apply a logical AND to two or
// more predicates. The Lifecycle Rule will apply to any object matching all
// of the predicates configured inside the And operator.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/LifecycleRuleAndOperator
type LifecycleRuleAndOperator struct {
	_ struct{} `type:"structure"`

	Prefix *string `type:"string"`

	// All of these tags must exist in the object's tag set in order for the rule
	// to apply.
	Tags []Tag `locationName:"Tag" locationNameList:"Tag" type:"list" flattened:"true"`
}

// String returns the string representation
func (s LifecycleRuleAndOperator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LifecycleRuleAndOperator) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LifecycleRuleAndOperator) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LifecycleRuleAndOperator"}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LifecycleRuleAndOperator) MarshalFields(e protocol.FieldEncoder) error {
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Tag", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// The Filter is used to identify objects that a Lifecycle Rule applies to.
// A Filter must have exactly one of Prefix, Tag, or And specified.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/LifecycleRuleFilter
type LifecycleRuleFilter struct {
	_ struct{} `type:"structure"`

	// This is used in a Lifecycle Rule Filter to apply a logical AND to two or
	// more predicates. The Lifecycle Rule will apply to any object matching all
	// of the predicates configured inside the And operator.
	And *LifecycleRuleAndOperator `type:"structure"`

	// Prefix identifying one or more objects to which the rule applies.
	Prefix *string `type:"string"`

	// This tag must exist in the object's tag set in order for the rule to apply.
	Tag *Tag `type:"structure"`
}

// String returns the string representation
func (s LifecycleRuleFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LifecycleRuleFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LifecycleRuleFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LifecycleRuleFilter"}
	if s.And != nil {
		if err := s.And.Validate(); err != nil {
			invalidParams.AddNested("And", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tag != nil {
		if err := s.Tag.Validate(); err != nil {
			invalidParams.AddNested("Tag", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LifecycleRuleFilter) MarshalFields(e protocol.FieldEncoder) error {
	if s.And != nil {
		v := s.And

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "And", v, metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if s.Tag != nil {
		v := s.Tag

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Tag", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketAnalyticsConfigurationsRequest
type ListBucketAnalyticsConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// The name of the bucket from which analytics configurations are retrieved.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The ContinuationToken that represents a placeholder from where this request
	// should begin.
	ContinuationToken *string `location:"querystring" locationName:"continuation-token" type:"string"`
}

// String returns the string representation
func (s ListBucketAnalyticsConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBucketAnalyticsConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBucketAnalyticsConfigurationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListBucketAnalyticsConfigurationsInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *ListBucketAnalyticsConfigurationsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListBucketAnalyticsConfigurationsInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.ContinuationToken != nil {
		v := *s.ContinuationToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "continuation-token", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketAnalyticsConfigurationsOutput
type ListBucketAnalyticsConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The list of analytics configurations for a bucket.
	AnalyticsConfigurationList []AnalyticsConfiguration `locationName:"AnalyticsConfiguration" type:"list" flattened:"true"`

	// The ContinuationToken that represents where this request began.
	ContinuationToken *string `type:"string"`

	// Indicates whether the returned list of analytics configurations is complete.
	// A value of true indicates that the list is not complete and the NextContinuationToken
	// will be provided for a subsequent request.
	IsTruncated *bool `type:"boolean"`

	// NextContinuationToken is sent when isTruncated is true, which indicates that
	// there are more analytics configurations to list. The next request must include
	// this NextContinuationToken. The token is obfuscated and is not a usable value.
	NextContinuationToken *string `type:"string"`
}

// String returns the string representation
func (s ListBucketAnalyticsConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBucketAnalyticsConfigurationsOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s ListBucketAnalyticsConfigurationsOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListBucketAnalyticsConfigurationsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AnalyticsConfigurationList) > 0 {
		v := s.AnalyticsConfigurationList

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "AnalyticsConfiguration", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ContinuationToken != nil {
		v := *s.ContinuationToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContinuationToken", protocol.StringValue(v), metadata)
	}
	if s.IsTruncated != nil {
		v := *s.IsTruncated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsTruncated", protocol.BoolValue(v), metadata)
	}
	if s.NextContinuationToken != nil {
		v := *s.NextContinuationToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextContinuationToken", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketInventoryConfigurationsRequest
type ListBucketInventoryConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// The name of the bucket containing the inventory configurations to retrieve.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The marker used to continue an inventory configuration listing that has been
	// truncated. Use the NextContinuationToken from a previously truncated list
	// response to continue the listing. The continuation token is an opaque value
	// that Amazon S3 understands.
	ContinuationToken *string `location:"querystring" locationName:"continuation-token" type:"string"`
}

// String returns the string representation
func (s ListBucketInventoryConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBucketInventoryConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBucketInventoryConfigurationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListBucketInventoryConfigurationsInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *ListBucketInventoryConfigurationsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListBucketInventoryConfigurationsInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.ContinuationToken != nil {
		v := *s.ContinuationToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "continuation-token", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketInventoryConfigurationsOutput
type ListBucketInventoryConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// If sent in the request, the marker that is used as a starting point for this
	// inventory configuration list response.
	ContinuationToken *string `type:"string"`

	// The list of inventory configurations for a bucket.
	InventoryConfigurationList []InventoryConfiguration `locationName:"InventoryConfiguration" type:"list" flattened:"true"`

	// Indicates whether the returned list of inventory configurations is truncated
	// in this response. A value of true indicates that the list is truncated.
	IsTruncated *bool `type:"boolean"`

	// The marker used to continue this inventory configuration listing. Use the
	// NextContinuationToken from this response to continue the listing in a subsequent
	// request. The continuation token is an opaque value that Amazon S3 understands.
	NextContinuationToken *string `type:"string"`
}

// String returns the string representation
func (s ListBucketInventoryConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBucketInventoryConfigurationsOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s ListBucketInventoryConfigurationsOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListBucketInventoryConfigurationsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ContinuationToken != nil {
		v := *s.ContinuationToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContinuationToken", protocol.StringValue(v), metadata)
	}
	if len(s.InventoryConfigurationList) > 0 {
		v := s.InventoryConfigurationList

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "InventoryConfiguration", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.IsTruncated != nil {
		v := *s.IsTruncated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsTruncated", protocol.BoolValue(v), metadata)
	}
	if s.NextContinuationToken != nil {
		v := *s.NextContinuationToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextContinuationToken", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketMetricsConfigurationsRequest
type ListBucketMetricsConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// The name of the bucket containing the metrics configurations to retrieve.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The marker that is used to continue a metrics configuration listing that
	// has been truncated. Use the NextContinuationToken from a previously truncated
	// list response to continue the listing. The continuation token is an opaque
	// value that Amazon S3 understands.
	ContinuationToken *string `location:"querystring" locationName:"continuation-token" type:"string"`
}

// String returns the string representation
func (s ListBucketMetricsConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBucketMetricsConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBucketMetricsConfigurationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListBucketMetricsConfigurationsInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *ListBucketMetricsConfigurationsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListBucketMetricsConfigurationsInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.ContinuationToken != nil {
		v := *s.ContinuationToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "continuation-token", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketMetricsConfigurationsOutput
type ListBucketMetricsConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The marker that is used as a starting point for this metrics configuration
	// list response. This value is present if it was sent in the request.
	ContinuationToken *string `type:"string"`

	// Indicates whether the returned list of metrics configurations is complete.
	// A value of true indicates that the list is not complete and the NextContinuationToken
	// will be provided for a subsequent request.
	IsTruncated *bool `type:"boolean"`

	// The list of metrics configurations for a bucket.
	MetricsConfigurationList []MetricsConfiguration `locationName:"MetricsConfiguration" type:"list" flattened:"true"`

	// The marker used to continue a metrics configuration listing that has been
	// truncated. Use the NextContinuationToken from a previously truncated list
	// response to continue the listing. The continuation token is an opaque value
	// that Amazon S3 understands.
	NextContinuationToken *string `type:"string"`
}

// String returns the string representation
func (s ListBucketMetricsConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBucketMetricsConfigurationsOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s ListBucketMetricsConfigurationsOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListBucketMetricsConfigurationsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ContinuationToken != nil {
		v := *s.ContinuationToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContinuationToken", protocol.StringValue(v), metadata)
	}
	if s.IsTruncated != nil {
		v := *s.IsTruncated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsTruncated", protocol.BoolValue(v), metadata)
	}
	if len(s.MetricsConfigurationList) > 0 {
		v := s.MetricsConfigurationList

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "MetricsConfiguration", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextContinuationToken != nil {
		v := *s.NextContinuationToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextContinuationToken", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketsInput
type ListBucketsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ListBucketsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBucketsInput) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListBucketsInput) MarshalFields(e protocol.FieldEncoder) error {

	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketsOutput
type ListBucketsOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	Buckets []Bucket `locationNameList:"Bucket" type:"list"`

	Owner *Owner `type:"structure"`
}

// String returns the string representation
func (s ListBucketsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBucketsOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s ListBucketsOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListBucketsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Buckets) > 0 {
		v := s.Buckets

		metadata := protocol.Metadata{ListLocationName: "Bucket"}
		ls0 := e.List(protocol.BodyTarget, "Buckets", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Owner != nil {
		v := s.Owner

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Owner", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListMultipartUploadsRequest
type ListMultipartUploadsInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Character you use to group keys.
	Delimiter *string `location:"querystring" locationName:"delimiter" type:"string"`

	// Requests Amazon S3 to encode the object keys in the response and specifies
	// the encoding method to use. An object key may contain any Unicode character;
	// however, XML 1.0 parser cannot parse some characters, such as characters
	// with an ASCII value from 0 to 10. For characters that are not supported in
	// XML 1.0, you can add this parameter to request that Amazon S3 encode the
	// keys in the response.
	EncodingType EncodingType `location:"querystring" locationName:"encoding-type" type:"string" enum:"true"`

	// Together with upload-id-marker, this parameter specifies the multipart upload
	// after which listing should begin.
	KeyMarker *string `location:"querystring" locationName:"key-marker" type:"string"`

	// Sets the maximum number of multipart uploads, from 1 to 1,000, to return
	// in the response body. 1,000 is the maximum number of uploads that can be
	// returned in a response.
	MaxUploads *int64 `location:"querystring" locationName:"max-uploads" type:"integer"`

	// Lists in-progress uploads only for those keys that begin with the specified
	// prefix.
	Prefix *string `location:"querystring" locationName:"prefix" type:"string"`

	// Together with key-marker, specifies the multipart upload after which listing
	// should begin. If key-marker is not specified, the upload-id-marker parameter
	// is ignored.
	UploadIdMarker *string `location:"querystring" locationName:"upload-id-marker" type:"string"`
}

// String returns the string representation
func (s ListMultipartUploadsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMultipartUploadsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMultipartUploadsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListMultipartUploadsInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *ListMultipartUploadsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListMultipartUploadsInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Delimiter != nil {
		v := *s.Delimiter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "delimiter", protocol.StringValue(v), metadata)
	}
	if len(s.EncodingType) > 0 {
		v := s.EncodingType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "encoding-type", v, metadata)
	}
	if s.KeyMarker != nil {
		v := *s.KeyMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "key-marker", protocol.StringValue(v), metadata)
	}
	if s.MaxUploads != nil {
		v := *s.MaxUploads

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "max-uploads", protocol.Int64Value(v), metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "prefix", protocol.StringValue(v), metadata)
	}
	if s.UploadIdMarker != nil {
		v := *s.UploadIdMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "upload-id-marker", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListMultipartUploadsOutput
type ListMultipartUploadsOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// Name of the bucket to which the multipart upload was initiated.
	Bucket *string `type:"string"`

	CommonPrefixes []CommonPrefix `type:"list" flattened:"true"`

	Delimiter *string `type:"string"`

	// Encoding type used by Amazon S3 to encode object keys in the response.
	EncodingType EncodingType `type:"string" enum:"true"`

	// Indicates whether the returned list of multipart uploads is truncated. A
	// value of true indicates that the list was truncated. The list can be truncated
	// if the number of multipart uploads exceeds the limit allowed or specified
	// by max uploads.
	IsTruncated *bool `type:"boolean"`

	// The key at or after which the listing began.
	KeyMarker *string `type:"string"`

	// Maximum number of multipart uploads that could have been included in the
	// response.
	MaxUploads *int64 `type:"integer"`

	// When a list is truncated, this element specifies the value that should be
	// used for the key-marker request parameter in a subsequent request.
	NextKeyMarker *string `type:"string"`

	// When a list is truncated, this element specifies the value that should be
	// used for the upload-id-marker request parameter in a subsequent request.
	NextUploadIdMarker *string `type:"string"`

	// When a prefix is provided in the request, this field contains the specified
	// prefix. The result contains only keys starting with the specified prefix.
	Prefix *string `type:"string"`

	// Upload ID after which listing began.
	UploadIdMarker *string `type:"string"`

	Uploads []MultipartUpload `locationName:"Upload" type:"list" flattened:"true"`
}

// String returns the string representation
func (s ListMultipartUploadsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMultipartUploadsOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s ListMultipartUploadsOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

func (s *ListMultipartUploadsOutput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListMultipartUploadsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if len(s.CommonPrefixes) > 0 {
		v := s.CommonPrefixes

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "CommonPrefixes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Delimiter != nil {
		v := *s.Delimiter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Delimiter", protocol.StringValue(v), metadata)
	}
	if len(s.EncodingType) > 0 {
		v := s.EncodingType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EncodingType", v, metadata)
	}
	if s.IsTruncated != nil {
		v := *s.IsTruncated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsTruncated", protocol.BoolValue(v), metadata)
	}
	if s.KeyMarker != nil {
		v := *s.KeyMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KeyMarker", protocol.StringValue(v), metadata)
	}
	if s.MaxUploads != nil {
		v := *s.MaxUploads

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxUploads", protocol.Int64Value(v), metadata)
	}
	if s.NextKeyMarker != nil {
		v := *s.NextKeyMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextKeyMarker", protocol.StringValue(v), metadata)
	}
	if s.NextUploadIdMarker != nil {
		v := *s.NextUploadIdMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextUploadIdMarker", protocol.StringValue(v), metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if s.UploadIdMarker != nil {
		v := *s.UploadIdMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UploadIdMarker", protocol.StringValue(v), metadata)
	}
	if len(s.Uploads) > 0 {
		v := s.Uploads

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Upload", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjectVersionsRequest
type ListObjectVersionsInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// A delimiter is a character you use to group keys.
	Delimiter *string `location:"querystring" locationName:"delimiter" type:"string"`

	// Requests Amazon S3 to encode the object keys in the response and specifies
	// the encoding method to use. An object key may contain any Unicode character;
	// however, XML 1.0 parser cannot parse some characters, such as characters
	// with an ASCII value from 0 to 10. For characters that are not supported in
	// XML 1.0, you can add this parameter to request that Amazon S3 encode the
	// keys in the response.
	EncodingType EncodingType `location:"querystring" locationName:"encoding-type" type:"string" enum:"true"`

	// Specifies the key to start with when listing objects in a bucket.
	KeyMarker *string `location:"querystring" locationName:"key-marker" type:"string"`

	// Sets the maximum number of keys returned in the response. The response might
	// contain fewer keys but will never contain more.
	MaxKeys *int64 `location:"querystring" locationName:"max-keys" type:"integer"`

	// Limits the response to keys that begin with the specified prefix.
	Prefix *string `location:"querystring" locationName:"prefix" type:"string"`

	// Specifies the object version you want to start listing from.
	VersionIdMarker *string `location:"querystring" locationName:"version-id-marker" type:"string"`
}

// String returns the string representation
func (s ListObjectVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListObjectVersionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListObjectVersionsInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *ListObjectVersionsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListObjectVersionsInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Delimiter != nil {
		v := *s.Delimiter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "delimiter", protocol.StringValue(v), metadata)
	}
	if len(s.EncodingType) > 0 {
		v := s.EncodingType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "encoding-type", v, metadata)
	}
	if s.KeyMarker != nil {
		v := *s.KeyMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "key-marker", protocol.StringValue(v), metadata)
	}
	if s.MaxKeys != nil {
		v := *s.MaxKeys

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "max-keys", protocol.Int64Value(v), metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "prefix", protocol.StringValue(v), metadata)
	}
	if s.VersionIdMarker != nil {
		v := *s.VersionIdMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "version-id-marker", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjectVersionsOutput
type ListObjectVersionsOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	CommonPrefixes []CommonPrefix `type:"list" flattened:"true"`

	DeleteMarkers []DeleteMarkerEntry `locationName:"DeleteMarker" type:"list" flattened:"true"`

	Delimiter *string `type:"string"`

	// Encoding type used by Amazon S3 to encode object keys in the response.
	EncodingType EncodingType `type:"string" enum:"true"`

	// A flag that indicates whether or not Amazon S3 returned all of the results
	// that satisfied the search criteria. If your results were truncated, you can
	// make a follow-up paginated request using the NextKeyMarker and NextVersionIdMarker
	// response parameters as a starting place in another request to return the
	// rest of the results.
	IsTruncated *bool `type:"boolean"`

	// Marks the last Key returned in a truncated response.
	KeyMarker *string `type:"string"`

	MaxKeys *int64 `type:"integer"`

	Name *string `type:"string"`

	// Use this value for the key marker request parameter in a subsequent request.
	NextKeyMarker *string `type:"string"`

	// Use this value for the next version id marker parameter in a subsequent request.
	NextVersionIdMarker *string `type:"string"`

	Prefix *string `type:"string"`

	VersionIdMarker *string `type:"string"`

	Versions []ObjectVersion `locationName:"Version" type:"list" flattened:"true"`
}

// String returns the string representation
func (s ListObjectVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectVersionsOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s ListObjectVersionsOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListObjectVersionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.CommonPrefixes) > 0 {
		v := s.CommonPrefixes

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "CommonPrefixes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.DeleteMarkers) > 0 {
		v := s.DeleteMarkers

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "DeleteMarker", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Delimiter != nil {
		v := *s.Delimiter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Delimiter", protocol.StringValue(v), metadata)
	}
	if len(s.EncodingType) > 0 {
		v := s.EncodingType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EncodingType", v, metadata)
	}
	if s.IsTruncated != nil {
		v := *s.IsTruncated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsTruncated", protocol.BoolValue(v), metadata)
	}
	if s.KeyMarker != nil {
		v := *s.KeyMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KeyMarker", protocol.StringValue(v), metadata)
	}
	if s.MaxKeys != nil {
		v := *s.MaxKeys

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxKeys", protocol.Int64Value(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.StringValue(v), metadata)
	}
	if s.NextKeyMarker != nil {
		v := *s.NextKeyMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextKeyMarker", protocol.StringValue(v), metadata)
	}
	if s.NextVersionIdMarker != nil {
		v := *s.NextVersionIdMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextVersionIdMarker", protocol.StringValue(v), metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if s.VersionIdMarker != nil {
		v := *s.VersionIdMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionIdMarker", protocol.StringValue(v), metadata)
	}
	if len(s.Versions) > 0 {
		v := s.Versions

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Version", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjectsRequest
type ListObjectsInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// A delimiter is a character you use to group keys.
	Delimiter *string `location:"querystring" locationName:"delimiter" type:"string"`

	// Requests Amazon S3 to encode the object keys in the response and specifies
	// the encoding method to use. An object key may contain any Unicode character;
	// however, XML 1.0 parser cannot parse some characters, such as characters
	// with an ASCII value from 0 to 10. For characters that are not supported in
	// XML 1.0, you can add this parameter to request that Amazon S3 encode the
	// keys in the response.
	EncodingType EncodingType `location:"querystring" locationName:"encoding-type" type:"string" enum:"true"`

	// Specifies the key to start with when listing objects in a bucket.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// Sets the maximum number of keys returned in the response. The response might
	// contain fewer keys but will never contain more.
	MaxKeys *int64 `location:"querystring" locationName:"max-keys" type:"integer"`

	// Limits the response to keys that begin with the specified prefix.
	Prefix *string `location:"querystring" locationName:"prefix" type:"string"`

	// Confirms that the requester knows that she or he will be charged for the
	// list objects request. Bucket owners need not specify this parameter in their
	// requests.
	RequestPayer RequestPayer `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"true"`
}

// String returns the string representation
func (s ListObjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListObjectsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListObjectsInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *ListObjectsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListObjectsInput) MarshalFields(e protocol.FieldEncoder) error {

	if len(s.RequestPayer) > 0 {
		v := s.RequestPayer

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-payer", v, metadata)
	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Delimiter != nil {
		v := *s.Delimiter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "delimiter", protocol.StringValue(v), metadata)
	}
	if len(s.EncodingType) > 0 {
		v := s.EncodingType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "encoding-type", v, metadata)
	}
	if s.Marker != nil {
		v := *s.Marker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "marker", protocol.StringValue(v), metadata)
	}
	if s.MaxKeys != nil {
		v := *s.MaxKeys

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "max-keys", protocol.Int64Value(v), metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "prefix", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjectsOutput
type ListObjectsOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	CommonPrefixes []CommonPrefix `type:"list" flattened:"true"`

	Contents []Object `type:"list" flattened:"true"`

	Delimiter *string `type:"string"`

	// Encoding type used by Amazon S3 to encode object keys in the response.
	EncodingType EncodingType `type:"string" enum:"true"`

	// A flag that indicates whether or not Amazon S3 returned all of the results
	// that satisfied the search criteria.
	IsTruncated *bool `type:"boolean"`

	Marker *string `type:"string"`

	MaxKeys *int64 `type:"integer"`

	Name *string `type:"string"`

	// When response is truncated (the IsTruncated element value in the response
	// is true), you can use the key name in this field as marker in the subsequent
	// request to get next set of objects. Amazon S3 lists objects in alphabetical
	// order Note: This element is returned only if you have delimiter request parameter
	// specified. If response does not include the NextMaker and it is truncated,
	// you can use the value of the last Key in the response as the marker in the
	// subsequent request to get the next set of object keys.
	NextMarker *string `type:"string"`

	Prefix *string `type:"string"`
}

// String returns the string representation
func (s ListObjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectsOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s ListObjectsOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListObjectsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.CommonPrefixes) > 0 {
		v := s.CommonPrefixes

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "CommonPrefixes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Contents) > 0 {
		v := s.Contents

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Contents", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Delimiter != nil {
		v := *s.Delimiter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Delimiter", protocol.StringValue(v), metadata)
	}
	if len(s.EncodingType) > 0 {
		v := s.EncodingType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EncodingType", v, metadata)
	}
	if s.IsTruncated != nil {
		v := *s.IsTruncated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsTruncated", protocol.BoolValue(v), metadata)
	}
	if s.Marker != nil {
		v := *s.Marker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Marker", protocol.StringValue(v), metadata)
	}
	if s.MaxKeys != nil {
		v := *s.MaxKeys

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxKeys", protocol.Int64Value(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.StringValue(v), metadata)
	}
	if s.NextMarker != nil {
		v := *s.NextMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextMarker", protocol.StringValue(v), metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjectsV2Request
type ListObjectsV2Input struct {
	_ struct{} `type:"structure"`

	// Name of the bucket to list.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// ContinuationToken indicates Amazon S3 that the list is being continued on
	// this bucket with a token. ContinuationToken is obfuscated and is not a real
	// key
	ContinuationToken *string `location:"querystring" locationName:"continuation-token" type:"string"`

	// A delimiter is a character you use to group keys.
	Delimiter *string `location:"querystring" locationName:"delimiter" type:"string"`

	// Encoding type used by Amazon S3 to encode object keys in the response.
	EncodingType EncodingType `location:"querystring" locationName:"encoding-type" type:"string" enum:"true"`

	// The owner field is not present in listV2 by default, if you want to return
	// owner field with each key in the result then set the fetch owner field to
	// true
	FetchOwner *bool `location:"querystring" locationName:"fetch-owner" type:"boolean"`

	// Sets the maximum number of keys returned in the response. The response might
	// contain fewer keys but will never contain more.
	MaxKeys *int64 `location:"querystring" locationName:"max-keys" type:"integer"`

	// Limits the response to keys that begin with the specified prefix.
	Prefix *string `location:"querystring" locationName:"prefix" type:"string"`

	// Confirms that the requester knows that she or he will be charged for the
	// list objects request in V2 style. Bucket owners need not specify this parameter
	// in their requests.
	RequestPayer RequestPayer `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"true"`

	// StartAfter is where you want Amazon S3 to start listing from. Amazon S3 starts
	// listing after this specified key. StartAfter can be any key in the bucket
	StartAfter *string `location:"querystring" locationName:"start-after" type:"string"`
}

// String returns the string representation
func (s ListObjectsV2Input) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectsV2Input) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListObjectsV2Input) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListObjectsV2Input"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *ListObjectsV2Input) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListObjectsV2Input) MarshalFields(e protocol.FieldEncoder) error {

	if len(s.RequestPayer) > 0 {
		v := s.RequestPayer

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-payer", v, metadata)
	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.ContinuationToken != nil {
		v := *s.ContinuationToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "continuation-token", protocol.StringValue(v), metadata)
	}
	if s.Delimiter != nil {
		v := *s.Delimiter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "delimiter", protocol.StringValue(v), metadata)
	}
	if len(s.EncodingType) > 0 {
		v := s.EncodingType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "encoding-type", v, metadata)
	}
	if s.FetchOwner != nil {
		v := *s.FetchOwner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "fetch-owner", protocol.BoolValue(v), metadata)
	}
	if s.MaxKeys != nil {
		v := *s.MaxKeys

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "max-keys", protocol.Int64Value(v), metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "prefix", protocol.StringValue(v), metadata)
	}
	if s.StartAfter != nil {
		v := *s.StartAfter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "start-after", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjectsV2Output
type ListObjectsV2Output struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// CommonPrefixes contains all (if there are any) keys between Prefix and the
	// next occurrence of the string specified by delimiter
	CommonPrefixes []CommonPrefix `type:"list" flattened:"true"`

	// Metadata about each object returned.
	Contents []Object `type:"list" flattened:"true"`

	// ContinuationToken indicates Amazon S3 that the list is being continued on
	// this bucket with a token. ContinuationToken is obfuscated and is not a real
	// key
	ContinuationToken *string `type:"string"`

	// A delimiter is a character you use to group keys.
	Delimiter *string `type:"string"`

	// Encoding type used by Amazon S3 to encode object keys in the response.
	EncodingType EncodingType `type:"string" enum:"true"`

	// A flag that indicates whether or not Amazon S3 returned all of the results
	// that satisfied the search criteria.
	IsTruncated *bool `type:"boolean"`

	// KeyCount is the number of keys returned with this request. KeyCount will
	// always be less than equals to MaxKeys field. Say you ask for 50 keys, your
	// result will include less than equals 50 keys
	KeyCount *int64 `type:"integer"`

	// Sets the maximum number of keys returned in the response. The response might
	// contain fewer keys but will never contain more.
	MaxKeys *int64 `type:"integer"`

	// Name of the bucket to list.
	Name *string `type:"string"`

	// NextContinuationToken is sent when isTruncated is true which means there
	// are more keys in the bucket that can be listed. The next list requests to
	// Amazon S3 can be continued with this NextContinuationToken. NextContinuationToken
	// is obfuscated and is not a real key
	NextContinuationToken *string `type:"string"`

	// Limits the response to keys that begin with the specified prefix.
	Prefix *string `type:"string"`

	// StartAfter is where you want Amazon S3 to start listing from. Amazon S3 starts
	// listing after this specified key. StartAfter can be any key in the bucket
	StartAfter *string `type:"string"`
}

// String returns the string representation
func (s ListObjectsV2Output) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectsV2Output) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s ListObjectsV2Output) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListObjectsV2Output) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.CommonPrefixes) > 0 {
		v := s.CommonPrefixes

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "CommonPrefixes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Contents) > 0 {
		v := s.Contents

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Contents", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ContinuationToken != nil {
		v := *s.ContinuationToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContinuationToken", protocol.StringValue(v), metadata)
	}
	if s.Delimiter != nil {
		v := *s.Delimiter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Delimiter", protocol.StringValue(v), metadata)
	}
	if len(s.EncodingType) > 0 {
		v := s.EncodingType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EncodingType", v, metadata)
	}
	if s.IsTruncated != nil {
		v := *s.IsTruncated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsTruncated", protocol.BoolValue(v), metadata)
	}
	if s.KeyCount != nil {
		v := *s.KeyCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KeyCount", protocol.Int64Value(v), metadata)
	}
	if s.MaxKeys != nil {
		v := *s.MaxKeys

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxKeys", protocol.Int64Value(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.StringValue(v), metadata)
	}
	if s.NextContinuationToken != nil {
		v := *s.NextContinuationToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextContinuationToken", protocol.StringValue(v), metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if s.StartAfter != nil {
		v := *s.StartAfter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartAfter", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListPartsRequest
type ListPartsInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Sets the maximum number of parts to return.
	MaxParts *int64 `location:"querystring" locationName:"max-parts" type:"integer"`

	// Specifies the part after which listing should begin. Only parts with higher
	// part numbers will be listed.
	PartNumberMarker *int64 `location:"querystring" locationName:"part-number-marker" type:"integer"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer RequestPayer `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"true"`

	// Upload ID identifying the multipart upload whose parts are being listed.
	//
	// UploadId is a required field
	UploadId *string `location:"querystring" locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPartsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPartsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPartsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListPartsInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.UploadId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UploadId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *ListPartsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListPartsInput) MarshalFields(e protocol.FieldEncoder) error {

	if len(s.RequestPayer) > 0 {
		v := s.RequestPayer

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-payer", v, metadata)
	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.MaxParts != nil {
		v := *s.MaxParts

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "max-parts", protocol.Int64Value(v), metadata)
	}
	if s.PartNumberMarker != nil {
		v := *s.PartNumberMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "part-number-marker", protocol.Int64Value(v), metadata)
	}
	if s.UploadId != nil {
		v := *s.UploadId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "uploadId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListPartsOutput
type ListPartsOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// Date when multipart upload will become eligible for abort operation by lifecycle.
	AbortDate *time.Time `location:"header" locationName:"x-amz-abort-date" type:"timestamp" timestampFormat:"rfc822"`

	// Id of the lifecycle rule that makes a multipart upload eligible for abort
	// operation.
	AbortRuleId *string `location:"header" locationName:"x-amz-abort-rule-id" type:"string"`

	// Name of the bucket to which the multipart upload was initiated.
	Bucket *string `type:"string"`

	// Identifies who initiated the multipart upload.
	Initiator *Initiator `type:"structure"`

	// Indicates whether the returned list of parts is truncated.
	IsTruncated *bool `type:"boolean"`

	// Object key for which the multipart upload was initiated.
	Key *string `min:"1" type:"string"`

	// Maximum number of parts that were allowed in the response.
	MaxParts *int64 `type:"integer"`

	// When a list is truncated, this element specifies the last part in the list,
	// as well as the value to use for the part-number-marker request parameter
	// in a subsequent request.
	NextPartNumberMarker *int64 `type:"integer"`

	Owner *Owner `type:"structure"`

	// Part number after which listing begins.
	PartNumberMarker *int64 `type:"integer"`

	Parts []Part `locationName:"Part" type:"list" flattened:"true"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged RequestCharged `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"true"`

	// The class of storage used to store the object.
	StorageClass StorageClass `type:"string" enum:"true"`

	// Upload ID identifying the multipart upload whose parts are being listed.
	UploadId *string `type:"string"`
}

// String returns the string representation
func (s ListPartsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPartsOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s ListPartsOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

func (s *ListPartsOutput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListPartsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Initiator != nil {
		v := s.Initiator

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Initiator", v, metadata)
	}
	if s.IsTruncated != nil {
		v := *s.IsTruncated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsTruncated", protocol.BoolValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.MaxParts != nil {
		v := *s.MaxParts

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxParts", protocol.Int64Value(v), metadata)
	}
	if s.NextPartNumberMarker != nil {
		v := *s.NextPartNumberMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextPartNumberMarker", protocol.Int64Value(v), metadata)
	}
	if s.Owner != nil {
		v := s.Owner

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Owner", v, metadata)
	}
	if s.PartNumberMarker != nil {
		v := *s.PartNumberMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PartNumberMarker", protocol.Int64Value(v), metadata)
	}
	if len(s.Parts) > 0 {
		v := s.Parts

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Part", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.StorageClass) > 0 {
		v := s.StorageClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StorageClass", v, metadata)
	}
	if s.UploadId != nil {
		v := *s.UploadId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UploadId", protocol.StringValue(v), metadata)
	}
	if s.AbortDate != nil {
		v := *s.AbortDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-abort-date", protocol.TimeValue{V: v, Format: protocol.RFC822TimeFromat}, metadata)
	}
	if s.AbortRuleId != nil {
		v := *s.AbortRuleId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-abort-rule-id", protocol.StringValue(v), metadata)
	}
	if len(s.RequestCharged) > 0 {
		v := s.RequestCharged

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-charged", v, metadata)
	}
	return nil
}

// Describes an S3 location that will receive the results of the restore request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/S3Location
type Location struct {
	_ struct{} `type:"structure"`

	// A list of grants that control access to the staged results.
	AccessControlList []Grant `locationNameList:"Grant" type:"list"`

	// The name of the bucket where the restore results will be placed.
	//
	// BucketName is a required field
	BucketName *string `type:"string" required:"true"`

	// The canned ACL to apply to the restore results.
	CannedACL ObjectCannedACL `type:"string" enum:"true"`

	// Describes the server-side encryption that will be applied to the restore
	// results.
	Encryption *Encryption `type:"structure"`

	// The prefix that is prepended to the restore results for this request.
	//
	// Prefix is a required field
	Prefix *string `type:"string" required:"true"`

	// The class of storage used to store the restore results.
	StorageClass StorageClass `type:"string" enum:"true"`

	// The tag-set that is applied to the restore results.
	Tagging *Tagging `type:"structure"`

	// A list of metadata to store with the restore results in S3.
	UserMetadata []MetadataEntry `locationNameList:"MetadataEntry" type:"list"`
}

// String returns the string representation
func (s Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Location) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Location) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Location"}

	if s.BucketName == nil {
		invalidParams.Add(aws.NewErrParamRequired("BucketName"))
	}

	if s.Prefix == nil {
		invalidParams.Add(aws.NewErrParamRequired("Prefix"))
	}
	if s.AccessControlList != nil {
		for i, v := range s.AccessControlList {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AccessControlList", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Encryption != nil {
		if err := s.Encryption.Validate(); err != nil {
			invalidParams.AddNested("Encryption", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tagging != nil {
		if err := s.Tagging.Validate(); err != nil {
			invalidParams.AddNested("Tagging", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Location) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AccessControlList) > 0 {
		v := s.AccessControlList

		metadata := protocol.Metadata{ListLocationName: "Grant"}
		ls0 := e.List(protocol.BodyTarget, "AccessControlList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.BucketName != nil {
		v := *s.BucketName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BucketName", protocol.StringValue(v), metadata)
	}
	if len(s.CannedACL) > 0 {
		v := s.CannedACL

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CannedACL", v, metadata)
	}
	if s.Encryption != nil {
		v := s.Encryption

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Encryption", v, metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if len(s.StorageClass) > 0 {
		v := s.StorageClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StorageClass", v, metadata)
	}
	if s.Tagging != nil {
		v := s.Tagging

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Tagging", v, metadata)
	}
	if len(s.UserMetadata) > 0 {
		v := s.UserMetadata

		metadata := protocol.Metadata{ListLocationName: "MetadataEntry"}
		ls0 := e.List(protocol.BodyTarget, "UserMetadata", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Container for logging information. Presence of this element indicates that
// logging is enabled. Parameters TargetBucket and TargetPrefix are required
// in this case.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/LoggingEnabled
type LoggingEnabled struct {
	_ struct{} `type:"structure"`

	// Specifies the bucket where you want Amazon S3 to store server access logs.
	// You can have your logs delivered to any bucket that you own, including the
	// same bucket that is being logged. You can also configure multiple buckets
	// to deliver their logs to the same target bucket. In this case you should
	// choose a different TargetPrefix for each source bucket so that the delivered
	// log files can be distinguished by key.
	//
	// TargetBucket is a required field
	TargetBucket *string `type:"string" required:"true"`

	TargetGrants []TargetGrant `locationNameList:"Grant" type:"list"`

	// This element lets you specify a prefix for the keys that the log files will
	// be stored under.
	//
	// TargetPrefix is a required field
	TargetPrefix *string `type:"string" required:"true"`
}

// String returns the string representation
func (s LoggingEnabled) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoggingEnabled) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoggingEnabled) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LoggingEnabled"}

	if s.TargetBucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetBucket"))
	}

	if s.TargetPrefix == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetPrefix"))
	}
	if s.TargetGrants != nil {
		for i, v := range s.TargetGrants {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TargetGrants", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LoggingEnabled) MarshalFields(e protocol.FieldEncoder) error {
	if s.TargetBucket != nil {
		v := *s.TargetBucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TargetBucket", protocol.StringValue(v), metadata)
	}
	if len(s.TargetGrants) > 0 {
		v := s.TargetGrants

		metadata := protocol.Metadata{ListLocationName: "Grant"}
		ls0 := e.List(protocol.BodyTarget, "TargetGrants", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.TargetPrefix != nil {
		v := *s.TargetPrefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TargetPrefix", protocol.StringValue(v), metadata)
	}
	return nil
}

// A metadata key-value pair to store with an object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/MetadataEntry
type MetadataEntry struct {
	_ struct{} `type:"structure"`

	Name *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s MetadataEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetadataEntry) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MetadataEntry) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.StringValue(v), metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/MetricsAndOperator
type MetricsAndOperator struct {
	_ struct{} `type:"structure"`

	// The prefix used when evaluating an AND predicate.
	Prefix *string `type:"string"`

	// The list of tags used when evaluating an AND predicate.
	Tags []Tag `locationName:"Tag" locationNameList:"Tag" type:"list" flattened:"true"`
}

// String returns the string representation
func (s MetricsAndOperator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricsAndOperator) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricsAndOperator) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MetricsAndOperator"}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MetricsAndOperator) MarshalFields(e protocol.FieldEncoder) error {
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Tag", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/MetricsConfiguration
type MetricsConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies a metrics configuration filter. The metrics configuration will
	// only include objects that meet the filter's criteria. A filter must be a
	// prefix, a tag, or a conjunction (MetricsAndOperator).
	Filter *MetricsFilter `type:"structure"`

	// The ID used to identify the metrics configuration.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`
}

// String returns the string representation
func (s MetricsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricsConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MetricsConfiguration"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MetricsConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.Filter != nil {
		v := s.Filter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Filter", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/MetricsFilter
type MetricsFilter struct {
	_ struct{} `type:"structure"`

	// A conjunction (logical AND) of predicates, which is used in evaluating a
	// metrics filter. The operator must have at least two predicates, and an object
	// must match all of the predicates in order for the filter to apply.
	And *MetricsAndOperator `type:"structure"`

	// The prefix used when evaluating a metrics filter.
	Prefix *string `type:"string"`

	// The tag used when evaluating a metrics filter.
	Tag *Tag `type:"structure"`
}

// String returns the string representation
func (s MetricsFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricsFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricsFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MetricsFilter"}
	if s.And != nil {
		if err := s.And.Validate(); err != nil {
			invalidParams.AddNested("And", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tag != nil {
		if err := s.Tag.Validate(); err != nil {
			invalidParams.AddNested("Tag", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MetricsFilter) MarshalFields(e protocol.FieldEncoder) error {
	if s.And != nil {
		v := s.And

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "And", v, metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if s.Tag != nil {
		v := s.Tag

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Tag", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/MultipartUpload
type MultipartUpload struct {
	_ struct{} `type:"structure"`

	// Date and time at which the multipart upload was initiated.
	Initiated *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Identifies who initiated the multipart upload.
	Initiator *Initiator `type:"structure"`

	// Key of the object for which the multipart upload was initiated.
	Key *string `min:"1" type:"string"`

	Owner *Owner `type:"structure"`

	// The class of storage used to store the object.
	StorageClass StorageClass `type:"string" enum:"true"`

	// Upload ID that identifies the multipart upload.
	UploadId *string `type:"string"`
}

// String returns the string representation
func (s MultipartUpload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MultipartUpload) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MultipartUpload) MarshalFields(e protocol.FieldEncoder) error {
	if s.Initiated != nil {
		v := *s.Initiated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Initiated", protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormat}, metadata)
	}
	if s.Initiator != nil {
		v := s.Initiator

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Initiator", v, metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.Owner != nil {
		v := s.Owner

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Owner", v, metadata)
	}
	if len(s.StorageClass) > 0 {
		v := s.StorageClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StorageClass", v, metadata)
	}
	if s.UploadId != nil {
		v := *s.UploadId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UploadId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Specifies when noncurrent object versions expire. Upon expiration, Amazon
// S3 permanently deletes the noncurrent object versions. You set this lifecycle
// configuration action on a bucket that has versioning enabled (or suspended)
// to request that Amazon S3 delete noncurrent object versions at a specific
// period in the object's lifetime.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/NoncurrentVersionExpiration
type NoncurrentVersionExpiration struct {
	_ struct{} `type:"structure"`

	// Specifies the number of days an object is noncurrent before Amazon S3 can
	// perform the associated action. For information about the noncurrent days
	// calculations, see How Amazon S3 Calculates When an Object Became Noncurrent
	// (http://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html) in
	// the Amazon Simple Storage Service Developer Guide.
	NoncurrentDays *int64 `type:"integer"`
}

// String returns the string representation
func (s NoncurrentVersionExpiration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NoncurrentVersionExpiration) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NoncurrentVersionExpiration) MarshalFields(e protocol.FieldEncoder) error {
	if s.NoncurrentDays != nil {
		v := *s.NoncurrentDays

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NoncurrentDays", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Container for the transition rule that describes when noncurrent objects
// transition to the STANDARD_IA, ONEZONE_IA or GLACIER storage class. If your
// bucket is versioning-enabled (or versioning is suspended), you can set this
// action to request that Amazon S3 transition noncurrent object versions to
// the STANDARD_IA, ONEZONE_IA or GLACIER storage class at a specific period
// in the object's lifetime.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/NoncurrentVersionTransition
type NoncurrentVersionTransition struct {
	_ struct{} `type:"structure"`

	// Specifies the number of days an object is noncurrent before Amazon S3 can
	// perform the associated action. For information about the noncurrent days
	// calculations, see How Amazon S3 Calculates When an Object Became Noncurrent
	// (http://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html) in
	// the Amazon Simple Storage Service Developer Guide.
	NoncurrentDays *int64 `type:"integer"`

	// The class of storage used to store the object.
	StorageClass TransitionStorageClass `type:"string" enum:"true"`
}

// String returns the string representation
func (s NoncurrentVersionTransition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NoncurrentVersionTransition) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NoncurrentVersionTransition) MarshalFields(e protocol.FieldEncoder) error {
	if s.NoncurrentDays != nil {
		v := *s.NoncurrentDays

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NoncurrentDays", protocol.Int64Value(v), metadata)
	}
	if len(s.StorageClass) > 0 {
		v := s.StorageClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StorageClass", v, metadata)
	}
	return nil
}

// Container for object key name filtering rules. For information about key
// name filtering, go to Configuring Event Notifications (http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
// in the Amazon Simple Storage Service Developer Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/NotificationConfigurationFilter
type NotificationConfigurationFilter struct {
	_ struct{} `type:"structure"`

	// Container for object key name prefix and suffix filtering rules.
	Key *KeyFilter `locationName:"S3Key" type:"structure"`
}

// String returns the string representation
func (s NotificationConfigurationFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotificationConfigurationFilter) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NotificationConfigurationFilter) MarshalFields(e protocol.FieldEncoder) error {
	if s.Key != nil {
		v := s.Key

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "S3Key", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Object
type Object struct {
	_ struct{} `type:"structure"`

	ETag *string `type:"string"`

	Key *string `min:"1" type:"string"`

	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	Owner *Owner `type:"structure"`

	Size *int64 `type:"integer"`

	// The class of storage used to store the object.
	StorageClass ObjectStorageClass `type:"string" enum:"true"`
}

// String returns the string representation
func (s Object) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Object) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Object) MarshalFields(e protocol.FieldEncoder) error {
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.LastModified != nil {
		v := *s.LastModified

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModified", protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormat}, metadata)
	}
	if s.Owner != nil {
		v := s.Owner

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Owner", v, metadata)
	}
	if s.Size != nil {
		v := *s.Size

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Size", protocol.Int64Value(v), metadata)
	}
	if len(s.StorageClass) > 0 {
		v := s.StorageClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StorageClass", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ObjectIdentifier
type ObjectIdentifier struct {
	_ struct{} `type:"structure"`

	// Key name of the object to delete.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// VersionId for the specific version of the object to delete.
	VersionId *string `type:"string"`
}

// String returns the string representation
func (s ObjectIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ObjectIdentifier) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ObjectIdentifier) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ObjectIdentifier"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ObjectIdentifier) MarshalFields(e protocol.FieldEncoder) error {
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ObjectVersion
type ObjectVersion struct {
	_ struct{} `type:"structure"`

	ETag *string `type:"string"`

	// Specifies whether the object is (true) or is not (false) the latest version
	// of an object.
	IsLatest *bool `type:"boolean"`

	// The object key.
	Key *string `min:"1" type:"string"`

	// Date and time the object was last modified.
	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	Owner *Owner `type:"structure"`

	// Size in bytes of the object.
	Size *int64 `type:"integer"`

	// The class of storage used to store the object.
	StorageClass ObjectVersionStorageClass `type:"string" enum:"true"`

	// Version ID of an object.
	VersionId *string `type:"string"`
}

// String returns the string representation
func (s ObjectVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ObjectVersion) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ObjectVersion) MarshalFields(e protocol.FieldEncoder) error {
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.IsLatest != nil {
		v := *s.IsLatest

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsLatest", protocol.BoolValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.LastModified != nil {
		v := *s.LastModified

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModified", protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormat}, metadata)
	}
	if s.Owner != nil {
		v := s.Owner

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Owner", v, metadata)
	}
	if s.Size != nil {
		v := *s.Size

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Size", protocol.Int64Value(v), metadata)
	}
	if len(s.StorageClass) > 0 {
		v := s.StorageClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StorageClass", v, metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Describes the location where the restore job's output is stored.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/OutputLocation
type OutputLocation struct {
	_ struct{} `type:"structure"`

	// Describes an S3 location that will receive the results of the restore request.
	S3 *Location `type:"structure"`
}

// String returns the string representation
func (s OutputLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputLocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputLocation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OutputLocation"}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OutputLocation) MarshalFields(e protocol.FieldEncoder) error {
	if s.S3 != nil {
		v := s.S3

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "S3", v, metadata)
	}
	return nil
}

// Describes how results of the Select job are serialized.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/OutputSerialization
type OutputSerialization struct {
	_ struct{} `type:"structure"`

	// Describes the serialization of CSV-encoded Select results.
	CSV *CSVOutput `type:"structure"`

	// Specifies JSON as request's output serialization format.
	JSON *JSONOutput `type:"structure"`
}

// String returns the string representation
func (s OutputSerialization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputSerialization) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OutputSerialization) MarshalFields(e protocol.FieldEncoder) error {
	if s.CSV != nil {
		v := s.CSV

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CSV", v, metadata)
	}
	if s.JSON != nil {
		v := s.JSON

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "JSON", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Owner
type Owner struct {
	_ struct{} `type:"structure"`

	DisplayName *string `type:"string"`

	ID *string `type:"string"`
}

// String returns the string representation
func (s Owner) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Owner) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Owner) MarshalFields(e protocol.FieldEncoder) error {
	if s.DisplayName != nil {
		v := *s.DisplayName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DisplayName", protocol.StringValue(v), metadata)
	}
	if s.ID != nil {
		v := *s.ID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ID", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ParquetInput
type ParquetInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ParquetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ParquetInput) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ParquetInput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Part
type Part struct {
	_ struct{} `type:"structure"`

	// Entity tag returned when the part was uploaded.
	ETag *string `type:"string"`

	// Date and time at which the part was uploaded.
	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Part number identifying the part. This is a positive integer between 1 and
	// 10,000.
	PartNumber *int64 `type:"integer"`

	// Size of the uploaded part data.
	Size *int64 `type:"integer"`
}

// String returns the string representation
func (s Part) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Part) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Part) MarshalFields(e protocol.FieldEncoder) error {
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.LastModified != nil {
		v := *s.LastModified

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModified", protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormat}, metadata)
	}
	if s.PartNumber != nil {
		v := *s.PartNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PartNumber", protocol.Int64Value(v), metadata)
	}
	if s.Size != nil {
		v := *s.Size

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Size", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketAccelerateConfigurationRequest
type PutBucketAccelerateConfigurationInput struct {
	_ struct{} `type:"structure" payload:"AccelerateConfiguration"`

	// Specifies the Accelerate Configuration you want to set for the bucket.
	//
	// AccelerateConfiguration is a required field
	AccelerateConfiguration *AccelerateConfiguration `locationName:"AccelerateConfiguration" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	// Name of the bucket for which the accelerate configuration is set.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s PutBucketAccelerateConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketAccelerateConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketAccelerateConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutBucketAccelerateConfigurationInput"}

	if s.AccelerateConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccelerateConfiguration"))
	}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *PutBucketAccelerateConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketAccelerateConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.AccelerateConfiguration != nil {
		v := s.AccelerateConfiguration

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "AccelerateConfiguration", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketAccelerateConfigurationOutput
type PutBucketAccelerateConfigurationOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s PutBucketAccelerateConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketAccelerateConfigurationOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s PutBucketAccelerateConfigurationOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketAccelerateConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketAclRequest
type PutBucketAclInput struct {
	_ struct{} `type:"structure" payload:"AccessControlPolicy"`

	// The canned ACL to apply to the bucket.
	ACL BucketCannedACL `location:"header" locationName:"x-amz-acl" type:"string" enum:"true"`

	AccessControlPolicy *AccessControlPolicy `locationName:"AccessControlPolicy" type:"structure" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Allows grantee the read, write, read ACP, and write ACP permissions on the
	// bucket.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to list the objects in the bucket.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the bucket ACL.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to create, overwrite, and delete any object in the bucket.
	GrantWrite *string `location:"header" locationName:"x-amz-grant-write" type:"string"`

	// Allows grantee to write the ACL for the applicable bucket.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`
}

// String returns the string representation
func (s PutBucketAclInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketAclInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketAclInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutBucketAclInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}
	if s.AccessControlPolicy != nil {
		if err := s.AccessControlPolicy.Validate(); err != nil {
			invalidParams.AddNested("AccessControlPolicy", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *PutBucketAclInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketAclInput) MarshalFields(e protocol.FieldEncoder) error {

	if len(s.ACL) > 0 {
		v := s.ACL

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-acl", v, metadata)
	}
	if s.GrantFullControl != nil {
		v := *s.GrantFullControl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-grant-full-control", protocol.StringValue(v), metadata)
	}
	if s.GrantRead != nil {
		v := *s.GrantRead

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-grant-read", protocol.StringValue(v), metadata)
	}
	if s.GrantReadACP != nil {
		v := *s.GrantReadACP

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-grant-read-acp", protocol.StringValue(v), metadata)
	}
	if s.GrantWrite != nil {
		v := *s.GrantWrite

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-grant-write", protocol.StringValue(v), metadata)
	}
	if s.GrantWriteACP != nil {
		v := *s.GrantWriteACP

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-grant-write-acp", protocol.StringValue(v), metadata)
	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.AccessControlPolicy != nil {
		v := s.AccessControlPolicy

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "AccessControlPolicy", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketAclOutput
type PutBucketAclOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s PutBucketAclOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketAclOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s PutBucketAclOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketAclOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketAnalyticsConfigurationRequest
type PutBucketAnalyticsConfigurationInput struct {
	_ struct{} `type:"structure" payload:"AnalyticsConfiguration"`

	// The configuration and any analyses for the analytics filter.
	//
	// AnalyticsConfiguration is a required field
	AnalyticsConfiguration *AnalyticsConfiguration `locationName:"AnalyticsConfiguration" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	// The name of the bucket to which an analytics configuration is stored.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The identifier used to represent an analytics configuration.
	//
	// Id is a required field
	Id *string `location:"querystring" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s PutBucketAnalyticsConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketAnalyticsConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketAnalyticsConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutBucketAnalyticsConfigurationInput"}

	if s.AnalyticsConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("AnalyticsConfiguration"))
	}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.AnalyticsConfiguration != nil {
		if err := s.AnalyticsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AnalyticsConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *PutBucketAnalyticsConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketAnalyticsConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.AnalyticsConfiguration != nil {
		v := s.AnalyticsConfiguration

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "AnalyticsConfiguration", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "id", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketAnalyticsConfigurationOutput
type PutBucketAnalyticsConfigurationOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s PutBucketAnalyticsConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketAnalyticsConfigurationOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s PutBucketAnalyticsConfigurationOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketAnalyticsConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketCorsRequest
type PutBucketCorsInput struct {
	_ struct{} `type:"structure" payload:"CORSConfiguration"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// CORSConfiguration is a required field
	CORSConfiguration *CORSConfiguration `locationName:"CORSConfiguration" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketCorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketCorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketCorsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutBucketCorsInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.CORSConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("CORSConfiguration"))
	}
	if s.CORSConfiguration != nil {
		if err := s.CORSConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CORSConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *PutBucketCorsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketCorsInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.CORSConfiguration != nil {
		v := s.CORSConfiguration

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "CORSConfiguration", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketCorsOutput
type PutBucketCorsOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s PutBucketCorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketCorsOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s PutBucketCorsOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketCorsOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketEncryptionRequest
type PutBucketEncryptionInput struct {
	_ struct{} `type:"structure" payload:"ServerSideEncryptionConfiguration"`

	// The name of the bucket for which the server-side encryption configuration
	// is set.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Container for server-side encryption configuration rules. Currently S3 supports
	// one rule only.
	//
	// ServerSideEncryptionConfiguration is a required field
	ServerSideEncryptionConfiguration *ServerSideEncryptionConfiguration `locationName:"ServerSideEncryptionConfiguration" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketEncryptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketEncryptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketEncryptionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutBucketEncryptionInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.ServerSideEncryptionConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServerSideEncryptionConfiguration"))
	}
	if s.ServerSideEncryptionConfiguration != nil {
		if err := s.ServerSideEncryptionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ServerSideEncryptionConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *PutBucketEncryptionInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketEncryptionInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.ServerSideEncryptionConfiguration != nil {
		v := s.ServerSideEncryptionConfiguration

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "ServerSideEncryptionConfiguration", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketEncryptionOutput
type PutBucketEncryptionOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s PutBucketEncryptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketEncryptionOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s PutBucketEncryptionOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketEncryptionOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketInventoryConfigurationRequest
type PutBucketInventoryConfigurationInput struct {
	_ struct{} `type:"structure" payload:"InventoryConfiguration"`

	// The name of the bucket where the inventory configuration will be stored.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The ID used to identify the inventory configuration.
	//
	// Id is a required field
	Id *string `location:"querystring" locationName:"id" type:"string" required:"true"`

	// Specifies the inventory configuration.
	//
	// InventoryConfiguration is a required field
	InventoryConfiguration *InventoryConfiguration `locationName:"InventoryConfiguration" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketInventoryConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketInventoryConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketInventoryConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutBucketInventoryConfigurationInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if s.InventoryConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("InventoryConfiguration"))
	}
	if s.InventoryConfiguration != nil {
		if err := s.InventoryConfiguration.Validate(); err != nil {
			invalidParams.AddNested("InventoryConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *PutBucketInventoryConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketInventoryConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.InventoryConfiguration != nil {
		v := s.InventoryConfiguration

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "InventoryConfiguration", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "id", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketInventoryConfigurationOutput
type PutBucketInventoryConfigurationOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s PutBucketInventoryConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketInventoryConfigurationOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s PutBucketInventoryConfigurationOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketInventoryConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLifecycleConfigurationRequest
type PutBucketLifecycleConfigurationInput struct {
	_ struct{} `type:"structure" payload:"LifecycleConfiguration"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	LifecycleConfiguration *BucketLifecycleConfiguration `locationName:"LifecycleConfiguration" type:"structure" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketLifecycleConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketLifecycleConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketLifecycleConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutBucketLifecycleConfigurationInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}
	if s.LifecycleConfiguration != nil {
		if err := s.LifecycleConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LifecycleConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *PutBucketLifecycleConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketLifecycleConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.LifecycleConfiguration != nil {
		v := s.LifecycleConfiguration

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "LifecycleConfiguration", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLifecycleConfigurationOutput
type PutBucketLifecycleConfigurationOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s PutBucketLifecycleConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketLifecycleConfigurationOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s PutBucketLifecycleConfigurationOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketLifecycleConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLifecycleRequest
type PutBucketLifecycleInput struct {
	_ struct{} `type:"structure" payload:"LifecycleConfiguration"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	LifecycleConfiguration *LifecycleConfiguration `locationName:"LifecycleConfiguration" type:"structure" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketLifecycleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketLifecycleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketLifecycleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutBucketLifecycleInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}
	if s.LifecycleConfiguration != nil {
		if err := s.LifecycleConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LifecycleConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *PutBucketLifecycleInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketLifecycleInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.LifecycleConfiguration != nil {
		v := s.LifecycleConfiguration

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "LifecycleConfiguration", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLifecycleOutput
type PutBucketLifecycleOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s PutBucketLifecycleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketLifecycleOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s PutBucketLifecycleOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketLifecycleOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLoggingRequest
type PutBucketLoggingInput struct {
	_ struct{} `type:"structure" payload:"BucketLoggingStatus"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// BucketLoggingStatus is a required field
	BucketLoggingStatus *BucketLoggingStatus `locationName:"BucketLoggingStatus" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketLoggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketLoggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketLoggingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutBucketLoggingInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.BucketLoggingStatus == nil {
		invalidParams.Add(aws.NewErrParamRequired("BucketLoggingStatus"))
	}
	if s.BucketLoggingStatus != nil {
		if err := s.BucketLoggingStatus.Validate(); err != nil {
			invalidParams.AddNested("BucketLoggingStatus", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *PutBucketLoggingInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketLoggingInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.BucketLoggingStatus != nil {
		v := s.BucketLoggingStatus

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "BucketLoggingStatus", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLoggingOutput
type PutBucketLoggingOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s PutBucketLoggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketLoggingOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s PutBucketLoggingOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketLoggingOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketMetricsConfigurationRequest
type PutBucketMetricsConfigurationInput struct {
	_ struct{} `type:"structure" payload:"MetricsConfiguration"`

	// The name of the bucket for which the metrics configuration is set.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The ID used to identify the metrics configuration.
	//
	// Id is a required field
	Id *string `location:"querystring" locationName:"id" type:"string" required:"true"`

	// Specifies the metrics configuration.
	//
	// MetricsConfiguration is a required field
	MetricsConfiguration *MetricsConfiguration `locationName:"MetricsConfiguration" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketMetricsConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketMetricsConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketMetricsConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutBucketMetricsConfigurationInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if s.MetricsConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("MetricsConfiguration"))
	}
	if s.MetricsConfiguration != nil {
		if err := s.MetricsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("MetricsConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *PutBucketMetricsConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketMetricsConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.MetricsConfiguration != nil {
		v := s.MetricsConfiguration

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "MetricsConfiguration", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "id", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketMetricsConfigurationOutput
type PutBucketMetricsConfigurationOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s PutBucketMetricsConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketMetricsConfigurationOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s PutBucketMetricsConfigurationOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketMetricsConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketNotificationConfigurationRequest
type PutBucketNotificationConfigurationInput struct {
	_ struct{} `type:"structure" payload:"NotificationConfiguration"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Container for specifying the notification configuration of the bucket. If
	// this element is empty, notifications are turned off on the bucket.
	//
	// NotificationConfiguration is a required field
	NotificationConfiguration *GetBucketNotificationConfigurationOutput `locationName:"NotificationConfiguration" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketNotificationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketNotificationConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketNotificationConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutBucketNotificationConfigurationInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.NotificationConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("NotificationConfiguration"))
	}
	if s.NotificationConfiguration != nil {
		if err := s.NotificationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("NotificationConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *PutBucketNotificationConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketNotificationConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.NotificationConfiguration != nil {
		v := s.NotificationConfiguration

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "NotificationConfiguration", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketNotificationConfigurationOutput
type PutBucketNotificationConfigurationOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s PutBucketNotificationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketNotificationConfigurationOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s PutBucketNotificationConfigurationOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketNotificationConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketNotificationRequest
type PutBucketNotificationInput struct {
	_ struct{} `type:"structure" payload:"NotificationConfiguration"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// NotificationConfiguration is a required field
	NotificationConfiguration *GetBucketNotificationOutput `locationName:"NotificationConfiguration" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketNotificationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketNotificationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketNotificationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutBucketNotificationInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.NotificationConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("NotificationConfiguration"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *PutBucketNotificationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketNotificationInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.NotificationConfiguration != nil {
		v := s.NotificationConfiguration

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "NotificationConfiguration", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketNotificationOutput
type PutBucketNotificationOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s PutBucketNotificationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketNotificationOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s PutBucketNotificationOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketNotificationOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketPolicyRequest
type PutBucketPolicyInput struct {
	_ struct{} `type:"structure" payload:"Policy"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Set this parameter to true to confirm that you want to remove your permissions
	// to change this bucket policy in the future.
	ConfirmRemoveSelfBucketAccess *bool `location:"header" locationName:"x-amz-confirm-remove-self-bucket-access" type:"boolean"`

	// The bucket policy as a JSON document.
	//
	// Policy is a required field
	Policy *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PutBucketPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutBucketPolicyInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Policy == nil {
		invalidParams.Add(aws.NewErrParamRequired("Policy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *PutBucketPolicyInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketPolicyInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.ConfirmRemoveSelfBucketAccess != nil {
		v := *s.ConfirmRemoveSelfBucketAccess

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-confirm-remove-self-bucket-access", protocol.BoolValue(v), metadata)
	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Policy != nil {
		v := *s.Policy

		metadata := protocol.Metadata{}
		e.SetStream(protocol.PayloadTarget, "Policy", protocol.StringStream(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketPolicyOutput
type PutBucketPolicyOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s PutBucketPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketPolicyOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s PutBucketPolicyOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketPolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketReplicationRequest
type PutBucketReplicationInput struct {
	_ struct{} `type:"structure" payload:"ReplicationConfiguration"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Container for replication rules. You can add as many as 1,000 rules. Total
	// replication configuration size can be up to 2 MB.
	//
	// ReplicationConfiguration is a required field
	ReplicationConfiguration *ReplicationConfiguration `locationName:"ReplicationConfiguration" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketReplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketReplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketReplicationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutBucketReplicationInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.ReplicationConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReplicationConfiguration"))
	}
	if s.ReplicationConfiguration != nil {
		if err := s.ReplicationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ReplicationConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *PutBucketReplicationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketReplicationInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.ReplicationConfiguration != nil {
		v := s.ReplicationConfiguration

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "ReplicationConfiguration", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketReplicationOutput
type PutBucketReplicationOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s PutBucketReplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketReplicationOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s PutBucketReplicationOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketReplicationOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketRequestPaymentRequest
type PutBucketRequestPaymentInput struct {
	_ struct{} `type:"structure" payload:"RequestPaymentConfiguration"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// RequestPaymentConfiguration is a required field
	RequestPaymentConfiguration *RequestPaymentConfiguration `locationName:"RequestPaymentConfiguration" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketRequestPaymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketRequestPaymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketRequestPaymentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutBucketRequestPaymentInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.RequestPaymentConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("RequestPaymentConfiguration"))
	}
	if s.RequestPaymentConfiguration != nil {
		if err := s.RequestPaymentConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RequestPaymentConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *PutBucketRequestPaymentInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketRequestPaymentInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.RequestPaymentConfiguration != nil {
		v := s.RequestPaymentConfiguration

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "RequestPaymentConfiguration", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketRequestPaymentOutput
type PutBucketRequestPaymentOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s PutBucketRequestPaymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketRequestPaymentOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s PutBucketRequestPaymentOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketRequestPaymentOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketTaggingRequest
type PutBucketTaggingInput struct {
	_ struct{} `type:"structure" payload:"Tagging"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Tagging is a required field
	Tagging *Tagging `locationName:"Tagging" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketTaggingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutBucketTaggingInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Tagging == nil {
		invalidParams.Add(aws.NewErrParamRequired("Tagging"))
	}
	if s.Tagging != nil {
		if err := s.Tagging.Validate(); err != nil {
			invalidParams.AddNested("Tagging", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *PutBucketTaggingInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketTaggingInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Tagging != nil {
		v := s.Tagging

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "Tagging", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketTaggingOutput
type PutBucketTaggingOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s PutBucketTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketTaggingOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s PutBucketTaggingOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketTaggingOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketVersioningRequest
type PutBucketVersioningInput struct {
	_ struct{} `type:"structure" payload:"VersioningConfiguration"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The concatenation of the authentication device's serial number, a space,
	// and the value that is displayed on your authentication device.
	MFA *string `location:"header" locationName:"x-amz-mfa" type:"string"`

	// VersioningConfiguration is a required field
	VersioningConfiguration *VersioningConfiguration `locationName:"VersioningConfiguration" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketVersioningInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketVersioningInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketVersioningInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutBucketVersioningInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.VersioningConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("VersioningConfiguration"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *PutBucketVersioningInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketVersioningInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.MFA != nil {
		v := *s.MFA

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-mfa", protocol.StringValue(v), metadata)
	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.VersioningConfiguration != nil {
		v := s.VersioningConfiguration

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "VersioningConfiguration", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketVersioningOutput
type PutBucketVersioningOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s PutBucketVersioningOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketVersioningOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s PutBucketVersioningOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketVersioningOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketWebsiteRequest
type PutBucketWebsiteInput struct {
	_ struct{} `type:"structure" payload:"WebsiteConfiguration"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// WebsiteConfiguration is a required field
	WebsiteConfiguration *WebsiteConfiguration `locationName:"WebsiteConfiguration" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketWebsiteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketWebsiteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketWebsiteInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutBucketWebsiteInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.WebsiteConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("WebsiteConfiguration"))
	}
	if s.WebsiteConfiguration != nil {
		if err := s.WebsiteConfiguration.Validate(); err != nil {
			invalidParams.AddNested("WebsiteConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *PutBucketWebsiteInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketWebsiteInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.WebsiteConfiguration != nil {
		v := s.WebsiteConfiguration

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "WebsiteConfiguration", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketWebsiteOutput
type PutBucketWebsiteOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s PutBucketWebsiteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketWebsiteOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s PutBucketWebsiteOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketWebsiteOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectAclRequest
type PutObjectAclInput struct {
	_ struct{} `type:"structure" payload:"AccessControlPolicy"`

	// The canned ACL to apply to the object.
	ACL ObjectCannedACL `location:"header" locationName:"x-amz-acl" type:"string" enum:"true"`

	AccessControlPolicy *AccessControlPolicy `locationName:"AccessControlPolicy" type:"structure" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Allows grantee the read, write, read ACP, and write ACP permissions on the
	// bucket.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to list the objects in the bucket.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the bucket ACL.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to create, overwrite, and delete any object in the bucket.
	GrantWrite *string `location:"header" locationName:"x-amz-grant-write" type:"string"`

	// Allows grantee to write the ACL for the applicable bucket.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer RequestPayer `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"true"`

	// VersionId used to reference a specific version of the object.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s PutObjectAclInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutObjectAclInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutObjectAclInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutObjectAclInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}
	if s.AccessControlPolicy != nil {
		if err := s.AccessControlPolicy.Validate(); err != nil {
			invalidParams.AddNested("AccessControlPolicy", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *PutObjectAclInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutObjectAclInput) MarshalFields(e protocol.FieldEncoder) error {

	if len(s.ACL) > 0 {
		v := s.ACL

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-acl", v, metadata)
	}
	if s.GrantFullControl != nil {
		v := *s.GrantFullControl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-grant-full-control", protocol.StringValue(v), metadata)
	}
	if s.GrantRead != nil {
		v := *s.GrantRead

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-grant-read", protocol.StringValue(v), metadata)
	}
	if s.GrantReadACP != nil {
		v := *s.GrantReadACP

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-grant-read-acp", protocol.StringValue(v), metadata)
	}
	if s.GrantWrite != nil {
		v := *s.GrantWrite

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-grant-write", protocol.StringValue(v), metadata)
	}
	if s.GrantWriteACP != nil {
		v := *s.GrantWriteACP

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-grant-write-acp", protocol.StringValue(v), metadata)
	}
	if len(s.RequestPayer) > 0 {
		v := s.RequestPayer

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-payer", v, metadata)
	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.AccessControlPolicy != nil {
		v := s.AccessControlPolicy

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "AccessControlPolicy", v, metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "versionId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectAclOutput
type PutObjectAclOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged RequestCharged `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"true"`
}

// String returns the string representation
func (s PutObjectAclOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutObjectAclOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s PutObjectAclOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutObjectAclOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.RequestCharged) > 0 {
		v := s.RequestCharged

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-charged", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectRequest
type PutObjectInput struct {
	_ struct{} `type:"structure" payload:"Body"`

	// The canned ACL to apply to the object.
	ACL ObjectCannedACL `location:"header" locationName:"x-amz-acl" type:"string" enum:"true"`

	// Object data.
	Body io.ReadSeeker `type:"blob"`

	// Name of the bucket to which the PUT operation was initiated.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Specifies caching behavior along the request/reply chain.
	CacheControl *string `location:"header" locationName:"Cache-Control" type:"string"`

	// Specifies presentational information for the object.
	ContentDisposition *string `location:"header" locationName:"Content-Disposition" type:"string"`

	// Specifies what content encodings have been applied to the object and thus
	// what decoding mechanisms must be applied to obtain the media-type referenced
	// by the Content-Type header field.
	ContentEncoding *string `location:"header" locationName:"Content-Encoding" type:"string"`

	// The language the content is in.
	ContentLanguage *string `location:"header" locationName:"Content-Language" type:"string"`

	// Size of the body in bytes. This parameter is useful when the size of the
	// body cannot be determined automatically.
	ContentLength *int64 `location:"header" locationName:"Content-Length" type:"long"`

	// The base64-encoded 128-bit MD5 digest of the part data.
	ContentMD5 *string `location:"header" locationName:"Content-MD5" type:"string"`

	// A standard MIME type describing the format of the object data.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// The date and time at which the object is no longer cacheable.
	Expires *time.Time `location:"header" locationName:"Expires" type:"timestamp" timestampFormat:"rfc822"`

	// Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to read the object data and its metadata.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the object ACL.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to write the ACL for the applicable object.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`

	// Object key for which the PUT operation was initiated.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// A map of metadata to store with the object in S3.
	Metadata map[string]string `location:"headers" locationName:"x-amz-meta-" type:"map"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer RequestPayer `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"true"`

	// Specifies the algorithm to use to when encrypting the object (e.g., AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// does not store the encryption key. The key must be appropriate for use with
	// the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm
	// header.
	SSECustomerKey *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// Specifies the AWS KMS key ID to use for object encryption. All GET and PUT
	// requests for an object protected by AWS KMS will fail if not made via SSL
	// or using SigV4. Documentation on configuring any of the officially supported
	// AWS SDKs and CLI can be found at http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption ServerSideEncryption `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"true"`

	// The type of storage to use for the object. Defaults to 'STANDARD'.
	StorageClass StorageClass `location:"header" locationName:"x-amz-storage-class" type:"string" enum:"true"`

	// The tag-set for the object. The tag-set must be encoded as URL Query parameters
	Tagging *string `location:"header" locationName:"x-amz-tagging" type:"string"`

	// If the bucket is configured as a website, redirects requests for this object
	// to another object in the same bucket or to an external URL. Amazon S3 stores
	// the value of this header in the object metadata.
	WebsiteRedirectLocation *string `location:"header" locationName:"x-amz-website-redirect-location" type:"string"`
}

// String returns the string representation
func (s PutObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutObjectInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutObjectInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *PutObjectInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

func (s *PutObjectInput) getSSECustomerKey() (v string) {
	if s.SSECustomerKey == nil {
		return v
	}
	return *s.SSECustomerKey
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutObjectInput) MarshalFields(e protocol.FieldEncoder) error {

	if len(s.ACL) > 0 {
		v := s.ACL

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-acl", v, metadata)
	}
	if s.CacheControl != nil {
		v := *s.CacheControl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Cache-Control", protocol.StringValue(v), metadata)
	}
	if s.ContentDisposition != nil {
		v := *s.ContentDisposition

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Content-Disposition", protocol.StringValue(v), metadata)
	}
	if s.ContentEncoding != nil {
		v := *s.ContentEncoding

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Content-Encoding", protocol.StringValue(v), metadata)
	}
	if s.ContentLanguage != nil {
		v := *s.ContentLanguage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Content-Language", protocol.StringValue(v), metadata)
	}
	if s.ContentLength != nil {
		v := *s.ContentLength

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Content-Length", protocol.Int64Value(v), metadata)
	}
	if s.ContentMD5 != nil {
		v := *s.ContentMD5

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Content-MD5", protocol.StringValue(v), metadata)
	}
	if s.ContentType != nil {
		v := *s.ContentType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue(v), metadata)
	}
	if s.Expires != nil {
		v := *s.Expires

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Expires", protocol.TimeValue{V: v, Format: protocol.RFC822TimeFromat}, metadata)
	}
	if s.GrantFullControl != nil {
		v := *s.GrantFullControl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-grant-full-control", protocol.StringValue(v), metadata)
	}
	if s.GrantRead != nil {
		v := *s.GrantRead

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-grant-read", protocol.StringValue(v), metadata)
	}
	if s.GrantReadACP != nil {
		v := *s.GrantReadACP

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-grant-read-acp", protocol.StringValue(v), metadata)
	}
	if s.GrantWriteACP != nil {
		v := *s.GrantWriteACP

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-grant-write-acp", protocol.StringValue(v), metadata)
	}
	if len(s.RequestPayer) > 0 {
		v := s.RequestPayer

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-payer", v, metadata)
	}
	if s.SSECustomerAlgorithm != nil {
		v := *s.SSECustomerAlgorithm

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-customer-algorithm", protocol.StringValue(v), metadata)
	}
	if s.SSECustomerKey != nil {
		v := *s.SSECustomerKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-customer-key", protocol.StringValue(v), metadata)
	}
	if s.SSECustomerKeyMD5 != nil {
		v := *s.SSECustomerKeyMD5

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-customer-key-MD5", protocol.StringValue(v), metadata)
	}
	if s.SSEKMSKeyId != nil {
		v := *s.SSEKMSKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-aws-kms-key-id", protocol.StringValue(v), metadata)
	}
	if len(s.ServerSideEncryption) > 0 {
		v := s.ServerSideEncryption

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption", v, metadata)
	}
	if len(s.StorageClass) > 0 {
		v := s.StorageClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-storage-class", v, metadata)
	}
	if s.Tagging != nil {
		v := *s.Tagging

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-tagging", protocol.StringValue(v), metadata)
	}
	if s.WebsiteRedirectLocation != nil {
		v := *s.WebsiteRedirectLocation

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-website-redirect-location", protocol.StringValue(v), metadata)
	}
	if len(s.Metadata) > 0 {
		v := s.Metadata

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.HeadersTarget, "x-amz-meta-", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.StringValue(v1))
		}
		ms0.End()

	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.Body != nil {
		v := s.Body

		metadata := protocol.Metadata{}
		e.SetStream(protocol.PayloadTarget, "Body", protocol.ReadSeekerStream{V: v}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectOutput
type PutObjectOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// Entity tag for the uploaded object.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// If the object expiration is configured, this will contain the expiration
	// date (expiry-date) and rule ID (rule-id). The value of rule-id is URL encoded.
	Expiration *string `location:"header" locationName:"x-amz-expiration" type:"string"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged RequestCharged `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"true"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the ID of the AWS Key Management Service (KMS) master
	// encryption key that was used for the object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption ServerSideEncryption `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"true"`

	// Version of the object.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation
func (s PutObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutObjectOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s PutObjectOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutObjectOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.Expiration != nil {
		v := *s.Expiration

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-expiration", protocol.StringValue(v), metadata)
	}
	if len(s.RequestCharged) > 0 {
		v := s.RequestCharged

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-charged", v, metadata)
	}
	if s.SSECustomerAlgorithm != nil {
		v := *s.SSECustomerAlgorithm

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-customer-algorithm", protocol.StringValue(v), metadata)
	}
	if s.SSECustomerKeyMD5 != nil {
		v := *s.SSECustomerKeyMD5

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-customer-key-MD5", protocol.StringValue(v), metadata)
	}
	if s.SSEKMSKeyId != nil {
		v := *s.SSEKMSKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-aws-kms-key-id", protocol.StringValue(v), metadata)
	}
	if len(s.ServerSideEncryption) > 0 {
		v := s.ServerSideEncryption

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption", v, metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-version-id", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectTaggingRequest
type PutObjectTaggingInput struct {
	_ struct{} `type:"structure" payload:"Tagging"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Tagging is a required field
	Tagging *Tagging `locationName:"Tagging" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s PutObjectTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutObjectTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutObjectTaggingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutObjectTaggingInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Tagging == nil {
		invalidParams.Add(aws.NewErrParamRequired("Tagging"))
	}
	if s.Tagging != nil {
		if err := s.Tagging.Validate(); err != nil {
			invalidParams.AddNested("Tagging", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *PutObjectTaggingInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutObjectTaggingInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.Tagging != nil {
		v := s.Tagging

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "Tagging", v, metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "versionId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectTaggingOutput
type PutObjectTaggingOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation
func (s PutObjectTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutObjectTaggingOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s PutObjectTaggingOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutObjectTaggingOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-version-id", protocol.StringValue(v), metadata)
	}
	return nil
}

// Container for specifying an configuration when you want Amazon S3 to publish
// events to an Amazon Simple Queue Service (Amazon SQS) queue.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/QueueConfiguration
type QueueConfiguration struct {
	_ struct{} `type:"structure"`

	// Events is a required field
	Events []Event `locationName:"Event" type:"list" flattened:"true" required:"true"`

	// Container for object key name filtering rules. For information about key
	// name filtering, go to Configuring Event Notifications (http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
	// in the Amazon Simple Storage Service Developer Guide.
	Filter *NotificationConfigurationFilter `type:"structure"`

	// Optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	// Amazon SQS queue ARN to which Amazon S3 will publish a message when it detects
	// events of specified type.
	//
	// QueueArn is a required field
	QueueArn *string `locationName:"Queue" type:"string" required:"true"`
}

// String returns the string representation
func (s QueueConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueueConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueueConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "QueueConfiguration"}

	if s.Events == nil {
		invalidParams.Add(aws.NewErrParamRequired("Events"))
	}

	if s.QueueArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("QueueArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s QueueConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Events) > 0 {
		v := s.Events

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Event", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.Filter != nil {
		v := s.Filter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Filter", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.QueueArn != nil {
		v := *s.QueueArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Queue", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/QueueConfigurationDeprecated
type QueueConfigurationDeprecated struct {
	_ struct{} `type:"structure"`

	// Bucket event for which to send notifications.
	Event Event `deprecated:"true" type:"string" enum:"true"`

	Events []Event `locationName:"Event" type:"list" flattened:"true"`

	// Optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	Queue *string `type:"string"`
}

// String returns the string representation
func (s QueueConfigurationDeprecated) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueueConfigurationDeprecated) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s QueueConfigurationDeprecated) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Event) > 0 {
		v := s.Event

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Event", v, metadata)
	}
	if len(s.Events) > 0 {
		v := s.Events

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Event", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.Queue != nil {
		v := *s.Queue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Queue", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Redirect
type Redirect struct {
	_ struct{} `type:"structure"`

	// The host name to use in the redirect request.
	HostName *string `type:"string"`

	// The HTTP redirect code to use on the response. Not required if one of the
	// siblings is present.
	HttpRedirectCode *string `type:"string"`

	// Protocol to use (http, https) when redirecting requests. The default is the
	// protocol that is used in the original request.
	Protocol Protocol `type:"string" enum:"true"`

	// The object key prefix to use in the redirect request. For example, to redirect
	// requests for all pages with prefix docs/ (objects in the docs/ folder) to
	// documents/, you can set a condition block with KeyPrefixEquals set to docs/
	// and in the Redirect set ReplaceKeyPrefixWith to /documents. Not required
	// if one of the siblings is present. Can be present only if ReplaceKeyWith
	// is not provided.
	ReplaceKeyPrefixWith *string `type:"string"`

	// The specific object key to use in the redirect request. For example, redirect
	// request to error.html. Not required if one of the sibling is present. Can
	// be present only if ReplaceKeyPrefixWith is not provided.
	ReplaceKeyWith *string `type:"string"`
}

// String returns the string representation
func (s Redirect) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Redirect) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Redirect) MarshalFields(e protocol.FieldEncoder) error {
	if s.HostName != nil {
		v := *s.HostName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HostName", protocol.StringValue(v), metadata)
	}
	if s.HttpRedirectCode != nil {
		v := *s.HttpRedirectCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HttpRedirectCode", protocol.StringValue(v), metadata)
	}
	if len(s.Protocol) > 0 {
		v := s.Protocol

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Protocol", v, metadata)
	}
	if s.ReplaceKeyPrefixWith != nil {
		v := *s.ReplaceKeyPrefixWith

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReplaceKeyPrefixWith", protocol.StringValue(v), metadata)
	}
	if s.ReplaceKeyWith != nil {
		v := *s.ReplaceKeyWith

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReplaceKeyWith", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/RedirectAllRequestsTo
type RedirectAllRequestsTo struct {
	_ struct{} `type:"structure"`

	// Name of the host where requests will be redirected.
	//
	// HostName is a required field
	HostName *string `type:"string" required:"true"`

	// Protocol to use (http, https) when redirecting requests. The default is the
	// protocol that is used in the original request.
	Protocol Protocol `type:"string" enum:"true"`
}

// String returns the string representation
func (s RedirectAllRequestsTo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RedirectAllRequestsTo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RedirectAllRequestsTo) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RedirectAllRequestsTo"}

	if s.HostName == nil {
		invalidParams.Add(aws.NewErrParamRequired("HostName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RedirectAllRequestsTo) MarshalFields(e protocol.FieldEncoder) error {
	if s.HostName != nil {
		v := *s.HostName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HostName", protocol.StringValue(v), metadata)
	}
	if len(s.Protocol) > 0 {
		v := s.Protocol

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Protocol", v, metadata)
	}
	return nil
}

// Container for replication rules. You can add as many as 1,000 rules. Total
// replication configuration size can be up to 2 MB.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ReplicationConfiguration
type ReplicationConfiguration struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of an IAM role for Amazon S3 to assume when replicating
	// the objects.
	//
	// Role is a required field
	Role *string `type:"string" required:"true"`

	// Container for one or more replication rules. Replication configuration must
	// have at least one rule and can contain up to 1,000 rules.
	//
	// Rules is a required field
	Rules []ReplicationRule `locationName:"Rule" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s ReplicationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplicationConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ReplicationConfiguration"}

	if s.Role == nil {
		invalidParams.Add(aws.NewErrParamRequired("Role"))
	}

	if s.Rules == nil {
		invalidParams.Add(aws.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ReplicationConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.Role != nil {
		v := *s.Role

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Role", protocol.StringValue(v), metadata)
	}
	if len(s.Rules) > 0 {
		v := s.Rules

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Rule", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Container for information about a particular replication rule.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ReplicationRule
type ReplicationRule struct {
	_ struct{} `type:"structure"`

	// Specifies whether Amazon S3 should replicate delete makers.
	DeleteMarkerReplication *DeleteMarkerReplication `type:"structure"`

	// Container for replication destination information.
	//
	// Destination is a required field
	Destination *Destination `type:"structure" required:"true"`

	// Filter that identifies subset of objects to which the replication rule applies.
	// A Filter must specify exactly one Prefix, Tag, or an And child element.
	Filter *ReplicationRuleFilter `type:"structure"`

	// Unique identifier for the rule. The value cannot be longer than 255 characters.
	ID *string `type:"string"`

	// Object keyname prefix identifying one or more objects to which the rule applies.
	// Maximum prefix length can be up to 1,024 characters.
	Prefix *string `deprecated:"true" type:"string"`

	// The priority associated with the rule. If you specify multiple rules in a
	// replication configuration, then Amazon S3 applies rule priority in the event
	// there are conflicts (two or more rules identify the same object based on
	// filter specified). The rule with higher priority takes precedence. For example,
	//
	//    * Same object quality prefix based filter criteria If prefixes you specified
	//    in multiple rules overlap.
	//
	//    * Same object qualify tag based filter criteria specified in multiple
	//    rules
	//
	// For more information, see Cross-Region Replication (CRR) ( https://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html)
	// in the Amazon S3 Developer Guide.
	Priority *int64 `type:"integer"`

	// Container that describes additional filters in identifying source objects
	// that you want to replicate. Currently, Amazon S3 supports only the filter
	// that you can specify for objects created with server-side encryption using
	// an AWS KMS-managed key. You can choose to enable or disable replication of
	// these objects.
	//
	// if you want Amazon S3 to replicate objects created with server-side encryption
	// using AWS KMS-managed keys.
	SourceSelectionCriteria *SourceSelectionCriteria `type:"structure"`

	// The rule is ignored if status is not Enabled.
	//
	// Status is a required field
	Status ReplicationRuleStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ReplicationRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplicationRule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ReplicationRule"}

	if s.Destination == nil {
		invalidParams.Add(aws.NewErrParamRequired("Destination"))
	}
	if len(s.Status) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}
	if s.Destination != nil {
		if err := s.Destination.Validate(); err != nil {
			invalidParams.AddNested("Destination", err.(aws.ErrInvalidParams))
		}
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(aws.ErrInvalidParams))
		}
	}
	if s.SourceSelectionCriteria != nil {
		if err := s.SourceSelectionCriteria.Validate(); err != nil {
			invalidParams.AddNested("SourceSelectionCriteria", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ReplicationRule) MarshalFields(e protocol.FieldEncoder) error {
	if s.DeleteMarkerReplication != nil {
		v := s.DeleteMarkerReplication

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DeleteMarkerReplication", v, metadata)
	}
	if s.Destination != nil {
		v := s.Destination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Destination", v, metadata)
	}
	if s.Filter != nil {
		v := s.Filter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Filter", v, metadata)
	}
	if s.ID != nil {
		v := *s.ID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ID", protocol.StringValue(v), metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if s.Priority != nil {
		v := *s.Priority

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Priority", protocol.Int64Value(v), metadata)
	}
	if s.SourceSelectionCriteria != nil {
		v := s.SourceSelectionCriteria

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SourceSelectionCriteria", v, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ReplicationRuleAndOperator
type ReplicationRuleAndOperator struct {
	_ struct{} `type:"structure"`

	Prefix *string `type:"string"`

	Tags []Tag `locationName:"Tag" locationNameList:"Tag" type:"list" flattened:"true"`
}

// String returns the string representation
func (s ReplicationRuleAndOperator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationRuleAndOperator) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplicationRuleAndOperator) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ReplicationRuleAndOperator"}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ReplicationRuleAndOperator) MarshalFields(e protocol.FieldEncoder) error {
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Tag", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Filter that identifies subset of objects to which the replication rule applies.
// A Filter must specify exactly one Prefix, Tag, or an And child element.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ReplicationRuleFilter
type ReplicationRuleFilter struct {
	_ struct{} `type:"structure"`

	// Container for specifying rule filters. These filters determine the subset
	// of objects to which the rule applies. The element is required only if you
	// specify more than one filter. For example:
	//
	//    * You specify both a Prefix and a Tag filters. Then you wrap these in
	//    an And tag.
	//
	//    * You specify filter based on multiple tags. Then you wrap the Tag elements
	//    in an And tag.
	And *ReplicationRuleAndOperator `type:"structure"`

	// Object keyname prefix that identifies subset of objects to which the rule
	// applies.
	Prefix *string `type:"string"`

	// Container for specifying a tag key and value.
	//
	// The rule applies only to objects having the tag in its tagset.
	Tag *Tag `type:"structure"`
}

// String returns the string representation
func (s ReplicationRuleFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationRuleFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplicationRuleFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ReplicationRuleFilter"}
	if s.And != nil {
		if err := s.And.Validate(); err != nil {
			invalidParams.AddNested("And", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tag != nil {
		if err := s.Tag.Validate(); err != nil {
			invalidParams.AddNested("Tag", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ReplicationRuleFilter) MarshalFields(e protocol.FieldEncoder) error {
	if s.And != nil {
		v := s.And

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "And", v, metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if s.Tag != nil {
		v := s.Tag

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Tag", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/RequestPaymentConfiguration
type RequestPaymentConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies who pays for the download and request fees.
	//
	// Payer is a required field
	Payer Payer `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s RequestPaymentConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestPaymentConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RequestPaymentConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RequestPaymentConfiguration"}
	if len(s.Payer) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Payer"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RequestPaymentConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Payer) > 0 {
		v := s.Payer

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Payer", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/RestoreObjectRequest
type RestoreObjectInput struct {
	_ struct{} `type:"structure" payload:"RestoreRequest"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer RequestPayer `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"true"`

	// Container for restore job parameters.
	RestoreRequest *RestoreRequest `locationName:"RestoreRequest" type:"structure" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s RestoreObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreObjectInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RestoreObjectInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}
	if s.RestoreRequest != nil {
		if err := s.RestoreRequest.Validate(); err != nil {
			invalidParams.AddNested("RestoreRequest", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *RestoreObjectInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RestoreObjectInput) MarshalFields(e protocol.FieldEncoder) error {

	if len(s.RequestPayer) > 0 {
		v := s.RequestPayer

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-payer", v, metadata)
	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.RestoreRequest != nil {
		v := s.RestoreRequest

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "RestoreRequest", v, metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "versionId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/RestoreObjectOutput
type RestoreObjectOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged RequestCharged `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"true"`

	// Indicates the path in the provided S3 output location where Select results
	// will be restored to.
	RestoreOutputPath *string `location:"header" locationName:"x-amz-restore-output-path" type:"string"`
}

// String returns the string representation
func (s RestoreObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreObjectOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s RestoreObjectOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RestoreObjectOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.RequestCharged) > 0 {
		v := s.RequestCharged

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-charged", v, metadata)
	}
	if s.RestoreOutputPath != nil {
		v := *s.RestoreOutputPath

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-restore-output-path", protocol.StringValue(v), metadata)
	}
	return nil
}

// Container for restore job parameters.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/RestoreRequest
type RestoreRequest struct {
	_ struct{} `type:"structure"`

	// Lifetime of the active copy in days. Do not use with restores that specify
	// OutputLocation.
	Days *int64 `type:"integer"`

	// The optional description for the job.
	Description *string `type:"string"`

	// Glacier related parameters pertaining to this job. Do not use with restores
	// that specify OutputLocation.
	GlacierJobParameters *GlacierJobParameters `type:"structure"`

	// Describes the location where the restore job's output is stored.
	OutputLocation *OutputLocation `type:"structure"`

	// Describes the parameters for Select job types.
	SelectParameters *SelectParameters `type:"structure"`

	// Glacier retrieval tier at which the restore will be processed.
	Tier Tier `type:"string" enum:"true"`

	// Type of restore request.
	Type RestoreRequestType `type:"string" enum:"true"`
}

// String returns the string representation
func (s RestoreRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RestoreRequest"}
	if s.GlacierJobParameters != nil {
		if err := s.GlacierJobParameters.Validate(); err != nil {
			invalidParams.AddNested("GlacierJobParameters", err.(aws.ErrInvalidParams))
		}
	}
	if s.OutputLocation != nil {
		if err := s.OutputLocation.Validate(); err != nil {
			invalidParams.AddNested("OutputLocation", err.(aws.ErrInvalidParams))
		}
	}
	if s.SelectParameters != nil {
		if err := s.SelectParameters.Validate(); err != nil {
			invalidParams.AddNested("SelectParameters", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RestoreRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.Days != nil {
		v := *s.Days

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Days", protocol.Int64Value(v), metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.StringValue(v), metadata)
	}
	if s.GlacierJobParameters != nil {
		v := s.GlacierJobParameters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "GlacierJobParameters", v, metadata)
	}
	if s.OutputLocation != nil {
		v := s.OutputLocation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "OutputLocation", v, metadata)
	}
	if s.SelectParameters != nil {
		v := s.SelectParameters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SelectParameters", v, metadata)
	}
	if len(s.Tier) > 0 {
		v := s.Tier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Tier", v, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/RoutingRule
type RoutingRule struct {
	_ struct{} `type:"structure"`

	// A container for describing a condition that must be met for the specified
	// redirect to apply. For example, 1. If request is for pages in the /docs folder,
	// redirect to the /documents folder. 2. If request results in HTTP error 4xx,
	// redirect request to another host where you might process the error.
	Condition *Condition `type:"structure"`

	// Container for redirect information. You can redirect requests to another
	// host, to another page, or with another protocol. In the event of an error,
	// you can can specify a different error code to return.
	//
	// Redirect is a required field
	Redirect *Redirect `type:"structure" required:"true"`
}

// String returns the string representation
func (s RoutingRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RoutingRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RoutingRule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RoutingRule"}

	if s.Redirect == nil {
		invalidParams.Add(aws.NewErrParamRequired("Redirect"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RoutingRule) MarshalFields(e protocol.FieldEncoder) error {
	if s.Condition != nil {
		v := s.Condition

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Condition", v, metadata)
	}
	if s.Redirect != nil {
		v := s.Redirect

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Redirect", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Rule
type Rule struct {
	_ struct{} `type:"structure"`

	// Specifies the days since the initiation of an Incomplete Multipart Upload
	// that Lifecycle will wait before permanently removing all parts of the upload.
	AbortIncompleteMultipartUpload *AbortIncompleteMultipartUpload `type:"structure"`

	Expiration *LifecycleExpiration `type:"structure"`

	// Unique identifier for the rule. The value cannot be longer than 255 characters.
	ID *string `type:"string"`

	// Specifies when noncurrent object versions expire. Upon expiration, Amazon
	// S3 permanently deletes the noncurrent object versions. You set this lifecycle
	// configuration action on a bucket that has versioning enabled (or suspended)
	// to request that Amazon S3 delete noncurrent object versions at a specific
	// period in the object's lifetime.
	NoncurrentVersionExpiration *NoncurrentVersionExpiration `type:"structure"`

	// Container for the transition rule that describes when noncurrent objects
	// transition to the STANDARD_IA, ONEZONE_IA or GLACIER storage class. If your
	// bucket is versioning-enabled (or versioning is suspended), you can set this
	// action to request that Amazon S3 transition noncurrent object versions to
	// the STANDARD_IA, ONEZONE_IA or GLACIER storage class at a specific period
	// in the object's lifetime.
	NoncurrentVersionTransition *NoncurrentVersionTransition `type:"structure"`

	// Prefix identifying one or more objects to which the rule applies.
	//
	// Prefix is a required field
	Prefix *string `type:"string" required:"true"`

	// If 'Enabled', the rule is currently being applied. If 'Disabled', the rule
	// is not currently being applied.
	//
	// Status is a required field
	Status ExpirationStatus `type:"string" required:"true" enum:"true"`

	Transition *Transition `type:"structure"`
}

// String returns the string representation
func (s Rule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Rule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Rule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Rule"}

	if s.Prefix == nil {
		invalidParams.Add(aws.NewErrParamRequired("Prefix"))
	}
	if len(s.Status) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Rule) MarshalFields(e protocol.FieldEncoder) error {
	if s.AbortIncompleteMultipartUpload != nil {
		v := s.AbortIncompleteMultipartUpload

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AbortIncompleteMultipartUpload", v, metadata)
	}
	if s.Expiration != nil {
		v := s.Expiration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Expiration", v, metadata)
	}
	if s.ID != nil {
		v := *s.ID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ID", protocol.StringValue(v), metadata)
	}
	if s.NoncurrentVersionExpiration != nil {
		v := s.NoncurrentVersionExpiration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "NoncurrentVersionExpiration", v, metadata)
	}
	if s.NoncurrentVersionTransition != nil {
		v := s.NoncurrentVersionTransition

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "NoncurrentVersionTransition", v, metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", v, metadata)
	}
	if s.Transition != nil {
		v := s.Transition

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Transition", v, metadata)
	}
	return nil
}

// Specifies the use of SSE-KMS to encrypt delievered Inventory reports.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/SSEKMS
type SSEKMS struct {
	_ struct{} `type:"structure"`

	// Specifies the ID of the AWS Key Management Service (KMS) master encryption
	// key to use for encrypting Inventory reports.
	//
	// KeyId is a required field
	KeyId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SSEKMS) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SSEKMS) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SSEKMS) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SSEKMS"}

	if s.KeyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("KeyId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SSEKMS) MarshalFields(e protocol.FieldEncoder) error {
	if s.KeyId != nil {
		v := *s.KeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KeyId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Specifies the use of SSE-S3 to encrypt delievered Inventory reports.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/SSES3
type SSES3 struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SSES3) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SSES3) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SSES3) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Describes the parameters for Select job types.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/SelectParameters
type SelectParameters struct {
	_ struct{} `type:"structure"`

	// The expression that is used to query the object.
	//
	// Expression is a required field
	Expression *string `type:"string" required:"true"`

	// The type of the provided expression (e.g., SQL).
	//
	// ExpressionType is a required field
	ExpressionType ExpressionType `type:"string" required:"true" enum:"true"`

	// Describes the serialization format of the object.
	//
	// InputSerialization is a required field
	InputSerialization *InputSerialization `type:"structure" required:"true"`

	// Describes how the results of the Select job are serialized.
	//
	// OutputSerialization is a required field
	OutputSerialization *OutputSerialization `type:"structure" required:"true"`
}

// String returns the string representation
func (s SelectParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SelectParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SelectParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SelectParameters"}

	if s.Expression == nil {
		invalidParams.Add(aws.NewErrParamRequired("Expression"))
	}
	if len(s.ExpressionType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ExpressionType"))
	}

	if s.InputSerialization == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputSerialization"))
	}

	if s.OutputSerialization == nil {
		invalidParams.Add(aws.NewErrParamRequired("OutputSerialization"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SelectParameters) MarshalFields(e protocol.FieldEncoder) error {
	if s.Expression != nil {
		v := *s.Expression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Expression", protocol.StringValue(v), metadata)
	}
	if len(s.ExpressionType) > 0 {
		v := s.ExpressionType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExpressionType", v, metadata)
	}
	if s.InputSerialization != nil {
		v := s.InputSerialization

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "InputSerialization", v, metadata)
	}
	if s.OutputSerialization != nil {
		v := s.OutputSerialization

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "OutputSerialization", v, metadata)
	}
	return nil
}

// Describes the default server-side encryption to apply to new objects in the
// bucket. If Put Object request does not specify any server-side encryption,
// this default encryption will be applied.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ServerSideEncryptionByDefault
type ServerSideEncryptionByDefault struct {
	_ struct{} `type:"structure"`

	// KMS master key ID to use for the default encryption. This parameter is allowed
	// if SSEAlgorithm is aws:kms.
	KMSMasterKeyID *string `type:"string"`

	// Server-side encryption algorithm to use for the default encryption.
	//
	// SSEAlgorithm is a required field
	SSEAlgorithm ServerSideEncryption `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ServerSideEncryptionByDefault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServerSideEncryptionByDefault) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServerSideEncryptionByDefault) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ServerSideEncryptionByDefault"}
	if len(s.SSEAlgorithm) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("SSEAlgorithm"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ServerSideEncryptionByDefault) MarshalFields(e protocol.FieldEncoder) error {
	if s.KMSMasterKeyID != nil {
		v := *s.KMSMasterKeyID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KMSMasterKeyID", protocol.StringValue(v), metadata)
	}
	if len(s.SSEAlgorithm) > 0 {
		v := s.SSEAlgorithm

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SSEAlgorithm", v, metadata)
	}
	return nil
}

// Container for server-side encryption configuration rules. Currently S3 supports
// one rule only.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ServerSideEncryptionConfiguration
type ServerSideEncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// Container for information about a particular server-side encryption configuration
	// rule.
	//
	// Rules is a required field
	Rules []ServerSideEncryptionRule `locationName:"Rule" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s ServerSideEncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServerSideEncryptionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServerSideEncryptionConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ServerSideEncryptionConfiguration"}

	if s.Rules == nil {
		invalidParams.Add(aws.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ServerSideEncryptionConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Rules) > 0 {
		v := s.Rules

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Rule", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Container for information about a particular server-side encryption configuration
// rule.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ServerSideEncryptionRule
type ServerSideEncryptionRule struct {
	_ struct{} `type:"structure"`

	// Describes the default server-side encryption to apply to new objects in the
	// bucket. If Put Object request does not specify any server-side encryption,
	// this default encryption will be applied.
	ApplyServerSideEncryptionByDefault *ServerSideEncryptionByDefault `type:"structure"`
}

// String returns the string representation
func (s ServerSideEncryptionRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServerSideEncryptionRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServerSideEncryptionRule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ServerSideEncryptionRule"}
	if s.ApplyServerSideEncryptionByDefault != nil {
		if err := s.ApplyServerSideEncryptionByDefault.Validate(); err != nil {
			invalidParams.AddNested("ApplyServerSideEncryptionByDefault", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ServerSideEncryptionRule) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplyServerSideEncryptionByDefault != nil {
		v := s.ApplyServerSideEncryptionByDefault

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ApplyServerSideEncryptionByDefault", v, metadata)
	}
	return nil
}

// Container for filters that define which source objects should be replicated.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/SourceSelectionCriteria
type SourceSelectionCriteria struct {
	_ struct{} `type:"structure"`

	// Container for filter information of selection of KMS Encrypted S3 objects.
	// The element is required if you include SourceSelectionCriteria in the replication
	// configuration.
	SseKmsEncryptedObjects *SseKmsEncryptedObjects `type:"structure"`
}

// String returns the string representation
func (s SourceSelectionCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SourceSelectionCriteria) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceSelectionCriteria) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SourceSelectionCriteria"}
	if s.SseKmsEncryptedObjects != nil {
		if err := s.SseKmsEncryptedObjects.Validate(); err != nil {
			invalidParams.AddNested("SseKmsEncryptedObjects", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SourceSelectionCriteria) MarshalFields(e protocol.FieldEncoder) error {
	if s.SseKmsEncryptedObjects != nil {
		v := s.SseKmsEncryptedObjects

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SseKmsEncryptedObjects", v, metadata)
	}
	return nil
}

// Container for filter information of selection of KMS Encrypted S3 objects.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/SseKmsEncryptedObjects
type SseKmsEncryptedObjects struct {
	_ struct{} `type:"structure"`

	// The replication for KMS encrypted S3 objects is disabled if status is not
	// Enabled.
	//
	// Status is a required field
	Status SseKmsEncryptedObjectsStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s SseKmsEncryptedObjects) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SseKmsEncryptedObjects) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SseKmsEncryptedObjects) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SseKmsEncryptedObjects"}
	if len(s.Status) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SseKmsEncryptedObjects) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/StorageClassAnalysis
type StorageClassAnalysis struct {
	_ struct{} `type:"structure"`

	// A container used to describe how data related to the storage class analysis
	// should be exported.
	DataExport *StorageClassAnalysisDataExport `type:"structure"`
}

// String returns the string representation
func (s StorageClassAnalysis) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageClassAnalysis) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StorageClassAnalysis) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StorageClassAnalysis"}
	if s.DataExport != nil {
		if err := s.DataExport.Validate(); err != nil {
			invalidParams.AddNested("DataExport", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StorageClassAnalysis) MarshalFields(e protocol.FieldEncoder) error {
	if s.DataExport != nil {
		v := s.DataExport

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DataExport", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/StorageClassAnalysisDataExport
type StorageClassAnalysisDataExport struct {
	_ struct{} `type:"structure"`

	// The place to store the data for an analysis.
	//
	// Destination is a required field
	Destination *AnalyticsExportDestination `type:"structure" required:"true"`

	// The version of the output schema to use when exporting data. Must be V_1.
	//
	// OutputSchemaVersion is a required field
	OutputSchemaVersion StorageClassAnalysisSchemaVersion `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s StorageClassAnalysisDataExport) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageClassAnalysisDataExport) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StorageClassAnalysisDataExport) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StorageClassAnalysisDataExport"}

	if s.Destination == nil {
		invalidParams.Add(aws.NewErrParamRequired("Destination"))
	}
	if len(s.OutputSchemaVersion) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("OutputSchemaVersion"))
	}
	if s.Destination != nil {
		if err := s.Destination.Validate(); err != nil {
			invalidParams.AddNested("Destination", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StorageClassAnalysisDataExport) MarshalFields(e protocol.FieldEncoder) error {
	if s.Destination != nil {
		v := s.Destination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Destination", v, metadata)
	}
	if len(s.OutputSchemaVersion) > 0 {
		v := s.OutputSchemaVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OutputSchemaVersion", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// Name of the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Value of the tag.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Tag) MarshalFields(e protocol.FieldEncoder) error {
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Tagging
type Tagging struct {
	_ struct{} `type:"structure"`

	// TagSet is a required field
	TagSet []Tag `locationNameList:"Tag" type:"list" required:"true"`
}

// String returns the string representation
func (s Tagging) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tagging) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tagging) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tagging"}

	if s.TagSet == nil {
		invalidParams.Add(aws.NewErrParamRequired("TagSet"))
	}
	if s.TagSet != nil {
		for i, v := range s.TagSet {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagSet", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Tagging) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.TagSet) > 0 {
		v := s.TagSet

		metadata := protocol.Metadata{ListLocationName: "Tag"}
		ls0 := e.List(protocol.BodyTarget, "TagSet", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/TargetGrant
type TargetGrant struct {
	_ struct{} `type:"structure"`

	Grantee *Grantee `type:"structure" xmlPrefix:"xsi" xmlURI:"http://www.w3.org/2001/XMLSchema-instance"`

	// Logging permissions assigned to the Grantee for the bucket.
	Permission BucketLogsPermission `type:"string" enum:"true"`
}

// String returns the string representation
func (s TargetGrant) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TargetGrant) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TargetGrant) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TargetGrant"}
	if s.Grantee != nil {
		if err := s.Grantee.Validate(); err != nil {
			invalidParams.AddNested("Grantee", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TargetGrant) MarshalFields(e protocol.FieldEncoder) error {
	if s.Grantee != nil {
		v := s.Grantee
		attrs := make([]protocol.Attribute, 0, 1)

		if len(s.Grantee.Type) > 0 {

			v := s.Grantee.Type
			attrs = append(attrs, protocol.Attribute{Name: "xsi:type", Value: v, Meta: protocol.Metadata{}})
		}
		metadata := protocol.Metadata{Attributes: attrs, XMLNamespacePrefix: "xsi", XMLNamespaceURI: "http://www.w3.org/2001/XMLSchema-instance"}
		e.SetFields(protocol.BodyTarget, "Grantee", v, metadata)
	}
	if len(s.Permission) > 0 {
		v := s.Permission

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Permission", v, metadata)
	}
	return nil
}

// Container for specifying the configuration when you want Amazon S3 to publish
// events to an Amazon Simple Notification Service (Amazon SNS) topic.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/TopicConfiguration
type TopicConfiguration struct {
	_ struct{} `type:"structure"`

	// Events is a required field
	Events []Event `locationName:"Event" type:"list" flattened:"true" required:"true"`

	// Container for object key name filtering rules. For information about key
	// name filtering, go to Configuring Event Notifications (http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
	// in the Amazon Simple Storage Service Developer Guide.
	Filter *NotificationConfigurationFilter `type:"structure"`

	// Optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	// Amazon SNS topic ARN to which Amazon S3 will publish a message when it detects
	// events of specified type.
	//
	// TopicArn is a required field
	TopicArn *string `locationName:"Topic" type:"string" required:"true"`
}

// String returns the string representation
func (s TopicConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TopicConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TopicConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TopicConfiguration"}

	if s.Events == nil {
		invalidParams.Add(aws.NewErrParamRequired("Events"))
	}

	if s.TopicArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("TopicArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TopicConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Events) > 0 {
		v := s.Events

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Event", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.Filter != nil {
		v := s.Filter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Filter", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.TopicArn != nil {
		v := *s.TopicArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Topic", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/TopicConfigurationDeprecated
type TopicConfigurationDeprecated struct {
	_ struct{} `type:"structure"`

	// Bucket event for which to send notifications.
	Event Event `deprecated:"true" type:"string" enum:"true"`

	Events []Event `locationName:"Event" type:"list" flattened:"true"`

	// Optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	// Amazon SNS topic to which Amazon S3 will publish a message to report the
	// specified events for the bucket.
	Topic *string `type:"string"`
}

// String returns the string representation
func (s TopicConfigurationDeprecated) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TopicConfigurationDeprecated) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TopicConfigurationDeprecated) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Event) > 0 {
		v := s.Event

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Event", v, metadata)
	}
	if len(s.Events) > 0 {
		v := s.Events

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Event", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.Topic != nil {
		v := *s.Topic

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Topic", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Transition
type Transition struct {
	_ struct{} `type:"structure"`

	// Indicates at what date the object is to be moved or deleted. Should be in
	// GMT ISO 8601 Format.
	Date *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Indicates the lifetime, in days, of the objects that are subject to the rule.
	// The value must be a non-zero positive integer.
	Days *int64 `type:"integer"`

	// The class of storage used to store the object.
	StorageClass TransitionStorageClass `type:"string" enum:"true"`
}

// String returns the string representation
func (s Transition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Transition) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Transition) MarshalFields(e protocol.FieldEncoder) error {
	if s.Date != nil {
		v := *s.Date

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Date", protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormat}, metadata)
	}
	if s.Days != nil {
		v := *s.Days

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Days", protocol.Int64Value(v), metadata)
	}
	if len(s.StorageClass) > 0 {
		v := s.StorageClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StorageClass", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/UploadPartCopyRequest
type UploadPartCopyInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The name of the source bucket and key name of the source object, separated
	// by a slash (/). Must be URL-encoded.
	//
	// CopySource is a required field
	CopySource *string `location:"header" locationName:"x-amz-copy-source" type:"string" required:"true"`

	// Copies the object if its entity tag (ETag) matches the specified tag.
	CopySourceIfMatch *string `location:"header" locationName:"x-amz-copy-source-if-match" type:"string"`

	// Copies the object if it has been modified since the specified time.
	CopySourceIfModifiedSince *time.Time `location:"header" locationName:"x-amz-copy-source-if-modified-since" type:"timestamp" timestampFormat:"rfc822"`

	// Copies the object if its entity tag (ETag) is different than the specified
	// ETag.
	CopySourceIfNoneMatch *string `location:"header" locationName:"x-amz-copy-source-if-none-match" type:"string"`

	// Copies the object if it hasn't been modified since the specified time.
	CopySourceIfUnmodifiedSince *time.Time `location:"header" locationName:"x-amz-copy-source-if-unmodified-since" type:"timestamp" timestampFormat:"rfc822"`

	// The range of bytes to copy from the source object. The range value must use
	// the form bytes=first-last, where the first and last are the zero-based byte
	// offsets to copy. For example, bytes=0-9 indicates that you want to copy the
	// first ten bytes of the source. You can copy a range only if the source object
	// is greater than 5 GB.
	CopySourceRange *string `location:"header" locationName:"x-amz-copy-source-range" type:"string"`

	// Specifies the algorithm to use when decrypting the source object (e.g., AES256).
	CopySourceSSECustomerAlgorithm *string `location:"header" locationName:"x-amz-copy-source-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use to decrypt
	// the source object. The encryption key provided in this header must be one
	// that was used when the source object was created.
	CopySourceSSECustomerKey *string `location:"header" locationName:"x-amz-copy-source-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	CopySourceSSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-copy-source-server-side-encryption-customer-key-MD5" type:"string"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Part number of part being copied. This is a positive integer between 1 and
	// 10,000.
	//
	// PartNumber is a required field
	PartNumber *int64 `location:"querystring" locationName:"partNumber" type:"integer" required:"true"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer RequestPayer `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"true"`

	// Specifies the algorithm to use to when encrypting the object (e.g., AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// does not store the encryption key. The key must be appropriate for use with
	// the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm
	// header. This must be the same encryption key specified in the initiate multipart
	// upload request.
	SSECustomerKey *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// Upload ID identifying the multipart upload whose part is being copied.
	//
	// UploadId is a required field
	UploadId *string `location:"querystring" locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation
func (s UploadPartCopyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadPartCopyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UploadPartCopyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UploadPartCopyInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.CopySource == nil {
		invalidParams.Add(aws.NewErrParamRequired("CopySource"))
	}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.PartNumber == nil {
		invalidParams.Add(aws.NewErrParamRequired("PartNumber"))
	}

	if s.UploadId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UploadId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *UploadPartCopyInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

func (s *UploadPartCopyInput) getCopySourceSSECustomerKey() (v string) {
	if s.CopySourceSSECustomerKey == nil {
		return v
	}
	return *s.CopySourceSSECustomerKey
}

func (s *UploadPartCopyInput) getSSECustomerKey() (v string) {
	if s.SSECustomerKey == nil {
		return v
	}
	return *s.SSECustomerKey
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UploadPartCopyInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.CopySource != nil {
		v := *s.CopySource

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-copy-source", protocol.StringValue(v), metadata)
	}
	if s.CopySourceIfMatch != nil {
		v := *s.CopySourceIfMatch

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-copy-source-if-match", protocol.StringValue(v), metadata)
	}
	if s.CopySourceIfModifiedSince != nil {
		v := *s.CopySourceIfModifiedSince

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-copy-source-if-modified-since", protocol.TimeValue{V: v, Format: protocol.RFC822TimeFromat}, metadata)
	}
	if s.CopySourceIfNoneMatch != nil {
		v := *s.CopySourceIfNoneMatch

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-copy-source-if-none-match", protocol.StringValue(v), metadata)
	}
	if s.CopySourceIfUnmodifiedSince != nil {
		v := *s.CopySourceIfUnmodifiedSince

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-copy-source-if-unmodified-since", protocol.TimeValue{V: v, Format: protocol.RFC822TimeFromat}, metadata)
	}
	if s.CopySourceRange != nil {
		v := *s.CopySourceRange

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-copy-source-range", protocol.StringValue(v), metadata)
	}
	if s.CopySourceSSECustomerAlgorithm != nil {
		v := *s.CopySourceSSECustomerAlgorithm

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-copy-source-server-side-encryption-customer-algorithm", protocol.StringValue(v), metadata)
	}
	if s.CopySourceSSECustomerKey != nil {
		v := *s.CopySourceSSECustomerKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-copy-source-server-side-encryption-customer-key", protocol.StringValue(v), metadata)
	}
	if s.CopySourceSSECustomerKeyMD5 != nil {
		v := *s.CopySourceSSECustomerKeyMD5

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-copy-source-server-side-encryption-customer-key-MD5", protocol.StringValue(v), metadata)
	}
	if len(s.RequestPayer) > 0 {
		v := s.RequestPayer

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-payer", v, metadata)
	}
	if s.SSECustomerAlgorithm != nil {
		v := *s.SSECustomerAlgorithm

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-customer-algorithm", protocol.StringValue(v), metadata)
	}
	if s.SSECustomerKey != nil {
		v := *s.SSECustomerKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-customer-key", protocol.StringValue(v), metadata)
	}
	if s.SSECustomerKeyMD5 != nil {
		v := *s.SSECustomerKeyMD5

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-customer-key-MD5", protocol.StringValue(v), metadata)
	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.PartNumber != nil {
		v := *s.PartNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "partNumber", protocol.Int64Value(v), metadata)
	}
	if s.UploadId != nil {
		v := *s.UploadId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "uploadId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/UploadPartCopyOutput
type UploadPartCopyOutput struct {
	_ struct{} `type:"structure" payload:"CopyPartResult"`

	responseMetadata aws.Response

	CopyPartResult *CopyPartResult `type:"structure"`

	// The version of the source object that was copied, if you have enabled versioning
	// on the source bucket.
	CopySourceVersionId *string `location:"header" locationName:"x-amz-copy-source-version-id" type:"string"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged RequestCharged `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"true"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the ID of the AWS Key Management Service (KMS) master
	// encryption key that was used for the object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption ServerSideEncryption `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"true"`
}

// String returns the string representation
func (s UploadPartCopyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadPartCopyOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s UploadPartCopyOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UploadPartCopyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CopySourceVersionId != nil {
		v := *s.CopySourceVersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-copy-source-version-id", protocol.StringValue(v), metadata)
	}
	if len(s.RequestCharged) > 0 {
		v := s.RequestCharged

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-charged", v, metadata)
	}
	if s.SSECustomerAlgorithm != nil {
		v := *s.SSECustomerAlgorithm

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-customer-algorithm", protocol.StringValue(v), metadata)
	}
	if s.SSECustomerKeyMD5 != nil {
		v := *s.SSECustomerKeyMD5

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-customer-key-MD5", protocol.StringValue(v), metadata)
	}
	if s.SSEKMSKeyId != nil {
		v := *s.SSEKMSKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-aws-kms-key-id", protocol.StringValue(v), metadata)
	}
	if len(s.ServerSideEncryption) > 0 {
		v := s.ServerSideEncryption

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption", v, metadata)
	}
	if s.CopyPartResult != nil {
		v := s.CopyPartResult

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "CopyPartResult", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/UploadPartRequest
type UploadPartInput struct {
	_ struct{} `type:"structure" payload:"Body"`

	// Object data.
	Body io.ReadSeeker `type:"blob"`

	// Name of the bucket to which the multipart upload was initiated.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Size of the body in bytes. This parameter is useful when the size of the
	// body cannot be determined automatically.
	ContentLength *int64 `location:"header" locationName:"Content-Length" type:"long"`

	// The base64-encoded 128-bit MD5 digest of the part data.
	ContentMD5 *string `location:"header" locationName:"Content-MD5" type:"string"`

	// Object key for which the multipart upload was initiated.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Part number of part being uploaded. This is a positive integer between 1
	// and 10,000.
	//
	// PartNumber is a required field
	PartNumber *int64 `location:"querystring" locationName:"partNumber" type:"integer" required:"true"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer RequestPayer `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"true"`

	// Specifies the algorithm to use to when encrypting the object (e.g., AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// does not store the encryption key. The key must be appropriate for use with
	// the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm
	// header. This must be the same encryption key specified in the initiate multipart
	// upload request.
	SSECustomerKey *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// Upload ID identifying the multipart upload whose part is being uploaded.
	//
	// UploadId is a required field
	UploadId *string `location:"querystring" locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation
func (s UploadPartInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadPartInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UploadPartInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UploadPartInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.PartNumber == nil {
		invalidParams.Add(aws.NewErrParamRequired("PartNumber"))
	}

	if s.UploadId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UploadId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *UploadPartInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

func (s *UploadPartInput) getSSECustomerKey() (v string) {
	if s.SSECustomerKey == nil {
		return v
	}
	return *s.SSECustomerKey
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UploadPartInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.ContentLength != nil {
		v := *s.ContentLength

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Content-Length", protocol.Int64Value(v), metadata)
	}
	if s.ContentMD5 != nil {
		v := *s.ContentMD5

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Content-MD5", protocol.StringValue(v), metadata)
	}
	if len(s.RequestPayer) > 0 {
		v := s.RequestPayer

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-payer", v, metadata)
	}
	if s.SSECustomerAlgorithm != nil {
		v := *s.SSECustomerAlgorithm

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-customer-algorithm", protocol.StringValue(v), metadata)
	}
	if s.SSECustomerKey != nil {
		v := *s.SSECustomerKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-customer-key", protocol.StringValue(v), metadata)
	}
	if s.SSECustomerKeyMD5 != nil {
		v := *s.SSECustomerKeyMD5

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-customer-key-MD5", protocol.StringValue(v), metadata)
	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.Body != nil {
		v := s.Body

		metadata := protocol.Metadata{}
		e.SetStream(protocol.PayloadTarget, "Body", protocol.ReadSeekerStream{V: v}, metadata)
	}
	if s.PartNumber != nil {
		v := *s.PartNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "partNumber", protocol.Int64Value(v), metadata)
	}
	if s.UploadId != nil {
		v := *s.UploadId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "uploadId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/UploadPartOutput
type UploadPartOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// Entity tag for the uploaded object.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged RequestCharged `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"true"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the ID of the AWS Key Management Service (KMS) master
	// encryption key that was used for the object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption ServerSideEncryption `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"true"`
}

// String returns the string representation
func (s UploadPartOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadPartOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s UploadPartOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UploadPartOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if len(s.RequestCharged) > 0 {
		v := s.RequestCharged

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-charged", v, metadata)
	}
	if s.SSECustomerAlgorithm != nil {
		v := *s.SSECustomerAlgorithm

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-customer-algorithm", protocol.StringValue(v), metadata)
	}
	if s.SSECustomerKeyMD5 != nil {
		v := *s.SSECustomerKeyMD5

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-customer-key-MD5", protocol.StringValue(v), metadata)
	}
	if s.SSEKMSKeyId != nil {
		v := *s.SSEKMSKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption-aws-kms-key-id", protocol.StringValue(v), metadata)
	}
	if len(s.ServerSideEncryption) > 0 {
		v := s.ServerSideEncryption

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-server-side-encryption", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/VersioningConfiguration
type VersioningConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies whether MFA delete is enabled in the bucket versioning configuration.
	// This element is only returned if the bucket has been configured with MFA
	// delete. If the bucket has never been so configured, this element is not returned.
	MFADelete MFADelete `locationName:"MfaDelete" type:"string" enum:"true"`

	// The versioning state of the bucket.
	Status BucketVersioningStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s VersioningConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VersioningConfiguration) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VersioningConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.MFADelete) > 0 {
		v := s.MFADelete

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MfaDelete", v, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/WebsiteConfiguration
type WebsiteConfiguration struct {
	_ struct{} `type:"structure"`

	ErrorDocument *ErrorDocument `type:"structure"`

	IndexDocument *IndexDocument `type:"structure"`

	RedirectAllRequestsTo *RedirectAllRequestsTo `type:"structure"`

	RoutingRules []RoutingRule `locationNameList:"RoutingRule" type:"list"`
}

// String returns the string representation
func (s WebsiteConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WebsiteConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WebsiteConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "WebsiteConfiguration"}
	if s.ErrorDocument != nil {
		if err := s.ErrorDocument.Validate(); err != nil {
			invalidParams.AddNested("ErrorDocument", err.(aws.ErrInvalidParams))
		}
	}
	if s.IndexDocument != nil {
		if err := s.IndexDocument.Validate(); err != nil {
			invalidParams.AddNested("IndexDocument", err.(aws.ErrInvalidParams))
		}
	}
	if s.RedirectAllRequestsTo != nil {
		if err := s.RedirectAllRequestsTo.Validate(); err != nil {
			invalidParams.AddNested("RedirectAllRequestsTo", err.(aws.ErrInvalidParams))
		}
	}
	if s.RoutingRules != nil {
		for i, v := range s.RoutingRules {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RoutingRules", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s WebsiteConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.ErrorDocument != nil {
		v := s.ErrorDocument

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ErrorDocument", v, metadata)
	}
	if s.IndexDocument != nil {
		v := s.IndexDocument

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "IndexDocument", v, metadata)
	}
	if s.RedirectAllRequestsTo != nil {
		v := s.RedirectAllRequestsTo

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "RedirectAllRequestsTo", v, metadata)
	}
	if len(s.RoutingRules) > 0 {
		v := s.RoutingRules

		metadata := protocol.Metadata{ListLocationName: "RoutingRule"}
		ls0 := e.List(protocol.BodyTarget, "RoutingRules", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

type AnalyticsS3ExportFileFormat string

// Enum values for AnalyticsS3ExportFileFormat
const (
	AnalyticsS3ExportFileFormatCsv AnalyticsS3ExportFileFormat = "CSV"
)

func (enum AnalyticsS3ExportFileFormat) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum AnalyticsS3ExportFileFormat) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type BucketAccelerateStatus string

// Enum values for BucketAccelerateStatus
const (
	BucketAccelerateStatusEnabled   BucketAccelerateStatus = "Enabled"
	BucketAccelerateStatusSuspended BucketAccelerateStatus = "Suspended"
)

func (enum BucketAccelerateStatus) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum BucketAccelerateStatus) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type BucketCannedACL string

// Enum values for BucketCannedACL
const (
	BucketCannedACLPrivate           BucketCannedACL = "private"
	BucketCannedACLPublicRead        BucketCannedACL = "public-read"
	BucketCannedACLPublicReadWrite   BucketCannedACL = "public-read-write"
	BucketCannedACLAuthenticatedRead BucketCannedACL = "authenticated-read"
)

func (enum BucketCannedACL) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum BucketCannedACL) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type BucketLocationConstraint string

// Enum values for BucketLocationConstraint
const (
	BucketLocationConstraintEu           BucketLocationConstraint = "EU"
	BucketLocationConstraintEuWest1      BucketLocationConstraint = "eu-west-1"
	BucketLocationConstraintUsWest1      BucketLocationConstraint = "us-west-1"
	BucketLocationConstraintUsWest2      BucketLocationConstraint = "us-west-2"
	BucketLocationConstraintApSouth1     BucketLocationConstraint = "ap-south-1"
	BucketLocationConstraintApSoutheast1 BucketLocationConstraint = "ap-southeast-1"
	BucketLocationConstraintApSoutheast2 BucketLocationConstraint = "ap-southeast-2"
	BucketLocationConstraintApNortheast1 BucketLocationConstraint = "ap-northeast-1"
	BucketLocationConstraintSaEast1      BucketLocationConstraint = "sa-east-1"
	BucketLocationConstraintCnNorth1     BucketLocationConstraint = "cn-north-1"
	BucketLocationConstraintEuCentral1   BucketLocationConstraint = "eu-central-1"
)

func (enum BucketLocationConstraint) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum BucketLocationConstraint) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type BucketLogsPermission string

// Enum values for BucketLogsPermission
const (
	BucketLogsPermissionFullControl BucketLogsPermission = "FULL_CONTROL"
	BucketLogsPermissionRead        BucketLogsPermission = "READ"
	BucketLogsPermissionWrite       BucketLogsPermission = "WRITE"
)

func (enum BucketLogsPermission) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum BucketLogsPermission) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type BucketVersioningStatus string

// Enum values for BucketVersioningStatus
const (
	BucketVersioningStatusEnabled   BucketVersioningStatus = "Enabled"
	BucketVersioningStatusSuspended BucketVersioningStatus = "Suspended"
)

func (enum BucketVersioningStatus) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum BucketVersioningStatus) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type CompressionType string

// Enum values for CompressionType
const (
	CompressionTypeNone  CompressionType = "NONE"
	CompressionTypeGzip  CompressionType = "GZIP"
	CompressionTypeBzip2 CompressionType = "BZIP2"
)

func (enum CompressionType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum CompressionType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type DeleteMarkerReplicationStatus string

// Enum values for DeleteMarkerReplicationStatus
const (
	DeleteMarkerReplicationStatusEnabled  DeleteMarkerReplicationStatus = "Enabled"
	DeleteMarkerReplicationStatusDisabled DeleteMarkerReplicationStatus = "Disabled"
)

func (enum DeleteMarkerReplicationStatus) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum DeleteMarkerReplicationStatus) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Requests Amazon S3 to encode the object keys in the response and specifies
// the encoding method to use. An object key may contain any Unicode character;
// however, XML 1.0 parser cannot parse some characters, such as characters
// with an ASCII value from 0 to 10. For characters that are not supported in
// XML 1.0, you can add this parameter to request that Amazon S3 encode the
// keys in the response.
type EncodingType string

// Enum values for EncodingType
const (
	EncodingTypeUrl EncodingType = "url"
)

func (enum EncodingType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum EncodingType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Bucket event for which to send notifications.
type Event string

// Enum values for Event
const (
	EventS3ReducedRedundancyLostObject          Event = "s3:ReducedRedundancyLostObject"
	EventS3ObjectCreated                        Event = "s3:ObjectCreated:*"
	EventS3ObjectCreatedPut                     Event = "s3:ObjectCreated:Put"
	EventS3ObjectCreatedPost                    Event = "s3:ObjectCreated:Post"
	EventS3ObjectCreatedCopy                    Event = "s3:ObjectCreated:Copy"
	EventS3ObjectCreatedCompleteMultipartUpload Event = "s3:ObjectCreated:CompleteMultipartUpload"
	EventS3ObjectRemoved                        Event = "s3:ObjectRemoved:*"
	EventS3ObjectRemovedDelete                  Event = "s3:ObjectRemoved:Delete"
	EventS3ObjectRemovedDeleteMarkerCreated     Event = "s3:ObjectRemoved:DeleteMarkerCreated"
)

func (enum Event) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Event) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type ExpirationStatus string

// Enum values for ExpirationStatus
const (
	ExpirationStatusEnabled  ExpirationStatus = "Enabled"
	ExpirationStatusDisabled ExpirationStatus = "Disabled"
)

func (enum ExpirationStatus) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ExpirationStatus) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type ExpressionType string

// Enum values for ExpressionType
const (
	ExpressionTypeSql ExpressionType = "SQL"
)

func (enum ExpressionType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ExpressionType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type FileHeaderInfo string

// Enum values for FileHeaderInfo
const (
	FileHeaderInfoUse    FileHeaderInfo = "USE"
	FileHeaderInfoIgnore FileHeaderInfo = "IGNORE"
	FileHeaderInfoNone   FileHeaderInfo = "NONE"
)

func (enum FileHeaderInfo) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum FileHeaderInfo) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type FilterRuleName string

// Enum values for FilterRuleName
const (
	FilterRuleNamePrefix FilterRuleName = "prefix"
	FilterRuleNameSuffix FilterRuleName = "suffix"
)

func (enum FilterRuleName) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum FilterRuleName) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type InventoryFormat string

// Enum values for InventoryFormat
const (
	InventoryFormatCsv InventoryFormat = "CSV"
	InventoryFormatOrc InventoryFormat = "ORC"
)

func (enum InventoryFormat) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum InventoryFormat) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type InventoryFrequency string

// Enum values for InventoryFrequency
const (
	InventoryFrequencyDaily  InventoryFrequency = "Daily"
	InventoryFrequencyWeekly InventoryFrequency = "Weekly"
)

func (enum InventoryFrequency) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum InventoryFrequency) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type InventoryIncludedObjectVersions string

// Enum values for InventoryIncludedObjectVersions
const (
	InventoryIncludedObjectVersionsAll     InventoryIncludedObjectVersions = "All"
	InventoryIncludedObjectVersionsCurrent InventoryIncludedObjectVersions = "Current"
)

func (enum InventoryIncludedObjectVersions) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum InventoryIncludedObjectVersions) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type InventoryOptionalField string

// Enum values for InventoryOptionalField
const (
	InventoryOptionalFieldSize                InventoryOptionalField = "Size"
	InventoryOptionalFieldLastModifiedDate    InventoryOptionalField = "LastModifiedDate"
	InventoryOptionalFieldStorageClass        InventoryOptionalField = "StorageClass"
	InventoryOptionalFieldEtag                InventoryOptionalField = "ETag"
	InventoryOptionalFieldIsMultipartUploaded InventoryOptionalField = "IsMultipartUploaded"
	InventoryOptionalFieldReplicationStatus   InventoryOptionalField = "ReplicationStatus"
	InventoryOptionalFieldEncryptionStatus    InventoryOptionalField = "EncryptionStatus"
)

func (enum InventoryOptionalField) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum InventoryOptionalField) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type JSONType string

// Enum values for JSONType
const (
	JSONTypeDocument JSONType = "DOCUMENT"
	JSONTypeLines    JSONType = "LINES"
)

func (enum JSONType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum JSONType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type MFADelete string

// Enum values for MFADelete
const (
	MFADeleteEnabled  MFADelete = "Enabled"
	MFADeleteDisabled MFADelete = "Disabled"
)

func (enum MFADelete) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum MFADelete) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type MFADeleteStatus string

// Enum values for MFADeleteStatus
const (
	MFADeleteStatusEnabled  MFADeleteStatus = "Enabled"
	MFADeleteStatusDisabled MFADeleteStatus = "Disabled"
)

func (enum MFADeleteStatus) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum MFADeleteStatus) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type MetadataDirective string

// Enum values for MetadataDirective
const (
	MetadataDirectiveCopy    MetadataDirective = "COPY"
	MetadataDirectiveReplace MetadataDirective = "REPLACE"
)

func (enum MetadataDirective) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum MetadataDirective) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type ObjectCannedACL string

// Enum values for ObjectCannedACL
const (
	ObjectCannedACLPrivate                ObjectCannedACL = "private"
	ObjectCannedACLPublicRead             ObjectCannedACL = "public-read"
	ObjectCannedACLPublicReadWrite        ObjectCannedACL = "public-read-write"
	ObjectCannedACLAuthenticatedRead      ObjectCannedACL = "authenticated-read"
	ObjectCannedACLAwsExecRead            ObjectCannedACL = "aws-exec-read"
	ObjectCannedACLBucketOwnerRead        ObjectCannedACL = "bucket-owner-read"
	ObjectCannedACLBucketOwnerFullControl ObjectCannedACL = "bucket-owner-full-control"
)

func (enum ObjectCannedACL) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ObjectCannedACL) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type ObjectStorageClass string

// Enum values for ObjectStorageClass
const (
	ObjectStorageClassStandard          ObjectStorageClass = "STANDARD"
	ObjectStorageClassReducedRedundancy ObjectStorageClass = "REDUCED_REDUNDANCY"
	ObjectStorageClassGlacier           ObjectStorageClass = "GLACIER"
	ObjectStorageClassStandardIa        ObjectStorageClass = "STANDARD_IA"
	ObjectStorageClassOnezoneIa         ObjectStorageClass = "ONEZONE_IA"
)

func (enum ObjectStorageClass) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ObjectStorageClass) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type ObjectVersionStorageClass string

// Enum values for ObjectVersionStorageClass
const (
	ObjectVersionStorageClassStandard ObjectVersionStorageClass = "STANDARD"
)

func (enum ObjectVersionStorageClass) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ObjectVersionStorageClass) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type OwnerOverride string

// Enum values for OwnerOverride
const (
	OwnerOverrideDestination OwnerOverride = "Destination"
)

func (enum OwnerOverride) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum OwnerOverride) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type Payer string

// Enum values for Payer
const (
	PayerRequester   Payer = "Requester"
	PayerBucketOwner Payer = "BucketOwner"
)

func (enum Payer) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Payer) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type Permission string

// Enum values for Permission
const (
	PermissionFullControl Permission = "FULL_CONTROL"
	PermissionWrite       Permission = "WRITE"
	PermissionWriteAcp    Permission = "WRITE_ACP"
	PermissionRead        Permission = "READ"
	PermissionReadAcp     Permission = "READ_ACP"
)

func (enum Permission) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Permission) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type Protocol string

// Enum values for Protocol
const (
	ProtocolHttp  Protocol = "http"
	ProtocolHttps Protocol = "https"
)

func (enum Protocol) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Protocol) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type QuoteFields string

// Enum values for QuoteFields
const (
	QuoteFieldsAlways   QuoteFields = "ALWAYS"
	QuoteFieldsAsneeded QuoteFields = "ASNEEDED"
)

func (enum QuoteFields) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum QuoteFields) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type ReplicationRuleStatus string

// Enum values for ReplicationRuleStatus
const (
	ReplicationRuleStatusEnabled  ReplicationRuleStatus = "Enabled"
	ReplicationRuleStatusDisabled ReplicationRuleStatus = "Disabled"
)

func (enum ReplicationRuleStatus) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ReplicationRuleStatus) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type ReplicationStatus string

// Enum values for ReplicationStatus
const (
	ReplicationStatusComplete ReplicationStatus = "COMPLETE"
	ReplicationStatusPending  ReplicationStatus = "PENDING"
	ReplicationStatusFailed   ReplicationStatus = "FAILED"
	ReplicationStatusReplica  ReplicationStatus = "REPLICA"
)

func (enum ReplicationStatus) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ReplicationStatus) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// If present, indicates that the requester was successfully charged for the
// request.
type RequestCharged string

// Enum values for RequestCharged
const (
	RequestChargedRequester RequestCharged = "requester"
)

func (enum RequestCharged) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum RequestCharged) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Confirms that the requester knows that she or he will be charged for the
// request. Bucket owners need not specify this parameter in their requests.
// Documentation on downloading objects from requester pays buckets can be found
// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
type RequestPayer string

// Enum values for RequestPayer
const (
	RequestPayerRequester RequestPayer = "requester"
)

func (enum RequestPayer) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum RequestPayer) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type RestoreRequestType string

// Enum values for RestoreRequestType
const (
	RestoreRequestTypeSelect RestoreRequestType = "SELECT"
)

func (enum RestoreRequestType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum RestoreRequestType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type ServerSideEncryption string

// Enum values for ServerSideEncryption
const (
	ServerSideEncryptionAes256 ServerSideEncryption = "AES256"
	ServerSideEncryptionAwsKms ServerSideEncryption = "aws:kms"
)

func (enum ServerSideEncryption) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ServerSideEncryption) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type SseKmsEncryptedObjectsStatus string

// Enum values for SseKmsEncryptedObjectsStatus
const (
	SseKmsEncryptedObjectsStatusEnabled  SseKmsEncryptedObjectsStatus = "Enabled"
	SseKmsEncryptedObjectsStatusDisabled SseKmsEncryptedObjectsStatus = "Disabled"
)

func (enum SseKmsEncryptedObjectsStatus) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum SseKmsEncryptedObjectsStatus) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type StorageClass string

// Enum values for StorageClass
const (
	StorageClassStandard          StorageClass = "STANDARD"
	StorageClassReducedRedundancy StorageClass = "REDUCED_REDUNDANCY"
	StorageClassStandardIa        StorageClass = "STANDARD_IA"
	StorageClassOnezoneIa         StorageClass = "ONEZONE_IA"
)

func (enum StorageClass) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum StorageClass) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type StorageClassAnalysisSchemaVersion string

// Enum values for StorageClassAnalysisSchemaVersion
const (
	StorageClassAnalysisSchemaVersionV1 StorageClassAnalysisSchemaVersion = "V_1"
)

func (enum StorageClassAnalysisSchemaVersion) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum StorageClassAnalysisSchemaVersion) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type TaggingDirective string

// Enum values for TaggingDirective
const (
	TaggingDirectiveCopy    TaggingDirective = "COPY"
	TaggingDirectiveReplace TaggingDirective = "REPLACE"
)

func (enum TaggingDirective) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum TaggingDirective) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type Tier string

// Enum values for Tier
const (
	TierStandard  Tier = "Standard"
	TierBulk      Tier = "Bulk"
	TierExpedited Tier = "Expedited"
)

func (enum Tier) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Tier) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type TransitionStorageClass string

// Enum values for TransitionStorageClass
const (
	TransitionStorageClassGlacier    TransitionStorageClass = "GLACIER"
	TransitionStorageClassStandardIa TransitionStorageClass = "STANDARD_IA"
	TransitionStorageClassOnezoneIa  TransitionStorageClass = "ONEZONE_IA"
)

func (enum TransitionStorageClass) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum TransitionStorageClass) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type Type string

// Enum values for Type
const (
	TypeCanonicalUser         Type = "CanonicalUser"
	TypeAmazonCustomerByEmail Type = "AmazonCustomerByEmail"
	TypeGroup                 Type = "Group"
)

func (enum Type) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Type) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}
