/*
 * bystand uses at least the following nonstandard functions:
 * - strchrnul()  [GNU extension, in GNU libc >=2.1.1]
 */
#include <string.h>
#include "gnu_compat.h"


/*
 * From the GNU libc manual page:
 * The strchrnul() function is like strchr() except that if c is not found in s,
 * then it returns a pointer to the null byte at the end of s, rather than NULL.
 */
char *strchrnul(const char *s, int c)
{
   char *r;

   r = strchr(s, c);
   if (NULL == r)
   {
      r = (char*) &s[strlen(s)];
   }

   return r;
}
