#ifndef OUTBUF_H
#define OUTBUF_H

#include "num.h"

extern num outbuf_unixwrite(num,const char *,num);

typedef struct outbuf {
  char *x;
  num p;
  num n;
  num fd;
  num (*op)(num,const char *,num);
} outbuf;

#define OUTBUF_INIT(op,fd,buf,len) { (buf), 0, (len), (fd), (op) }
#define OUTBUF_SIZE 8192

extern void outbuf_init(outbuf *,num (*)(num,const char *,num),num,char *,num);

extern num outbuf_flush(outbuf *);
extern num outbuf_put(outbuf *,const char *,num);
extern num outbuf_putalign(outbuf *,const char *,num);
extern num outbuf_putflush(outbuf *,const char *,num);
extern num outbuf_puts(outbuf *,const char *);
extern num outbuf_putsalign(outbuf *,const char *);
extern num outbuf_putsflush(outbuf *,const char *);

#define outbuf_PUTC(s,c) \
  ( ((s)->n != (s)->p) \
    ? ( (s)->x[(s)->p++] = (c), 0 ) \
    : outbuf_put((s),&(c),1) \
  )

extern num outbuf_copy(outbuf *,outbuf *);

extern outbuf *outbuf_1;
extern outbuf *outbuf_1small;
extern outbuf *outbuf_2;

#endif
