---
title: Release 1.3.0 - Config File, History System, and Material Difference
authors:
  - thomas-mauran
tags:
  - release
date: 2024-11-15
---

# Release 1.3.0

**Released:** November 15, 2024

This release brings configuration file support, improved history system, and material difference tracking.

<!-- truncate -->

## What's New

### Configuration File
Chess TUI now supports a TOML configuration file located at `.config/chess-tui/`, allowing you to customize settings persistently.

### Better History System
Improved game history navigation and display for a better user experience.

### Material Difference
Track the material difference between players during the game.

### Code Quality Improvements
- Fixed various issues found with `cargo clippy -- --warn clippy::pedantic`
- Improved coordinate storage
- Keymap fixes
- Dependency updates

### Performance Optimizations
- Enabled Link-Time Optimization (LTO) and other size-related optimizations for smaller binaries

### CI/CD
- Added clippy and fmt checks to CI pipeline

### Documentation
- Updated Arch Linux installation instructions

## Contributors

Thank you to all contributors:
- @orhun (first contribution!)
- @nicholasmello (first contribution!)
- @damien-mathieu1 (first contribution!)
- @zamazan4ik (first contribution!)
- @infernosalex (first contribution!)
- @thomas-mauran
- @JeromeSchmied

## Full Changelog

For the complete list of changes, see the [full changelog](https://github.com/thomas-mauran/chess-tui/compare/1.2.1...1.3.0).

---

[View on GitHub](https://github.com/thomas-mauran/chess-tui/releases/tag/1.3.0)
