/*
 * CHEST, chess analyst.  For Copyright notice read file "COPYRIGHT".
 *
 * $Source: /home/heiner/ca/chest/RCS/dump.c,v $
 * $Id: dump.c,v 3.8 1999/07/20 21:01:24 heiner Exp $
 *
 *	dump various data structures to standard output
 */

#include "types.h"
#include "board.h"
#include <stdio.h>
#include "dump.h"


    Eximpl void
dump_pset( PieceSet pset )
{
    printf("%8lx", (long)pset);
}


    Eximpl void
dump_Pset( PieceSet pset )
{
    short	i;
    Flag	first;

    printf("{" /*}*/);
    first = TRUE;
    for( i=0 ; i < 2*MAX_PIECE ; ++i ) {
	if( pset & SET1(i) ) {
	    if( ! first ) {
		printf(",");
	    }
	    printf("%d", i);
	    first = FALSE;
	}
    }
    printf(/*{*/ "}");
}


/*
 *	Here we use low level access macros for attack info,
 *	since we use this function on sync'ed boards, only.
 */
    static void
dump_pos( const Board* bp, Position pos, Bool complete )
{
    const Field*	fp;

    fp = &(bp->b_f[pos]);
    printf(" %d/%-2d/%2d", fp->f_c, fp->f_f, fp->f_idx);
    if( complete ) {
	printf("/%d", fp->f_pos64);
	dump_pset(F_DATTioXX(bp,fp,XATT_TP_extern));
	dump_pset(F_IATTioXX(bp,fp,XATT_TP_extern));
    }
}

 
    static void
dump_plist( int count, const Position* plist )
{
    printf(" %d(" /*)*/, count);
    for( ; count > 0 ; ++plist, --count ) {
	if( *plist == NO_POS ) {
	    printf("  NIL");
	}else {
	    printf(" %#02x", (int)*plist);
	}
    }
    printf(/*(*/ ")\n");
}


    Eximpl void
dump_fieldset( register const FieldSet* fsp )
{
    register int	 i;

    for( i=0 ; i<8 ; ++i ) {
	printf(" %02x", (unsigned) fsp->fs_line[i]);
    }
}


    Eximpl void
dump_packedboard( register const PackedBoard* pbp )
{
    register int	i;

    for( i=0 ; i<8 ; ++i ) {
	printf(" %08lx", (long) pbp->pb_long[i]);
    }
}


    Eximpl void
dump_board( register const Board* bp_x )
{
    register int		lin;
    register int		col;
    register Xconst Field*	fp;
    register int		i;
    Board			b_sync;
    register Board*		bp;

    bp = &b_sync;
    COPY_BOARD(bp_x, bp);
    XATT_sync(bp);

    printf("tomove=%d ep=%d castle=(%d;%d)\n",
	    (int) bp->b_tomove,
	    (int) bp->b_ep,
	    (int) bp->b_castle[white],
	    (int) bp->b_castle[black] );
    printf("w [%2d]", (int) bp->b_cur_piece[white]);
    dump_plist(bp->b_max_piece[white], &(bp->b_piece[COLOUR_IDX(white)]));
    printf("b [%2d]", (int) bp->b_cur_piece[black]);
    dump_plist(bp->b_max_piece[black], &(bp->b_piece[COLOUR_IDX(black)]));
    printf("\tfig"); dump_fieldset(&(bp->b_fig)); printf("\n");
    printf("\twB "); dump_fieldset(&(bp->b_bau[white]));
    printf("\tbB "); dump_fieldset(&(bp->b_bau[black]));
    printf("\n");
    printf("pacb "); dump_packedboard(&(bp->b_packed)); printf("\n");
#if WITH_ZHASH
    printf("zhash %08lx\n", (long)bp->b_zhash);
#endif
    printf("wBSLTDK:");
    for( i=0 ; i<MAX_FIGURES ; ++i ) {
	printf(" %2d", (int) bp->b_fig_cnt[white][i]);
    }
    printf("\tbBSLTDK:");
    for( i=0 ; i<MAX_FIGURES ; ++i ) {
	printf(" %2d", (int) bp->b_fig_cnt[black][i]);
    }
    printf("\n");
    for( lin=7 ; lin >= 0 ; --lin ) {
	printf(" %d: ", lin);
	for( col=0 ; col < 8 ; ++col ) {
	    dump_pos(bp, MK_POS(col,lin), FALSE);
	}
	printf("\n    ");
	for( col=0 ; col < 8 ; ++col ) {
	    fp = &(bp->b_f[MK_POS(col,lin)]);
	    dump_pset(F_DATTioXX(bp,fp,XATT_TP_extern));
	}
	printf("\n    ");
	for( col=0 ; col < 8 ; ++col ) {
	    fp = &(bp->b_f[MK_POS(col,lin)]);
	    dump_pset(F_IATTioXX(bp,fp,XATT_TP_extern));
	}
	printf("\n");
    }
}
