/*
 * CHEST, chess analyst.  For Copyright notice read file "COPYRIGHT".
 *
 * $Source: /home/heiner/ca/chest/RCS/mate2.h,v $
 * $Id: mate2.h,v 1.12 1999/07/20 21:03:45 heiner Exp $
 *
 *	eliminate candidates for mate in 2
 *
 */

#ifndef CHEST_mate2_h_INCLUDED
#define CHEST_mate2_h_INCLUDED

#include "types.h"
#include "board.h"

typedef struct M2State		M2State;	/* hidden */
typedef struct M2Info		M2Info;		/* exposed */

struct M2Info
{
    PieceSet	m2_apscands;	/* att-PS: candidates for 2-mate */
    PieceSet	m2_apsdunno;	/* att-PS: unexcludable candidates */
};

Extern void	m2_stats (Bool print);

Extern void	m2_enter (Xconst Board*, const Movelist*, M2Info*);

Extern Bool	m2_cand  (Xconst Board*, const Move*, M2Info*);
					/* whether still a candidate */
Extern void	m2_leave (void);


#endif	/* ndef CHEST_mate2_h_INCLUDED */
