/*
 * CHEST, chess analyst.  For Copyright notice read file "COPYRIGHT".
 *
 * $Source: /home/heiner/ca/chest/RCS/refu.c,v $
 * $Id: refu.c,v 1.14 1999/12/04 23:07:17 heiner Exp $
 *
 *	Refutation table management
 */

#include "types.h"
#include "timing.h"		/* TimeSecs */
#include "output.h"
#include <stdio.h>		/* printf */
#include "move.h"		/* move_execute */
#include "refu.h"

#define MOV_IS_EQ(m1,m2)			\
	(   ((m1).m_from == (m2).m_from)	\
	 && ((m1).m_to   == (m2).m_to  )	\
	 && ((m1).m_fig  == (m2).m_fig ) )


    Eximpl void
refu_clear( RefuList* rlp )
{
    if( rlp ) {
	rlp->rfull = 0;
	rlp->nfull = 0;
    }
}


    static char*		/* --> static data */
refu_reason( int reason )
{
    switch( reason ) {
     case REFUT_MOVE:		return "";
     case REFUT_NONE:		return "SOLUTION";
     case REFUT_ANAKED:		return "attacker naked";
     case REFUT_DNAKED:		return "defender naked";
     case REFUT_NOMOVE:		return "no legal move";
     case REFUT_NOTCHECK:	return "not a check move";
     case REFUT_DITO:		return "prom beaten";
     case REFUT_FACKM:		return "FAC (K)";
     case REFUT_FACT:		return "FAC (again)";
     case REFUT_FAC:		return "FAC";
     case REFUT_M2PIECE:	return "M2: piece";
     case REFUT_M2MOVE:		return "M2: move";
     case REFUT_SMFACT:		return "FAC (again)";
     case REFUT_SM1:		return "SM-1 test";
     case REFUT_CHECK:		return "is a check move";
    }
    {
	    static char	buf[50];
	sprintf(buf, "?(%d)", reason);
	return buf;
    }
}

/*---------------------------------------------------------------------------*/

    static void
refu__setrefu( RefuMove* rmp, const Move* dp )
{
    if( dp ) {
	rmp->refu        = *dp;
    }else {
	rmp->refu.m_from = NO_POS;
	rmp->refu.m_to   = NO_POS;
	rmp->refu.m_fig  = no_figure;
    }
}

    static RefuMove*
refu__tabfind(
    RefuMove*			tab,	/* to be searched */
    int				siz,	/* total # elems */
    int*			fullp,	/* currently filled elems */
    register const Move*	keyp,	/* "key" must match */
    register const Move*	dp)	/* 0 | "refu" must match */
{
    register int	i;
    register int	full;
    register RefuMove*	rmp;

    full = *fullp;
    for( rmp=tab, i=0 ; i<full ; ++rmp, ++i ) {
	if(         MOV_IS_EQ(rmp->key , *keyp)
	 && (!dp || MOV_IS_EQ(rmp->refu, *dp  )) ) {
	    return rmp;				/* found */
	}
    }
    if( full < siz ) {
	rmp->key     = *keyp;
	refu__setrefu(rmp, dp);
	rmp->anares  = 0;
	rmp->refutyp = 0;
	rmp->isinv   = FALSE;
	*fullp = ++full;
	return rmp;
    }
    return (RefuMove*)0;
}


    static RefuMove*
refu__rfind( RefuList* rlp, register const Move* ap )
{
    return refu__tabfind(rlp->rtab, MAX_MOVES, &(rlp->rfull), ap, (Move*)0);
}


    static RefuMove*
refu__nfind( RefuList* rlp, register const Move* ap, const Move* dp )
{
    return refu__tabfind(rlp->ntab, MAX_NONREFU, &(rlp->nfull), ap, dp);
}


    static void
refu__note(
    RefuList*	rlp,		/* search rtab[] */
    const Move*	ap,		/* for this key */
    const Move*	dp,		/* fill, if "key" found (not key) */
    int		reason,
    int		subres,
    Bool	isinv )
{
    RefuMove*	rmp;

    if( rlp && ap ) {
	rmp = refu__rfind(rlp, ap);
	if( rmp ) {
	    refu__setrefu(rmp, dp);
	    rmp->anares  = subres;
	    rmp->refutyp = (int8) reason;
	    rmp->isinv   = (Flag) isinv;
	}
    }
}


    Eximpl void
refu__fail(
    RefuList*	rlp,		/* search ntab[] */
    const Move*	ap,		/* for this "key" */
    const Move*	dp,		/* 0 | must also match */
    int		subres,
    Bool	isinv )
{
    RefuMove*	rmp;

    if( rlp && ap ) {
	rmp = refu__nfind(rlp, ap, dp);
	if( rmp ) {
	    rmp->anares  = subres;
	    rmp->refutyp = REFUT_NONE;
	    rmp->isinv   = (Flag) isinv;
	}
    }
}

#if 0
    static void
refu__deltab( RefuMove* tab, int* fullp, const Move* keyp )
{
    register int	i;
    register int	full;
    register RefuMove*	rmp;

    full = *fullp;
    for( rmp=tab, i=0 ; i<full ; ++rmp, ++i ) {
	if( MOV_IS_EQ(rmp->key, *keyp) ) {	/* found */
	    for( ; ++i<full ; ++rmp ) {
		rmp[0] = rmp[1];		/* copy down */
	    }
	    *fullp = --full;
	    return;
	}
    }
}

    static void
refu__ntab_del( RefuList* rlp, const Move* keyp )
{
    refu__deltab( rlp->ntab, &(rlp->nfull), keyp);
}
#endif
/*---------------------------------------------------------------------------*/

    Eximpl void
refu_move( RefuList* rlp, const Move* ap, const Move* dp, int subres )
{
    refu__note(rlp, ap, dp, REFUT_MOVE, subres, FALSE);
}


    Eximpl void
refu_note( RefuList* rlp, const Move* ap, int reason, int dep )
{
    refu__note(rlp, ap, (Move*)0, reason, ANARES(dep-1,FALSE), FALSE);
}


    Eximpl void
refu_fail( RefuList* rlp, const Move* ap, const Move* dp, int subres )
{
    refu__fail(rlp, ap, dp, subres, FALSE);
}

/*...........................................................................*/

    Eximpl void
refu_lost( RefuList* rlp, const Move* ap, const Move* dp, int subres )
{
    refu__note(rlp, ap, dp, REFUT_MOVE, subres, TRUE);
#if 0
    refu__ntab_del(rlp, ap);
#endif
}

    Eximpl void
refu_safe( RefuList* rlp, const Move* ap, int subres )
{
    refu__fail(rlp, ap, (Move*)0, subres, TRUE);
}

/*---------------------------------------------------------------------------*/

    static void
put_anares( int anares )
{
    printf(" [%3d%c]", ANADEP(anares), "-+"[!!ANASUC(anares)]);
}


#define REFU_NUM_LEN	3	/* should be >= 3 */
#define REFU_MOV_LEN	7	/* should be >= 7 */

#define IS_RTAB		TRUE	/* for "isrtab" */
#define IS_NTAB		FALSE	/* for "isrtab" */

#define NO_KEY		TRUE	/* for "nokey" */
#define SHOW_KEY	FALSE	/* for "nokey" */

    static const char*
refu_tabname( Bool isrtab, Bool isinv )
{
    return isinv ? (isrtab ? "lost" : "safe")
		 : (isrtab ? "refu" : "solu");
}

    static void
put_1_refu( Board* bp, RefuMove* rmp, int i, Bool isrtab, Bool nokey )
{
    printf("%s", refu_tabname(isrtab, rmp->isinv));
    if( nokey ) {
	printf(" %*d:", REFU_NUM_LEN+REFU_MOV_LEN, i+1);
    }else {
	printf("%*d:", REFU_NUM_LEN, i+1);
	printf(" %-*s", REFU_MOV_LEN, mvc_L7(bp, &(rmp->key)));
    }
    if( ! no_pos(rmp->refu.m_from) ) {		/* have move */
	move_execute(bp, &(rmp->key));
	printf(" %-*s", REFU_MOV_LEN, mvc_L7(bp, &(rmp->refu)));
	move_undo(bp);
	put_anares(rmp->anares);
    }else {					/* without a move */
	printf(" %-*s", REFU_MOV_LEN, "--");
	put_anares(rmp->anares);
	printf("   %s", refu_reason(rmp->refutyp));
    }
    printf("\n");
}


    static void
put_ntab_forkey( Board* bp, RefuList* rlp, Move* keyp )
{
    RefuMove*	rmp;
    int		j;
    int		nfull;

    nfull = rlp->nfull;
    for( rmp=rlp->ntab, j=0 ; j<nfull ; ++rmp, ++j ) {
	if( ! (rmp->refu.m_attr & MA_SKIP)		/* not yet done */
	 && MOV_IS_EQ(*keyp, rmp->key) ) {
	    put_1_refu(bp, rmp, j, IS_NTAB, NO_KEY);
	    rmp->refu.m_attr |= MA_SKIP;		/* mark "done" */
	}
    }
}


    Eximpl void
put_refulist( Board* bp, RefuList* rlp )
{
    if( bp && rlp && (rlp->rfull || rlp->nfull) ) {
	/* Note, that we want to mix the non-refu's into the refu list,
	 * since that really increases readability.
	 */
	    RefuMove*	rmp;
	    int		i;
	    int		rfull;
	    int		nfull;
	    int		fsave;
	fsave     = f_mvtrace;
	f_mvtrace = 0;		/* no more tracing; output would mix up */
	rfull = rlp->rfull;
	nfull = rlp->nfull;
	for( rmp=rlp->ntab, i=0 ; i<nfull ; ++rmp, ++i ) {
	    rmp->refu.m_attr &= ~MA_SKIP;
	}
	for( rmp=rlp->rtab, i=0 ; i<rfull ; ++rmp, ++i ) {
	    put_1_refu(bp, rmp, i, IS_RTAB, SHOW_KEY);
	    put_ntab_forkey(bp, rlp, &(rmp->key));
	}
	for( rmp=rlp->ntab, i=0 ; i<nfull ; ++rmp, ++i ) {
	    if( rmp->refu.m_attr & MA_SKIP ) continue;
	    put_1_refu(bp, rmp, i, IS_NTAB, SHOW_KEY);
	    rmp->refu.m_attr |= MA_SKIP;		/* mark "done" */
	    put_ntab_forkey(bp, rlp, &(rmp->key));
	}
#if 1
	if( rfull && nfull ) {
	    i = rlp->rtab[0].isinv;
	    printf("Refu tab: %3d %s, %3d %s\n",
		    rfull, refu_tabname(IS_RTAB, i),
		    nfull, refu_tabname(IS_NTAB, i));
	}
#endif
	f_mvtrace = fsave;
    }
}
