/*
 * CHEST, chess analyst.  For Copyright notice read file "COPYRIGHT".
 *
 * $Source: /home/heiner/ca/chest/RCS/xatt.h,v $
 * $Id: xatt.h,v 4.9 1999/07/20 20:02:46 heiner Exp $
 *
 *	Extended attack bits.
 */

#ifndef CHEST_xatt_h_INCLUDED
#define CHEST_xatt_h_INCLUDED 1

#ifndef USE_XATT
# define USE_XATT		0
#endif
#if ! USE_XATT
# ifdef XATT_LAZY
#  undef XATT_LAZY
# endif
# ifdef XATT_TST_OVRHD
#  undef XATT_TST_OVRHD
# endif
# ifdef XATT_TST_LAZY
#  undef XATT_TST_LAZY
# endif
# define XATT_LAZY		0
# define XATT_TST_OVRHD		0
# define XATT_TST_LAZY		0
#endif

/*
 * Prevent re-compilation of modules
 * not using extended attack bits.
 */
#if USE_XATT
# include "xatt_cf.h"
#endif /*USE_XATT*/

#if XATT_LAZY && ( ! XATT_TST_OVRHD )
# define Xconst		/*empty*/
#else
# define Xconst		const
#endif

#if USE_XATT
# include "board.h"
#else
# define XATT_stats(doPrint)		{ /*empty*/ }
# define XATT_sync(bp)			{ /*empty*/ }
# define XATT_empty(bp)			{ /*empty*/ }
# define XATT_check(bp)			0	/* always correct */
#endif

#if ! ( USE_XATT && XATT_LAZY )
  /* see "xatt_global.h" */
# define XATT_F_cnt(bp, fp, depth, type, ioop, tok)	/*EMPTY*/
# define XATT_F_acc(bp, fp, depth, type, ioop, tok)	/*EMPTY*/
#endif

/**/
#endif /*ndef CHEST_xatt_h_INCLUDED*/
