/*
 *  Not included by default for any architecture:
 *      #define USE_LONG_LONG
 */
#define USE_CHECK

#ifdef __GO32
#   define OPSYS "go32"
#   define USE_ALLOCA
#   define USE_PC_H
#   define IN_OUT_INSTRUCTIONS
#   define USE_MEMTEST
#   define USE_TESTS
#   define my_ioperm(x,y,z) 0
#   define READ "rb"
#endif

#ifdef linux
#   define OPSYS "linux"
#   define USE_UNISTD
#   define USE_CBREAK
#   define USE_KMEM
#ifndef NO_SHM_COMM
#   define USE_SHM_COMM
#endif

#   define USE_MMAP
#   define USE_SIGNALS
#   define SYSV_SIGNALS
#   define USE_WAIT
#   define UNIX
#   define USE_ALLOCA
#   define USE_READLINE
#   define USE_MEMTEST
#   define USE_TESTS
#   define USE_SIGNAL_H
#   define IN_OUT_INSTRUCTIONS
#   define my_ioperm(x,y,z) ioperm(x,y,z)

#define SIGNAL_FUNCTION_CAST (SignalHandler)
#endif

#ifdef sun
#   define OPSYS "sun"
#   define USE_MMAP
#   define USE_UNISTD
#   define USE_CBREAK
#   define UNIX
#   define USE_ALLOCA
#   define USE_READLINE
#   define USE_MEMTEST
#   define USE_TESTS
#   define INCLUDE_SBUS
#   define INCLUDE_RMOVE
#   define INCLUDE_P555
#   define INCLUDE_2051
#   define INCLUDE_MOVE_TEST
#   define USE_SIGNALS
#   define my_ioperm(x,y,z) 0
#   define STRERROR_MISSING
#   define STRERROR_DEF_MISSING
#if 1
#   define usleep my_usleep
#   define USE_BOGUS_USLEEP
#   define PROCESSOR_SPEED  9  /* 8.25 */
#endif
#endif

#ifdef hpux
#   define OPSYS "hpux"
#   define USE_UNISTD
#   define USE_CBREAK
#   define UNIX
#   define USE_ALLOCA
#   define USE_READLINE
#   define USE_MEMTEST
#   define USE_TESTS
#   define SYSV_SIGNALS
#   define USE_SIGNALS
#   define my_ioperm(x,y,z) 0
#   define USE_BOGUS_USLEEP
#   define PROCESSOR_SPEED 25
#   define STRERROR_DEF_MISSING
#endif

#ifdef sgi
#   define OPSYS "sgi"
#   define USE_UNISTD
#   define USE_CBREAK
#   define UNIX
#   define USE_ALLOCA
#   define USE_READLINE
#   define USE_MEMTEST
#   define USE_TESTS
#   define SYSV_SIGNALS
#   define USE_SIGNALS
#   define my_ioperm(x,y,z) 0
#   define USE_BOGUS_USLEEP
#   define PROCESSOR_SPEED 33
#   define STRERROR_DEF_MISSING
#endif

#ifdef TCC
#   define getkey getche
#   define READ "rb"
#   define MAXDEPTH 5
#   define USE_MEMTEST
#   define USE_TESTS
#endif

/*
 * Here starts the section that provides defaults for most systems, that
 * can be overridden for a specific OS/compiler.
 */


#ifndef READ
#   define READ "r"
#endif	

#ifndef MAXDEPTH
#   define MAXDEPTH 100
#endif

#ifndef SIGNAL_FUNCTION_CAST
#define SIGNAL_FUNCTION_CAST /* */
#endif

#ifndef OPSYS
#   define OPSYS "unconfigured"
#endif

#ifdef STRERROR_DEF_MISSING
extern char *strerror (int errnum);
#endif


#ifdef DONT_USE_READLINE
#undef USE_READLINE
#endif

#ifdef DONT_USE_ALLOCA
#undef USE_ALLOCA
#endif

