/*
   NAME memtest.c CREATED 1 Mar, 1994

   perform tests as described in MAIN.TEX MT_ALGO.TEX   
   */
#include <stdio.h>
#include <stdlib.h>
#include "config.h"

#ifdef STANDALONE
#define USE_MEMTEST
#endif STANDALONE

#ifdef USE_MEMTEST

#ifdef USE_UNISTD
#include <unistd.h>
#endif USE_UNISTD

#ifndef STANDALONE
#include "chipmunk.h"
#include "tests.h"
#endif STANDALONE

/* next definitions specify which order instances to include */
/* if INCLUDE_RND is defined, ...RND1 or ...RND2 must be defined as well */
#define INCLUDE_RND
#define INCLUDE_RND2
#define INCLUDE_CNT
/* now long long is supported !!, include this definition */
/* #define USE_LONG_LONG */

                                              /* march algorithm definitions */
/* SMATA: By REW. Symmetric, assumes mem initialized to all zeros */
#define SMATA        R0W1_UP; R1W0_UP

/* mats+ */
#define MATSPLUS     W0_UP; R0W1_UP; R1W0_DOWN

/* mats++ */
#define MATSPLUSPLUS W0_UP; R0W1_UP; R1W0_DOWN; R0_DOWN

/* march C- */
#define MARCHCMINUS  W0_UP; R0W1_UP; R1W0_UP; R0W1_DOWN; \
                     R1W0_DOWN; R0_DOWN

/* march C- with delay elements */
#define MARCHCMINDEL W0_UP; R0W1_UP; R1W0_UP; R0W1_DOWN; \
                     DELAY; R1W0_DOWN; DELAY; R0_DOWN

/* march B */
#define MARCHB       W0_UP; R0W1R1W0R0W1_UP; R1W0W1_UP; \
                     R1W0W1W0_DOWN; R0W1W0_DOWN

/* march G */
#define MARCHG       W0_UP; R0W1R1W0R0W1_UP; R1W0W1_UP; \
                     R1W0W1W0_DOWN; R0W1W0_DOWN; DELAY; \
                     R0W1R1_UP; DELAY; R1W0R0_UP

/* march G symmetrical version */
#define MARCHGSYM    W0_UP; R0W1R1W0W1_UP; R1W0W1_UP; \
                     R1W0W1W0_DOWN; R0W1R1W0_DOWN; DELAY; \
                     R0W1R1_UP;DELAY; R1W0R0_UP

/* extension to detect DRF's */
#define MARCHDEL     DELAY; R0W1_UP; DELAY; R1_UP

/* extension to detect DRF's wich behave like SOF's */
#define MARCHDELSOF  DELAY; R0W1R1_UP; DELAY; R1W0R0_UP



                                                /* march element definitions */
/*one operation*/
#define W0_UP        LOOP_UP   (W0;)
#define W0_DOWN      LOOP_DOWN (W0;)

#define W1_UP        LOOP_UP   (W1;)
#define W1_DOWN      LOOP_DOWN (W1;)

#define R0_UP        LOOP_UP   (R0;)
#define R0_DOWN      LOOP_DOWN (R0;)

#define R1_UP        LOOP_UP   (R1;)
#define R1_DOWN      LOOP_DOWN (R1;)

/*two operations*/
#define R0W1_UP      LOOP_UP   (R0; W1; )
#define R0W1_DOWN    LOOP_DOWN (R0; W1; )

#define R1W0_UP      LOOP_UP   (R1; W0; )
#define R1W0_DOWN    LOOP_DOWN (R1; W0; )

/*three operations*/
#define R0W1R1_UP    LOOP_UP   (R0; W1; R1; )
#define R1W0R0_UP    LOOP_UP   (R1; W0; R0; )

#define R1W0W1_UP    LOOP_UP   (R1; W0; W1; )
#define R0W1W0_DOWN  LOOP_DOWN (R0; W1; W0; )

/*four or more operations*/
#define R1W0W1W0_DOWN   LOOP_DOWN (R1; W0; W1; W0; )
#define R0W1R1W0_DOWN   LOOP_DOWN (R0; W1; R1; W0; )

#define R0W1R1W0W1_UP   LOOP_UP   (R0; W1; R1; W0; W1; )
#define R0W1R1W0R0W1_UP LOOP_UP   (R0; W1; R1; W0; R0; W1; )


                                                    /* operation definitions */
#define LOOP_UP(s)   SEQ_UP(s)
#define LOOP_DOWN(s) SEQ_DOWN(s)
#define W0        AT(p) = zero
#define W1        AT(p) = one
/* use following to eventually include debugging stuff (slow) */
/* #define W0        WT(p,zero) */
/* #define W1        WT(p,one ) */
#define R0        RX(zero)
#define R1        RX(one )
#define RX(v)     if (dm & ( (t = AT(p)) ^ v ) ) \
                    if (handle_error (p, t, AT(p), v)) goto end_of_test;
#ifdef USE_USLEEP
#  define DELAY   usleep (t_delay)
#else
#  define DELAY	  sleep ((t_delay + 999999) / 1000000)
#endif USE_USLEEP

#if 0
  /* loop definitions, common description: */
  i = 0;            /* keeps track of number of visited locations */
  mec++;            /* update march element counter */
  p = a_ref;        /* initial pointer to target */
  while (i < n) {   /* for the number of locations */
    statements;     /* perform march operations (at pointer location) */
    i++;            /* next location */
    p += stride;    /* update pointer */
  }
#endif

/* sequential order */
#define SEQ_UP(s)   for (i = 0, mec++, p = a_ref;\
                      i < n_loc; i++, p+= stride){s}
#define SEQ_DOWN(s) for (i = n_loc, mec++, p = a_ref + stride * (n_loc - 1);\
                      i > 0; i--,     p-= stride){s}
/* random order using randomly shuffled list (eats mem) */
#define RND1UP(s)   for (i = 0, mec++, p = a_ref + stride * list[i];\
                      i < n_loc; i++, p = a_ref + stride * list[i]){s}
#define RND1DOWN(s) for (i = n_loc, mec++, p = a_ref + stride * list[i - 1];\
                      i > 0; i--,     p = a_ref + stride * list[i - 1]){s}
/* counting-order */
#define CNT_UP(s)   for (i = 0, mec++, p = a_ref, cnt = 0; i < n_loc; i++,\
                      cnt = ((cnt | ~cmask)+ 1) & cmask, p = a_ref ^ cnt){s}
#define CNT_DOWN(s) for (i = 0, mec++, p = a_ref ^ cmask, cnt=cmask; i< n_loc;\
                      i++, cnt = (cnt - 1) & cmask, p = a_ref ^ cnt){s}
/* random-order using pseudo random pattern generator (LFSR) */
#define RND2UP(s)   for (i = 0, mec++, p = a_ref, pr  = 0;\
                      i < n_loc ; i++, p = a_ref + pr * stride){s;\
                      do { pt = (pr << 1); pr = pt & mask; \
                        pr |= ((pr==0) + count_ones(pt & ppoly[order])) % 2;\
                      } while (pr >= n_loc);}
#define RND2DOWN(s) for (i  = 0, mec++, p = a_ref, pr = 0;\
                      i < n_loc ; i++){\
                      do { pr = (pr >> 1) | (( \
                        (((pr & ~1)==0) + count_ones(pr & ppoly[order])) % 2\
                        ) << (order - 1));\
                      } while (pr >= n_loc); p = a_ref + pr * stride; s;}
#if 0
  /* non optimized pseudo random generator */
#define RND2UP(statements)
    i   = 0;     /* keeps track of number of locations */
    mec++;       /* march elemenrt cntr */
    p   = a_ref; /* pointer to target */
    pr  = 0;     /* initial random pointer (range 0..n_loc) */
    while (i < n_loc) {             /* for the number of locations */
      statements;                   /* perform march operations */
      do {
        pr = (pr << 1) |                       /* shift */
           ((((pr << 1) & mask)==0) +          /* all zeroes pattern */
            count_ones((pr<<1) & ppoly[order]))/* polynomial contribution */
            % 2);                              /* modulo 2 addition */
      } while (pr >= n_loc); /* if out of range, find next in sequence */
      i++;                          /* next location */
      p = a_ref + pr * stride;      /* compute pointer (offset, scale) */
    }

#define RND2DOWN(statements)
    i   = 0;     /* keeps track of number of locations */
    mec++;       /* march elemenrt cntr */
    p   = a_ref; /* pointer to target */
    pr  = 0;     /* initial random pointer (range 0..n_loc) */
    while (i < n_loc) {             /* for the number of locations */
      do {
        pr = (pr >> 1) |                       /* shift */
            (((((pr & ~1)==0) +                /* all zeroes pattern */
             count_ones(pr & ppoly[order]))    /* polynomial contribution */
             % 2) << (order - 1));             /* modulo 2 addition as MSB */
      } while (pr >= n_loc); /* if out of range, find next in sequence */
      p = a_ref + pr * stride;      /* compute pointer (offset, scale) */
      statements;                   /* perform march operations */
      i++;                          /* next location */
    }
#endif

                                                            /* calling macro */
#define DO_TEST(alg)   switch (alg) {               \
                         case 0: SMATA;       break;\
                         case 1: MATSPLUS;    break;\
                         case 2: MARCHCMINUS; break;\
                         case 3: MARCHB;      break;\
                         case 4: MARCHG;      break;\
                         }

char *algname[] = {"SMATA", "Mats+", "March C-", "March B", "March G", NULL};

#define NALGS ((sizeof (algname) / sizeof (char*)) -1)

#ifdef USE_LONG_LONG
# define MAXWS 64
# define UIMAX UINT64
#else
# define MAXWS 32
# define UIMAX UINT32
#endif USE_LONG_LONG

#ifdef STANDALONE
/* if used as single source */

#define memtest main
#define DWN(v,x,y) for((v)=(x);(v)>=(y);(v)--)
#define AN_X(x)    (x) ? "x" : " "
#define VERBOSE 2
#define BASE 0
#define getintvar(x) (void) (x)

typedef unsigned char  UINT8;
typedef unsigned short UINT16;
typedef unsigned int   UINT32;
#ifdef USE_LONG_LONG
typedef unsigned long long UINT64;
#endif USE_LONG_LONG

#define AT(p)       *(TESTTYPE *)(p)
#define WT(p,v)     AT(p) = v
#define RT(p)       AT(p)
#define internal_set_int(x,y) (void) (x)

int count_ones (UINT32 w) {
  w = (w & 0x55555555) + ((w >> 1) & 0x55555555);
  w = (w & 0x33333333) + ((w >> 2) & 0x33333333);
  w = (w & 0x0f0f0f0f) + ((w >> 4) & 0x0f0f0f0f);
  w = (w & 0x00ff00ff) + ((w >> 8) & 0x00ff00ff);
  w = (w & 0x0000ffff) + ((w >>16) & 0x0000ffff);
  return w;
}

UIMAX myatoi (char *str) {
  UIMAX 
    t;
  char 
    *fmt = "%x";

  if ((str[0] == '0') && (str[1] == 'x')) {           str += 2;}
  if ((str[0] == '#')                   ) {fmt = "%d";str += 1;}
  if (sscanf (str, fmt, &t) != 1)
    return (0);
  return t;
}

#ifdef USE_ALLOCA
#define MY_ALLOCA(x)    alloca ((x))
#define MY_AFREE(x)     (void) (x)
#else
#define MY_ALLOCA(x)    MY_MALLOC ((x))
#define MY_AFREE(x)     free ((x))
#endif

#define MY_MALLOC(x)    my_malloc ((x), __LINE__, __FILE__)

static inline void*  my_malloc(int nbytes, int line, char *file) {
  void *t;

  if (!(t = malloc (nbytes))) {
    fprintf (stderr, "Out of memory in file %s, at line %d.\n", file, line);
    exit (1);
  }
  return t;
}

#endif STANDALONE

                                                      /* global declarations */
int    error  = 0;      /* error counter */
UINT32 pass,            /* pass counter */
       maxe   =~0;      /* maximum errors to report */
int    mec    = 0,      /* march element counter*/
       e_v[MAXWS];      /* error count per bit */
UIMAX  dm;              /* data mask */

#define FMT64 "%6d %5d  %08x .%08x %c.%08x %c.%08x  M%d\n"
#define FMT32 "%6d %5d  %08x  %08x %c %08x %c %08x  M%d\n"
#define FMT16 "%6d %5d  %08x  %04x     %c %04x     %c %08x  M%d\n"
#define FMT8 "%6d %5d  %08x  %02x       %c %02x       %c %08x  M%d\n"
char* reportfmt = FMT32;/* report format */


                                                                /* functions */
                                                  /* count and print errrors */
int handle_error (UINT32 a, UIMAX d_r, UIMAX d_a, UIMAX d_e) {
  int   i;
  UIMAX fault;

  fault = (dm & (d_r ^ d_e));
  for (i = 0; i < MAXWS; i++)
    e_v[i] += 1 & (fault >> i);
 
  if ((error <= maxe) && (VERBOSE > 1)) {
    if (!error)
      printf ("  pass error  address   read       read       instead   march\n"
          "    nr    nr                       again      of        element\n");
    if (error == maxe)
      printf ("         ...\n");
    else
      printf (reportfmt,
              pass, error, a, d_r, (dm &(d_r ^ d_a)) ? ' ' : '=', d_a, 
              (dm &(d_a ^ d_e)) ? ' ' : '=', d_e, mec - 1);
  }
  error++;
  return (error > maxe);
}

                                /* shuffles list of targets for random order */
UINT32* shuffle (UINT32 *list, int n) {
  UINT32 tmp;
  int    i, k;
/*   srand(list[n]); */
  for (i = 0; i < n; i++) list[i] = i;
  for (i = 0;i < (n-1); i++) {
    k = rand() % (n - i - 1) + 1;
    tmp       = list[i];
    list[i]   = list[k+i];
    list[k+i] = tmp;
  }
  return list;
}

                                                 /* main or memtest function */
int memtest (int argc, char **argv)
{
  volatile UINT32 p; /* tested location pointer */
  UIMAX  t,          /* tmp value */
         one, zero;  /* data backgrounds */
  UINT32 a_ref = 0,  /* reference addres */
         n_loc = 0,  /* number of locations */
         n_pass = 1, /* number of passes */
         shift_len,  /* shift length */
         alg  = 3,   /* selected algorithm */
         ws   = MAXWS,  /* word size */
         use_db = 0, /* use data backgrounds (boolean) */
         stride = 0, /* stride in byte units */
         nopt = 0,   /* argument passing vars */
         t_delay = 100000;/* delay time in us */
  int    e    = 0,
         i, j = 0,
         iinc = 1;
  UIMAX  value;
  char   option;

#ifdef  INCLUDE_RND
  int   use_rnd  = 0;   /* random order (boolean)*/
#endif INCLUDE_RND
#ifdef  INCLUDE_RND1
  UINT32 *list = NULL; /* addresslist */
#endif INCLUDE_RND1
#ifdef  INCLUDE_RND2
  UINT32 mask = 0, pr = 0, pt = 0, order = 0,
         /* primary polynomials */
         ppoly[]= {0x0,           /* order  0 */
                   0x3,           /* order  1 */
                   0x7,           /* order  2 */
                   0xb,           /* order  3 */
                   0x13,          /* order  4 */
                   0x25,          /* order  5 */
                   0x43,          /* order  6 */
                   0x89,          /* order  7 */
                   0x187,         /* order  8 */
                   0x211,         /* order  9 */
                   0x409,         /* order 10 */
                   0x805,         /* order 11 */
                   0x1123,        /* order 12 */
                   0x3007,        /* order 13 */
                   0x600d,        /* order 14 */
                   0x8003,        /* order 15 */
                   0x10483,       /* order 16 */
                   0x20009,       /* order 17 */
                   0x40081,       /* order 18 */
                   0x80063,       /* order 19 */
                   0x100009,      /* order 20 */
                   0x200005,      /* order 21 */
                   0x400003,      /* order 22 */
                   0x800021,      /* order 23 */
                   0x100001b,     /* order 24 */
                   0x2000009,     /* order 25 */
                   0x4000183,     /* order 26 */
                   0x8000183,     /* order 27 */
                   0x10000009,    /* order 28 */
                   0x20000005,    /* order 29 */
                   0x40018003,    /* order 30 */
                   0x80000009};   /* order 31 */
#endif INCLUDE_RND2
#ifdef  INCLUDE_CNT
  UINT32 cnt, cmask = 0;
#endif INCLUDE_CNT


  dm    =~0;                                   /* defaults */
  maxe  =~0;
  error = 0;                         
  for (i = 1; i < argc; i += iinc) {   /* argument passing */
    if (argv[i][0] == '-') {
      option = argv[i][1];
      if (argv[i][2] == '\0') { 
        value = myatoi(argv[i+1]);
        iinc  = 2;
      }else{
        value = myatoi(argv[i] + 2);
        iinc  = 1;
      }
      switch (option) {
      case 'r': a_ref = (UINT32)value; j = 1; break;
      case 'n': n_loc = (UINT32)value; break;
      case 'a': alg   = (UINT32)value; break;
      case 'w': ws    = (UINT32)value; break;
#ifdef INCLUDE_RND
      case 'o': use_rnd= 1; iinc = 1; break;
#endif INCLUDE_RND
#ifdef INCLUDE_CNT
      case 'c': cmask = (UINT32)value; break;
#endif INCLUDE_CNT
      case 'b': use_db = 1; iinc = 1; break;
      case 'd': dm     = value; break;
      case 'u': t_delay = (UINT32)value; break;
      case 's': stride = (UINT32)value; break;
      case 'p': n_pass = (int)value; break;
      case 'e': maxe   = (int)value; break;
      default : iinc   = 1; e = 1;
      }
    }
    else {
      iinc = 1;
      nopt++;
      switch (nopt + j) {
      case  1 : a_ref = (UINT32)myatoi (argv[i]); break;
      case  2 : n_loc = (UINT32)myatoi (argv[i]); break;
      default : e     = 1;
      }
    }
  }

# ifdef USE_LONG_LONG
    if (!( (ws == 64) || (ws == 32) || (ws == 16) || (ws == 8) )) e = 1;
# else
    if (!( (ws == 32) || (ws == 16) || (ws == 8) )) e = 1;
# endif USE_LONG_LONG

  if (e  || (argc < 3) || (alg >= NALGS)) {
    fprintf (stderr, "usage: memtest [-r]base [-n]length [options]\n");
    fprintf (stderr, "-r<base>  base address\n");
    fprintf (stderr, "-n<length>number of locations\n");
    fprintf (stderr, "-a<n>     select algorithm used:\n");
    for (i = 0; i < NALGS; i++)
      fprintf (stderr, "         %2d. %s%s%c\n", i, algname[i],
              alg == i ? " (default)" : "", i == (NALGS - 1) ? '.' : ';');
#   ifdef USE_LONG_LONG
      fprintf ( stderr, "-w<n>     wordsize n = 8, 16, 32 or 64 (%d)\n", ws);
#   else
      fprintf ( stderr, "-w<n>     wordsize n = 8, 16, or 32 (%d)\n", ws);
#   endif USE_LONG_LONG
#   ifdef INCLUDE_RND
      fprintf (stderr, "-o        random addressorder (off)\n");
#   endif INCLUDE_RND
#   ifdef INCLUDE_CNT
      fprintf (stderr, "-c<cmask> counting addressorder (off)\n");
#   endif INCLUDE_CNT
    fprintf (stderr, "-b        bit-fault detection (off)\n");
    fprintf (stderr, "-d<n>     data mask (0x%8x)\n", dm);
    fprintf (stderr, "-u<n>     us sleep for delay (%d)\n", t_delay);
    fprintf (stderr, "-s<n>     stride n (byte unit)(wordsize)\n");
    fprintf (stderr, "-p<n>     pass n times (%d)\n", n_pass);
    fprintf (stderr, "-e<n>     stop after n errors occured (inf)"
            "(default = %d)\n", maxe);
    fprintf (stderr, "returns number of errors.\n");
    return 1;
  }
  
# ifdef INCLUDE_CNT
    if (cmask) {
      if ((cmask & ((ws / 8)- 1)) && (VERBOSE >= 2))
        printf ("WRN: ignoring cmask bits that address within word.\n");
      cmask &= ~((ws / 8)- 1);
      n_loc = 1 << count_ones(cmask);
    }
    else
# endif INCLUDE_CNT
    {
    if (!stride) stride = ws / 8;/* if not specified */
    if ((stride % (ws/8)) && (VERBOSE >= 2))
      printf ("WRN: stride not in wordsize units causing misalignment.\n");
    if ((n_loc % stride) && (VERBOSE >= 2))
      printf ("WRN: using length %x instead of %x to fit stride.\n",
               n_loc - n_loc % stride, n_loc);
    n_loc /= stride;  /* adapt n to stride */
  }
  if (((a_ref + BASE) & ((ws / 8) - 1)) && (VERBOSE >= 2))
    printf ("WRN: reference address misaligned.\n");

  if (ws != MAXWS)
    dm &= ~(~0 << ws);
  if ((!n_loc) || (!n_pass) || (!dm)) {
    if (VERBOSE > 0) printf ("Nothing to do.\n");
    return(0);
  }
 
                                                             /* print header */
# ifdef STANDALONE
    printf ("Performing %s (%d bit)%s", algname[alg], ws, use_db?"db":"");
#   ifdef INCLUDE_RND
      printf ("%s", use_rnd?"rnd":"");
#   endif INCLUDE_RND
#   ifdef INCLUDE_CNT
      if (cmask)
        printf (" using Aref 0x%08x, mask 0x%08x.\n", a_ref, cmask);
      else
#   endif INCLUDE_CNT
    printf (" from 0x%08x to 0x%08x, stride 0x%x.\n",
            a_ref, a_ref + ((n_loc - 1)* stride), stride);
# endif STANDALONE

# ifdef INCLUDE_RND1
    if (use_rnd)
      list = MY_ALLOCA (sizeof (*list) * n_loc);
# endif INCLUDE_RND1
# ifdef INCLUDE_RND2
    if (use_rnd){
      for (order = 0; (n_loc - 1) >> order; order++);
      mask = ~(~0 << order);
      if (order == 0) use_rnd = 0;
    }
# endif INCLUDE_RND2

  for (i = 0; i < MAXWS; i++)
    e_v[i] = 0;
  switch (ws) {
    case 64: reportfmt = FMT64;break;
    case 32: reportfmt = FMT32;break;
    case 16: reportfmt = FMT16;break;
    case  8: reportfmt = FMT8 ;break;
  }
  one = ~0;             /* generate databackgrounds */
  shift_len  = ws;
  while ( shift_len > 0 ) {
    if (use_db) {       /* use data background */
      shift_len /= 2;
      one = one << shift_len ^ one;
    }
    else                /* else shortcut db generation */
      shift_len = 0;
    zero = ~one;
    for (pass = 1; pass <= n_pass; pass++) {
      mec = 0;
#     define TESTTYPE UIMAX
#     ifdef INCLUDE_CNT
#       undef  LOOP_UP
#       undef  LOOP_DOWN
#       define LOOP_UP(s)   CNT_UP(s)
#       define LOOP_DOWN(s) CNT_DOWN(s)
        if (cmask) {
          switch (ws) {       /* counting order */
#         ifdef USE_LONG_LONG
            case 64: DO_TEST (alg); break;
#             undef  TESTTYPE
#             define TESTTYPE UINT32
#         endif USE_LONG_LONG
          case 32: DO_TEST (alg); break;
#           undef  TESTTYPE
#           define TESTTYPE UINT16
          case 16: DO_TEST (alg); break;
#           undef  TESTTYPE
#           define TESTTYPE UINT8
          case 8:  DO_TEST (alg); break;
#           undef  TESTTYPE
#           define TESTTYPE UIMAX
          }
#       undef  LOOP_UP
#       undef  LOOP_DOWN
#       define LOOP_UP(s)   SEQ_UP(s)
#       define LOOP_DOWN(s) SEQ_DOWN(s)
        }else
#     endif INCLUDE_CNT
#     ifndef  INCLUDE_RND
        switch (ws) {       /* sequential order */
#       ifdef USE_LONG_LONG
          case 64: DO_TEST (alg); break;
#           undef  TESTTYPE
#           define TESTTYPE UINT32
#       endif USE_LONG_LONG
        case 32: DO_TEST (alg); break;
#         undef  TESTTYPE
#         define TESTTYPE UINT16
        case 16: DO_TEST (alg); break;
#         undef  TESTTYPE
#         define TESTTYPE UINT8
        case 8:  DO_TEST (alg); break;
#         undef  TESTTYPE
#         define TESTTYPE UIMAX
        }
#     else 
        if (!use_rnd) {
          switch (ws) {       /* sequential order */
#         ifdef USE_LONG_LONG
            case 64: DO_TEST (alg); break;
#             undef  TESTTYPE
#             define TESTTYPE UINT32
#         endif USE_LONG_LONG
          case 32: DO_TEST (alg); break;
#           undef  TESTTYPE
#           define TESTTYPE UINT16
          case 16: DO_TEST (alg); break;
#           undef  TESTTYPE
#           define TESTTYPE UINT8
          case 8:  DO_TEST (alg); break;
#           undef  TESTTYPE
#           define TESTTYPE UIMAX
          }
        }
        else{
#         undef LOOP_UP
#         undef LOOP_DOWN
#         ifdef INCLUDE_RND2
#           define LOOP_UP(s)    RND2UP(s)
#           define LOOP_DOWN(s)  RND2DOWN(s)
#         endif INCLUDE_RND2
#         ifdef INCLUDE_RND1
#           define LOOP_UP(s)    RND1UP(s)
#           define LOOP_DOWN(s)  RND1DOWN(s)
            list = shuffle (list, n_loc);/* random order */
#         endif INCLUDE_RND1
          switch (ws) {        /* sequential order */
#         ifdef USE_LONG_LONG
            case 64: DO_TEST (alg); break;
#             undef  TESTTYPE
#             define TESTTYPE UINT32
#         endif USE_LONG_LONG
          case 32: DO_TEST (alg); break;
#           undef  TESTTYPE
#           define TESTTYPE UINT16
          case 16: DO_TEST (alg); break;
#           undef  TESTTYPE
#           define TESTTYPE UINT8
          case 8:  DO_TEST (alg); break;
#           undef  TESTTYPE
#           define TESTTYPE UIMAX
          }
        }
#     endif INCLUDE_RND
    }
  }
end_of_test:
# ifdef INCLUDE_RND1
    if (use_rnd)
      MY_AFREE (list);
# endif INCLUDE_RND1
  
 t = 0;
 DWN(i, 31, 0) if (e_v[i]) t |= 1 << i;
 internal_set_int("DLMF", t & dm);

 if (VERBOSE > 0) {                                         /* report */
    if (error) {
      if (error == (maxe + 1)) 
        printf ("ERR: found more than %d error%s.\n", maxe, error==1?"":"s");
      else
        printf ("ERR: found %d error%s.\n", error, error == 1 ? "" : "s");
    }
    else 
      printf ("OK : no memory faults.\n");
    if (!getintvar ("notable") && error) {
      printf(  "bitnr ");
      DWN(i, 31, 0) if (dm & (1 << i))
        printf (" %d", i / 10);
      else
        printf (" .");
      printf ("\n      ");
      DWN(i, 31, 0) if (dm & (1 << i))
        printf (" %d", i % 10);
      else
        printf ("  ");
      printf ("\n0..9A ");
      DWN(i, 31, 0) {
        if (e_v[i]) {
          e_v[i] = (10 * e_v[i]) / error;
          if (e_v[i] == 10)
            printf (" A");
          else
            if (e_v[i] == 0) e_v[i] = 1;
            printf (" %d", e_v[i] );
        }
        else
          printf ("  ");
      }
      printf ("\n");
#     ifdef USE_LONG_LONG
      if (ws > 32)
        printf(  "bitnr ");
        DWN(i, 63, 32) if (dm & (1 << i))
          printf (" %d", i / 10);
        else
          printf (" .");
        printf ("\n      ");
        DWN(i, 63, 32) if (dm & (1 << i))
          printf (" %d", i % 10);
        else
          printf ("  ");
        printf ("\n0..9A ");
        DWN(i, 63, 32) {
          if (e_v[i]) {
            e_v[i] = (10 * e_v[i]) / error;
            if (e_v[i] == 10)
              printf (" A");
            else {
              if (e_v[i] == 0) e_v[i] = 1;
              printf (" %d", e_v[i] );
            }
          }
          else
            printf ("  ");
        }
        printf ("\n");
      }
#endif USE_LONG_LONG
    }
  }
  return error;                                                    /* return */
}

/* end of file memtest.c */
#endif USE_MEMTEST
