/*
   NAME move.c CREATED 15:35 16 Apr, 1994
   
 */

#include "config.h"

#include <stdio.h>
#include <unistd.h>
#include <math.h>


#ifdef INCLUDE_MOVE
#define CRYSTAL 15.0


extern int BASE;
extern int myatoi(char *s);

/********************************************************************/
/*   This function uses the inputparameter clock (in MHz)           */
/*   to calculate the 22-bit inputword required to program the ICD  */
/*   2051. This word returned by CalulateClockWord can be directly  */
/*   fed (serially) to the ICD2051. If an error during calculation  */
/*   occurred -1 is returned.                                       */
/*   The result is usually accurate to within 0.4%                  */
/********************************************************************/

long calc_clock (int argc,char **argv)
{
int pwr=0;
int P,Q,fac,I;
int Pmin,Qmin;
float diff,diffmin,clk,clock;
float table[15] = {40, 42.5, 47.5, 53.5, 58.5, 62.5, 68.5,
	   	   69, 82, 87, 92, 92.1, 105, 115, 120};

sscanf (argv[1],"%f",&clock);
if ((clock < 0.32) || (clock > 120))
     return -1;

/* The VCO clock frequency should be above 40MHz. To generate lower */
/* output clocks, it can divide the VCO output by a power of two. We */
/* therefore find this power first.... */
while (clock < 40)
    {
    pwr++;
    clock *= 2;
    }
fac = 1 << pwr;

/* Table lookup for "I" parameter. */
for (I=-1;I<14;I++)
    if (table[I+1] > clock) break;

/* Initialize variables (to please the compiler... ) */
Pmin = Qmin = 0;diffmin = 1000.0;

/* Try all possible P parameters */
for (P = 129;P > 4;P--)
    {
    /* Calculate the corresponding Q */
    Q = 0.5 + (2 * CRYSTAL * P / clock);
    /* and the resulting clock frequency. */
    clk = 2 * CRYSTAL * (float)P / (float)Q;
    diff = fabs (clk-clock);
    if (diff < diffmin)  /* Better than what we have so far? */
        {
        diffmin = diff;
        Pmin = P;
        Qmin = Q;
        }
    }
printf ("REW %8.4f MHz           P= %3d  Q= %3d  I= %3d  Mux= %3d\n",
        clock/fac,
           Pmin,Qmin,I,pwr);

P = 127 & (~(130-Pmin));
Q = 127 & (~(129-Qmin));
printf ("REW %8.4f MHz  %6.2f%%  P= %3d  Q= %3d  I= %3d  Mux= %3d\n",
        clock/fac,
        ((2 * CRYSTAL * Pmin / Qmin / clock)-1)*100,
           Pmin,Qmin,I,pwr);
return	(I << 18)  
        |   (P << 11)  
            |   (1 << 10) 
                |   (pwr << 7) 
                    |   (Q);
}


int ctrlreg;

#define CTRLREG (*((volatile short *)(BASE+0x80000)))

int ctrlreg_set (int argc,char **argv)
{
ctrlreg = myatoi (argv[1]);
CTRLREG = ctrlreg;
return 0;
}

int ctrlreg_get (int argc,char **argv)
{
return ctrlreg;
}

void setbit (int i,int v)
{
ctrlreg = (ctrlreg & ~(1 << i)) | (v << i);
CTRLREG = ctrlreg;
}



int codeword (int argc,char **argv)
{
int cw,i;

cw = myatoi (argv[1]);

setbit (11,0);
usleep (1000);
for (i=0;i<22;i++)
    { 
    setbit (4,cw & 1);
    cw >>= 1;
    setbit (5,1);
    usleep (1000);
    setbit (5,0);
    }
usleep (1000);
setbit (11,1);
return 0;
}


#endif




