
#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>


#ifdef INCLUDE_SBUS
#include "commands.h"

#include "chipmunk.h"


#define MAXBITS 65000

int loadcfg (int argc,char **argv)
{
FILE *f;
int n,s,i,t=0;
char buf[BUFSIZ],*p;
char *a;

MINARGC(3);
if ((f = fopen (argv[1],READ)) == NULL)
    {
    printf ("Cannot open file `%s'.\n",argv[1]);
    return 1;
    }
a = (char *)(BASE + myatoi (argv[2]));
n = 0;
do {
    s = fread ((void *)buf,1,BUFSIZ,f);
    n += s;
    for (i=0,p=buf;i<s;i++)
        {
	*a = *p++;
	usleep (20);   /* officially 1/0.5MHz  * (8 + sec) */
	if (!(++t % 100)) write (1,"*",1);
        }
    } while (s > 0);
fclose (f);
if (VERBOSE > 0)
    printf ("Read %08x bytes from '%s', into address %08x.\n",
            n,argv[1],(int)a);
return 0;
}


#define CRREG (*((volatile int*)(BASE + 0* (1<<19) + 0* (1<<18) + 1* (1<<17))))
#define A0    (*((volatile int*)(BASE + 0* (1<<19) + 1* (1<<18) + 0* (1<<17))))
#define A1    (*((volatile int*)(BASE + 0* (1<<19) + 1* (1<<18) + 1* (1<<17))))

#define CCLK  (1 << 8)
#define RDATA (1 << 20)


#define cli() /* Sorry. Can't disable interrupts from user mode */
#define sti() /* Sorry. Can't enable  interrupts from user mode */



int readcfg (int argc,char **argv)
{
char bitbuf[65000]; /* 64160 */
FILE *fp;
int i;
char *p;

printf ("Warning hardware BUG compensated for in software.\n"
        "(this software needs an update for the final version of the pal) \n");
usleep (1); /* Give the computer time to print the above message.... */
/* Do "rtrig" */
(void) A1;  /* rtrig := 0 */
usleep (10);
CRREG &= ~CCLK;
(void) A0;  /* rtrig := 1 !!! */

CRREG |= CCLK;
usleep (1);
for (i=0,p=bitbuf;i<MAXBITS;i++)
    {
    *p++ = (CRREG & RDATA) == 0;
    cli ();
    CRREG &= ~CCLK; /* NO interrupts allowed :-) */
    /* Wait min 0.5 microsecond (4)T_CCLR 2-125 */
    usleep (1);
    CRREG |=  CCLK;
    sti ();
    /* Wait min 0.5 microsecond (5)T_CCHR 2-125 */
    usleep (1);
    
    }
fp = fopen (argv[1],"w");
fwrite (bitbuf,1,MAXBITS,fp);
fclose (fp);
return 0;
}



#endif
