.\" Automatically generated from an mdoc input file.  Do not edit.
.\" Copyright (c) 2003-2023 Dieter Baron and Thomas Klausner.
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above
.\"    copyright notice, this list of conditions and the following
.\"    disclaimer in the documentation and/or other materials provided
.\"    with the distribution.
.\" 3. The name of the author may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THOMAS KLAUSNER ``AS IS'' AND ANY
.\" EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
.\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR
.\" CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
.\" SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
.\" LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
.\" USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
.\" ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
.\" OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
.\" OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.TH "CKMAMERC" "5" "June 16, 2023" "NiH" "File Formats Manual"
.nh
.if n .ad l
.SH "NAME"
\fBckmamerc\fR
\- config file for ckmame, dumpgame, and mkmamedb
.SH "DESCRIPTION"
The
\fBckmamerc\fR
config file sets global or local configuration for running
ckmame(1),
dumpgame(1),
and
mkmamedb(1).
.PP
By default, the configuration is read from
\fI~/.config/ckmame/ckmamerc\fR
and
\fI.ckmamerc\fR
in the current directory if they exist, in this order.
.PP
Many settings can also be specified on the command line.
.PP
Later settings override earlier ones.
.SS "SECTIONS"
The config file is in TOML format and consists of three types of sections.
A section header consists of the name of the section enclosed in square brackets
on its own line.
.TP 29n
[global]
The
\(lqglobal\(rq
section contains settings that apply in general.
.TP 29n
["set name"]
\(lqset name\(rq
sections contain settings for a particular set (see the
\fB\-\fR\fB\-set\fR
command line option).
.TP 29n
[profile."profile name"]
Settings can be shared and referenced from multiple sets by defining
them in a profile and referencing this.
Use sections whose name starts with
\(lqprofile.\(rq
for this.
They can be referenced from other sections by using the
\(lqprofiles\(rq
keyword with
\(lqprofile name\(rq
(without the leading
\(lqprofile.\(rq).
.SS "CONFIGURATION VARIABLES"
Most command line options can be used as configuration variables in
the config file.
Take the name of the long option and use it without the leading
dashes.
For boolean settings and those with a value, use the
.RS 6n
variable = value
.RE
syntax.
For example,
ckmame(1)'s
\fB\-\fR\fB\-complete-games-only\fR
will be written in the config file as
.RS 6n
complete-games-only = true
.RE
.PP
Options that exist as
\fB\-\fR\fB\-foo\fR
and
\fB\-\fR\fB\-no-foo\fR
are mapped to a single configuration value with values
\(lqtrue\(rq
and
\(lqfalse\(rq.
.PP
For full documentation of config file options with corresponding command line options,
see the manual page of the command.
.PP
Options can use the string
\(lq$set\(rq
which will be replaced by the set name when used.
.PP
The following options are supported by all tools:
.RS 4n
.TP 22n
rom-db
String.
.TP 22n
profiles
Array of strings.
List of profile names (without the leading
\(lqprofile.\(rq)
whose configuration variables should be merged into
the current section.
.TP 22n
sets
Array of strings.
Each string is the name of a set.
.TP 22n
sets-file
String.
Points to a file that lists sets, one line per set.
.TP 22n
update-database
Boolean.
.TP 22n
verbose
Boolean.
.RE
.PP
The following options are supported only by
ckmame(1)
and
mkmamedb(1):
.RS 4n
.TP 22n
roms-zipped
Boolean.
.TP 22n
use-central-cache-directory
Boolean.
Put the cache databases generated by
ckmame(1)
and
mkmamedb(1)
below
\fI$HOME/.cache/ckmame/\fR.
This affects the location of
mkmamedb(1)'s
\fI.mkmamedb.db\fR
(\fB\-\fR\fB\-directory-cache\fR)
and
ckmame(1)'s
\fI.ckmame.db\fR
files for extra-directories (but not for the
\fIroms\fR,
\fIsaved\fR,
and
\fIunknown\fR
directories).
.RE
.PP
The following options are supported only by
ckmame(1):
.RS 4n
.TP 22n
complete-games-only
Boolean.
.TP 22n
complete-list
String.
.TP 22n
create-fixdat
Boolean.
.TP 22n
delete-unknown-pattern
String.
.TP 22n
extra-directories
Either an array of strings, or a table where the keys are directories
and the values are a table of options.
For the second case, the following options are supported:
.RS 26n
.TP 12n
move-from-extra
Boolean.
.TP 12n
use-central-cache-directory
Boolean.
.RE
.TP 22n
extra-directories-append
Same as
\(lqextra-directories\(rq
but does not override the previous value, but appends to it instead.
.TP 22n
fixdat-directory
String.
.TP 22n
keep-old-duplicates
Boolean.
.TP 22n
missing-list
String.
.TP 22n
move-from-extra
Boolean.
Setting this to
\(lqfalse\(rq
is the same as using
\fB\-\fR\fB\-copy-from-extra\fR
on the command line.
.TP 22n
old-db
String.
.TP 22n
report-changes
Boolean.
.TP 22n
report-correct
Boolean.
.TP 22n
report-detailed
Boolean.
.TP 22n
report-fixable
Boolean.
.TP 22n
report-missing
Boolean.
.TP 22n
report-no-good-dump
Boolean.
.TP 22n
report-summary
Boolean.
.TP 22n
rom-directory
String.
.TP 22n
saved-directory
String.
.TP 22n
unknown-directory
String.
.TP 22n
use-torrentzip
Boolean.
.RE
.PP
The following variables are only supported by
mkmamedb(1):
.RS 4n
.TP 22n
dats
Array of strings, or table where the keys are strings and the values
are tables with options.
Each string is the (internal) name of a dat.
The supported options in the second case are:
.RS 26n
.TP 27n
game-name-suffix
String.
Suffix all game names in the dat with the given string argument.
.TP 27n
use-description-as-name
Boolean.
.RE
.TP 22n
dat-directories
Either an array of strings, or a table where the keys are directories
and the values are a table of options.
Each string is a directory containing dats.
.RS 26n
.TP 12n
use-central-cache-directory
Boolean.
.RE
.TP 22n
use-temp-directory
Boolean.
.RE
.SH "TOML PITFALLS"
While TOML is a relatively simple and readable format, it has some unexpected details:
.PP
Any key that contains characters other than letters, digits,
\(lq-\(rq,
and
\(lq_\(rq
must be quoted using double quotes.
.PP
Nested tables can be written in two forms:
.PP
Inline using
\(lq{\(rq
and
\(lq}\(rq.
However, the complete inline table must be on one line (unlike inline arrays, which can span multiple lines). See
\(lqextra-directories-append\(rq
in
\(lqBig Set\(rq
in EXAMPLES below.
.PP
As sections with a
\(lq\&.\(rq
separating the outer and inner names:
.RS 6n
["outer table name"."inner table name"]
.RE
Note that the
\(lq\&.\(rq
must be outside any quotation marks.
All settings in this section apply to the inner table.
When using this for options that allow tables as values (like
\(lqdats\(rq),
the keys in this table are not configuration
variables and need to be quoted if they contain special characters. See
\(lqextra-directories\(rq
in
\(lqUnzipped Set\(rq
in EXAMPLES below.
.SH "EXAMPLES"
.nf
.RS 4n
[global]
verbose = true
extra-directories = [ "incoming" ]
sets = [ "Set using standard settings only" ]

[profile.incomplete]
complete-only = true
report-missing = false

["Big Set"]
verbose = false
rom-directory = "Big Set ROMs"
extra-directories-append = { "another-location" = { move-from-extra = true } }
rom-db = "Big Set.db"
profiles = [ "incomplete" ]

["Unzipped Set"]
roms-unzipped = true
rom-directory = "Unzipped Set ROMs"
rom-db = "Unzipped Set.db"
["Unzipped Set".extra-directories]
"unzipped-incoming" = { use-central-cache-directory = true }
.RE
.fi
.PP
This configuration would by default report verbosely,
but override this for the "Big Set" set.
It would also set the rom directories and database files
for both the "Big Set" and the "Unzipped Set" and not use
ZIP archives for the latter.
.PP
Example run:
.RS 6n
ckmame --set Big Set
.RE
.SH "SEE ALSO"
ckmame(1),
dumpgame(1),
mkmamedb(1)
.SH "AUTHORS"
\fBckmame\fR
was written by
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>.
