#include <stdio.h>

/*
 * ASCII TABLE:

 0    ^@ ^A ^B ^C   ^D ^E ^F ^G   ^H ^I ^J ^K   ^L ^M ^N ^O
10    ^P ^Q ^R ^S   ^T ^U ^V ^W   ^X ^Y ^Z ^[   ^\ ^] ^^ ^_
20       !  "  #    $  %  &  '    (  )  *  +    ,  -  .  /
30    0  1  2  3    4  5  6  7    8  9  :  ;    <  =  >  ?
40    @  A  B  C    D  E  F  G    H  I  J  K    L  M  N  O
50    P  Q  R  S    T  U  V  W    X  Y  Z  [    \  ]  ^  _
60    `  a  b  c    d  e  f  g    h  i  j  k    l  m  n  o
70    p  q  r  s    t  u  v  w    x  y  z  {    |  }  ~  

 */

main()
{
	int             i, j, two_byte;

	for (i = 0x00; i <= 0xff; ++i) {
		if (i % 16 == 0)
			printf("\n%2x     ", i);
		else if (i % 4 == 0)
			printf("   ");

		two_byte = 0;
		if (i < 0x20) {
			underline();
			putchar('^');
			putchar(i + 0x40);
			normal();
			two_byte = 1;
		} else if (i < 0x80) {
			putchar(i);
		} else if (i < 0xa0) {
			reverse();
			putchar('^');
			putchar(i - 0x80 + 0x40);
			normal();
			two_byte = 1;
		} else if (i <= 0xff) {
			reverse();
			putchar(i - 0x80);
			normal();
		}
		if ((i % 16) != 15)
			if (two_byte)
				putchar(' ');
			else
				printf("  ");
	};
	putchar('\n');
}

normal()
{
	printf("%c%c%c", 27, '[', 'm');
}

reverse()
{
	printf("%c%c%c%c", 27, '[', '7', 'm');
}

underline()
{
	printf("%c%c%c%c", 27, '[', '4', 'm');
}
