static char version[] = "cn2jp 1.3 (Mar 1, 1996)";

/*
  Copyright (C) 1996      Seke Wei      (seke@sys.es.osaka-u.ac.jp)

  mktbl2c:  convert <.t> table to <.c> program for static link


  This program is free for general distribution.

  This program runs on UNIX. You are welcome to port it to other operating
  systems.
*/

#include <stdio.h>

int debug = 0;
char	*init_table();

struct code_table {
				/* main table */
				/* size = row * char_per_row * 2 */
	char    tbl_name[20];	/* name of src to dest translatio table */
	int     row;		/* row of src code set */
	int     char_per_row;	/* char_per_row of src code set */
	char    *tbl;		/* table itself */

				/* supplementary table */
				/* size = supp_tbl_size = max_index*2 + content */
	int	supp_tbl_size;	/* supplementary translation table */
	int	supp_tbl_max_index;
	char	*supp_tbl;	/* supp table itself, */

	int     loaded;

	int	(*src_seq)();
	int	(*src_seq_to_dest)();
	char *	(*src_to_dest)();
}  table;

char	tbl_name[20];


main(argc,argv)
int     argc;
char    **argv;
{
	char	istr[1024],*ostr;
	char	c1,c2,e1,e2;
	int	ilen,olen;
	FILE	*fp;


if((argc != 2) && (argc != 3)){
	puts("------------  Translate .t table to .c program -------");
	puts("Usage: mktbl2c .t_tbl [b2j]");
	puts("		requires '.t_tbl'");
	puts("		Version 0.4 by Seke Wei on 1996/03/01");
	return -1;
}

	if(argc==1)
		fp = stdin;
	else if(argc>=2)
		fp = fopen(argv[1],"rb");

	if(argc==3)
		strcpy(tbl_name,argv[2]);
	else
		tbl_name[0]=0;

	if(fp==NULL) {
		fprintf(stderr, "\nmktbl2c: .t table <%s> not found!", argv[1]);
		return -1;
	}
	
	if(!init_table(fp, &table)){
		fprintf(stderr, "\nmktbl2c: .t table <%s> not init!", argv[1]);
                return -1;
	}

	write_table(&table);

	return 0;
}



char *
init_table(fp,ptable)
FILE	*fp;
struct code_table 	*ptable;
{
	unsigned char *tbl,tbl_name[20],c;
	int	k,row,char_per_row,tbl_size;

	ptable->loaded = 0;
	/* open the lookup table */

	fscanf(fp,"%s ( %d x %d )", tbl_name, &row, &char_per_row);
	tbl_size = row * char_per_row * 2;

	strcpy(ptable->tbl_name,tbl_name);
	ptable->row = row;
	ptable->char_per_row = char_per_row;


	/* allocate for the table */
	tbl = (unsigned char*) calloc(tbl_size,sizeof(unsigned char));
	if(tbl==NULL) return NULL;

	/* fill in the table */
	while((fgetc(fp)) != '\n');

	k=fread(tbl, char_per_row*2, row, fp);
	if(k!=row) {
		fprintf(stderr,"\ninit_table: fails to fread()!!");
		return NULL;
	}

	if(init_supp_tbl(fp,ptable)!=0) {
		fprintf(stderr,"\ninit_table: fails to init_supp_tbl()!!");
		return NULL;
	}

	fclose(fp);

	ptable->tbl = tbl;
	ptable->loaded=1;

	return tbl;
}


init_supp_tbl(fp,ptable)
FILE	*fp;
struct code_table	*ptable;
{
	unsigned char	*tbl,lo,hi;
	int	k,tbl_max_index,tbl_size;


	ptable->supp_tbl = NULL;
	ptable->supp_tbl_size = 0;

			/* read tbl_size: including index and content */
	k=fread(&lo, sizeof(char), 1, fp);
	k+=fread(&hi, sizeof(char), 1, fp);
	tbl_size = lo + (hi << 8);
	if((k!=2) || (tbl_size==0))
		return 0;	/* no definition of supp table */

			/* read tbl_max_index */
	k=fread(&lo, sizeof(char), 1, fp);
	k+=fread(&hi, sizeof(char), 1, fp);
	tbl_max_index = lo + (hi << 8);
	if(k!=2) return -1;

	tbl = (char *) calloc(tbl_size,sizeof(unsigned char));
	if(tbl==NULL) return -1;

			/* read index and content */
	k=fread(tbl, sizeof(unsigned char), tbl_size, fp);
	if(k!=tbl_size) return -1;

	ptable->supp_tbl = tbl;
	ptable->supp_tbl_max_index = tbl_max_index;
	ptable->supp_tbl_size = tbl_size;

	return 0;
}


write_table(ptable)
struct code_table	*ptable;
{
	long	size;
	int	i;
	unsigned char	*ptbl;
	

	/* comment */

	printf("/*	Generated by 'mktbl2c' from '%s' */",ptable->tbl_name);
	printf("\n");


	/* variable name definition */

	printf("\n#define MAIN_TABLE_NAME	%smain_tbl_static",tbl_name);
	printf("\n#define SUPP_TABLE_NAME	%ssupp_tbl_static",tbl_name);
	printf("\n#define TABLE_STRUCTURE_NAME	%stbl_static",tbl_name);
	printf("\n");

	printf("\nextern char	MAIN_TABLE_NAME[];");
	printf("\nextern char	SUPP_TABLE_NAME[];");
	printf("\n");

	/* code table structure definition */

	printf("\nstruct code_table {");
	printf("\n	char    tbl_name[20];");
	printf("\n	int     row;");
	printf("\n	int     char_per_row;");
	printf("\n	char    *tbl;");
	printf("\n	int     supp_tbl_size;");
	printf("\n	int     supp_tbl_max_index;");
	printf("\n	char    *supp_tbl;");
	printf("\n	int     loaded;");
	printf("\n	int	(*src_seq)();");
	printf("\n	int	(*src_seq_to_dest)();");
	printf("\n	char *	(*src_to_dest)();");
	printf("\n}  TABLE_STRUCTURE_NAME = {");
	printf("\n");
	printf("\n	\"%s\",",ptable->tbl_name);
	printf("\n	%d,",ptable->row);
	printf("\n	%d,",ptable->char_per_row);
	printf("\n	(char *) %s,","MAIN_TABLE_NAME");
	printf("\n	%d,",ptable->supp_tbl_size);
	printf("\n	%d,",ptable->supp_tbl_max_index);
	printf("\n	(char *) %s,","SUPP_TABLE_NAME");
	printf("\n	%d,",1);
	printf("\n	0,");
	printf("\n	0,");
	printf("\n	0");
	printf("\n};");
	printf("\n");
	

	/* main table definition */

	size = ptable->row * ptable->char_per_row * 2;
	printf("\nchar	MAIN_TABLE_NAME[%d] = {", size);
	ptbl = ptable->tbl;

	for(i=0; i< size - 1; i++) {

		if(i%10==0)
			printf("\n");

		printf(" 0x%x,",*ptbl);
		ptbl++;
	}
		
	printf(" 0x%x };",*ptbl);
	printf("\n");


	/* aux table definition */

	size = ptable->supp_tbl_size;
	if(size==0) size=1;
	printf("\nchar	SUPP_TABLE_NAME[%d] = {", size);
	ptbl = (char *) ptable->supp_tbl;
	if(!ptbl) ptbl = (char *) &size;	/* let { 1 } be printed */

	for(i=0; i< size - 1; i++) {
		if(i%10==0)
			printf("\n");

		printf(" 0x%x,",*ptbl);
		ptbl++;
	}
		
	printf(" 0x%x };",*ptbl);

	return 0;
}
