#include <sys/ioctl.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <err.h>

#include <dev/usb/usb.h>

struct usb_dev_info{
    char	*productName;
    u_int16_t	vendorNo;
    u_int16_t	productNo;
    int		returnNo;
};

#define	ACT_WRITE	0
#define	ACT_READ	1
#define	ACT_SETIF	2

#define	ISOCH_IFNUM	0x07
#define ISOBUF_SIZE	1023

#define WIDTH	352
#define HEIGHT	288

#define DEPTH	3

#define IMAGE_SIZE	(WIDTH*HEIGHT*DEPTH)

typedef struct
{
    u_int8_t  act;
    u_int16_t idx;
    u_int16_t len;
#define LENNUM_MAX	8
    u_int8_t data[LENNUM_MAX];
} initURB_t;

/** Prototype definition **/
int usbdev_probe(int fd, struct usb_dev_info *list);
int camera_reg_read(int fd, initURB_t const *urb, u_int8_t *val, int flag);
int camera_reg_write(int fd, initURB_t const *urb);
int usb_set_interface(int fd, int alternate);

/* cnxtinit.c */
int camera_init(int fd);
int camera_init2(int fd);

/* init code */
#define HEADER_SIZE 556
#define PICBUF_FREESIZE (IMAGE_SIZE-HEADER_SIZE)

#define INIT1_URBS_NUM 377
#define INIT2_URBS_NUM 89

extern	u_int8_t picbuf[IMAGE_SIZE];
extern	int ignoreURB[];

extern  initURB_t i420_init1[INIT1_URBS_NUM];
extern  initURB_t i420_init2[INIT2_URBS_NUM];
extern  initURB_t rgb24_init1[INIT1_URBS_NUM];
extern  initURB_t rgb24_init2[INIT2_URBS_NUM];


