{ inputs, ... }:
{
  perSystem =
    {
      self',
      pkgs,
      lib,
      ...
    }:
    let
      testLib = inputs.self.testLib { inherit self' lib pkgs; };
    in
    {
      checks =
        {
          repo1 = {
            withAuth = true;
            test =
              # user info test
              ''
                repo = ${
                  testLib.berg_run_json {
                    cmd = ''repo create --name "foo" --description "asdf" --private "private" --default-branch "main"'';
                  }
                }
                printj(repo)

                assert repo["name"] == "foo", f"repo name incorrect\ngot:{repo}"
                assert repo["owner"]["login"] == "${testLib.user}", f"repo owner incorrect\ngot:{repo}"
                assert repo["description"] == "asdf", f"repo description incorrect\ngot:{repo}"
                assert repo["private"] == True, f"repo private incorrect\ngot:{repo}"
                assert repo["default_branch"] == "main", f"repo default branch incorrect\ngot:{repo}"
              '';
          };
          repo2 = {
            withAuth = true;
            test =
              # user info test
              ''
                repo = ${
                  testLib.berg_run_json {
                    cmd = ''repo create --name "bar" --description "asdf" --private "public" --default-branch "mega"'';
                  }
                }
                printj(repo)

                assert repo["name"] == "bar", f"repo name incorrect\ngot:{repo}"
                assert repo["owner"]["login"] == "${testLib.user}", f"repo owner incorrect\ngot:{repo}"
                assert repo["description"] == "asdf", f"repo description incorrect\ngot:{repo}"
                assert repo["private"] == False, f"repo private incorrect\ngot:{repo}"
                assert repo["default_branch"] == "mega", f"repo default branch incorrect\ngot:{repo}"
              '';
          };
          repoInfo = {
            withRepoSetup = true;
            withAuth = true;
            test = ''
              repo = ${
                testLib.berg_run_json {
                  cmd = ''repo info'';
                  withTestRepo = true;
                }
              }

              printj(repo)

              assert repo["name"] == "${testLib.testRepo}", f"repo name incorrect\ngot:{repo}"
              assert repo["owner"]["login"] == "${testLib.user}", f"repo owner incorrect\ngot:{repo}"
              assert repo["description"] == "", f"repo description incorrect\ngot:{repo}"
              assert repo["private"] == False, f"repo private incorrect\ngot:{repo}"
              assert repo["default_branch"] == "main", f"repo default branch incorrect\ngot:{repo}"
            '';
          };
        }
        |> testLib.embeddInFlake;
    };
}
