pub mod info;

use clap::Subcommand;

use super::GeneralArgs;

/// User subcommands
#[derive(Subcommand, Debug)]
pub enum UserArgs {
    Info(info::UserInfoArgs),
}

impl UserArgs {
    pub async fn run(self, general_args: GeneralArgs) -> anyhow::Result<()> {
        match self {
            UserArgs::Info(args) => args.run(general_args).await,
        }
    }
}
