package digests

import (
	. "gopkg.in/check.v1"
)

type DigestsSuite struct{}

var _ = Suite(&DigestsSuite{})

func (s *DigestsSuite) Test_Sha1_calculatesCorrectly(c *C) {
	res := Sha1([]byte{0x01, 0x02, 0x03})
	c.Assert(res, DeepEquals, []byte{0x70, 0x37, 0x80, 0x71, 0x98, 0xc2, 0x2a, 0x7d, 0x2b, 0x8, 0x7, 0x37, 0x1d, 0x76, 0x37, 0x79, 0xa8, 0x4f, 0xdf, 0xcf})
}

func (s *DigestsSuite) Test_Sha256_calculatesCorrectly(c *C) {
	res := Sha256([]byte{0x01, 0x02, 0x03})
	c.Assert(res, DeepEquals, []byte{0x3, 0x90, 0x58, 0xc6, 0xf2, 0xc0, 0xcb, 0x49, 0x2c, 0x53, 0x3b, 0xa, 0x4d, 0x14, 0xef, 0x77, 0xcc, 0xf, 0x78, 0xab, 0xcc, 0xce, 0xd5, 0x28, 0x7d, 0x84, 0xa1, 0xa2, 0x1, 0x1c, 0xfb, 0x81})
}

func (s *DigestsSuite) Test_Sha3_256_calculatesCorrectly(c *C) {
	res := Sha3_256([]byte{0x01, 0x02, 0x03})
	c.Assert(res, DeepEquals, []byte{0xfd, 0x17, 0x80, 0xa6, 0xfc, 0x9e, 0xe0, 0xda, 0xb2, 0x6c, 0xeb, 0x4b, 0x39, 0x41, 0xab, 0x3, 0xe6, 0x6c, 0xcd, 0x97, 0xd, 0x1d, 0xb9, 0x16, 0x12, 0xc6, 0x6d, 0xf4, 0x51, 0x5b, 0xa, 0xa})
}
