/****************************************************************************
 *
 *  Filename: cpia2dev.h
 *
 *  Copyright 2001, STMicrolectronics, Inc.
 *
 *  Contact:  steve.miller@st.com
 *
 *  Description:
 *     This file provides definitions for applications wanting to use the 
 *     cpia2 driver beyond the generic v4l capabilities.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/
/* $Id: cpia2dev.h,v 1.2 2002/07/23 04:47:55 sbertin Exp $ */

#ifndef CPIA2_DEV_HEADER
#define CPIA2_DEV_HEADER

#include <linux/types.h>


struct cpia2_cam_state
{
   __u8  asic_id;              /* 672/676/etc */
   __u8  sensor_size;         /* VGA or CIF */
   __u8  current_image_size;  /* VGA. CIF. QVGA, QCIF, etc */
   __u8  current_alternate;
   __u8  current_framerate;
   __u8  flicker_mode;
   __u8  mirror_on;
   __u8  flip_on;
};


#define USBIF_CMDONLY 0
#define USBIF_BULK 1
#define USBIF_ISO_1 2	/*  128 bytes/ms */
#define USBIF_ISO_2 3	/*  384 bytes/ms */
#define USBIF_ISO_3 4	/*  640 bytes/ms */
#define USBIF_ISO_4 5	/*  768 bytes/ms */
#define USBIF_ISO_5 6	/*  896 bytes/ms */
#define USBIF_ISO_6 7	/* 1023 bytes/ms */


/* Flicker Modes */
#define NEVER_FLICKER   0
#define ANTI_FLICKER_ON 1
#define FLICKER_60      60
#define FLICKER_50      50

/***
 * The following defines are ioctl numbers based on video4linux private ioctls,
 * which can range from 192 (BASE_VIDIOCPRIVATE) to 255. All of these take int
 * args
 */
#define CPIA2_IOC_SET_FRAMERATE    _IOW('v', BASE_VIDIOCPRIVATE + 7, __u32)
#define CPIA2_IOC_GET_FRAMERATE    _IOR('v', BASE_VIDIOCPRIVATE + 8, __u32)
#define CPIA2_IOC_SET_USB_ALT      _IOW('v', BASE_VIDIOCPRIVATE + 9, __u32)
#define CPIA2_IOC_GET_USB_ALT      _IOR('v', BASE_VIDIOCPRIVATE + 10, __u32)
#define CPIA2_IOC_SET_FLICKER_MODE _IOW('v', BASE_VIDIOCPRIVATE + 11, __u32)
#define CPIA2_IOC_SET_FLIP         _IOW('v', BASE_VIDIOCPRIVATE + 12, __u32)
#define CPIA2_IOC_SET_MIRROR       _IOW('v', BASE_VIDIOCPRIVATE + 13, __u32)
#define CPIA2_IOC_GET_CAM_STATE    _IOR('v', BASE_VIDIOCPRIVATE + 14, struct cpia2_cam_state)
#define CPIA2_IOC_SET_TARGET_KB    _IOR('V', BASE_VIDIOCPRIVATE + 15, __u32)
#define CPIA2_IOC_GET_TARGET_KB    _IOR('V', BASE_VIDIOCPRIVATE + 16, __u32)


/***
 * Defines for other properties, such as flip and mirror
 ***/
#define CPIA2_PROPERTY_ON   1
#define CPIA2_PPROPERTY_OFF 0
#define CPIA2_PROPERTY_MIRROR 0
#define CPIA2_PROPERTY_FLIP 1

/***
 * Misc stuff
 ***/
#define SENSOR_MAX_SIZE_VGA 0
#define SENSOR_MAX_SIZE_CIF 1
#define CPIA2_TYPE_672 0
#define CPIA2_TYPE_676 1

/***
 * Video frame sizes
 ***/
enum {
	VIDEOSIZE_VGA = 0,	/* 640x480 */
	VIDEOSIZE_CIF,		/* 352x288 */
	VIDEOSIZE_QVGA,		/* 320x240 */
	VIDEOSIZE_QCIF,		/* 176x144 */
	VIDEOSIZE_640_480,
	VIDEOSIZE_352_288,
	VIDEOSIZE_320_240,
	VIDEOSIZE_176_144,
	VIDEOSIZE_288_216,
	VIDEOSIZE_256_192,
	VIDEOSIZE_224_168,
	VIDEOSIZE_192_144,
	VIDEOSIZE_160_120,
	VIDEOSIZE_128_96,
	VIDEOSIZE_88_72,
	VIDEOSIZE_64_48,
	VIDEOSIZE_48_48
};

/* These defines MUST NOT be changed. They are passed to the driver, which
 * in turn sets the camera frame rate with these values.
 */
#define CPIA2_FRAMERATE_30                     0x20    
#define CPIA2_FRAMERATE_25                     0x10    
#define CPIA2_FRAMERATE_15                     0x08    
#define CPIA2_FRAMERATE_12_5                   0x04    
#define CPIA2_FRAMERATE_7_5                    0x02    
#define CPIA2_FRAMERATE_6_25                   0x01


#endif
