/* This file is part of cqual.
   Copyright (C) 2000-2002 The Regents of the University of California.

cqual is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

cqual is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with cqual; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */

#ifndef USER_QUAL_H
#define USER_QUAL_H

#include "common-AST.h"
#include "cstring.h"
#include "location.h"
#include "linkage.h"

EXTERN_C_BEGIN

/* lifted from AST_defs.h */
/* The user-defined type qualifier CSTRING */
/*struct AST_user_qual { */ /* extends type_element */
/*  ast_kind kind;
    location loc;
    node sameregion next;
    node sameregion parent;
    cstring cstring;
  };
  typedef struct AST_user_qual *user_qual;
  
  user_qual new_user_qual(region r, location loc, cstring cstring); */

/* used in user-qual.c */
extern region parse_region;

typedef enum 
{
  no_qualifiers = 0, 
  transparent_qualifier = 1,
#define Q(name, kind, qual, val) qual = val,
#include "qualifiers.h"
#undef Q
  last_qualifier
} type_quals;



/* User-defined qualifiers */
typedef struct user_qual_list
{
  user_qual qual;
  struct user_qual_list *next;
} *user_qual_list;

user_qual_list new_user_qual_list(user_qual, user_qual_list);
user_qual_list copy_user_qual_list(user_qual_list l);
bool member_user_qual_list(user_qual_list l, char *q);
user_qual_list union_user_qual_list(user_qual_list left,
				    user_qual_list right);
bool empty_user_qual_list(user_qual_list);

#define scan_user_qual_list(var, list) for (var = (list); var; var = var->next)

EXTERN_C_END

#endif
