/************************************
     Copyright 2008 Google Inc.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 ************************************/

/** @file usage.c
 *  @brief contains functions for parsing arguments and printing usage info.
 *
 *  generated by cgener.  http://code.google.com/p/cgener/
 */


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include "convdate_main.h"

/** prints application help information.
 * @param bin application name as invoked on the commandline
 */
void usage( char *bin ) {
  fprintf(stderr, "\nconvdate: converts a date within a field of a dt file into a different format.\n");
  fprintf(stderr, "\nusage: %s <options>\n", bin);
  fprintf(stderr, "options:\n");
	fprintf(stderr, "  -h, --help             print this message and exit\n");
	fprintf(stderr, "  -V, --version          print version info and exit\n");
	fprintf(stderr, "  -v, --verbose          print verbose runtime messages and warnings.\n");
	fprintf(stderr, "  -d, --delim <delim>    field separator string (default: 0xfe)\n");
	fprintf(stderr, "  -f, --field <field>    1-based number of field to convert (default: 1)\n");
	fprintf(stderr, "  -F, --field-label <field_label>\n                         header label of field to convert\n");
	fprintf(stderr, "  -i, --input_format <input_format>\n                         date format in the input file - see strptime (default:\n                         %%m-%%d-%%Y-%%T)\n");
	fprintf(stderr, "  -o, --output_format <output_format>\n                         date format in the output file - see strftime (default:\n                         %%Y-%%m-%%d-%%T)\n");
	fprintf(stderr, "  -p, --preserve_header  preserve the header line (default: do not preserve the\n                         header)\n");
	fprintf(stderr, "\nthe file is read from the stdin and written to stdout");
	printf("\n\n");
	return;
} 

/* this won't be used outside of this file */
void init_cmdargs( struct cmdargs * );

#include <getopt.h>

/** long option structure list */
static struct option long_options[] = {
	{"help", no_argument, 0, 'h'},
	{"version", no_argument, 0, 'V'},
	{"verbose", no_argument, 0, 'v'},
	{"delim", required_argument, 0, 'd'},
	{"field", required_argument, 0, 'f'},
	{"field-label", required_argument, 0, 'F'},
	{"input_format", required_argument, 0, 'i'},
	{"output_format", required_argument, 0, 'o'},
	{"preserve_header", no_argument, 0, 'p'},
	{0, 0, 0, 0}
};

/** parses commandline arguments and puts the info into a cmdargs struct.
 * @param argc number of arguments
 * @param argv array of argument strings
 * @param args structure to hold the parsed options & arguments
 */
void parse_args ( int argc, char **argv, struct cmdargs *args){
  int c, option_index=0;

  init_cmdargs(args);

  while( (c = getopt_long(argc, argv, "hVvd:f:F:i:o:p", long_options, &option_index)) != -1 ){
    switch (c) {
      case '0':
        if ( long_options[option_index].flag != 0 )
          break;
			case 'h':
				args->help = 1;
				break;
			case 'V':
				args->version = 1;
				break;
			case 'v':
				args->verbose++;;
				break;
			case 'd':
				args->delim = optarg;
				break;
			case 'f':
				args->field = optarg;
				break;
			case 'F':
				args->field_label = optarg;
				break;
			case 'i':
				args->input_format = optarg;
				break;
			case 'o':
				args->output_format = optarg;
				break;
			case 'p':
				args->preserve_header = 1;
				break;
			default: break;
		}
	}
	return;
}


/** @brief initializes all elements in the cmdargs struct to NULL or 0.
 *  @param args pointer to the argument structure to be cleared out.
 */
void init_cmdargs( struct cmdargs *args ){
  /* this set all pointers to null, int values to 0 */
  memset( args, 0, sizeof(struct cmdargs) );
}

/** @brief prints application version.
  */
void version ( void ){
  fprintf(stderr, "%s\n", APPLICATION_VERSION);
}

